/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.IIOException;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.SVGRasterizerPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SVGAnimationRasterizerPanel
extends SVGRasterizerPanel {
    private SpinnerNumberModel m_previewSpinnerModel;
    private final ComponentGroup m_startTime;
    private final ComponentGroup m_stopTime;
    private Thread m_sizeCalculationThread;
    private volatile boolean m_processingStopped = false;
    private JCheckBox allFramesCheckBox;
    private ButtonGroup buttonGroup1;
    private JLabel compressionLabel;
    private JComboBox compressionLevelCombo;
    private JLabel compressionQualityLabel;
    private JSpinner compressionQualitySpinner;
    private JPanel exportPanel;
    private JComboBox formatComboBox;
    private JSpinner framesPerSecSpinner;
    private JScrollPane imageHolder;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox keepRatio;
    private JPanel optionsPanel;
    private JTextField previewAnimationSizeText;
    private JTextField previewCurrentTimeText;
    private JTextField previewEndTimeText;
    private JTextField previewFileText;
    private JTextField previewFormatText;
    private JTextField previewFrameSizeText;
    private JSpinner previewFrameSpinner;
    private JTextField previewMaxFrameText;
    private JCheckBox progressiveCheckBox;
    private JRadioButton radioExportAll;
    private JRadioButton radioExportCurrent;
    private JComboBox reductionCombo;
    private JLabel reductionLabel;
    private JPanel sizePanel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerWidth;
    private JSlider startTimeSlider;
    private JSpinner startTimeSpinner;
    private JSlider stopTimeSlider;
    private JSpinner stopTimeSpinner;
    private JPanel timeLinePanel;
    private JCheckBox transparentCheckBox;
    private double m_backupFramesPerSec;
    private boolean m_backupAllFramesInSingleImage;
    private double m_backupStartTime;
    private double m_backupStopTime;

    public SVGAnimationRasterizerPanel(SVGDataObject dObj) throws IOException, BadLocationException {
        super(dObj, null);
        this.initComponents();
        this.createCompressionGroup(this.compressionLevelCombo, this.compressionQualitySpinner);
        float duration = this.m_dObj.getSceneManager().getAnimationDuration();
        this.m_startTime = this.createTimeGroup(this.startTimeSpinner, this.startTimeSlider, duration, true);
        this.m_stopTime = this.createTimeGroup(this.stopTimeSpinner, this.stopTimeSlider, duration, false);
        this.radioExportAll.setEnabled(this.isInProject());
        this.m_ratio = this.m_dim.getHeight() / this.m_dim.getWidth();
        this.spinnerHeight.setModel(new SpinnerNumberModel((int)this.m_dim.getHeight(), 1, 2048, 1));
        this.spinnerWidth.setModel(new SpinnerNumberModel((int)this.m_dim.getWidth(), 1, 2048, 1));
        this.framesPerSecSpinner.setModel(new SpinnerNumberModel(2.0, 0.1, 30.0, 1.0));
        this.m_previewSpinnerModel = new SpinnerNumberModel(1, 1, 10, 1);
        this.previewFrameSpinner.setModel(this.m_previewSpinnerModel);
        this.spinnerWidth.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SVGAnimationRasterizerPanel.this.keepRatio.isSelected()) {
                    SVGAnimationRasterizerPanel.this.spinnerHeight.setValue(new Integer((int)(((Integer)SVGAnimationRasterizerPanel.this.spinnerWidth.getValue()).doubleValue() * SVGAnimationRasterizerPanel.this.m_ratio)));
                }
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.spinnerWidth, true);
            }
        });
        this.m_previewSpinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.previewFrameSpinner, false);
            }
        });
        this.framesPerSecSpinner.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.framesPerSecSpinner, true);
            }
        });
        this.updateImage(null, true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sizePanel = new JPanel();
        JLabel jLabel11 = new JLabel();
        this.spinnerWidth = new JSpinner();
        JLabel jLabel12 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.keepRatio = new JCheckBox();
        this.optionsPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.progressiveCheckBox = new JCheckBox();
        this.compressionLabel = new JLabel();
        this.compressionLevelCombo = new JComboBox<AnimationRasterizer.CompressionLevel>(AnimationRasterizer.CompressionLevel.values());
        this.compressionQualityLabel = new JLabel();
        this.compressionQualitySpinner = new JSpinner();
        this.reductionLabel = new JLabel();
        this.reductionCombo = new JComboBox<AnimationRasterizer.ColorReductionMethod>(AnimationRasterizer.ColorReductionMethod.values());
        this.transparentCheckBox = new JCheckBox();
        this.timeLinePanel = new JPanel();
        this.startTimeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 30.0, 1.0));
        JLabel startTimeLabel = new JLabel();
        JLabel stopTimeLabel = new JLabel();
        this.stopTimeSpinner = new JSpinner(new SpinnerNumberModel(30.0, 0.0, 30.0, 1.0));
        this.startTimeSlider = new JSlider();
        this.stopTimeSlider = new JSlider();
        JLabel framesPerSecLabel = new JLabel();
        this.framesPerSecSpinner = new JSpinner();
        this.exportPanel = new JPanel();
        this.radioExportCurrent = new JRadioButton();
        this.radioExportAll = new JRadioButton();
        this.allFramesCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.previewFormatText = new JTextField();
        this.previewFrameSizeText = new JTextField();
        this.previewFileText = new JTextField();
        this.jLabel5 = new JLabel();
        this.previewAnimationSizeText = new JTextField();
        this.imageHolder = new JScrollPane();
        JLabel previewLabel = new JLabel();
        this.previewFrameSpinner = new JSpinner();
        this.previewMaxFrameText = new JTextField();
        this.jLabel7 = new JLabel();
        this.previewCurrentTimeText = new JTextField();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.previewEndTimeText = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.setOpaque(false);
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ImageSize")));
        jLabel11.setLabelFor(this.spinnerWidth);
        Mnemonics.setLocalizedText((JLabel)jLabel11, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationImageWidth"));
        jLabel12.setLabelFor(this.spinnerHeight);
        Mnemonics.setLocalizedText((JLabel)jLabel12, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationImageHeight"));
        this.spinnerHeight.setEnabled(false);
        this.keepRatio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.keepRatio, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationKeepRatio"));
        this.keepRatio.setToolTipText("Images for other configurations are transformed using screen ratio.");
        this.keepRatio.setMargin(new Insets(0, 0, 0, 0));
        this.keepRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGAnimationRasterizerPanel.this.keepRatioActionPerformed(evt);
            }
        });
        GroupLayout sizePanelLayout = new GroupLayout((Container)this.sizePanel);
        this.sizePanel.setLayout((LayoutManager)sizePanelLayout);
        sizePanelLayout.setHorizontalGroup((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((Component)jLabel11).add((Component)jLabel12)).addPreferredGap(0).add((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((Component)this.spinnerHeight, -2, 56, -2).add((Component)this.spinnerWidth, -2, 56, -2))).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.keepRatio))).addContainerGap(151, Short.MAX_VALUE)));
        sizePanelLayout.setVerticalGroup((GroupLayout.Group)sizePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sizePanelLayout.createSequentialGroup().add((GroupLayout.Group)sizePanelLayout.createParallelGroup(3).add((Component)jLabel11).add((Component)this.spinnerWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)sizePanelLayout.createParallelGroup(3).add((Component)jLabel12).add((Component)this.spinnerHeight, -2, -1, -2)).addPreferredGap(0).add((Component)this.keepRatio).addContainerGap(-1, Short.MAX_VALUE)));
        jLabel11.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLabel11_name"));
        jLabel11.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLabel11_description"));
        this.spinnerWidth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jSpinner_name"));
        this.spinnerWidth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jSpinner_descriprion"));
        jLabel12.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jSpinner_height"));
        jLabel12.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jSpinner_description"));
        this.spinnerHeight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_spinnerHeight_name"));
        this.spinnerHeight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_spinnerHeight_description"));
        this.keepRatio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_keepRation_name"));
        this.keepRatio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_keepRation_description"));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ImageOptions")));
        jLabel2.setLabelFor(this.formatComboBox);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsFormat"));
        this.formatComboBox.setModel(SVGAnimationRasterizerPanel.createImageTypeComboBoxModel());
        this.formatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGAnimationRasterizerPanel.this.formatComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.progressiveCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsProgressive"));
        this.progressiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.compressionLabel.setLabelFor(this.compressionLevelCombo);
        Mnemonics.setLocalizedText((JLabel)this.compressionLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsQuality"));
        this.compressionQualityLabel.setLabelFor(this.compressionQualitySpinner);
        Mnemonics.setLocalizedText((JLabel)this.compressionQualityLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsRate"));
        this.reductionLabel.setLabelFor(this.reductionCombo);
        Mnemonics.setLocalizedText((JLabel)this.reductionLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsColorReduction"));
        this.reductionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGAnimationRasterizerPanel.this.colorReductionChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.transparentCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsTransparent"));
        this.transparentCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transparentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGAnimationRasterizerPanel.this.transparentCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout optionsPanelLayout = new GroupLayout((Container)this.optionsPanel);
        this.optionsPanel.setLayout((LayoutManager)optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add(84, 84, 84).add((Component)this.jPanel1, -1, 162, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)jLabel2).addPreferredGap(1).add((Component)this.formatComboBox, -2, 93, -2).addContainerGap()).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.progressiveCheckBox).addContainerGap(169, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((Component)this.compressionLabel).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.compressionLevelCombo, -2, 94, -2).addPreferredGap(1).add((Component)this.compressionQualityLabel).add(5, 5, 5).add((Component)this.compressionQualitySpinner, -2, 48, -2))).add(40, 40, 40)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((Component)this.transparentCheckBox).addContainerGap(165, Short.MAX_VALUE)).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(2, false).add(1, (Component)this.reductionCombo, 0, -1, Short.MAX_VALUE).add(1, (Component)this.reductionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(130, Short.MAX_VALUE)))));
        optionsPanelLayout.setVerticalGroup((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)optionsPanelLayout.createSequentialGroup().add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.formatComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressiveCheckBox).addPreferredGap(0).add((Component)this.transparentCheckBox).add(14, 14, 14).add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.reductionLabel)).addPreferredGap(0).add((Component)this.reductionCombo, -2, -1, -2).addPreferredGap(0, 15, Short.MAX_VALUE).add((Component)this.compressionLabel).addPreferredGap(0).add((GroupLayout.Group)optionsPanelLayout.createParallelGroup(4).add((Component)this.compressionLevelCombo, -2, 25, -2).add((Component)this.compressionQualityLabel).add((Component)this.compressionQualitySpinner, -2, 25, -2)).addContainerGap()));
        jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLabel2_name"));
        jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLabel2_description"));
        this.formatComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_formatComboBox_name"));
        this.formatComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLabel2_descritpion"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_name"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_description"));
        this.compressionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionLabel_name"));
        this.compressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionLabel_description"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_name"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_description"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_name"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_description"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_name"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_description"));
        this.reductionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_reductionLabel_name"));
        this.reductionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_reductionLabel_descritpion"));
        this.reductionCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_reductionCombo_name"));
        this.reductionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_reductionCombo_description"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_name"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_description"));
        this.timeLinePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationFrameTime")));
        startTimeLabel.setLabelFor(this.startTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)startTimeLabel, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationTime"));
        stopTimeLabel.setLabelFor(this.stopTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)stopTimeLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationEndTime"));
        framesPerSecLabel.setLabelFor(this.framesPerSecSpinner);
        Mnemonics.setLocalizedText((JLabel)framesPerSecLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationFramePerSec"));
        GroupLayout timeLinePanelLayout = new GroupLayout((Container)this.timeLinePanel);
        this.timeLinePanel.setLayout((LayoutManager)timeLinePanelLayout);
        timeLinePanelLayout.setHorizontalGroup((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)framesPerSecLabel).addPreferredGap(0, 97, Short.MAX_VALUE).add((Component)this.framesPerSecSpinner, -2, 46, -2)).add((Component)this.startTimeSlider, -1, 246, Short.MAX_VALUE).add(2, (Component)this.stopTimeSlider, -1, 246, Short.MAX_VALUE).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((Component)stopTimeLabel).addPreferredGap(0, 105, Short.MAX_VALUE).add((Component)this.stopTimeSpinner, -2, 84, -2)).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((Component)startTimeLabel).addPreferredGap(0, 104, Short.MAX_VALUE).add((Component)this.startTimeSpinner, -2, 83, -2))))).addContainerGap()));
        timeLinePanelLayout.setVerticalGroup((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeLinePanelLayout.createSequentialGroup().add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(3).add((Component)startTimeLabel).add((Component)this.startTimeSpinner, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.startTimeSlider, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(3).add((Component)stopTimeLabel).add((Component)this.stopTimeSpinner, -2, -1, -2)).addPreferredGap(0).add((Component)this.stopTimeSlider, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)timeLinePanelLayout.createParallelGroup(3).add((Component)framesPerSecLabel).add((Component)this.framesPerSecSpinner, -2, -1, -2)).add(24, 24, 24)));
        this.startTimeSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeSpinner_name"));
        this.startTimeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeSpinner_description"));
        startTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeLabel_name"));
        startTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeLabel_description"));
        stopTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeLabel_name"));
        stopTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeLabel_description"));
        this.stopTimeSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeSpinner_name"));
        this.stopTimeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeSpinner_description"));
        this.startTimeSlider.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeSlider_name"));
        this.startTimeSlider.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_startTimeSlider_descritpion"));
        this.stopTimeSlider.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeSlider_name"));
        this.stopTimeSlider.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_stopTimeSlider_description"));
        framesPerSecLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_framePerSecLabel_name"));
        framesPerSecLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_framePerSecLabel_description"));
        this.framesPerSecSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_framePerSecSpinner_name"));
        this.framesPerSecSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_framePerSecSpinner_description"));
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ExportLabel")));
        this.buttonGroup1.add(this.radioExportCurrent);
        this.radioExportCurrent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportCurrent, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationOnlyActiveConfiguration"));
        this.radioExportCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.radioExportAll);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportAll, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationAllConfigurations"));
        this.radioExportAll.setMargin(new Insets(0, 0, 0, 0));
        this.allFramesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.allFramesCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationInSingleFile"));
        this.allFramesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.allFramesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGAnimationRasterizerPanel.this.allFramesInSingleFileChanged(evt);
            }
        });
        GroupLayout exportPanelLayout = new GroupLayout((Container)this.exportPanel);
        this.exportPanel.setLayout((LayoutManager)exportPanelLayout);
        exportPanelLayout.setHorizontalGroup((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((GroupLayout.Group)exportPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((Component)this.radioExportAll).add((Component)this.allFramesCheckBox).add((Component)this.radioExportCurrent)).addContainerGap(89, Short.MAX_VALUE)));
        exportPanelLayout.setVerticalGroup((GroupLayout.Group)exportPanelLayout.createParallelGroup(1).add((GroupLayout.Group)exportPanelLayout.createSequentialGroup().add((Component)this.radioExportCurrent).addPreferredGap(0).add((Component)this.radioExportAll).addPreferredGap(0, 13, Short.MAX_VALUE).add((Component)this.allFramesCheckBox)));
        this.radioExportCurrent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_radioExportCurrent_name"));
        this.radioExportCurrent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_radioExportCurrent_description"));
        this.radioExportAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_radioExportAll_name"));
        this.radioExportAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_radioExportAll_description"));
        this.allFramesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_allFramesCheckBox_name"));
        this.allFramesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_allFramesCheckBox_name"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewTitle")));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setLabelFor(this.previewFormatText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewFormat"));
        this.jLabel1.setLabelFor(this.previewFrameSizeText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewSize"));
        this.jLabel4.setLabelFor(this.previewFileText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewFile"));
        this.previewFormatText.setEditable(false);
        this.previewFormatText.setText("JPEG");
        this.previewFormatText.setToolTipText("Image format");
        this.previewFrameSizeText.setEditable(false);
        this.previewFrameSizeText.setHorizontalAlignment(4);
        this.previewFrameSizeText.setText("5.6KBytes");
        this.previewFrameSizeText.setToolTipText("Single frame size");
        this.previewFileText.setEditable(false);
        this.previewFileText.setText("C:\\Program Files\\about.svg");
        this.previewFileText.setToolTipText("File location");
        this.jLabel5.setText("/");
        this.previewAnimationSizeText.setEditable(false);
        this.previewAnimationSizeText.setText("132.5 KBytes");
        this.previewAnimationSizeText.setToolTipText("Whole animation size");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabel1)).add((Component)this.jLabel4)).add(13, 13, 13).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.previewFrameSizeText, -2, 79, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.previewAnimationSizeText, -2, 162, -2)).add((Component)this.previewFileText, -1, 379, Short.MAX_VALUE).add((Component)this.previewFormatText, -2, 55, -2)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.previewFormatText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel5).add((Component)this.previewFrameSizeText, -2, -1, -2).add((Component)this.previewAnimationSizeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.previewFileText, -2, -1, -2)).addContainerGap()));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jlabel3_name"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jlabel3_descritpion"));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewSizelabel_name"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewSizelabel_description"));
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        this.previewFormatText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFormatlabel_name"));
        this.previewFormatText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFormatlabel_description"));
        this.previewFrameSizeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFrameSizeText_name"));
        this.previewFrameSizeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFrameSizeText_description"));
        this.previewFileText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        this.previewFileText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription("/");
        this.previewAnimationSizeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewAnimationSizeText_name"));
        this.previewAnimationSizeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_previewAnimationSizeText_description"));
        this.imageHolder.setBorder(BorderFactory.createEtchedBorder());
        this.imageHolder.setPreferredSize(new Dimension(300, 300));
        previewLabel.setLabelFor(this.previewFrameSpinner);
        Mnemonics.setLocalizedText((JLabel)previewLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationPreviewFrame"));
        this.previewMaxFrameText.setEditable(false);
        this.previewMaxFrameText.setText("30");
        this.previewMaxFrameText.setToolTipText("Number of frames");
        this.jLabel7.setLabelFor(this.previewCurrentTimeText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationPreviewTime"));
        this.previewCurrentTimeText.setEditable(false);
        this.previewCurrentTimeText.setHorizontalAlignment(4);
        this.previewCurrentTimeText.setText("0");
        this.previewCurrentTimeText.setToolTipText("Current time");
        jLabel8.setLabelFor(this.previewEndTimeText);
        jLabel8.setText("/");
        jLabel9.setLabelFor(this.previewMaxFrameText);
        jLabel9.setText("/");
        this.previewEndTimeText.setEditable(false);
        this.previewEndTimeText.setText("60");
        this.previewEndTimeText.setToolTipText("Duration");
        jLabel10.setLabelFor(this.previewEndTimeText);
        jLabel10.setText("[s]");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add(1, (Component)this.imageHolder, -1, 450, Short.MAX_VALUE).add(1, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)previewLabel).addPreferredGap(0).add((Component)this.previewFrameSpinner, -2, 49, -2).addPreferredGap(0).add((Component)jLabel9).addPreferredGap(0).add((Component)this.previewMaxFrameText, -2, 35, -2).addPreferredGap(0, 155, Short.MAX_VALUE).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.previewCurrentTimeText, -2, 56, -2).addPreferredGap(0).add((Component)jLabel8).addPreferredGap(0).add((Component)this.previewEndTimeText, -2, 54, -2).addPreferredGap(0).add((Component)jLabel10))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)previewLabel).add((Component)this.previewFrameSpinner, -2, -1, -2).add((Component)jLabel9).add((Component)jLabel8).add((Component)jLabel10).add((Component)this.jLabel7).add((Component)this.previewMaxFrameText, -2, -1, -2).add((Component)this.previewCurrentTimeText, -2, -1, -2).add((Component)this.previewEndTimeText, -2, -1, -2)).addPreferredGap(0).add((Component)this.imageHolder, -1, 467, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel4, -2, -1, -2).addContainerGap()));
        this.jPanel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jPanel4_name"));
        this.jPanel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jPanel4_description"));
        this.imageHolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_imageHolder_name"));
        this.imageHolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_imageHolder_description"));
        previewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_Frame_Label"));
        previewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_Frame_Label_Description"));
        this.previewFrameSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_Frame_spin_name"));
        this.previewFrameSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_Frame_spin_description"));
        this.previewMaxFrameText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"AY11Y_Max_frame_name"));
        this.previewMaxFrameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_Frame_spin_description"));
        this.jLabel7.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_LBL_Time_name"));
        this.jLabel7.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_LBL_Time_description"));
        this.previewCurrentTimeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_LBL_CurrentTimetext_name"));
        this.previewCurrentTimeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_CurrentTimeText_description"));
        jLabel8.getAccessibleContext().setAccessibleDescription("/");
        jLabel9.getAccessibleContext().setAccessibleDescription("/");
        this.previewEndTimeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_EndTimeText_name"));
        this.previewEndTimeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_EndTimeText_description"));
        jLabel10.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLable10_name"));
        jLabel10.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_jLable10_description"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.timeLinePanel, -1, -1, Short.MAX_VALUE).add((Component)this.optionsPanel, 0, -1, Short.MAX_VALUE).add((Component)this.sizePanel, -1, -1, Short.MAX_VALUE).add((Component)this.exportPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sizePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.optionsPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.timeLinePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.exportPanel, -2, -1, -2))).addContainerGap()));
        this.sizePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_sizePanel_name"));
        this.sizePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_sizePanel_description"));
        this.optionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_optionsPanel_name"));
        this.optionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_optionsPanel_description"));
        this.timeLinePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_timeLinePanel_name"));
        this.timeLinePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_timeLinePanel_description"));
        this.exportPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_exportPanel_name"));
        this.exportPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_exportPanel_description"));
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_Preview_Panel"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_Preview_Descripton"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_Panel_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"A11Y_Panel_description"));
    }

    private void transparentCheckBoxActionPerformed(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void colorReductionChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void allFramesInSingleFileChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void formatComboBoxActionPerformed(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void keepRatioActionPerformed(ActionEvent evt) {
        this.spinnerHeight.setEnabled(!this.keepRatio.isSelected());
    }

    @Override
    public int getImageWidth() {
        return this.m_overrideWidth != -1 ? this.m_overrideWidth : (Integer)this.spinnerWidth.getValue();
    }

    @Override
    public int getImageHeight() {
        return this.m_overrideHeight != -1 ? this.m_overrideHeight : (Integer)this.spinnerHeight.getValue();
    }

    @Override
    public float getStartTime() {
        return ((Double)this.startTimeSpinner.getValue()).floatValue();
    }

    @Override
    public float getEndTime() {
        return ((Double)this.stopTimeSpinner.getValue()).floatValue();
    }

    @Override
    public float getFramesPerSecond() {
        return ((Double)this.framesPerSecSpinner.getValue()).floatValue();
    }

    @Override
    public boolean isForAllConfigurations() {
        return this.radioExportAll.isSelected();
    }

    @Override
    public float getCompressionQuality() {
        int value = (Integer)this.compressionQualitySpinner.getValue();
        return (float)value / 100.0f;
    }

    @Override
    public boolean isProgressive() {
        return this.progressiveCheckBox.isSelected();
    }

    @Override
    public boolean isTransparent() {
        return this.transparentCheckBox.isSelected();
    }

    @Override
    public boolean isInSingleImage() {
        return this.allFramesCheckBox.isSelected();
    }

    @Override
    public int getNumberFrames() {
        float duration = this.getEndTime() - this.getStartTime();
        return 1 + (duration <= 0.0f ? 0 : (int)(duration * this.getFramesPerSecond()));
    }

    @Override
    public AnimationRasterizer.ImageType getImageType() {
        return (AnimationRasterizer.ImageType)((Object)this.formatComboBox.getSelectedItem());
    }

    @Override
    public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
        return (AnimationRasterizer.ColorReductionMethod)this.reductionCombo.getSelectedItem();
    }

    public void stopProcessing() {
        this.m_processingStopped = true;
        if (this.m_sizeCalculationThread != null) {
            this.m_sizeCalculationThread.interrupt();
        }
    }

    @Override
    protected String getPreviewFileName() {
        return this.previewFileText.getText();
    }

    @Override
    protected void updateImage(JComponent source, boolean isOutputChanged) {
        if (!this.m_updateInProgress && !this.m_processingStopped) {
            this.m_updateInProgress = true;
            final JLabel label = new JLabel("Updating image...");
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            label.setMinimumSize(new Dimension(100, 100));
            this.imageHolder.setViewportView(label);
            this.updateTimelineBounds(source);
            AnimationRasterizer.ImageType imgType = this.getImageType();
            boolean supportsCompression = imgType.supportsCompression();
            this.compressionQualitySpinner.setEnabled(supportsCompression);
            this.compressionLevelCombo.setEnabled(supportsCompression);
            this.compressionLabel.setEnabled(supportsCompression);
            this.compressionQualityLabel.setEnabled(supportsCompression);
            boolean needsColorReduction = imgType.needsColorReduction();
            this.reductionCombo.setEnabled(needsColorReduction);
            this.reductionLabel.setEnabled(needsColorReduction);
            if (imgType.supportsTransparency()) {
                this.transparentCheckBox.setEnabled(true);
            } else {
                this.transparentCheckBox.setEnabled(false);
                this.transparentCheckBox.setSelected(false);
            }
            float startTime = this.getStartTime();
            float endTime = this.getEndTime();
            float framesPerSec = this.getFramesPerSecond();
            final float duration = endTime - startTime;
            final int totalFrameNum = this.getNumberFrames();
            this.m_previewSpinnerModel.setMaximum(Integer.valueOf(totalFrameNum));
            if (this.m_startTime.findWrapper(source) != null) {
                this.previewFrameSpinner.setValue(new Integer(1));
            } else if (this.m_stopTime.findWrapper(source) != null) {
                this.previewFrameSpinner.setValue(new Integer(totalFrameNum));
            }
            final int currentFrame = (Integer)this.previewFrameSpinner.getValue() - 1;
            assert (currentFrame >= 0);
            final float frameTime = startTime + (float)currentFrame / framesPerSec;
            String filenameRoot = AnimationRasterizer.createFileNameRoot(this.m_dObj, this, null, true);
            final String fileName = AnimationRasterizer.createFileName(filenameRoot, this, currentFrame, totalFrameNum);
            if (isOutputChanged) {
                this.previewAnimationSizeText.setText("Calculating animation size ...");
                if (this.m_sizeCalculationThread != null) {
                    this.m_sizeCalculationThread.interrupt();
                }
                final boolean[] blockUpdate = new boolean[]{false};
                this.m_sizeCalculationThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            SVGImage svgImage = SVGAnimationRasterizerPanel.this.getSVGImage();
                            if (svgImage != null) {
                                AnimationRasterizer.calculateAnimationSize(svgImage, SVGAnimationRasterizerPanel.this, new AnimationRasterizer.ProgressUpdater(){

                                    @Override
                                    public void updateProgress(String text) {
                                        if (!blockUpdate[0]) {
                                            SVGAnimationRasterizerPanel.this.updatePreviewText(text);
                                        }
                                    }
                                });
                                SVGAnimationRasterizerPanel.this.updateSafeValues();
                            }
                        }
                        catch (InterruptedException e) {
                        }
                        catch (IIOException e) {
                            blockUpdate[0] = true;
                            if (!SVGAnimationRasterizerPanel.this.m_processingStopped) {
                                String msg = NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"MSG_IMG_ENCODING_ERROR");
                                SVGAnimationRasterizerPanel.this.updatePreviewText(msg + ".");
                                msg = msg + ": " + e.getLocalizedMessage();
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                                SVGAnimationRasterizerPanel.this.restoreSafeValues();
                            }
                        }
                        catch (Exception ex) {
                            SceneManager.log(Level.INFO, ex.getMessage(), ex);
                            SVGAnimationRasterizerPanel.this.restoreSafeValues();
                        }
                    }
                };
                this.m_sizeCalculationThread.setDaemon(true);
                this.m_sizeCalculationThread.setPriority(1);
                this.m_sizeCalculationThread.setName("AnimationSizeCalculationThread");
                this.m_sizeCalculationThread.start();
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SVGImage svgImage = SVGAnimationRasterizerPanel.this.getSVGImage();
                        if (svgImage != null) {
                            final AnimationRasterizer.PreviewInfo preview = AnimationRasterizer.previewFrame(SVGAnimationRasterizerPanel.this.getSVGImage(), SVGAnimationRasterizerPanel.this, currentFrame, frameTime);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SVGAnimationRasterizerPanel.this.previewFrameSizeText.setText(AnimationRasterizer.getSizeText(preview.m_imageSize));
                                    SVGAnimationRasterizerPanel.this.previewFormatText.setText(preview.m_imageFormat);
                                    SVGAnimationRasterizerPanel.this.previewFileText.setText(fileName);
                                    SVGAnimationRasterizerPanel.this.previewMaxFrameText.setText(String.valueOf(totalFrameNum));
                                    SVGAnimationRasterizerPanel.this.previewCurrentTimeText.setText(String.valueOf(SVGRasterizerPanel.roundTime(frameTime)));
                                    SVGAnimationRasterizerPanel.this.previewEndTimeText.setText(String.valueOf(SVGRasterizerPanel.roundTime(duration)));
                                    label.setText(null);
                                    label.setIcon(new ImageIcon(preview.m_image));
                                    label.invalidate();
                                    SVGAnimationRasterizerPanel.this.imageHolder.validate();
                                    SVGAnimationRasterizerPanel.this.imageHolder.repaint();
                                }
                            });
                        } else {
                            label.setText("Load of SVG image failed");
                            label.setIcon(null);
                            label.invalidate();
                            SVGAnimationRasterizerPanel.this.imageHolder.validate();
                            SVGAnimationRasterizerPanel.this.imageHolder.repaint();
                        }
                    }
                    catch (Exception ex) {
                        SceneManager.log(Level.INFO, ex.getMessage(), ex);
                    }
                    finally {
                        SVGAnimationRasterizerPanel.this.m_updateInProgress = false;
                    }
                }
            });
        }
    }

    private void updatePreviewText(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGAnimationRasterizerPanel.this.previewAnimationSizeText.setText(msg);
            }
        });
    }

    private void updateTimelineBounds(JComponent source) {
        ComponentGroup.ComponentWrapper wrapper = this.m_startTime.findWrapper(source);
        if (wrapper != null) {
            float value = wrapper.getValue();
            this.stopTimeSlider.setExtent(Math.round(value * 100.0f));
            ((SpinnerNumberModel)this.stopTimeSpinner.getModel()).setMinimum(new Double(value));
        } else {
            wrapper = this.m_stopTime.findWrapper(source);
            if (wrapper != null) {
                float value = wrapper.getValue();
                this.startTimeSlider.setExtent(this.startTimeSlider.getMaximum() - Math.round(value * 100.0f));
                ((SpinnerNumberModel)this.startTimeSpinner.getModel()).setMaximum(new Double(value));
            }
        }
    }

    private void updateSafeValues() {
        this.m_backupStartTime = this.getStartTime();
        this.m_backupStopTime = this.getEndTime();
        this.m_backupFramesPerSec = this.getFramesPerSecond();
        this.m_backupAllFramesInSingleImage = this.isInSingleImage();
    }

    private void restoreSafeValues() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGAnimationRasterizerPanel.this.framesPerSecSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupFramesPerSec);
                SVGAnimationRasterizerPanel.this.allFramesCheckBox.setSelected(SVGAnimationRasterizerPanel.this.m_backupAllFramesInSingleImage);
                SVGAnimationRasterizerPanel.this.startTimeSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupStartTime);
                SVGAnimationRasterizerPanel.this.stopTimeSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupStopTime);
            }
        });
    }
}

