/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.kenai.FakeJiraSupport;
import org.netbeans.modules.bugtracking.kenai.KenaiHandler;
import org.netbeans.modules.bugtracking.kenai.KenaiProjectImpl;
import org.netbeans.modules.bugtracking.kenai.QueryHandleImpl;
import org.netbeans.modules.bugtracking.kenai.QueryResultHandleImpl;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;

public class QueryAccessorImpl
extends QueryAccessor {
    private KenaiHandlers handlers = new KenaiHandlers();

    public QueryHandle getAllIssuesQuery(ProjectHandle projectHandle) {
        Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(projectHandle.getKenaiProject()));
        if (repo == null) {
            FakeJiraSupport jira = FakeJiraSupport.get(projectHandle);
            if (jira != null) {
                return jira.getAllIssuesQuery();
            }
            return null;
        }
        KenaiSupport support = (KenaiSupport)repo.getLookup().lookup(KenaiSupport.class);
        if (support == null) {
            return null;
        }
        KenaiHandler handler = this.handlers.get(projectHandle);
        handler.registerRepository(repo, projectHandle);
        Query allIssuesQuery = support.getAllIssuesQuery(repo);
        if (allIssuesQuery == null) {
            return null;
        }
        List<QueryHandle> queries = handler.getQueryHandles(projectHandle, allIssuesQuery);
        assert (queries.size() == 1);
        handler.registerProject(projectHandle, queries);
        return queries.get(0);
    }

    public List<QueryHandle> getQueries(ProjectHandle projectHandle) {
        Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(projectHandle.getKenaiProject()));
        if (repo == null) {
            return this.getQueriesForNoRepo(projectHandle);
        }
        KenaiHandler handler = this.handlers.get(projectHandle);
        handler.registerRepository(repo, projectHandle);
        List<QueryHandle> queryHandles = handler.getQueryHandles(repo, projectHandle);
        handler.registerProject(projectHandle, queryHandles);
        return Collections.unmodifiableList(queryHandles);
    }

    public List<QueryResultHandle> getQueryResults(QueryHandle queryHandle) {
        if (queryHandle instanceof QueryHandleImpl) {
            QueryHandleImpl qh = (QueryHandleImpl)queryHandle;
            qh.refreshIfNeeded();
            return Collections.unmodifiableList(qh.getQueryResults());
        }
        if (queryHandle instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            FakeJiraSupport.FakeJiraQueryHandle jqh = (FakeJiraSupport.FakeJiraQueryHandle)queryHandle;
            return jqh.getQueryResults();
        }
        return Collections.emptyList();
    }

    public Action getFindIssueAction(ProjectHandle projectHandle) {
        Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(projectHandle.getKenaiProject()));
        if (repo == null) {
            FakeJiraSupport jira = FakeJiraSupport.get(projectHandle);
            if (jira != null) {
                return new ActionWrapper(jira.getOpenProjectListener());
            }
            return null;
        }
        return this.handlers.get(projectHandle).getFindIssuesAction(repo);
    }

    public Action getCreateIssueAction(ProjectHandle projectHandle) {
        Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(projectHandle.getKenaiProject()));
        if (repo == null) {
            FakeJiraSupport jira = FakeJiraSupport.get(projectHandle);
            if (jira != null) {
                return new ActionWrapper(jira.getCreateIssueListener());
            }
            return null;
        }
        return this.handlers.get(projectHandle).getCreateIssueAction(repo);
    }

    public Action getOpenQueryResultAction(QueryResultHandle result) {
        if (result instanceof QueryResultHandleImpl || result instanceof FakeJiraSupport.FakeJiraQueryResultHandle) {
            return new ActionWrapper((ActionListener)result);
        }
        return null;
    }

    public Action getDefaultAction(QueryHandle query) {
        if (query instanceof QueryHandleImpl || query instanceof FakeJiraSupport.FakeJiraQueryHandle) {
            return new ActionWrapper((ActionListener)query);
        }
        return null;
    }

    void fireQueriesChanged(ProjectHandle project, List<QueryHandle> newQueryList) {
        this.fireQueryListChanged(project, newQueryList);
    }

    private List<QueryHandle> getQueriesForNoRepo(ProjectHandle project) {
        FakeJiraSupport jira = FakeJiraSupport.get(project);
        if (jira != null) {
            return jira.getQueries();
        }
        return Collections.emptyList();
    }

    private class KenaiHandlers {
        private Map<String, KenaiHandler> instances = new HashMap<String, KenaiHandler>();

        private KenaiHandlers() {
        }

        KenaiHandler get(ProjectHandle ph) {
            return this.get(ph.getKenaiProject().getKenai());
        }

        KenaiHandler get(Kenai kenai) {
            assert (kenai != null);
            String url = kenai.getUrl().toString();
            KenaiHandler ret = this.instances.get(url);
            if (ret == null) {
                ret = new KenaiHandler(QueryAccessorImpl.this, kenai);
                this.instances.put(url, ret);
            }
            return ret;
        }
    }

    private static class ActionWrapper
    extends AbstractAction {
        private final ActionListener al;

        public ActionWrapper(ActionListener al) {
            this.al = al;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.al.actionPerformed(e);
        }
    }
}

