/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;

final class SimpleAntArtifact
extends AntArtifact {
    private final AntProjectHelper h;
    private final String type;
    private final String locationProperty;
    private final PropertyEvaluator eval;
    private final String targetName;
    private final String cleanTargetName;
    private final String buildScriptProperty;

    public SimpleAntArtifact(AntProjectHelper helper, String type, String locationProperty, PropertyEvaluator eval, String targetName, String cleanTargetName, String buildScriptProperty) {
        this.h = helper;
        this.type = type;
        this.locationProperty = locationProperty;
        this.eval = eval;
        this.targetName = targetName;
        this.cleanTargetName = cleanTargetName;
        this.buildScriptProperty = buildScriptProperty;
    }

    private URI getArtifactLocation0() {
        String locationResolved = this.eval.getProperty(this.locationProperty);
        if (locationResolved == null) {
            return URI.create("file:/UNDEFINED");
        }
        File locF = new File(locationResolved);
        if (locF.isAbsolute()) {
            return locF.toURI();
        }
        try {
            return new URI(null, null, locationResolved.replace(File.separatorChar, '/'), null);
        }
        catch (URISyntaxException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return URI.create("file:/BROKEN");
        }
    }

    @Override
    public URI[] getArtifactLocations() {
        return new URI[]{this.getArtifactLocation0()};
    }

    @Override
    public String getCleanTargetName() {
        return this.cleanTargetName;
    }

    @Override
    public File getScriptLocation() {
        String path = null;
        if (this.buildScriptProperty != null) {
            path = this.eval.getProperty(this.buildScriptProperty);
        }
        if (path == null) {
            path = "build.xml";
        }
        return this.h.resolveFile(path);
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Project getProject() {
        return AntBasedProjectFactorySingleton.getProjectFor(this.h);
    }

    public String toString() {
        return "SimpleAntArtifact[helper=" + this.h + ",type=" + this.type + ",locationProperty=" + this.locationProperty + ",targetName=" + this.targetName + ",cleanTargetName=" + this.cleanTargetName + ",buildScriptProperty=" + this.buildScriptProperty + "]";
    }
}

