/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class BreakpointModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint breakpoint = (RubyLineBreakpoint)((Object)node);
            return breakpoint.getFileObject().getNameExt() + ':' + breakpoint.getLineNumber();
        }
        if (node instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint breakpoint = (RubyExceptionBreakpoint)((Object)node);
            return breakpoint.getException();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof RubyLineBreakpoint) {
            if (!((RubyBreakpoint)((Object)node)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        if (node instanceof RubyExceptionBreakpoint) {
            if (!((RubyBreakpoint)((Object)node)).isEnabled()) {
                return DISABLED_BREAKPOINT;
            }
            return BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint breakpoint = (RubyLineBreakpoint)((Object)node);
            return breakpoint.getLine().getDisplayName();
        }
        if (node instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint breakpoint = (RubyExceptionBreakpoint)((Object)node);
            return breakpoint.getException();
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        for (ModelListener ml : this.listeners) {
            ml.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

