/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import javax.swing.Action;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.ui.BreakpointCustomizer;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public final class RubyBreakpointNodeActions
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION;
    private static final Action CUSTOMIZE_ACTION;

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint bp = (RubyLineBreakpoint)((Object)node);
            EditorUtil.showLine(EditorUtil.getLineAnnotable(bp.getFilePath(), bp.getLineNumber() - 1));
        } else {
            original.performDefaultAction(node);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] origActions = original.getActions(node);
        if (node instanceof RubyLineBreakpoint) {
            Action[] actions = new Action[origActions.length + 3];
            actions[0] = GO_TO_SOURCE_ACTION;
            actions[1] = null;
            System.arraycopy(origActions, 0, actions, 2, origActions.length);
            actions[actions.length - 1] = CUSTOMIZE_ACTION;
            return actions;
        }
        return origActions;
    }

    static {
        Models.ActionPerformer goToSource = new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                RubyLineBreakpoint bp = (RubyLineBreakpoint)((Object)nodes[0]);
                EditorUtil.showLine(EditorUtil.getLineAnnotable(bp.getFilePath(), bp.getLineNumber() - 1));
            }
        };
        GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getMessage(RubyBreakpointNodeActions.class, (String)"CTL_GoToSource"), (Models.ActionPerformer)goToSource, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        Models.ActionPerformer customize = new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                RubyLineBreakpoint bp = (RubyLineBreakpoint)((Object)nodes[0]);
                BreakpointCustomizer.customize(bp);
            }
        };
        CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getMessage(RubyBreakpointNodeActions.class, (String)"CTL_customize"), (Models.ActionPerformer)customize, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

