/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion;

import groovy.lang.MetaMethod;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.GroovyTypeAnalyzer;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.GroovyKeyword;
import org.netbeans.modules.groovy.editor.api.completion.HTMLJavadocParser;
import org.netbeans.modules.groovy.editor.api.completion.KeywordCategory;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.completion.CompleteElementHandler;
import org.netbeans.modules.groovy.editor.completion.VariableFinderVisitor;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CompletionHandler
implements CodeCompletionHandler {
    private static final Logger LOG = Logger.getLogger(CompletionHandler.class.getName());
    private final PropertyChangeListener docListener;
    private int anchor;
    private String jdkJavaDocBase = null;
    private String groovyJavaDocBase = null;
    private String groovyApiDocBase = null;
    private Set<GroovyKeyword> keywords;

    public CompletionHandler() {
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform javaPlatform = javaPlatformManager.getDefaultPlatform();
        List list = javaPlatform.getJavadocFolders();
        for (URL uRL : list) {
            LOG.log(Level.FINEST, "JDK Doc path: {0}", uRL.toString());
            this.jdkJavaDocBase = uRL.toString();
        }
        GroovySettings groovySettings = GroovySettings.getInstance();
        this.docListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CompletionHandler completionHandler = CompletionHandler.this;
                synchronized (completionHandler) {
                    CompletionHandler.this.groovyJavaDocBase = null;
                    CompletionHandler.this.groovyApiDocBase = null;
                }
            }
        };
        groovySettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.docListener, (Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyJavadocBase() {
        CompletionHandler completionHandler = this;
        synchronized (completionHandler) {
            if (this.groovyJavaDocBase == null) {
                String string = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyJavaDocBase = CompletionHandler.directoryNameToUrl(string + "groovy-jdk/");
            }
            return this.groovyJavaDocBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyApiDocBase() {
        CompletionHandler completionHandler = this;
        synchronized (completionHandler) {
            if (this.groovyApiDocBase == null) {
                String string = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyApiDocBase = CompletionHandler.directoryNameToUrl(string + "gapi/");
            }
            return this.groovyApiDocBase;
        }
    }

    private static String directoryNameToUrl(String string) {
        if (string == null) {
            return "";
        }
        File file = new File(string);
        if (file != null && file.exists() && file.isDirectory()) {
            String string2 = "";
            if (org.openide.util.Utilities.isWindows()) {
                string = string.replace("\\", "/");
                string2 = "file:/";
            } else {
                string2 = "file://";
            }
            return string2 + string;
        }
        return "";
    }

    private static void printASTNodeInformation(String string, ASTNode aSTNode) {
        LOG.log(Level.FINEST, "--------------------------------------------------------");
        LOG.log(Level.FINEST, "{0}", string);
        if (aSTNode == null) {
            LOG.log(Level.FINEST, "node == null");
        } else {
            LOG.log(Level.FINEST, "Node.getText()  : " + aSTNode.getText());
            LOG.log(Level.FINEST, "Node.toString() : " + aSTNode.toString());
            LOG.log(Level.FINEST, "Node.getClass() : " + aSTNode.getClass());
            LOG.log(Level.FINEST, "Node.hashCode() : " + aSTNode.hashCode());
            if (aSTNode instanceof ModuleNode) {
                LOG.log(Level.FINEST, "ModuleNode.getClasses() : " + ((ModuleNode)aSTNode).getClasses());
                LOG.log(Level.FINEST, "SourceUnit.getName() : " + ((ModuleNode)aSTNode).getContext().getName());
            }
        }
        LOG.log(Level.FINEST, "--------------------------------------------------------");
    }

    private static void printMethod(MetaMethod metaMethod) {
        LOG.log(Level.FINEST, "--------------------------------------------------");
        LOG.log(Level.FINEST, "getName()           : " + metaMethod.getName());
        LOG.log(Level.FINEST, "toString()          : " + metaMethod.toString());
        LOG.log(Level.FINEST, "getDescriptor()     : " + metaMethod.getDescriptor());
        LOG.log(Level.FINEST, "getSignature()      : " + metaMethod.getSignature());
        LOG.log(Level.FINEST, "getDeclaringClass() : " + metaMethod.getDeclaringClass());
    }

    CompletionContext getCompletionContext(CompletionRequest completionRequest) {
        Token token;
        int n = completionRequest.lexOffset;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Token token8 = null;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        int n2 = 0;
        n2 = tokenSequence.move(n);
        if (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() >= 0) {
            token5 = tokenSequence.token();
        }
        if (token5 != null) {
            if (token5.id() == GroovyTokenId.WHITESPACE && n2 == 0) {
                LOG.log(Level.FINEST, "ts.movePrevious() - 1");
                tokenSequence.movePrevious();
            } else if (token5.id() == GroovyTokenId.NLS) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == GroovyTokenId.DOT) {
                    tokenSequence.moveNext();
                } else {
                    LOG.log(Level.FINEST, "ts.movePrevious() - 2");
                }
            }
        }
        int n3 = 0;
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() != GroovyTokenId.NLS) {
            if (token.id() == GroovyTokenId.WHITESPACE) continue;
            if (n3 == 0) {
                token4 = token;
            } else if (n3 == 1) {
                token3 = token;
            } else if (n3 == 2) break;
            ++n3;
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() != GroovyTokenId.NLS && token.id() != GroovyTokenId.LBRACE) {
            if (!((GroovyTokenId)token.id()).primaryCategory().equals("keyword")) continue;
            token2 = token;
            break;
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength() && (token = tokenSequence.token()).id() != GroovyTokenId.NLS && token.id() != GroovyTokenId.RBRACE) {
            if (!((GroovyTokenId)token.id()).primaryCategory().equals("keyword")) continue;
            token8 = token;
            break;
        }
        tokenSequence.move(n);
        n3 = 0;
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength() && (token = tokenSequence.token()).id() != GroovyTokenId.NLS) {
            if (token.id() == GroovyTokenId.WHITESPACE) continue;
            if (n3 == 0) {
                token6 = token;
            } else if (n3 == 1) {
                token7 = token;
            } else if (n3 == 2) break;
            ++n3;
        }
        LOG.log(Level.FINEST, "---------------------------------------------------------------");
        LOG.log(Level.FINEST, "move() diff   : {0}", n2);
        LOG.log(Level.FINEST, "beforeLiteral : {0}", token2);
        LOG.log(Level.FINEST, "before2       : {0}", token3);
        LOG.log(Level.FINEST, "before1       : {0}", token4);
        LOG.log(Level.FINEST, "active        : {0}", token5);
        LOG.log(Level.FINEST, "after1        : {0}", token6);
        LOG.log(Level.FINEST, "after2        : {0}", token7);
        LOG.log(Level.FINEST, "afterLiteral  : {0}", token8);
        return new CompletionContext((Token<? extends GroovyTokenId>)token2, (Token<? extends GroovyTokenId>)token3, (Token<? extends GroovyTokenId>)token4, (Token<? extends GroovyTokenId>)token5, (Token<? extends GroovyTokenId>)token6, (Token<? extends GroovyTokenId>)token7, (Token<? extends GroovyTokenId>)token8, tokenSequence);
    }

    boolean checkForPackageStatement(CompletionRequest completionRequest) {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, 1);
        if (tokenSequence != null) {
            tokenSequence.move(1);
            while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
                Token token = tokenSequence.token();
                if (token.id() != GroovyTokenId.LITERAL_package) continue;
                return true;
            }
        }
        return false;
    }

    private CaretLocation getCaretLocationFromRequest(CompletionRequest completionRequest) {
        Object object;
        Object object2;
        Token token;
        Token token2;
        int n = completionRequest.lexOffset;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        tokenSequence.move(n);
        if (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            token2 = tokenSequence.token();
            if (token2.id() == GroovyTokenId.LINE_COMMENT || token2.id() == GroovyTokenId.BLOCK_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
            if (token2.id() == GroovyTokenId.STRING_LITERAL) {
                return CaretLocation.INSIDE_STRING;
            }
            if (token2.id() == GroovyTokenId.NLS && tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() == GroovyTokenId.LINE_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            token2 = tokenSequence.token();
            if (token2.id() != GroovyTokenId.LITERAL_package) continue;
            return CaretLocation.ABOVE_PACKAGE;
        }
        boolean bl = false;
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0) {
            token = tokenSequence.token();
            if (token.id() != GroovyTokenId.LITERAL_class && token.id() != GroovyTokenId.LITERAL_interface) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            object2 = tokenSequence.token();
            if (object2.id() != GroovyTokenId.LITERAL_class && object2.id() != GroovyTokenId.LITERAL_interface) continue;
            bl2 = true;
            break;
        }
        if (completionRequest.path != null && (object2 = completionRequest.path.root()) instanceof ModuleNode) {
            ASTNode aSTNode = (ModuleNode)object2;
            object = null;
            for (ClassNode classNode : ((ModuleNode)aSTNode).getClasses()) {
                if (!classNode.isScript()) continue;
                object = classNode.getName();
                completionRequest.scriptMode = true;
                break;
            }
            if (object != null) {
                for (ClassNode classNode : ((ModuleNode)aSTNode).getClasses()) {
                    if (classNode.isScript() || !((String)object).equals(classNode.getName())) continue;
                    completionRequest.scriptMode = false;
                    break;
                }
            }
        }
        if (!completionRequest.scriptMode && !bl && bl2) {
            return CaretLocation.ABOVE_FIRST_CLASS;
        }
        if (!bl && completionRequest.scriptMode) {
            return CaretLocation.INSIDE_METHOD;
        }
        if (completionRequest.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode aSTNode : completionRequest.path) {
            if (aSTNode instanceof ClosureExpression) {
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (aSTNode instanceof FieldNode) {
                object = (FieldNode)aSTNode;
                if (!((FieldNode)object).isClosureSharedVariable()) continue;
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (aSTNode instanceof MethodNode) {
                return CaretLocation.INSIDE_METHOD;
            }
            if (aSTNode instanceof ClassNode) {
                return CaretLocation.INSIDE_CLASS;
            }
            if (aSTNode instanceof ModuleNode) {
                return CaretLocation.OUTSIDE_CLASSES;
            }
            if (!(aSTNode instanceof Parameter)) continue;
            return CaretLocation.INSIDE_PARAMETERS;
        }
        return CaretLocation.UNDEFINED;
    }

    private ArgumentListExpression getSurroundingArgumentList(AstPath astPath) {
        if (astPath == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        LOG.log(Level.FINEST, "AEL, Path : {0}", astPath);
        for (ASTNode aSTNode : astPath) {
            if (!(aSTNode instanceof ArgumentListExpression)) continue;
            return (ArgumentListExpression)aSTNode;
        }
        return null;
    }

    private ASTNode getSurroundingMethodOrClosure(CompletionRequest completionRequest) {
        if (completionRequest.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        LOG.log(Level.FINEST, "getSurroundingMethodOrClosure() ----------------------------------------");
        LOG.log(Level.FINEST, "Path : {0}", completionRequest.path);
        for (ASTNode aSTNode : completionRequest.path) {
            AnnotatedNode annotatedNode;
            if (aSTNode instanceof MethodNode) {
                annotatedNode = (MethodNode)aSTNode;
                LOG.log(Level.FINEST, "Found Method: {0}", ((MethodNode)annotatedNode).getName());
                return annotatedNode;
            }
            if (aSTNode instanceof FieldNode) {
                annotatedNode = (FieldNode)aSTNode;
                if (!((FieldNode)annotatedNode).isClosureSharedVariable()) continue;
                LOG.log(Level.FINEST, "Found Closure(Field): {0}", ((FieldNode)annotatedNode).getName());
                return annotatedNode;
            }
            if (!(aSTNode instanceof ClosureExpression)) continue;
            LOG.log(Level.FINEST, "Found Closure(Expr.): {0}", ((ClosureExpression)aSTNode).getText());
            return aSTNode;
        }
        return null;
    }

    private ClassNode getSurroundingClassNode(CompletionRequest completionRequest) {
        if (completionRequest.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode aSTNode : completionRequest.path) {
            if (!(aSTNode instanceof ClassNode)) continue;
            ClassNode classNode = (ClassNode)aSTNode;
            LOG.log(Level.FINEST, "Found surrounding Class: {0}", classNode.getName());
            return classNode;
        }
        return null;
    }

    private AstPath getPathFromRequest(CompletionRequest completionRequest) {
        ModuleNode moduleNode = AstUtilities.getRoot(completionRequest.info);
        if (moduleNode == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", completionRequest.info);
            LOG.log(Level.FINEST, "request.prefix = {0}", completionRequest.prefix);
            return null;
        }
        return new AstPath((ASTNode)moduleNode, completionRequest.astOffset, completionRequest.doc);
    }

    private AstPath getPath(ParserResult parserResult, BaseDocument baseDocument, int n) {
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        if (moduleNode == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", parserResult);
            return null;
        }
        return new AstPath((ASTNode)moduleNode, n, baseDocument);
    }

    private AstPath getPathFromInfo(int n, ParserResult parserResult) {
        assert (parserResult != null);
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        if (moduleNode == null) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(true);
        return new AstPath((ASTNode)moduleNode, n, baseDocument);
    }

    private boolean completeKeywords(List<CompletionProposal> list, CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "-> completeKeywords");
        String string = completionRequest.prefix;
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS) {
            LOG.log(Level.FINEST, "no keywords completion inside of parameters");
            return false;
        }
        if (completionRequest.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        boolean bl = this.checkForPackageStatement(completionRequest);
        this.keywords = EnumSet.allOf(GroovyKeyword.class);
        this.filterPackageStatement(bl);
        this.filterPrefix(string);
        this.filterLocation(completionRequest.location);
        this.filterClassInterfaceOrdering(completionRequest.ctx);
        this.filterMethodDefinitions(completionRequest.ctx);
        this.filterKeywordsNextToEachOther(completionRequest.ctx);
        for (GroovyKeyword groovyKeyword : this.keywords) {
            LOG.log(Level.FINEST, "Adding keyword proposal : {0}", groovyKeyword.name);
            list.add((CompletionProposal)new CompletionItem.KeywordItem(groovyKeyword.name, null, this.anchor, completionRequest.info, groovyKeyword.isGroovy));
        }
        return true;
    }

    void filterPackageStatement(boolean bl) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (!groovyKeyword.name.equals("package") || !bl) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterPrefix(String string) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (groovyKeyword.name.startsWith(string)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterLocation(CaretLocation caretLocation) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (this.checkKeywordAllowance(groovyKeyword, caretLocation)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterClassInterfaceOrdering(CompletionContext completionContext) {
        if (completionContext == null || completionContext.beforeLiteral == null) {
            return;
        }
        if (completionContext.beforeLiteral.id() == GroovyTokenId.LITERAL_interface) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
        } else if (completionContext.beforeLiteral.id() == GroovyTokenId.LITERAL_class) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
            this.keywords.add(GroovyKeyword.KEYWORD_implements);
        }
    }

    void filterMethodDefinitions(CompletionContext completionContext) {
        if (completionContext == null || completionContext.afterLiteral == null) {
            return;
        }
        if (completionContext.afterLiteral.id() == GroovyTokenId.LITERAL_void || completionContext.afterLiteral.id() == GroovyTokenId.IDENTIFIER || ((GroovyTokenId)completionContext.afterLiteral.id()).primaryCategory().equals("number")) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.PRIMITIVE) continue;
                LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    void filterKeywordsNextToEachOther(CompletionContext completionContext) {
        if (completionContext == null) {
            return;
        }
        boolean bl = false;
        if (completionContext.after1 != null && ((GroovyTokenId)completionContext.after1.id()).primaryCategory().equals("keyword")) {
            bl = true;
        }
        if (completionContext.before1 != null && ((GroovyTokenId)completionContext.before1.id()).primaryCategory().equals("keyword")) {
            bl = true;
        }
        if (bl) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.KEYWORD) continue;
                LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    boolean checkKeywordAllowance(GroovyKeyword groovyKeyword, CaretLocation caretLocation) {
        if (caretLocation == null) {
            return false;
        }
        switch (caretLocation) {
            case ABOVE_FIRST_CLASS: {
                if (!groovyKeyword.aboveFistClass) break;
                return true;
            }
            case OUTSIDE_CLASSES: {
                if (!groovyKeyword.outsideClasses) break;
                return true;
            }
            case INSIDE_CLASS: {
                if (!groovyKeyword.insideClass) break;
                return true;
            }
            case INSIDE_METHOD: 
            case INSIDE_CLOSURE: {
                if (!groovyKeyword.insideCode) break;
                return true;
            }
        }
        return false;
    }

    private boolean completeNewVars(List<CompletionProposal> list, CompletionRequest completionRequest, List<String> list2) {
        LOG.log(Level.FINEST, "-> completeNewVars");
        if (completionRequest.location == CaretLocation.OUTSIDE_CLASSES) {
            LOG.log(Level.FINEST, "outside of any class, bail out.");
            return false;
        }
        if (completionRequest.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        if (list2 == null) {
            LOG.log(Level.FINEST, "Can not propose with newVars == null");
            return false;
        }
        boolean bl = false;
        for (String string : list2) {
            LOG.log(Level.FINEST, "Variable candidate: {0}", string);
            if (!string.startsWith(completionRequest.prefix)) continue;
            list.add((CompletionProposal)new CompletionItem.NewVarItem(string, this.anchor));
            bl = true;
        }
        return bl;
    }

    private boolean completeFields(List<CompletionProposal> list, CompletionRequest completionRequest) {
        ClassNode classNode;
        String string;
        LOG.log(Level.FINEST, "-> completeFields");
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS && !completionRequest.isBehindDot()) {
            LOG.log(Level.FINEST, "no fields completion inside of parameters-list");
            return false;
        }
        if (completionRequest.dotContext != null && completionRequest.dotContext.isMethodsOnly()) {
            return false;
        }
        if (completionRequest.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
            if (packageCompletionRequest.basePackage.length() > 0 && this.isValidPackage((ClasspathInfo)(string = this.getClasspathInfoFromRequest(completionRequest)), packageCompletionRequest.basePackage)) {
                LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
                return false;
            }
            classNode = this.getBeforeDotDeclaringClass(completionRequest);
            if (classNode == null) {
                LOG.log(Level.FINEST, "No declaring class found");
                return false;
            }
        } else {
            classNode = this.getSurroundingClassNode(completionRequest);
            if (classNode == null) {
                LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
        }
        int n = 0;
        string = completionRequest.prefix;
        if (completionRequest.prefix.startsWith("$")) {
            string = completionRequest.prefix.substring(1);
            n = 1;
        }
        Map<FieldSignature, ? extends CompletionItem> map = CompleteElementHandler.forCompilationInfo(completionRequest.info).getFields(this.getSurroundingClassNode(completionRequest), classNode, string, this.anchor + n);
        list.addAll(map.values());
        return true;
    }

    private boolean completeLocalVars(List<CompletionProposal> list, CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "-> completeLocalVars");
        if (!(completionRequest.location == CaretLocation.INSIDE_CLOSURE || completionRequest.location == CaretLocation.INSIDE_METHOD || completionRequest.location == CaretLocation.INSIDE_STRING && completionRequest.prefix.matches("\\$[^\\{].*"))) {
            LOG.log(Level.FINEST, "Not inside method, closure or in-string variable, bail out.");
            return false;
        }
        if (completionRequest.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        VariableFinderVisitor variableFinderVisitor = new VariableFinderVisitor(((ModuleNode)completionRequest.path.root()).getContext(), completionRequest.path, completionRequest.doc, completionRequest.astOffset);
        variableFinderVisitor.collect();
        boolean bl = false;
        int n = 0;
        String string = completionRequest.prefix;
        if (completionRequest.prefix.startsWith("$")) {
            string = completionRequest.prefix.substring(1);
            n = 1;
        }
        for (Variable variable : variableFinderVisitor.getVariables()) {
            String string2 = variable.getName();
            LOG.log(Level.FINEST, "Node found: {0}", string2);
            if (string.length() < 1) {
                list.add((CompletionProposal)new CompletionItem.LocalVarItem(variable, this.anchor + n));
                bl = true;
                continue;
            }
            if (string2.equals(string) || !string2.startsWith(string)) continue;
            list.add((CompletionProposal)new CompletionItem.LocalVarItem(variable, this.anchor + n));
            bl = true;
        }
        return bl;
    }

    private boolean checkForVariableDefinition(CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "checkForVariableDefinition()");
        CompletionContext completionContext = completionRequest.ctx;
        if (completionContext == null || completionContext.before1 == null) {
            return false;
        }
        GroovyTokenId groovyTokenId = (GroovyTokenId)completionContext.before1.id();
        switch (groovyTokenId) {
            case LITERAL_boolean: 
            case LITERAL_byte: 
            case LITERAL_char: 
            case LITERAL_double: 
            case LITERAL_float: 
            case LITERAL_int: 
            case LITERAL_long: 
            case LITERAL_short: 
            case LITERAL_def: {
                LOG.log(Level.FINEST, "LITERAL_* discovered");
                return true;
            }
            case IDENTIFIER: {
                ASTNode aSTNode = this.getASTNodeForToken(completionContext.before1, completionRequest);
                LOG.log(Level.FINEST, "getASTNodeForToken(ASTNode) : {0}", aSTNode);
                if (aSTNode != null && (aSTNode instanceof ClassExpression || aSTNode instanceof DeclarationExpression)) {
                    LOG.log(Level.FINEST, "ClassExpression or DeclarationExpression discovered");
                    return true;
                }
                return false;
            }
        }
        LOG.log(Level.FINEST, "default:");
        return false;
    }

    private ASTNode getASTNodeForToken(Token<? extends GroovyTokenId> token, CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "getASTNodeForToken()");
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)completionRequest.doc);
        int n = token.offset(tokenHierarchy);
        ModuleNode moduleNode = AstUtilities.getRoot(completionRequest.info);
        if (moduleNode == null) {
            return null;
        }
        int n2 = AstUtilities.getAstOffset((Parser.Result)completionRequest.info, n);
        if (n2 == -1) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)completionRequest.info.getSnapshot().getSource().getDocument(false);
        if (baseDocument == null) {
            LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        AstPath astPath = new AstPath((ASTNode)moduleNode, n2, baseDocument);
        ASTNode aSTNode = astPath.leaf();
        LOG.log(Level.FINEST, "path = {0}", astPath);
        LOG.log(Level.FINEST, "node: {0}", aSTNode);
        return aSTNode;
    }

    private List<String> getNewVarNameSuggestion(CompletionContext completionContext) {
        String string;
        LOG.log(Level.FINEST, "getNewVarNameSuggestion()");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (completionContext == null || completionContext.before1 == null) {
            return arrayList;
        }
        if (completionContext.before1.id() == GroovyTokenId.LITERAL_boolean) {
            arrayList.add("b");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_byte) {
            arrayList.add("b");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_char) {
            arrayList.add("c");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_double) {
            arrayList.add("d");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_float) {
            arrayList.add("f");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_int) {
            arrayList.add("i");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_long) {
            arrayList.add("l");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_short) {
            arrayList.add("s");
        }
        if (completionContext.before1.id() == GroovyTokenId.IDENTIFIER && (string = ((Object)completionContext.before1.text()).toString()) != null) {
            this.addIfNotIn(arrayList, string.substring(0, 1).toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(arrayList, string.toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(arrayList, CompletionHandler.camelCaseHunch(string));
            this.addIfNotIn(arrayList, string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1));
        }
        return arrayList;
    }

    void addIfNotIn(List<String> list, String string) {
        if (string.length() > 0 && !list.contains(string)) {
            LOG.log(Level.FINEST, "Adding new-var suggestion : {0}", string);
            list.add(string);
        }
    }

    private static String camelCaseHunch(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char c2 = Character.toLowerCase(c);
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    boolean checkForRequestBehindImportStatement(CompletionRequest completionRequest) {
        int n = 0;
        int n2 = 0;
        try {
            n = Utilities.getRowStart((BaseDocument)completionRequest.doc, (int)completionRequest.lexOffset);
            n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)completionRequest.doc, (int)n);
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.FINEST, "Trouble doing getRowStart() or getFirstNonWhiteFwd(): {0}", badLocationException.getMessage());
        }
        Token<? extends GroovyTokenId> token = LexUtilities.getToken(completionRequest.doc, n2);
        if (token != null && token.id() == GroovyTokenId.LITERAL_import) {
            LOG.log(Level.FINEST, "Right behind an import statement");
            return true;
        }
        return false;
    }

    boolean checkBehindDot(CompletionRequest completionRequest) {
        boolean bl = false;
        if (completionRequest == null || completionRequest.ctx == null || completionRequest.ctx.before1 == null) {
            bl = false;
        } else if (CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before1.text(), (CharSequence)".") || ((Object)completionRequest.ctx.before1.text()).toString().equals(completionRequest.prefix) && completionRequest.ctx.before2 != null && CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before2.text(), (CharSequence)".")) {
            bl = true;
        }
        return bl;
    }

    PackageCompletionRequest getPackageRequest(CompletionRequest completionRequest) {
        Object object;
        StringBuffer stringBuffer;
        int n = completionRequest.lexOffset;
        PackageCompletionRequest packageCompletionRequest = new PackageCompletionRequest();
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        tokenSequence.move(n);
        StringBuffer stringBuffer2 = null;
        boolean bl = true;
        while (tokenSequence.isValid() && (bl = tokenSequence.movePrevious()) && tokenSequence.offset() >= 0 && ((stringBuffer = tokenSequence.token()).id() == GroovyTokenId.DOT || stringBuffer.id() == GroovyTokenId.IDENTIFIER)) {
            stringBuffer2 = stringBuffer;
        }
        stringBuffer = new StringBuffer();
        CharSequence charSequence = null;
        if (!bl && stringBuffer2 != null && tokenSequence.isValid()) {
            stringBuffer.append(((Object)stringBuffer2.text()).toString());
            charSequence = stringBuffer2;
        }
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < n && ((object = tokenSequence.token()).id() == GroovyTokenId.DOT || object.id() == GroovyTokenId.IDENTIFIER)) {
            stringBuffer.append(((Object)object.text()).toString());
            charSequence = object;
        }
        packageCompletionRequest.fullString = stringBuffer.toString();
        if (stringBuffer.length() == 0) {
            packageCompletionRequest.basePackage = "";
            packageCompletionRequest.prefix = "";
        } else if (charSequence != null && charSequence.id() == GroovyTokenId.DOT) {
            object = stringBuffer.toString();
            packageCompletionRequest.basePackage = ((String)object).substring(0, ((String)object).length() - 1);
            packageCompletionRequest.prefix = "";
        } else if (charSequence != null && charSequence.id() == GroovyTokenId.IDENTIFIER) {
            object = stringBuffer.toString();
            packageCompletionRequest.prefix = ((Object)charSequence.text()).toString();
            packageCompletionRequest.basePackage = ((String)object).substring(0, ((String)object).length() - packageCompletionRequest.prefix.length());
            if (packageCompletionRequest.basePackage.endsWith(".")) {
                packageCompletionRequest.basePackage = packageCompletionRequest.basePackage.substring(0, packageCompletionRequest.basePackage.length() - 1);
            }
        }
        LOG.log(Level.FINEST, "-- fullString : >{0}<", packageCompletionRequest.fullString);
        LOG.log(Level.FINEST, "-- basePackage: >{0}<", packageCompletionRequest.basePackage);
        LOG.log(Level.FINEST, "-- prefix:      >{0}<", packageCompletionRequest.prefix);
        return packageCompletionRequest;
    }

    private DotCompletionContext getDotCompletionContext(CompletionRequest completionRequest) {
        Token token;
        if (completionRequest.dotContext != null) {
            return completionRequest.dotContext;
        }
        int n = completionRequest.lexOffset;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        int n2 = tokenSequence.move(n);
        Token token2 = null;
        if (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() >= 0) {
            token2 = tokenSequence.token();
        }
        if (LOG.isLoggable(Level.FINE) && tokenSequence.isValid() && token2 != null) {
            LOG.log(Level.FINE, "Current token text {0}", token2.text());
        }
        if (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() != GroovyTokenId.DOT && token.id() != GroovyTokenId.OPTIONAL_DOT && token.id() != GroovyTokenId.MEMBER_POINTER && token.id() != GroovyTokenId.WHITESPACE && token.id() != GroovyTokenId.NLS) {
            if (token.id() != GroovyTokenId.IDENTIFIER) {
                return null;
            }
            tokenSequence.movePrevious();
        }
        boolean bl = true;
        if (tokenSequence.token().id() != GroovyTokenId.DOT && tokenSequence.token().id() != GroovyTokenId.OPTIONAL_DOT && tokenSequence.token().id() != GroovyTokenId.MEMBER_POINTER) {
            Token token3;
            while (tokenSequence.isValid() && (bl = tokenSequence.movePrevious()) && tokenSequence.offset() >= 0 && ((token3 = tokenSequence.token()).id() == GroovyTokenId.WHITESPACE || token3.id() == GroovyTokenId.NLS)) {
            }
        }
        if (tokenSequence.token().id() != GroovyTokenId.DOT && tokenSequence.token().id() != GroovyTokenId.OPTIONAL_DOT && tokenSequence.token().id() != GroovyTokenId.MEMBER_POINTER || !bl) {
            return null;
        }
        boolean bl2 = false;
        if (tokenSequence.token().id() == GroovyTokenId.MEMBER_POINTER) {
            bl2 = true;
        }
        Token token4 = null;
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && ((token4 = tokenSequence.token()).id() == GroovyTokenId.WHITESPACE || token4.id() == GroovyTokenId.NLS)) {
        }
        int n3 = tokenSequence.offset();
        int n4 = AstUtilities.getAstOffset((Parser.Result)completionRequest.info, n3);
        AstPath astPath = this.getPath(completionRequest.info, completionRequest.doc, n4);
        return new DotCompletionContext(n3, n4, astPath, bl2);
    }

    private ClasspathInfo getClasspathInfoFromRequest(CompletionRequest completionRequest) {
        FileObject fileObject = completionRequest.info.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            return ClasspathInfo.create((FileObject)fileObject);
        }
        return null;
    }

    private JavaSource getJavaSourceFromRequest(CompletionRequest completionRequest) {
        ClasspathInfo classpathInfo = this.getClasspathInfoFromRequest(completionRequest);
        assert (classpathInfo != null);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    private boolean completePackages(List<CompletionProposal> list, CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "-> completePackages");
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        if (completionRequest.isBehindDot() && packageCompletionRequest.basePackage.length() <= 0) {
            return false;
        }
        LOG.log(Level.FINEST, "Token fullString = >{0}<", packageCompletionRequest.fullString);
        ClasspathInfo classpathInfo = this.getClasspathInfoFromRequest(completionRequest);
        assert (classpathInfo != null) : "Can not get ClasspathInfo";
        if (completionRequest.ctx.before1 != null && CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before1.text(), (CharSequence)"*") && completionRequest.behindImport) {
            return false;
        }
        Set set = classpathInfo.getClassIndex().getPackageNames(packageCompletionRequest.fullString, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (String string : set) {
            LOG.log(Level.FINEST, "PKG set item: {0}", string);
            if (packageCompletionRequest.prefix.equals("")) {
                string = string.substring(packageCompletionRequest.fullString.length());
            } else if (!packageCompletionRequest.basePackage.equals("")) {
                string = string.substring(packageCompletionRequest.basePackage.length() + 1);
            }
            if (!string.startsWith(packageCompletionRequest.prefix) || string.length() <= 0) continue;
            CompletionItem.PackageItem packageItem = new CompletionItem.PackageItem(string, this.anchor, completionRequest.info);
            if (completionRequest.behindImport) {
                packageItem.setSmart(true);
            }
            list.add((CompletionProposal)packageItem);
        }
        return false;
    }

    private boolean isValidPackage(ClasspathInfo classpathInfo, String string) {
        assert (classpathInfo != null) : "ClasspathInfo can not be null";
        Set set = classpathInfo.getClassIndex().getPackageNames(string, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        if (set.size() > 0) {
            LOG.log(Level.FINEST, "Packages with prefix : {0}", string);
            LOG.log(Level.FINEST, "               found : {0}", set);
            for (String string2 : set) {
                if (!string2.equals(string)) continue;
                LOG.log(Level.FINEST, "Exact match found.");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean completeTypes(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Collection<TypeHolder> collection;
        Object object3;
        Object object4;
        Object object522;
        LOG.log(Level.FINEST, "-> completeTypes");
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() == 0 && packageCompletionRequest.prefix.length() == 0 && packageCompletionRequest.fullString.equals(".")) {
            return false;
        }
        if (completionRequest.ctx.before1 != null && ((Object)completionRequest.ctx.before1.text()).toString().equals("new") && completionRequest.prefix.length() > 0) {
            return false;
        }
        boolean bl = false;
        if (completionRequest.ctx.beforeLiteral != null && completionRequest.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_implements) {
            LOG.log(Level.FINEST, "Completing only interfaces after implements keyword.");
            bl = true;
        }
        ModuleNode moduleNode = null;
        AstPath astPath = completionRequest.path;
        if (astPath != null) {
            for (Object object522 : astPath) {
                if (!(object522 instanceof ModuleNode)) continue;
                LOG.log(Level.FINEST, "Found ModuleNode");
                moduleNode = (ModuleNode)object522;
            }
        }
        Object object6 = null;
        if (moduleNode != null) {
            object6 = moduleNode.getPackageName();
        } else {
            object522 = this.getSurroundingClassNode(completionRequest);
            if (object522 != null) {
                object6 = ((ClassNode)object522).getPackageName();
            }
        }
        object522 = new HashSet();
        JavaSource javaSource = this.getJavaSourceFromRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() > 0 || completionRequest.behindImport) {
            if (!completionRequest.behindImport || packageCompletionRequest.basePackage.length() != 0) {
                List<TypeHolder> list2 = this.getElementListForPackageAsTypeHolder(javaSource, packageCompletionRequest.basePackage, (String)object6);
                if (list2 == null) {
                    LOG.log(Level.FINEST, "Typelist is null for package : {0}", packageCompletionRequest.basePackage);
                    return false;
                }
                LOG.log(Level.FINEST, "Number of types found:  {0}", list2.size());
                for (TypeHolder typeHolder : list2) {
                    this.addToProposalUsingFilter((Set<TypeHolder>)object522, list, completionRequest, typeHolder, bl);
                }
            }
            return true;
        }
        if (completionRequest.isBehindDot()) {
            return false;
        }
        if (moduleNode != null) {
            LOG.log(Level.FINEST, "We are living in package : {0} ", object6);
            object4 = null;
            object3 = completionRequest.info.getSnapshot().getSource().getFileObject();
            if (object3 != null) {
                object4 = GroovyIndex.get(QuerySupport.findRoots(object3, Collections.singleton("classpath/source"), Collections.emptyList(), Collections.emptyList()));
            }
            if (object4 != null) {
                Set<IndexedClass> object22 = ((GroovyIndex)object4).getClasses(completionRequest.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, true, false, false);
                if (object22.size() == 0) {
                    LOG.log(Level.FINEST, "Nothing found in GroovyIndex");
                } else {
                    LOG.log(Level.FINEST, "Found this number of classes : {0} ", object22.size());
                    collection = new HashSet();
                    for (IndexedClass indexedClass : object22) {
                        LOG.log(Level.FINEST, "FQN classname from index : {0} ", indexedClass.getFqn());
                        ElementKind elementKind = indexedClass.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS ? ElementKind.CLASS : ElementKind.INTERFACE;
                        collection.add(new TypeHolder(indexedClass.getFqn(), elementKind));
                    }
                    for (TypeHolder typeHolder : collection) {
                        this.addToProposalUsingFilter((Set<TypeHolder>)object522, list, completionRequest, typeHolder, bl);
                    }
                }
            }
        }
        object4 = new ArrayList<String>();
        if (moduleNode != null) {
            object3 = moduleNode.getImports();
            if (object3 != null) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    collection = (ImportNode)iterator.next();
                    LOG.log(Level.FINEST, "From getImports() : {0} ", ((ImportNode)((Object)collection)).getClassName());
                    Object object = collection.getClass().isInterface() ? ElementKind.INTERFACE : ElementKind.CLASS;
                    this.addToProposalUsingFilter((Set<TypeHolder>)object522, list, completionRequest, new TypeHolder(((ImportNode)((Object)collection)).getClassName(), (ElementKind)((Object)object)), bl);
                }
            }
            List list2 = moduleNode.getImportPackages();
            for (Object object : list2) {
                LOG.log(Level.FINEST, "From getImportPackages() : {0} ", object);
                if (object.endsWith(".")) {
                    object = object.substring(0, object.length() - 1);
                }
                object4.add(object);
            }
        }
        object4.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
        object3 = object4.iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            collection = this.getElementListForPackageAsTypeHolder(javaSource, string, (String)object6);
            if (collection == null) {
                LOG.log(Level.FINEST, "Typelist is null for package : {0}", string);
                continue;
            }
            LOG.log(Level.FINEST, "Number of types found:  {0}", collection.size());
            for (TypeHolder typeHolder : collection) {
                this.addToProposalUsingFilter((Set<TypeHolder>)object522, list, completionRequest, typeHolder, bl);
            }
        }
        for (String string : GroovyUtils.DEFAULT_IMPORT_CLASSES) {
            this.addToProposalUsingFilter((Set<TypeHolder>)object522, list, completionRequest, new TypeHolder(string, ElementKind.CLASS), bl);
        }
        return true;
    }

    void addToProposalUsingFilter(Set<TypeHolder> set, List<CompletionProposal> list, CompletionRequest completionRequest, TypeHolder typeHolder, boolean bl) {
        if (bl && typeHolder.getKind() != ElementKind.INTERFACE || set.contains(typeHolder)) {
            return;
        }
        String string = NbUtilities.stripPackage(typeHolder.getName());
        if (string.toUpperCase(Locale.ENGLISH).startsWith(completionRequest.prefix.toUpperCase(Locale.ENGLISH))) {
            set.add(typeHolder);
            list.add((CompletionProposal)new CompletionItem.TypeItem(string, this.anchor, typeHolder.getKind()));
        }
    }

    List<? extends Element> getElementListForPackage(Elements elements, JavaSource javaSource, String string) {
        LOG.log(Level.FINEST, "getElementListForPackage(), Package :  {0}", string);
        List<? extends Element> list = null;
        if (elements != null && string != null) {
            LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
            PackageElement packageElement = elements.getPackageElement(string);
            if (packageElement == null) {
                LOG.log(Level.FINEST, "packageElement is null");
            } else {
                list = packageElement.getEnclosedElements();
            }
        }
        LOG.log(Level.FINEST, "Returning Typlist");
        return list;
    }

    List<TypeHolder> getElementListForPackageAsTypeHolder(JavaSource javaSource, final String string, final String string2) {
        LOG.log(Level.FINEST, "getElementListForPackageAsString(), Package :  {0}", string);
        final ArrayList<TypeHolder> arrayList = new ArrayList<TypeHolder>();
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) {
                        List<? extends Element> list = null;
                        Elements elements = compilationController.getElements();
                        if (elements != null && string != null) {
                            LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
                            PackageElement packageElement = elements.getPackageElement(string);
                            if (packageElement == null) {
                                LOG.log(Level.FINEST, "packageElement is null");
                            } else {
                                list = packageElement.getEnclosedElements();
                                boolean bl = string.equals(string2);
                                for (Element element : list) {
                                    Set<Modifier> set = element.getModifiers();
                                    if (!set.contains((Object)Modifier.PUBLIC) && (!bl || !set.contains((Object)Modifier.PROTECTED) && (set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PRIVATE)))) continue;
                                    arrayList.add(new TypeHolder(element.toString(), element.getKind()));
                                }
                            }
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                LOG.log(Level.FINEST, "IOException : {0}", iOException.getMessage());
            }
        }
        return arrayList;
    }

    boolean isPackageAlreadyProposed(Set<String> set, String string) {
        for (String string2 : set) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private ClassNode getBeforeDotDeclaringClass(CompletionRequest completionRequest) {
        Expression expression;
        assert (completionRequest.isBehindDot() || completionRequest.ctx.before1 == null);
        if (completionRequest.declaringClass != null && completionRequest.declaringClass instanceof ClassNode) {
            LOG.log(Level.FINEST, "returning declaringClass from request.");
            return completionRequest.declaringClass;
        }
        DotCompletionContext dotCompletionContext = this.getDotCompletionContext(completionRequest);
        if (!(completionRequest.isBehindDot() || completionRequest.ctx.before1 != null || completionRequest.location != CaretLocation.INSIDE_CLOSURE && completionRequest.location != CaretLocation.INSIDE_METHOD)) {
            completionRequest.declaringClass = this.getSurroundingClassNode(completionRequest);
            return completionRequest.declaringClass;
        }
        if (dotCompletionContext == null || dotCompletionContext.getAstPath() == null || dotCompletionContext.getAstPath().leaf() == null) {
            return null;
        }
        completionRequest.beforeDotPath = dotCompletionContext.getAstPath();
        Object var3_3 = null;
        GroovyTypeAnalyzer groovyTypeAnalyzer = new GroovyTypeAnalyzer(completionRequest.doc);
        Set<ClassNode> set = groovyTypeAnalyzer.getTypes(dotCompletionContext.getAstPath(), dotCompletionContext.getAstOffset());
        if (!set.isEmpty()) {
            return set.iterator().next();
        }
        if (var3_3 != null) {
            completionRequest.declaringClass = var3_3;
            return completionRequest.declaringClass;
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof VariableExpression) {
            expression = (VariableExpression)dotCompletionContext.getAstPath().leaf();
            if ("this".equals(((VariableExpression)expression).getName())) {
                completionRequest.declaringClass = this.getSurroundingClassNode(completionRequest);
                return completionRequest.declaringClass;
            }
            if ("super".equals(((VariableExpression)expression).getName())) {
                ClassNode classNode = this.getSurroundingClassNode(completionRequest);
                completionRequest.declaringClass = classNode.getSuperClass();
                if (completionRequest.declaringClass == null) {
                    return new ClassNode("java.lang.Object", 1, null);
                }
                return completionRequest.declaringClass;
            }
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof Expression) {
            expression = (Expression)dotCompletionContext.getAstPath().leaf();
            if (expression instanceof RangeExpression && "java.lang.Object".equals(expression.getType().getName())) {
                try {
                    expression.setType(new ClassNode(Class.forName("groovy.lang.Range")));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    expression.setType(new ClassNode("groovy.lang.Range", 513, null));
                }
            }
            completionRequest.declaringClass = expression.getType();
        }
        return completionRequest.declaringClass;
    }

    private static List<CompletionItem.ParameterDescriptor> getParameterList(ExecutableElement executableElement) {
        ArrayList<CompletionItem.ParameterDescriptor> arrayList = new ArrayList<CompletionItem.ParameterDescriptor>();
        if (executableElement != null) {
            List<? extends VariableElement> list = null;
            try {
                list = executableElement.getParameters();
                int n = 1;
                for (VariableElement variableElement : list) {
                    String string;
                    TypeMirror typeMirror = variableElement.asType();
                    String string2 = string = ((Object)typeMirror).toString();
                    if (typeMirror.getKind() == TypeKind.DECLARED) {
                        string2 = NbUtilities.stripPackage(string);
                    }
                    String string3 = "param" + String.valueOf(n);
                    arrayList.add(new CompletionItem.ParameterDescriptor(string, string2, string3));
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static String getParameterListForMethod(ExecutableElement executableElement) {
        StringBuffer stringBuffer = new StringBuffer();
        if (executableElement != null) {
            List<? extends VariableElement> list = null;
            try {
                list = executableElement.getParameters();
                for (VariableElement variableElement : list) {
                    TypeMirror typeMirror = variableElement.asType();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if (typeMirror.getKind() == TypeKind.DECLARED || typeMirror.getKind() == TypeKind.ARRAY) {
                        stringBuffer.append(NbUtilities.stripPackage(((Object)typeMirror).toString()));
                        continue;
                    }
                    stringBuffer.append(((Object)typeMirror).toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private boolean completeMethods(final List<CompletionProposal> list, final CompletionRequest completionRequest) {
        Object object;
        LOG.log(Level.FINEST, "-> completeMethods");
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS) {
            LOG.log(Level.FINEST, "no method completion inside of parameters");
            return false;
        }
        if (completionRequest == null || completionRequest.ctx == null) {
            return false;
        }
        if (completionRequest.ctx.before1 != null && ((Object)completionRequest.ctx.before1.text()).toString().equals("new") && completionRequest.prefix.length() > 0) {
            LOG.log(Level.FINEST, "This looks like a constructor ...");
            final ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
            final JavaSource javaSource = this.getJavaSourceFromRequest(completionRequest);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) {
                            for (String string : arrayList) {
                                List<? extends Element> list4 = CompletionHandler.this.getElementListForPackage(compilationController.getElements(), javaSource, string);
                                if (list4 == null) {
                                    LOG.log(Level.FINEST, "Typelist is null for package : {0}", string);
                                    continue;
                                }
                                LOG.log(Level.FINEST, "Number of types found:  {0}", list4.size());
                                for (Element element : list4) {
                                    if (element.getKind() != ElementKind.CLASS) continue;
                                    TypeElement typeElement = (TypeElement)element;
                                    List<? extends Element> list2 = typeElement.getEnclosedElements();
                                    String string2 = typeElement.getSimpleName().toString();
                                    for (Element element2 : list2) {
                                        if (element2.getKind() != ElementKind.CONSTRUCTOR || !string2.toUpperCase(Locale.ENGLISH).startsWith(completionRequest.prefix.toUpperCase(Locale.ENGLISH))) continue;
                                        LOG.log(Level.FINEST, "Constructor call candidate added : {0}", string2);
                                        String string3 = CompletionHandler.getParameterListForMethod((ExecutableElement)element2);
                                        List list3 = CompletionHandler.getParameterList((ExecutableElement)element2);
                                        list.add(new CompletionItem.ConstructorItem(string2, string3, list3, CompletionHandler.this.anchor, false));
                                    }
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINEST, "IOException : {0}", iOException.getMessage());
                }
            }
            return !list.isEmpty();
        }
        if (!completionRequest.isBehindDot() && completionRequest.ctx.before1 != null) {
            LOG.log(Level.FINEST, "I'm not invoked behind a dot.");
            return false;
        }
        ClassNode classNode = this.getBeforeDotDeclaringClass(completionRequest);
        if (classNode == null) {
            LOG.log(Level.FINEST, "No declaring class found");
            return false;
        }
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() > 0 && this.isValidPackage((ClasspathInfo)(object = this.getClasspathInfoFromRequest(completionRequest)), packageCompletionRequest.basePackage)) {
            LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
            return false;
        }
        object = CompleteElementHandler.forCompilationInfo(completionRequest.info).getMethods(this.getSurroundingClassNode(completionRequest), classNode, completionRequest.prefix, this.anchor, completionRequest.dotContext != null && completionRequest.dotContext.isMethodsOnly());
        list.addAll(object.values());
        return true;
    }

    private boolean completeCamelCase(List<CompletionProposal> list, CompletionRequest completionRequest) {
        LOG.log(Level.FINEST, "-> completeCamelCase");
        if (completionRequest.location != CaretLocation.INSIDE_CLASS) {
            LOG.log(Level.FINEST, "Not inside a class");
            return false;
        }
        String string = completionRequest.prefix;
        if (string != null && string.length() > 0 && string.equals(string.toUpperCase())) {
            ClassNode classNode = this.getSurroundingClassNode(completionRequest);
            if (classNode == null) {
                LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
            String string2 = this.computeCamelCaseSignature(classNode.getName());
            LOG.log(Level.FINEST, "Class name          : {0}", classNode.getName());
            LOG.log(Level.FINEST, "CamelCase signature : {0}", string2);
            if (string2.startsWith(string)) {
                LOG.log(Level.FINEST, "Prefix matches Class's CamelCase signature. Adding.");
                list.add((CompletionProposal)new CompletionItem.ConstructorItem(classNode.getName(), null, null, this.anchor, true));
                return true;
            }
        }
        return false;
    }

    private String computeCamelCaseSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        ParserResult parserResult = codeCompletionContext.getParserResult();
        String string = codeCompletionContext.getPrefix();
        int n = codeCompletionContext.getCaretOffset();
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        LOG.log(Level.FINEST, "complete(...), prefix      : {0}", string);
        LOG.log(Level.FINEST, "complete(...), lexOffset   : {0}", n);
        LOG.log(Level.FINEST, "complete(...), astOffset   : {0}", n2);
        if (string == null) {
            string = "";
        }
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        this.anchor = n - string.length();
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        baseDocument.readLock();
        try {
            CompletionRequest completionRequest = new CompletionRequest();
            completionRequest.lexOffset = n;
            completionRequest.astOffset = n2;
            completionRequest.doc = baseDocument;
            completionRequest.info = parserResult;
            completionRequest.prefix = string;
            completionRequest.scriptMode = false;
            completionRequest.path = this.getPathFromRequest(completionRequest);
            LOG.log(Level.FINEST, "complete(...), path        : {0}", completionRequest.path);
            completionRequest.location = this.getCaretLocationFromRequest(completionRequest);
            LOG.log(Level.FINEST, "I am here in sourcecode: {0}", (Object)completionRequest.location);
            if (completionRequest.location == CaretLocation.ABOVE_PACKAGE || completionRequest.location == CaretLocation.INSIDE_COMMENT) {
                DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
                return defaultCompletionResult;
            }
            completionRequest.ctx = this.getCompletionContext(completionRequest);
            assert (completionRequest.ctx != null);
            completionRequest.dotContext = this.getDotCompletionContext(completionRequest);
            if (completionRequest.isBehindDot()) {
                completionRequest.declaringClass = this.getBeforeDotDeclaringClass(completionRequest);
            }
            boolean bl = this.checkForVariableDefinition(completionRequest);
            completionRequest.behindImport = this.checkForRequestBehindImportStatement(completionRequest);
            List<String> list = null;
            if (bl) {
                list = this.getNewVarNameSuggestion(completionRequest.ctx);
            } else {
                if (completionRequest.location != CaretLocation.OUTSIDE_CLASSES && completionRequest.location != CaretLocation.INSIDE_STRING) {
                    this.completePackages(arrayList, completionRequest);
                    this.completeTypes(arrayList, completionRequest);
                }
                if (!completionRequest.behindImport) {
                    if (completionRequest.location != CaretLocation.INSIDE_STRING) {
                        this.completeKeywords(arrayList, completionRequest);
                        this.completeMethods(arrayList, completionRequest);
                    }
                    this.completeFields(arrayList, completionRequest);
                    this.completeLocalVars(arrayList, completionRequest);
                }
            }
            this.completeNewVars(arrayList, completionRequest, list);
            this.completeCamelCase(arrayList, completionRequest);
            DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
            return defaultCompletionResult;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    public static String getMethodSignature(MetaMethod metaMethod, boolean bl, boolean bl2) {
        String string = metaMethod.getSignature();
        string = string.trim();
        if (bl2) {
            int n = string.indexOf(" ");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (bl) {
                string = string.replaceAll(", ", ",%20");
            }
            return string;
        }
        String[] stringArray = string.split("[()]");
        if (stringArray.length < 2) {
            return "";
        }
        String string2 = CompletionHandler.decodeTypes(stringArray[1], bl);
        return stringArray[0] + "(" + string2 + ")";
    }

    static String decodeTypes(String string, boolean bl) {
        String string2 = ",";
        string2 = bl ? string2 + "%20" : string2 + " ";
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '[') {
                bl2 = true;
                continue;
            }
            if (c == 'Z') {
                stringBuffer.append("boolean");
            } else if (c == 'B') {
                stringBuffer.append("byte");
            } else if (c == 'C') {
                stringBuffer.append("char");
            } else if (c == 'D') {
                stringBuffer.append("double");
            } else if (c == 'F') {
                stringBuffer.append("float");
            } else if (c == 'I') {
                stringBuffer.append("int");
            } else if (c == 'J') {
                stringBuffer.append("long");
            } else if (c == 'S') {
                stringBuffer.append("short");
            } else if (c == 'L') {
                int n = string.indexOf(";", ++i);
                String string3 = string.substring(i, n);
                string3 = string3.replace('/', '.');
                if (bl) {
                    stringBuffer.append(string3);
                } else {
                    stringBuffer.append(NbUtilities.stripPackage(string3));
                }
                i = n;
            }
            if (bl2) {
                stringBuffer.append("[]");
                bl2 = false;
            }
            if (i >= string.length() - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String document(ParserResult parserResult, ElementHandle elementHandle) {
        LOG.log(Level.FINEST, "document(), ElementHandle : {0}", elementHandle);
        String string = NbBundle.getMessage(CompletionHandler.class, (String)"GroovyCompletion_NoJavaDocFound");
        String string2 = null;
        if (elementHandle instanceof AstMethodElement) {
            Object object;
            String string3;
            Object object2;
            String string4;
            String string5;
            AstMethodElement astMethodElement = (AstMethodElement)elementHandle;
            String string6 = "";
            String string7 = this.getGroovyJavadocBase();
            if (this.jdkJavaDocBase != null && !astMethodElement.isGDK()) {
                string6 = this.jdkJavaDocBase;
            } else if (string7 != null && astMethodElement.isGDK()) {
                string6 = string7;
            } else {
                LOG.log(Level.FINEST, "Neither JDK nor GDK or error locating: {0}", astMethodElement.isGDK());
                return string;
            }
            MetaMethod metaMethod = astMethodElement.getMethod();
            CompletionHandler.printMethod(metaMethod);
            if (astMethodElement.isGDK()) {
                string5 = metaMethod.getDeclaringClass().getName();
            } else {
                string4 = null;
                if (metaMethod != null && (object2 = metaMethod.getDeclaringClass()) != null) {
                    string4 = ((CachedClass)object2).getName();
                }
                string5 = string4 != null ? string4 : astMethodElement.getClz().getName();
            }
            string4 = string5.replace(".", "/");
            string4 = string4 + ".html";
            if (!astMethodElement.isGDK()) {
                string3 = this.getGroovyApiDocBase();
                try {
                    object2 = new URL(string3 + string4);
                    object = new File(((URL)object2).toURI());
                }
                catch (MalformedURLException malformedURLException) {
                    LOG.log(Level.FINEST, "MalformedURLException: {0}", malformedURLException);
                    return string;
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOG.log(Level.FINEST, "URISyntaxException: {0}", uRISyntaxException);
                    return string;
                }
                if (object != null && ((File)object).exists()) {
                    string6 = string3;
                }
            }
            object2 = CompletionHandler.getMethodSignature(astMethodElement.getMethod(), true, astMethodElement.isGDK());
            object = CompletionHandler.getMethodSignature(astMethodElement.getMethod(), false, astMethodElement.isGDK());
            string3 = string6 + string4 + "#" + (String)object2;
            try {
                LOG.log(Level.FINEST, "Trying to load URL = {0}", string3);
                string2 = HTMLJavadocParser.getJavadocText(new URL(string3), false, astMethodElement.isGDK());
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.FINEST, "document(), URL trouble: {0}", malformedURLException);
                return string;
            }
            if (string2 == null) {
                return string;
            }
            string2 = "<h3>" + string5 + "." + (String)object + "</h3><BR>" + string2;
        }
        return string2;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return elementHandle;
    }

    public String getPrefix(ParserResult parserResult, int n, boolean bl) {
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        char c = string.charAt(0);
        if (c == '.') {
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, ParserResult parserResult, int n, String string2, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(ParserResult parserResult, int n, int n2) {
        return Collections.emptySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterInfo parameters(ParserResult parserResult, int n, CompletionProposal completionProposal) {
        LOG.log(Level.FINEST, "parameters(), caretOffset = {0}", n);
        ArrayList<String> arrayList = new ArrayList<String>();
        AstPath astPath = this.getPathFromInfo(n, parserResult);
        BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(true);
        if (astPath != null) {
            ArgumentListExpression argumentListExpression = this.getSurroundingArgumentList(astPath);
            if (argumentListExpression != null) {
                List<ASTNode> list = AstUtilities.children(argumentListExpression);
                int n2 = 1;
                int n3 = -1;
                int n4 = -1;
                for (ASTNode aSTNode : list) {
                    OffsetRange offsetRange = AstUtilities.getRange(aSTNode, baseDocument);
                    arrayList.add(aSTNode.getText());
                    if (offsetRange.containsInclusive(n)) {
                        n4 = offsetRange.getStart();
                        n3 = n2;
                    }
                    ++n2;
                }
                if (arrayList == null || arrayList.isEmpty()) return ParameterInfo.NONE;
                return new ParameterInfo(arrayList, n3, n4);
            }
            LOG.log(Level.FINEST, "ArgumentListExpression ==  null");
            return ParameterInfo.NONE;
        }
        LOG.log(Level.FINEST, "path ==  null");
        return ParameterInfo.NONE;
    }

    private static class TypeHolder {
        private final String name;
        private final ElementKind kind;

        public TypeHolder(String string, ElementKind elementKind) {
            this.name = string;
            this.kind = elementKind;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TypeHolder typeHolder = (TypeHolder)object;
            if (this.name == null ? typeHolder.name != null : !this.name.equals(typeHolder.name)) {
                return false;
            }
            return this.kind == typeHolder.kind;
        }

        public int hashCode() {
            int n = 3;
            n = 59 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 59 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }
    }

    static class CompletionRequest {
        ParserResult info;
        int lexOffset;
        int astOffset;
        BaseDocument doc;
        String prefix = "";
        CaretLocation location;
        boolean scriptMode;
        boolean behindImport;
        CompletionContext ctx;
        AstPath path;
        AstPath beforeDotPath;
        ClassNode declaringClass;
        DotCompletionContext dotContext;

        CompletionRequest() {
        }

        public boolean isBehindDot() {
            return this.dotContext != null;
        }
    }

    private static class DotCompletionContext {
        private final int lexOffset;
        private final int astOffset;
        private final AstPath astPath;
        private final boolean methodsOnly;

        public DotCompletionContext(int n, int n2, AstPath astPath, boolean bl) {
            this.lexOffset = n;
            this.astOffset = n2;
            this.astPath = astPath;
            this.methodsOnly = bl;
        }

        public int getLexOffset() {
            return this.lexOffset;
        }

        public int getAstOffset() {
            return this.astOffset;
        }

        public AstPath getAstPath() {
            return this.astPath;
        }

        public boolean isMethodsOnly() {
            return this.methodsOnly;
        }
    }

    class PackageCompletionRequest {
        String fullString = "";
        String basePackage = "";
        String prefix = "";

        PackageCompletionRequest() {
        }
    }

    class CompletionContext {
        Token<? extends GroovyTokenId> beforeLiteral;
        Token<? extends GroovyTokenId> before2;
        Token<? extends GroovyTokenId> before1;
        Token<? extends GroovyTokenId> active;
        Token<? extends GroovyTokenId> after1;
        Token<? extends GroovyTokenId> after2;
        Token<? extends GroovyTokenId> afterLiteral;
        TokenSequence<?> ts;

        public CompletionContext(Token<? extends GroovyTokenId> token, Token<? extends GroovyTokenId> token2, Token<? extends GroovyTokenId> token3, Token<? extends GroovyTokenId> token4, Token<? extends GroovyTokenId> token5, Token<? extends GroovyTokenId> token6, Token<? extends GroovyTokenId> token7, TokenSequence<?> tokenSequence) {
            this.beforeLiteral = token;
            this.before2 = token2;
            this.before1 = token3;
            this.active = token4;
            this.after1 = token5;
            this.after2 = token6;
            this.afterLiteral = token7;
            this.ts = tokenSequence;
        }
    }
}

