/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class ProjectModel {
    private File baseFolder;
    private File nbProjectFolder;
    private PropertyEvaluator evaluator;
    private String sourceLevel;
    private String encoding;
    public static final String NO_ENCODING = NbBundle.getBundle(ProjectModel.class).getString("No_Encoding");
    private List<JavaProjectGenerator.SourceFolder> sourceFolders;
    public List<JavaProjectGenerator.JavaCompilationUnit> javaCompilationUnitsList;
    private Set<String> addedSourceFolders;
    private Set<String> removedSourceFolders;
    public static final String TYPE_JAVA = "java";
    public static final String CLASSPATH_MODE_COMPILE = "compile";
    private static final SpecificationVersion JDK_MAX_SUPPORTED_VERSION = new SpecificationVersion("1.5");
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    private ProjectModel(File baseFolder, File nbProjectFolder, PropertyEvaluator evaluator, List<JavaProjectGenerator.SourceFolder> sourceFolders, List<JavaProjectGenerator.JavaCompilationUnit> compUnits) {
        this.baseFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
        this.evaluator = evaluator;
        this.sourceFolders = sourceFolders;
        this.javaCompilationUnitsList = compUnits;
        if (this.javaCompilationUnitsList.size() > 0) {
            this.sourceLevel = this.javaCompilationUnitsList.get((int)0).sourceLevel;
        }
        if (this.sourceLevel == null) {
            this.setSourceLevel(ProjectModel.getDefaultSourceLevel());
        }
        if (sourceFolders.size() > 0) {
            JavaProjectGenerator.SourceFolder sf = sourceFolders.get(0);
            this.encoding = sf.encoding == null ? null : Charset.forName(sf.encoding).name();
        }
        this.resetState();
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }

    private void resetState() {
        this.addedSourceFolders = new HashSet<String>();
        this.removedSourceFolders = new HashSet<String>();
    }

    public static ProjectModel createEmptyModel(File baseFolder, File nbProjectFolder, PropertyEvaluator evaluator) {
        return new ProjectModel(baseFolder, nbProjectFolder, evaluator, new ArrayList<JavaProjectGenerator.SourceFolder>(), new ArrayList<JavaProjectGenerator.JavaCompilationUnit>());
    }

    public static ProjectModel createModel(final File baseFolder, final File nbProjectFolder, final PropertyEvaluator evaluator, final AntProjectHelper helper) {
        return (ProjectModel)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectModel>(){

            public ProjectModel run() {
                ProjectModel pm = new ProjectModel(baseFolder, nbProjectFolder, evaluator, JavaProjectGenerator.getSourceFolders(helper, ProjectModel.TYPE_JAVA), JavaProjectGenerator.getJavaCompilationUnits(helper, Util.getAuxiliaryConfiguration((AntProjectHelper)helper)));
                ProjectModel.updateStyle(pm.sourceFolders);
                return pm;
            }
        });
    }

    public static void instantiateJavaProject(AntProjectHelper helper, ProjectModel model) throws IOException {
        List<String> subprojects;
        List<JavaProjectGenerator.SourceFolder> sourceFolders = model.updatePrincipalSourceFolders(model.sourceFolders, true);
        ProjectModel.updateSourceFolders(sourceFolders, model);
        if (sourceFolders.size() > 0) {
            JavaProjectGenerator.putSourceFolders(helper, sourceFolders, null);
        }
        if (sourceFolders.size() > 0) {
            JavaProjectGenerator.putSourceViews(helper, sourceFolders, null);
        }
        JavaProjectGenerator.putJavaCompilationUnits(helper, Util.getAuxiliaryConfiguration((AntProjectHelper)helper), model.javaCompilationUnitsList);
        List<JavaProjectGenerator.Export> exports = JavaProjectGenerator.guessExports(model.evaluator, model.baseFolder, JavaProjectGenerator.getTargetMappings(helper), model.javaCompilationUnitsList);
        if (exports.size() > 0) {
            JavaProjectGenerator.putExports(helper, exports);
        }
        if ((subprojects = JavaProjectGenerator.guessSubprojects(model.evaluator, model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder)).size() > 0) {
            JavaProjectGenerator.putSubprojects(helper, subprojects);
        }
        model.resetState();
    }

    public static void saveProject(final AntProjectHelper helper, final ProjectModel model) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                JavaProjectGenerator.putSourceFolders(helper, model.sourceFolders, ProjectModel.TYPE_JAVA);
                JavaProjectGenerator.putSourceViews(helper, model.sourceFolders, "packages");
                List<JavaProjectGenerator.SourceFolder> sourceFolders = JavaProjectGenerator.getSourceFolders(helper, null);
                sourceFolders = model.updatePrincipalSourceFolders(sourceFolders, false);
                ProjectModel.updateSourceFolders(sourceFolders, model);
                JavaProjectGenerator.putSourceFolders(helper, sourceFolders, null);
                AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)helper);
                JavaProjectGenerator.putJavaCompilationUnits(helper, aux, model.javaCompilationUnitsList);
                model.resetState();
                List<JavaProjectGenerator.Export> exports = JavaProjectGenerator.guessExports(model.getEvaluator(), model.baseFolder, JavaProjectGenerator.getTargetMappings(helper), model.javaCompilationUnitsList);
                JavaProjectGenerator.putExports(helper, exports);
                List<String> subprojects = JavaProjectGenerator.guessSubprojects(model.getEvaluator(), model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder);
                JavaProjectGenerator.putSubprojects(helper, subprojects);
                List<String> buildFolders = JavaProjectGenerator.guessBuildFolders(model.getEvaluator(), model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder);
                JavaProjectGenerator.putBuildFolders(helper, buildFolders);
                List<String> buildFiles = JavaProjectGenerator.getBuildFiles(model.getEvaluator(), model.javaCompilationUnitsList, model.baseFolder, model.nbProjectFolder);
                JavaProjectGenerator.putBuildFiles(helper, buildFiles);
                return null;
            }
        });
    }

    private static void updateSourceFolders(List<JavaProjectGenerator.SourceFolder> list, ProjectModel model) {
        if (model.encoding != null) {
            String label;
            for (JavaProjectGenerator.SourceFolder sf : list) {
                if (!sf.location.equals(".")) continue;
                sf.encoding = model.encoding;
                return;
            }
            JavaProjectGenerator.SourceFolder sf = new JavaProjectGenerator.SourceFolder();
            Project project = null;
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)model.nbProjectFolder));
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            sf.label = label = project != null ? ProjectUtils.getInformation((Project)project).getDisplayName() : "projectdir";
            sf.location = ".";
            sf.encoding = model.encoding;
            list.add(sf);
        }
    }

    List<JavaProjectGenerator.SourceFolder> updatePrincipalSourceFolders(List<JavaProjectGenerator.SourceFolder> allSourceFolders, boolean checkProjectDir) {
        ArrayList<JavaProjectGenerator.SourceFolder> allSF = new ArrayList<JavaProjectGenerator.SourceFolder>(allSourceFolders);
        for (String location : this.addedSourceFolders) {
            if (!this.isExternalSourceRoot(location)) continue;
            boolean exist = false;
            String label = "";
            String includes = null;
            String excludes = null;
            for (JavaProjectGenerator.SourceFolder _sf : allSF) {
                if (_sf.location.equals(location) && _sf.type == null) {
                    exist = true;
                    break;
                }
                if (!_sf.location.equals(location) || _sf.type == null) continue;
                label = _sf.label;
                includes = _sf.includes;
                excludes = _sf.excludes;
            }
            if (exist) continue;
            JavaProjectGenerator.SourceFolder _sf = new JavaProjectGenerator.SourceFolder();
            _sf.location = location;
            _sf.label = label;
            _sf.includes = includes;
            _sf.excludes = excludes;
            allSF.add(_sf);
        }
        for (String location : this.removedSourceFolders) {
            if (!this.isExternalSourceRoot(location)) continue;
            Iterator it = allSF.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.SourceFolder _sf = (JavaProjectGenerator.SourceFolder)it.next();
                if (!_sf.location.equals(location) || _sf.type != null) continue;
                it.remove();
            }
        }
        if (checkProjectDir && !this.baseFolder.equals(this.nbProjectFolder)) {
            JavaProjectGenerator.SourceFolder gen = new JavaProjectGenerator.SourceFolder();
            gen.location = "${project.dir}";
            gen.label = this.baseFolder.getName();
            allSF.add(gen);
        }
        return allSF;
    }

    private boolean isExternalSourceRoot(String location) {
        File f;
        String nbProjectFolder_;
        String baseFolder_ = this.baseFolder.getAbsolutePath();
        if (!baseFolder_.endsWith(File.separator)) {
            baseFolder_ = baseFolder_ + File.separatorChar;
        }
        if (!(nbProjectFolder_ = this.nbProjectFolder.getAbsolutePath()).endsWith(File.separator)) {
            nbProjectFolder_ = nbProjectFolder_ + File.separatorChar;
        }
        if ((f = Util.resolveFile((PropertyEvaluator)this.evaluator, (File)this.baseFolder, (String)location)) == null) {
            return false;
        }
        location = f.getAbsolutePath();
        return !location.startsWith(baseFolder_) && !location.startsWith(nbProjectFolder_);
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getNBProjectFolder() {
        return this.nbProjectFolder;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int getSourceFoldersCount() {
        return this.sourceFolders.size();
    }

    public JavaProjectGenerator.SourceFolder getSourceFolder(int index) {
        return this.sourceFolders.get(index);
    }

    public void moveSourceFolder(int fromIndex, int toIndex) {
        JavaProjectGenerator.SourceFolder sf = this.sourceFolders.remove(fromIndex);
        this.sourceFolders.add(toIndex, sf);
    }

    public void addSourceFolder(JavaProjectGenerator.SourceFolder sf, boolean isTests) {
        JavaProjectGenerator.JavaCompilationUnit cu;
        List<CompilationUnitKey> keys = this.createCompilationUnitKeys();
        boolean singleCU = ProjectModel.isSingleCompilationUnit(keys);
        if (singleCU) {
            cu = this.javaCompilationUnitsList.get(0);
            if (cu.isTests != isTests) {
                this.updateCompilationUnits(true);
                singleCU = false;
            }
        }
        this.sourceFolders.add(sf);
        if (singleCU) {
            if (TYPE_JAVA.equals(sf.type)) {
                cu = this.javaCompilationUnitsList.get(0);
                cu.packageRoots.add(sf.location);
            }
        } else {
            for (CompilationUnitKey key : this.createCompilationUnitKeys()) {
                this.getCompilationUnit(key, isTests);
            }
        }
        if (this.removedSourceFolders.contains(sf.location)) {
            this.removedSourceFolders.remove(sf.location);
        } else {
            this.addedSourceFolders.add(sf.location);
        }
        this.fireChangeEvent();
    }

    public void removeSourceFolder(int index) {
        JavaProjectGenerator.SourceFolder sf = this.sourceFolders.get(index);
        if (TYPE_JAVA.equals(sf.type)) {
            this.removeSourceLocation(sf.location);
        }
        this.sourceFolders.remove(index);
        if (this.addedSourceFolders.contains(sf.location)) {
            this.addedSourceFolders.remove(sf.location);
        } else {
            this.removedSourceFolders.add(sf.location);
        }
        this.fireChangeEvent();
    }

    public void clearSourceFolders() {
        this.sourceFolders.clear();
        this.javaCompilationUnitsList.clear();
        this.fireChangeEvent();
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String sourceLevel) {
        if (this.sourceLevel == null && sourceLevel == null || this.sourceLevel != null && this.sourceLevel.equals(sourceLevel)) {
            return;
        }
        this.sourceLevel = sourceLevel;
        for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
            cu.sourceLevel = sourceLevel;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc == null || enc.equals(NO_ENCODING) ? null : enc;
        for (JavaProjectGenerator.SourceFolder sf : this.sourceFolders) {
            sf.encoding = this.encoding;
        }
    }

    public boolean canHaveSeparateClasspath() {
        return this.sourceFolders.size() > 1 || this.javaCompilationUnitsList.size() > 1;
    }

    public boolean canCreateSingleCompilationUnit() {
        boolean testCU = false;
        boolean sourceCU = false;
        for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
            if (cu.isTests) {
                testCU = true;
                continue;
            }
            sourceCU = true;
        }
        return !testCU || !sourceCU;
    }

    public static boolean isSingleCompilationUnit(List<CompilationUnitKey> compilationUnitKeys) {
        return compilationUnitKeys.size() == 1 && compilationUnitKeys.get((int)0).label == null;
    }

    public List<CompilationUnitKey> createCompilationUnitKeys() {
        CompilationUnitKey cul;
        ArrayList<CompilationUnitKey> l = new ArrayList<CompilationUnitKey>();
        for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
            cul = new CompilationUnitKey();
            cul.locations = cu.packageRoots;
            cul.label = null;
            l.add(cul);
        }
        for (JavaProjectGenerator.SourceFolder sf : this.sourceFolders) {
            if (!TYPE_JAVA.equals(sf.type)) continue;
            cul = new CompilationUnitKey();
            cul.locations = new ArrayList<String>();
            cul.locations.add(sf.location);
            cul.label = sf.label;
            int index = l.indexOf(cul);
            if (index != -1) {
                CompilationUnitKey cul_ = (CompilationUnitKey)l.get(index);
                cul_.label = sf.label;
                continue;
            }
            boolean found = false;
            for (JavaProjectGenerator.JavaCompilationUnit cu_ : this.javaCompilationUnitsList) {
                if (!cu_.packageRoots.contains(sf.location)) continue;
                found = true;
                break;
            }
            if (found) continue;
            l.add(cul);
        }
        return l;
    }

    public void updateCompilationUnits(boolean separateClasspath) {
        if (separateClasspath) {
            String classpath = null;
            List<String> output = null;
            if (this.javaCompilationUnitsList.size() > 0) {
                List<JavaProjectGenerator.JavaCompilationUnit.CP> classpaths = this.javaCompilationUnitsList.get((int)0).classpath;
                if (classpaths != null) {
                    for (JavaProjectGenerator.JavaCompilationUnit.CP cp : classpaths) {
                        if (!cp.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                        classpath = cp.classpath;
                        break;
                    }
                }
                output = this.javaCompilationUnitsList.get((int)0).output;
            }
            this.javaCompilationUnitsList.clear();
            for (JavaProjectGenerator.SourceFolder sf : this.sourceFolders) {
                JavaProjectGenerator.JavaCompilationUnit cu = new JavaProjectGenerator.JavaCompilationUnit();
                cu.packageRoots = new ArrayList<String>();
                cu.packageRoots.add(sf.location);
                if (classpath != null) {
                    JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
                    cp.mode = CLASSPATH_MODE_COMPILE;
                    cp.classpath = classpath;
                    cu.classpath = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
                    cu.classpath.add(cp);
                }
                if (output != null) {
                    cu.output = new ArrayList<String>();
                    cu.output.addAll(output);
                }
                cu.sourceLevel = this.sourceLevel;
                this.javaCompilationUnitsList.add(cu);
            }
        } else {
            ArrayList<String> packageRoots = new ArrayList<String>();
            for (JavaProjectGenerator.SourceFolder sf : this.sourceFolders) {
                packageRoots.add(sf.location);
            }
            LinkedHashSet<String> classpath = new LinkedHashSet<String>();
            LinkedHashSet<String> output = new LinkedHashSet<String>();
            for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
                if (cu.output != null) {
                    output.addAll(cu.output);
                }
                if (cu.classpath == null) continue;
                for (JavaProjectGenerator.JavaCompilationUnit.CP cp : cu.classpath) {
                    if (!cp.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                    classpath.addAll(Arrays.asList(PropertyUtils.tokenizePath((String)cp.classpath)));
                }
            }
            this.javaCompilationUnitsList.clear();
            JavaProjectGenerator.JavaCompilationUnit cu = new JavaProjectGenerator.JavaCompilationUnit();
            cu.packageRoots = packageRoots;
            JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
            if (classpath.size() > 0) {
                StringBuffer cp_ = new StringBuffer();
                Iterator it = classpath.iterator();
                while (it.hasNext()) {
                    cp_.append((String)it.next());
                    if (!it.hasNext()) continue;
                    cp_.append(File.pathSeparatorChar);
                }
                cp.classpath = cp_.toString();
                cp.mode = CLASSPATH_MODE_COMPILE;
                cu.classpath = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
                cu.classpath.add(cp);
            }
            cu.output = new ArrayList<String>(output);
            cu.sourceLevel = this.sourceLevel;
            this.javaCompilationUnitsList.add(cu);
        }
        this.fireChangeEvent();
    }

    public JavaProjectGenerator.JavaCompilationUnit getCompilationUnit(CompilationUnitKey key, boolean isTests) {
        for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
            if (!((Object)cu.packageRoots).equals(key.locations)) continue;
            return cu;
        }
        JavaProjectGenerator.JavaCompilationUnit cu = new JavaProjectGenerator.JavaCompilationUnit();
        cu.packageRoots = key.locations;
        cu.sourceLevel = this.sourceLevel;
        cu.isTests = isTests;
        this.javaCompilationUnitsList.add(cu);
        return cu;
    }

    private void removeSourceLocation(String location) {
        Iterator<JavaProjectGenerator.JavaCompilationUnit> it = this.javaCompilationUnitsList.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit cu = it.next();
            if (cu.packageRoots.contains(location)) {
                cu.packageRoots.remove(location);
            }
            if (cu.packageRoots.size() != 0) continue;
            it.remove();
        }
    }

    private static void updateStyle(List<JavaProjectGenerator.SourceFolder> sources) {
        for (JavaProjectGenerator.SourceFolder sf : sources) {
            assert (sf.type.equals(TYPE_JAVA));
            sf.style = "packages";
        }
    }

    void setSourceFolders(List<JavaProjectGenerator.SourceFolder> list) {
        this.sourceFolders = list;
    }

    List<JavaProjectGenerator.SourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    void setJavaCompilationUnits(List<JavaProjectGenerator.JavaCompilationUnit> list) {
        this.javaCompilationUnitsList = list;
    }

    List<JavaProjectGenerator.JavaCompilationUnit> getJavaCompilationUnits() {
        return this.javaCompilationUnitsList;
    }

    public static String getDefaultSourceLevel() {
        JavaPlatform platform = JavaPlatform.getDefault();
        SpecificationVersion sv = platform.getSpecification().getVersion();
        if (sv.compareTo((Object)JDK_MAX_SUPPORTED_VERSION) > 0) {
            sv = JDK_MAX_SUPPORTED_VERSION;
        }
        return sv.toString();
    }

    public boolean isTestSourceFolder(int index) {
        return this.isTestSourceFolder(this.getSourceFolder(index));
    }

    public boolean isTestSourceFolder(JavaProjectGenerator.SourceFolder sf) {
        for (JavaProjectGenerator.JavaCompilationUnit cu : this.javaCompilationUnitsList) {
            if (!cu.packageRoots.contains(sf.location)) continue;
            return cu.isTests;
        }
        return false;
    }

    public static class CompilationUnitKey {
        public List<String> locations;
        public String label;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnitKey)) {
                return false;
            }
            CompilationUnitKey cul = (CompilationUnitKey)o;
            return ((Object)this.locations).equals(cul.locations);
        }

        public int hashCode() {
            return ((Object)this.locations).hashCode() * 7;
        }

        public String toString() {
            return "PM.CUK:[label=" + this.label + ", locations=" + this.locations + ", this=" + super.toString() + "]";
        }
    }
}

