/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileObjectBasedFile
extends File {
    final ExecutionEnvironment env;
    private final FileObject fo;
    private final String path;
    private File[] NO_CHILDREN = new File[0];
    private static final String PREFIX = "NATIVEEXECUTOR: ";
    private static final RequestProcessor processor = new RequestProcessor("NATIVEEXECUTOR: ", 50);

    public FileObjectBasedFile(ExecutionEnvironment env, String path) {
        super(path);
        this.fo = null;
        this.path = FileObjectBasedFile.toUnix(super.getPath());
        this.env = env;
    }

    public FileObjectBasedFile(ExecutionEnvironment env, FileObject fo) {
        super(fo == null || "".equals(fo.getPath()) ? "/" : fo.getPath());
        this.fo = fo;
        this.path = fo.getPath();
        this.env = env;
    }

    @Override
    public boolean isDirectory() {
        return this.fo == null ? false : this.fo.isFolder();
    }

    @Override
    public boolean isAbsolute() {
        String p = this.getPath();
        if (p.length() != 0) {
            return p.charAt(0) == '/';
        }
        if (this.fo != null) {
            return this.fo.getParent() == null;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileObjectBasedFile other = (FileObjectBasedFile)obj;
        if (!(this.env == other.env || this.env != null && this.env.equals(other.env))) {
            return false;
        }
        if (!(this.fo == other.fo || this.fo != null && this.fo.equals(other.fo))) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.env != null ? this.env.hashCode() : 0);
        hash = 17 * hash + (this.fo != null ? this.fo.hashCode() : 0);
        hash = 17 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean exists() {
        return this.fo == null ? false : this.fo.isValid();
    }

    @Override
    public boolean renameTo(File dest) {
        Future<Integer> result = FileObjectBasedFile.renameTo(this.env, this.getPath(), dest.getPath(), new StringWriter());
        try {
            return result.get() == 0;
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean mkdirs() {
        if (this.fo == null) {
            Future result = CommonTasksSupport.mkDir((ExecutionEnvironment)this.env, (String)this.getPath(), (Writer)new StringWriter());
            try {
                return (Integer)result.get() == 0;
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean mkdir() {
        return this.mkdirs();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String getPath() {
        return this.fo == null ? this.path : this.fo.getPath();
    }

    @Override
    public File getParentFile() {
        if (this.fo == null) {
            return null;
        }
        FileObject parent = this.fo.getParent();
        return parent == null ? null : new FileObjectBasedFile(this.env, parent);
    }

    @Override
    public String getParent() {
        int index = this.path.lastIndexOf(47);
        return index < 0 ? null : this.path.substring(0, index);
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public String getAbsolutePath() {
        if (this.fo != null) {
            return this.fo.getPath();
        }
        if (FileObjectBasedFile.isAbsolute(this.path)) {
            return this.path;
        }
        return FileObjectBasedFile.toUnix(super.getAbsolutePath());
    }

    private static boolean isAbsolute(String fileName) {
        return fileName.length() > 0 && fileName.charAt(0) == '/';
    }

    private static String toUnix(String path) {
        if (path != null && Utilities.isWindows()) {
            path = path.replace('\\', '/');
            while (path.startsWith("//")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    @Override
    public File[] listFiles() {
        if (this.fo == null) {
            return this.NO_CHILDREN;
        }
        FileObject[] children = this.fo.getChildren();
        if (children.length == 0) {
            this.fo.refresh();
            children = this.fo.getChildren();
        }
        File[] res = new File[children.length];
        int idx = 0;
        for (FileObject child : children) {
            res[idx++] = new FileObjectBasedFile(this.env, child);
        }
        return res;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    public static Future<Integer> renameTo(final ExecutionEnvironment execEnv, final String sourceDir, final String destDir, final Writer error) {
        FutureTask<Integer> ftask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Thread.currentThread().setName("NATIVEEXECUTOR: mv " + sourceDir + " " + destDir);
                return new CommandRunner(execEnv, error, "mv", sourceDir, destDir).call();
            }
        });
        processor.post(ftask);
        return ftask;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandRunner
    implements Callable<Integer> {
        private final ExecutionEnvironment execEnv;
        private final String cmd;
        private final String[] args;
        private final Writer error;

        public CommandRunner(ExecutionEnvironment execEnv, Writer error, String cmd, String ... args) {
            this.execEnv = execEnv;
            this.cmd = cmd;
            this.args = args;
            this.error = error;
        }

        @Override
        public Integer call() throws Exception {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            npb.setExecutable(this.cmd).setArguments(this.args);
            NativeProcess p = npb.call();
            int exitStatus = p.waitFor();
            if (exitStatus != 0 && this.error != null) {
                ProcessUtils.writeError((Writer)this.error, (Process)p);
            }
            return exitStatus;
        }
    }
}

