/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.j2ee.sun.persistence.utility.openide;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.util.LogHelperModel;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevelopmentModel
extends Model {
    private static final Map<Project, Model> _modelCache = new WeakHashMap<Project, Model>();
    private HashMap<String, FileLock> _locks;
    private WeakReference<Project> _projectRef;
    private HashMap<String, TypeKind> primitiveTypes;

    public static Model getModel(FileObject fileObject) {
        return DevelopmentModel.getModel(fileObject != null ? FileOwnerQuery.getOwner((FileObject)fileObject) : (Project)null);
    }

    public static synchronized Model getModel(Project project) {
        Model value = _modelCache.get(project);
        if (value == null) {
            value = new DevelopmentModel(project);
            _modelCache.put(project, value);
        }
        return value;
    }

    private DevelopmentModel() {
        this(null);
    }

    protected DevelopmentModel(Project project) {
        this._projectRef = new WeakReference<Project>(project);
        this.primitiveTypes = new HashMap();
        this.primitiveTypes.put("boolean", TypeKind.BOOLEAN);
        this.primitiveTypes.put("byte", TypeKind.BYTE);
        this.primitiveTypes.put("short", TypeKind.SHORT);
        this.primitiveTypes.put("char", TypeKind.CHAR);
        this.primitiveTypes.put("int", TypeKind.INT);
        this.primitiveTypes.put("long", TypeKind.LONG);
        this.primitiveTypes.put("float", TypeKind.FLOAT);
        this.primitiveTypes.put("double", TypeKind.DOUBLE);
        this.primitiveTypes.put("void", TypeKind.VOID);
    }

    protected FileObject[] getSourceRoots() {
        FileObject[] srcDirs = null;
        Project project = (Project)this._projectRef.get();
        if (project != null) {
            SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            srcDirs = new FileObject[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                srcDirs[i] = groups[i].getRootFolder();
            }
        } else {
            srcDirs = new FileObject[]{};
        }
        return srcDirs;
    }

    protected void forAllSourceRoots(final SourceRootTask task) {
        FileObject[] sourceRoots = this.getSourceRoots();
        final ArrayList result = new ArrayList();
        if (sourceRoots != null) {
            for (int i = 0; i < sourceRoots.length && result.isEmpty(); ++i) {
                JavaSource js = JavaSource.forFileObject((FileObject)sourceRoots[i]);
                try {
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController controller) throws Exception {
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            if (task.run(controller)) {
                                result.add(true);
                            }
                        }
                    }, true);
                    continue;
                }
                catch (Exception e) {
                    LogHelperModel.getLogger().log(900, e.getMessage());
                }
            }
        }
    }

    public boolean isInterface(String className) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null && ElementKind.INTERFACE == clazz.getKind()) {
                        result.add(true);
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? false : (Boolean)result.get(0);
    }

    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        try {
            FileObject file = this.getFile(className, resourceName);
            return file != null ? new BufferedInputStream(file.getInputStream()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private TypeElement getSuperclass(TypeElement type) {
        TypeElement superclass;
        Element element;
        TypeMirror supertype = type.getSuperclass();
        if (TypeKind.DECLARED.equals((Object)supertype.getKind()) && ElementKind.CLASS.equals((Object)(element = ((DeclaredType)supertype).asElement()).getKind()) && !(superclass = (TypeElement)element).getQualifiedName().contentEquals("java.lang.Object")) {
            return superclass;
        }
        return null;
    }

    protected String findPenultimateSuperclass(String className) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList<String> result = new ArrayList<String>();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            if (classElement == null) {
                result.add(className);
            } else {
                this.forAllSourceRoots(new SourceRootTask(){

                    public boolean run(CompilationController controller) {
                        TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                        if (clazz != null) {
                            TypeElement superclass = null;
                            while ((superclass = DevelopmentModel.this.getSuperclass(clazz)) != null) {
                                clazz = superclass;
                            }
                            result.add(clazz.getQualifiedName().toString());
                        }
                        return !result.isEmpty();
                    }
                });
            }
        }
        return result.isEmpty() ? className : (String)result.get(0);
    }

    protected String getSuperclass(String className) {
        ElementHandle classElement;
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null && (classElement = wrapper.getHandle()) != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        TypeElement superclass = DevelopmentModel.this.getSuperclass(clazz);
                        result.add(superclass != null ? superclass.getQualifiedName().toString() : null);
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (String)result.get(0);
    }

    private synchronized Map<String, FileLock> getLocks() {
        if (this._locks == null) {
            this._locks = new HashMap();
        }
        return this._locks;
    }

    private synchronized FileLock getLock(String className) {
        return this.getLocks().get(className);
    }

    private synchronized void putLock(String className, FileLock lock) {
        this.getLocks().put(className, lock);
    }

    private synchronized void removeLock(String className) {
        this.getLocks().remove(className);
    }

    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        char extensionCharacter = '.';
        FileObject file = this.getFile(className, baseFileName + extensionCharacter + extension);
        if (file == null) {
            String shortClassName;
            String packageName;
            Repository repository = Repository.getDefault();
            FileObject javaFile = repository.find(packageName = JavaTypeHelper.getPackageName((String)className), shortClassName = JavaTypeHelper.getShortClassName((String)className), "java");
            if (javaFile != null) {
                file = javaFile.getParent().createData(shortClassName, extension);
            } else {
                throw new FileNotFoundException();
            }
        }
        if (file != null) {
            return new BufferedOutputStream(file.getOutputStream(this.lockFile(className, file)));
        }
        return null;
    }

    public void lockFile(String className) throws IOException {
        this.lockFile(className, this.getFile(className, this.getFileNameWithExtension(className)));
    }

    private FileLock lockFile(String className, FileObject file) throws IOException {
        FileLock lock = null;
        if (file != null && (lock = this.getLock(className)) == null) {
            lock = file.lock();
            this.putLock(className, lock);
        }
        return lock;
    }

    public void unlockFile(String className) {
        FileLock lock;
        if (className != null && (lock = this.getLock(className)) != null) {
            lock.releaseLock();
            this.removeLock(className);
        }
        super.unlockFile(className);
    }

    public void updateKeyForClass(MappingClassElement mappingClass, String oldName) {
        FileLock lock;
        super.updateKeyForClass(mappingClass, oldName);
        if (oldName != null && (lock = this.getLock(oldName)) != null) {
            this.unlockFile(oldName);
            if (mappingClass != null) {
                try {
                    this.lockFile(mappingClass.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFile(String className, String fileName) throws IOException {
        FileObject file = this.getFile(className, fileName);
        FileLock lock = this.lockFile(className, file);
        try {
            file.delete(lock);
        }
        finally {
            this.unlockFile(className);
        }
    }

    protected FileObject getFile(String className, String fileName) throws IOException {
        FileObject[] sourceRoots = this.getSourceRoots();
        if (fileName != null && sourceRoots != null) {
            for (int i = 0; i < sourceRoots.length; ++i) {
                ClassPath cp = ClassPath.getClassPath((FileObject)sourceRoots[i], (String)"classpath/source");
                List matches = cp.findAllResources(fileName.replace(File.separatorChar, '/'));
                for (FileObject nextMatch : matches) {
                    if (nextMatch.getFileSystem().isReadOnly()) continue;
                    return nextMatch;
                }
            }
        }
        return null;
    }

    public Object getClass(final String className, ClassLoader classLoader) {
        final ArrayList result = new ArrayList();
        if (className != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement returnObject = controller.getElements().getTypeElement(className);
                    if (returnObject != null) {
                        ElementHandle classHandle = ElementHandle.create((Element)returnObject);
                        result.add(new NamedElementHandleWrapper(classHandle, classHandle.getQualifiedName()));
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (NamedElementHandleWrapper)result.get(0);
    }

    public boolean implementsInterface(Object classElement, final String interfaceName) {
        if (classElement == null || !(classElement instanceof NamedElementHandleWrapper) || interfaceName == null) {
            return false;
        }
        final ElementHandle thisClass = ((NamedElementHandleWrapper)classElement).getHandle();
        final ArrayList result = new ArrayList();
        if (thisClass != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)thisClass.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        List<? extends TypeMirror> interfaces = clazz.getInterfaces();
                        for (TypeMirror typeMirror : interfaces) {
                            TypeElement typeElement;
                            Element element;
                            if (!TypeKind.DECLARED.equals(typeMirror) || !ElementKind.CLASS.equals((Object)(element = ((DeclaredType)typeMirror).asElement()).getKind()) || !(typeElement = (TypeElement)element).getQualifiedName().contentEquals(interfaceName)) continue;
                            result.add(true);
                            break;
                        }
                    }
                    TypeElement superclass = DevelopmentModel.this.getSuperclass(clazz);
                    if (result.isEmpty() && (superclass == null || superclass.getQualifiedName().contentEquals("java.lang.Object"))) {
                        result.add(false);
                    } else {
                        ElementHandle superHandle = ElementHandle.create((Element)superclass);
                        boolean bl = DevelopmentModel.this.implementsInterface(new NamedElementHandleWrapper(superHandle, superHandle.getQualifiedName()), interfaceName);
                        if (bl) {
                            result.add(bl);
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? false : (Boolean)result.get(0);
    }

    public boolean hasConstructor(String className) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        List<? extends Element> allElements = clazz.getEnclosedElements();
                        for (Element element : allElements) {
                            if (!ElementKind.CONSTRUCTOR.equals((Object)element.getKind())) continue;
                            result.add(true);
                            break;
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? false : (Boolean)result.get(0);
    }

    public Object getConstructor(String className, String[] argTypeNames) {
        return this.getExecutableObject(ElementKind.CONSTRUCTOR, null, className, argTypeNames);
    }

    private Object getExecutableObject(final ElementKind kind, final String elementName, String className, final String[] argTypeNames) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        List<? extends Element> allElements = clazz.getEnclosedElements();
                        for (Element element : allElements) {
                            ExecutableType executableType;
                            if (!kind.equals((Object)element.getKind()) || elementName != null && !element.getSimpleName().contentEquals(elementName) || !DevelopmentModel.this.isArgTypeMatch(argTypeNames, (executableType = (ExecutableType)element.asType()).getParameterTypes())) continue;
                            result.add(new NamedElementHandleWrapper(ElementHandle.create((Element)element), elementName));
                            break;
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (NamedElementHandleWrapper)result.get(0);
    }

    private boolean isArgTypeMatch(String[] argTypeNames, List<? extends TypeMirror> testParams) {
        int argTypeLength;
        if (argTypeNames == null && testParams == null) {
            return true;
        }
        if (argTypeNames != null && testParams != null && (argTypeLength = argTypeNames.length) == testParams.size()) {
            ArrayList<String> testParamNames = new ArrayList<String>(argTypeLength);
            for (TypeMirror typeMirror : testParams) {
                testParamNames.add(this.getNameForType(typeMirror));
            }
            testParamNames.removeAll(Arrays.asList(argTypeNames));
            return testParamNames.size() == 0;
        }
        return false;
    }

    public Object getMethod(String className, String methodName, String[] argTypeNames) {
        return this.getExecutableObject(ElementKind.METHOD, methodName, className, argTypeNames);
    }

    protected TypeMirrorHandle getWrapperType(NamedElementHandleWrapper element) {
        final ArrayList result = new ArrayList();
        if (element != null) {
            final ElementHandle thisElement = element.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                    if (resolvedElement != null) {
                        result.add(TypeMirrorHandle.create((TypeMirror)DevelopmentModel.this.getTypeObject(resolvedElement)));
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (TypeMirrorHandle)result.get(0);
    }

    public String getType(Object element) {
        NamedElementHandleWrapper wrapper;
        ElementHandle classElement;
        final ArrayList result = new ArrayList();
        if (element != null && element instanceof NamedElementHandleWrapper && (classElement = (wrapper = (NamedElementHandleWrapper)element).getHandle()) != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        result.add(DevelopmentModel.this.getNameForType(DevelopmentModel.this.getWrapperType(wrapper).resolve((CompilationInfo)controller)));
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (String)result.get(0);
    }

    public List getFields(String className) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        List<? extends Element> allElements = clazz.getEnclosedElements();
                        for (Element element : allElements) {
                            if (!ElementKind.FIELD.equals((Object)element.getKind())) continue;
                            result.add(element.getSimpleName().toString());
                        }
                    }
                    return false;
                }
            });
        }
        return result;
    }

    public Object getField(String className, final String fieldName) {
        NamedElementHandleWrapper wrapper = (NamedElementHandleWrapper)this.getClass(className);
        final ArrayList result = new ArrayList();
        if (wrapper != null) {
            final ElementHandle classElement = wrapper.getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeElement clazz = (TypeElement)classElement.resolve((CompilationInfo)controller);
                    if (clazz != null) {
                        List<? extends Element> allElements = clazz.getEnclosedElements();
                        for (Element element : allElements) {
                            if (!ElementKind.FIELD.equals((Object)element.getKind()) || !element.getSimpleName().contentEquals(fieldName)) continue;
                            result.add(new NamedElementHandleWrapper(ElementHandle.create((Element)element), fieldName));
                            break;
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (NamedElementHandleWrapper)result.get(0);
    }

    public boolean isSerializable(final Object fieldElement) {
        final ArrayList result = new ArrayList();
        if (!(fieldElement instanceof VariableElement)) {
            return false;
        }
        final ElementHandle thisElement = ((NamedElementHandleWrapper)fieldElement).getHandle();
        this.forAllSourceRoots(new SourceRootTask(){

            public boolean run(CompilationController controller) {
                Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                if (resolvedElement != null) {
                    TypeMirror type = DevelopmentModel.this.getTypeObject(fieldElement);
                    if (type == null) {
                        result.add(false);
                        return true;
                    }
                    while (TypeKind.ARRAY.equals((Object)type.getKind())) {
                        type = ((ArrayType)type).getComponentType();
                    }
                    if (type.getKind().isPrimitive()) {
                        result.add(true);
                        return true;
                    }
                    Object classElement = DevelopmentModel.this.getClass(DevelopmentModel.this.getNameForType(type));
                    result.add(classElement == null ? false : DevelopmentModel.this.implementsInterface(classElement, "java.io.Serializable"));
                    return true;
                }
                return false;
            }
        });
        return result.isEmpty() ? false : (Boolean)result.get(0);
    }

    public boolean isArray(String className, String fieldName) {
        final ArrayList result = new ArrayList();
        Object fieldElement = this.getField(className, fieldName);
        if (fieldElement != null) {
            final ElementHandle thisElement = ((NamedElementHandleWrapper)fieldElement).getHandle();
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    TypeMirror type;
                    Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                    if (resolvedElement != null && (type = DevelopmentModel.this.getTypeObject(resolvedElement)) != null && TypeKind.ARRAY.equals(type)) {
                        result.add(true);
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? false : (Boolean)result.get(0);
    }

    protected NamedElementHandleWrapper getWrapperDeclaringClass(NamedElementHandleWrapper memberElement) {
        ElementHandle thisElement;
        final ArrayList result = new ArrayList();
        if (memberElement != null && (thisElement = memberElement.getHandle()) != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                    if (resolvedElement != null) {
                        Element enclosingElement = resolvedElement.getEnclosingElement();
                        TypeElement classElement = null;
                        if (TypeKind.DECLARED.equals((Object)enclosingElement.getKind())) {
                            classElement = (TypeElement)enclosingElement;
                            ElementHandle classHandle = ElementHandle.create((Element)classElement);
                            result.add(classElement != null ? new NamedElementHandleWrapper(classHandle, classHandle.getQualifiedName()) : null);
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (NamedElementHandleWrapper)result.get(0);
    }

    public String getDeclaringClass(Object memberElement) {
        return memberElement != null && memberElement instanceof NamedElementHandleWrapper ? this.getWrapperDeclaringClass((NamedElementHandleWrapper)memberElement).toString() : null;
    }

    public int getModifiers(Object memberElement) {
        ElementHandle thisElement;
        final ArrayList result = new ArrayList();
        if (memberElement != null && memberElement instanceof NamedElementHandleWrapper && (thisElement = ((NamedElementHandleWrapper)memberElement).getHandle()) != null) {
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                    if (resolvedElement != null) {
                        result.add(DevelopmentModel.getModifiers(resolvedElement.getModifiers()));
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? 0 : (Integer)result.get(0);
    }

    protected static int getModifiers(Set<Modifier> modifierObjects) {
        int modifiers = 0;
        for (Modifier modObject : modifierObjects) {
            if (Modifier.ABSTRACT.equals((Object)modObject)) {
                modifiers |= 0x400;
                continue;
            }
            if (Modifier.FINAL.equals((Object)modObject)) {
                modifiers |= 0x10;
                continue;
            }
            if (Modifier.NATIVE.equals((Object)modObject)) {
                modifiers |= 0x100;
                continue;
            }
            if (Modifier.PRIVATE.equals((Object)modObject)) {
                modifiers |= 2;
                continue;
            }
            if (Modifier.PROTECTED.equals((Object)modObject)) {
                modifiers |= 4;
                continue;
            }
            if (Modifier.PUBLIC.equals((Object)modObject)) {
                modifiers |= 1;
                continue;
            }
            if (Modifier.STATIC.equals((Object)modObject)) {
                modifiers |= 8;
                continue;
            }
            if (Modifier.STRICTFP.equals((Object)modObject)) {
                modifiers |= 0x800;
                continue;
            }
            if (Modifier.SYNCHRONIZED.equals((Object)modObject)) {
                modifiers |= 0x20;
                continue;
            }
            if (Modifier.TRANSIENT.equals((Object)modObject)) {
                modifiers |= 0x80;
                continue;
            }
            if (!Modifier.VOLATILE.equals((Object)modObject)) continue;
            modifiers |= 0x40;
        }
        return modifiers;
    }

    protected TypeMirror getTypeObject(Object element) {
        TypeMirror type = null;
        if (element != null && element instanceof Element) {
            ElementKind kind = ((Element)element).getKind();
            if (ElementKind.FIELD.equals((Object)kind)) {
                type = ((VariableElement)element).asType();
            } else if (ElementKind.METHOD.equals((Object)kind)) {
                type = ((ExecutableElement)element).getReturnType();
            }
        }
        return type;
    }

    private String getNameForType(TypeMirror type) {
        String typeName = null;
        if (type != null) {
            Element element;
            TypeKind kind = type.getKind();
            if (TypeKind.ARRAY.equals((Object)kind)) {
                typeName = this.getNameForType(((ArrayType)type).getComponentType()) + "[]";
            } else if (kind.isPrimitive()) {
                typeName = ((Object)type).toString();
            } else if (TypeKind.DECLARED.equals(type) && ElementKind.CLASS.equals((Object)(element = ((DeclaredType)type).asElement()).getKind())) {
                TypeElement typeElement = (TypeElement)element;
                typeName = typeElement.getQualifiedName().toString();
            }
        }
        return typeName;
    }

    protected TypeMirrorHandle getTypeForName(String fullTypeName, NamedElementHandleWrapper element) {
        final ArrayList result = new ArrayList();
        if (element != null) {
            final ElementHandle thisElement = element.getHandle();
            final boolean isArray = fullTypeName.endsWith("[]");
            final String typeName = isArray ? fullTypeName.substring(0, fullTypeName.length() - 2) : fullTypeName;
            this.forAllSourceRoots(new SourceRootTask(){

                public boolean run(CompilationController controller) {
                    Element resolvedElement = thisElement.resolve((CompilationInfo)controller);
                    if (resolvedElement != null) {
                        TypeKind type = (TypeKind)((Object)DevelopmentModel.this.primitiveTypes.get(typeName));
                        Types types = controller.getTypes();
                        TypeMirror typeMirror = null;
                        if (type != null) {
                            typeMirror = type.isPrimitive() ? types.getPrimitiveType(type) : types.getNoType(type);
                        }
                        if (typeMirror == null && ElementKind.CLASS.equals((Object)resolvedElement.getKind())) {
                            TreeUtilities treeUtils = controller.getTreeUtilities();
                            typeMirror = treeUtils.parseType(typeName, (TypeElement)resolvedElement);
                        }
                        if (typeMirror != null) {
                            if (isArray) {
                                typeMirror = types.getArrayType(typeMirror);
                            }
                            result.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                        }
                    }
                    return !result.isEmpty();
                }
            });
        }
        return result.isEmpty() ? null : (TypeMirrorHandle)result.get(0);
    }

    protected static interface SourceRootTask {
        public boolean run(CompilationController var1) throws Exception;
    }

    protected class NamedElementHandleWrapper {
        private ElementHandle _elementHandle;
        private String _name;

        private NamedElementHandleWrapper(ElementHandle handle, String name) {
            this._elementHandle = handle;
            this._name = name;
        }

        public ElementHandle getHandle() {
            return this._elementHandle;
        }

        public String toString() {
            return this._name;
        }
    }
}

