/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.WebRequest;
import org.eclipse.mylyn.internal.commons.net.ICancellable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoredRequest<T>
extends WebRequest<T>
implements ICancellable {
    private static ThreadLocal<MonitoredRequest<?>> currentRequest = new ThreadLocal();
    private final CopyOnWriteArrayList<ICancellable> listeners = new CopyOnWriteArrayList();
    private final IProgressMonitor monitor;

    public static MonitoredRequest<?> getCurrentRequest() {
        return currentRequest.get();
    }

    public static void setCurrentRequest(MonitoredRequest<?> request) {
        currentRequest.set(request);
    }

    public MonitoredRequest(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        this.monitor = monitor;
    }

    @Override
    public T call() throws Exception {
        try {
            assert (MonitoredRequest.getCurrentRequest() == null);
            MonitoredRequest.setCurrentRequest(this);
            T t = this.execute();
            return t;
        }
        finally {
            MonitoredRequest.setCurrentRequest(null);
            this.listeners.clear();
        }
    }

    protected abstract T execute() throws Exception;

    @Override
    public void abort() {
        ICancellable[] iCancellableArray = this.listeners.toArray(new ICancellable[0]);
        int n = iCancellableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICancellable listener = iCancellableArray[n2];
            try {
                listener.abort();
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public void addListener(ICancellable listener) {
        this.listeners.add(listener);
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void removeListener(ICancellable listener) {
        this.listeners.remove(listener);
    }

    public static void connect(final Socket socket, InetSocketAddress address, int timeout) throws IOException {
        MonitoredRequest<?> request = MonitoredRequest.getCurrentRequest();
        if (request != null) {
            ICancellable listener = new ICancellable(){

                public void abort() {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            };
            try {
                request.addListener(listener);
                socket.connect(address, timeout);
            }
            finally {
                request.removeListener(listener);
            }
        } else {
            socket.connect(address, timeout);
        }
    }
}

