/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.editor.ext.html.parser.SyntaxTree;

public class SyntaxParserResult {
    public static String UNDECLARED_TAGS_NAMESPACE = "undeclared_tags_namespace";
    private static String UNDECLARED_TAGS_PREFIX = "undeclared_tags_prefix";
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private SyntaxParserContext context;
    private String publicID;
    private Map<String, AstNode> astRoots;
    private Map<String, String> namespaces;

    public SyntaxParserResult(SyntaxParserContext context) {
        this.context = context;
    }

    public CharSequence getSource() {
        return this.context.getSourceText();
    }

    public List<SyntaxElement> getElements() {
        return this.context.getElements();
    }

    public synchronized AstNode getASTRoot() {
        return this.getASTRoot(null);
    }

    public synchronized AstNode getASTRoot(String namespace) {
        return this.getASTRoot(namespace, null);
    }

    public synchronized AstNode getASTRoot(String namespace, DTD defaultDTD) {
        if (namespace == null && defaultDTD == null) {
            defaultDTD = this.getFallbackDTD();
        }
        if (this.astRoots == null) {
            this.astRoots = new HashMap<String, AstNode>();
        }
        if (this.astRoots.containsKey(namespace)) {
            return this.astRoots.get(namespace);
        }
        ArrayList<SyntaxElement> filtered = new ArrayList<SyntaxElement>();
        String prefix = UNDECLARED_TAGS_NAMESPACE.equals(namespace) ? UNDECLARED_TAGS_PREFIX : this.getDeclaredNamespaces().get(namespace);
        for (SyntaxElement e : this.getElements()) {
            if (e.type() == 4 || e.type() == 5) {
                SyntaxElement.Tag tag = (SyntaxElement.Tag)e;
                String tagNamePrefix = this.getTagNamePrefix(tag);
                if (!(tagNamePrefix == null && prefix == null || tagNamePrefix != null && UNDECLARED_TAGS_PREFIX.equals(prefix) && !this.getDeclaredNamespaces().containsValue(tagNamePrefix)) && (tagNamePrefix == null || prefix == null || !tagNamePrefix.equals(prefix))) continue;
                filtered.add(e);
                continue;
            }
            filtered.add(e);
        }
        DTD dtd = null;
        if (this.getDTDNoFallback() != null) {
            dtd = defaultDTD != null ? this.getDTDNoFallback() : null;
        } else if (defaultDTD != null) {
            dtd = defaultDTD;
        }
        AstNode root = SyntaxTree.makeTree(this.context.clone().setElements(filtered).setDTD(dtd));
        root.setProperty("namespace", namespace);
        this.astRoots.put(namespace, root);
        return root;
    }

    private String getTagNamePrefix(SyntaxElement.Tag tag) {
        String tName = tag.getName();
        int colonPrefix = tName.indexOf(58);
        if (colonPrefix == -1) {
            return null;
        }
        return tName.substring(0, colonPrefix);
    }

    public synchronized String getPublicID() {
        if (this.publicID == null) {
            for (SyntaxElement e : this.getElements()) {
                String _publicID;
                if (e.type() != 1 || (_publicID = ((SyntaxElement.Declaration)e).getPublicIdentifier()) == null) continue;
                this.publicID = _publicID;
                break;
            }
        }
        return this.publicID;
    }

    public synchronized Map<String, String> getDeclaredNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
            for (SyntaxElement se : this.getElements()) {
                if (se.type() != 4) continue;
                SyntaxElement.Tag tag = (SyntaxElement.Tag)se;
                for (SyntaxElement.TagAttribute attr : tag.getAttributes()) {
                    String nsPrefix;
                    String attrName = attr.getName();
                    if (!attrName.startsWith("xmlns")) continue;
                    int colonIndex = attrName.indexOf(58);
                    String string = nsPrefix = colonIndex == -1 ? null : attrName.substring(colonIndex + 1);
                    String value = attr.getValue();
                    if (this.namespaces.containsKey(SyntaxParserResult.dequote(value))) continue;
                    this.namespaces.put(SyntaxParserResult.dequote(value), nsPrefix);
                }
            }
        }
        return this.namespaces;
    }

    @Deprecated
    public Map<String, URI> getGlobalNamespaces() {
        HashMap<String, URI> _namespaces = new HashMap<String, URI>();
        AstNode root = this.getASTRoot();
        for (AstNode n : root.children()) {
            if (n.type() != AstNode.NodeType.OPEN_TAG) continue;
            for (String attrName : n.getAttributeKeys()) {
                if (!attrName.startsWith("xmlns")) continue;
                int colonIndex = attrName.indexOf(58);
                String nsPrefix = colonIndex == -1 ? "" : attrName.substring(colonIndex + 1);
                AstNode.Attribute attr = n.getAttribute(attrName);
                try {
                    _namespaces.put(nsPrefix, new URI(attr.unquotedValue()));
                }
                catch (URISyntaxException ex) {}
            }
        }
        return _namespaces;
    }

    private DTD getDTDNoFallback() {
        if (this.getPublicID() == null) {
            if (this.context.getDTD() != null) {
                return this.context.getDTD();
            }
        } else {
            return Registry.getDTD(this.getPublicID(), null);
        }
        return null;
    }

    public DTD getDTD() {
        if (this.getPublicID() == null) {
            if (this.context.getDTD() != null) {
                return this.context.getDTD();
            }
            return this.getFallbackDTD();
        }
        DTD dtd = Registry.getDTD(this.getPublicID(), null);
        return dtd != null ? dtd : this.getFallbackDTD();
    }

    private DTD getFallbackDTD() {
        return Registry.getDTD(FALLBACK_DOCTYPE, null);
    }

    private static String dequote(String text) {
        if (text.length() < 2) {
            return text;
        }
        if (!(text.charAt(0) != '\'' && text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\'' && text.charAt(text.length() - 1) != '\"')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }
}

