/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodePresenter;
import org.netbeans.modules.vmd.api.codegen.ModelUpdatePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public final class JavaCodeGenerator {
    private static final JavaCodeGenerator DEFAULT = new JavaCodeGenerator();
    public static final String VMD_FIELDS_SECTION_ID = "fields";
    public static final String VMD_METHODS_SECTION_ID = "methods";
    private final WeakHashMap<StyledDocument, HashMap<String, String>> userCodes = new WeakHashMap();
    private final HashMap<StyledDocument, ArrayList<String>> usedMultiSectionIDs = new HashMap();

    public static JavaCodeGenerator getDefault() {
        return DEFAULT;
    }

    private JavaCodeGenerator() {
    }

    public void updateUserCodesFromEditor(final StyledDocument document, final DesignDocument designDocument) {
        NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){

            @Override
            public void run() {
                JavaCodeGenerator.this.updateUserCodesFromEditorCore(document, designDocument);
            }
        });
    }

    public void preUpdateCode(StyledDocument document, DesignDocument designDocument) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(final StyledDocument document, DesignDocument designDocument) {
        final Collection presenters = DocumentSupport.gatherAllPresentersOfClass((DesignDocument)designDocument, CodePresenter.class);
        try {
            NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){

                @Override
                public void run() {
                    JavaCodeGenerator.this.generateCodeCore(presenters, document);
                }
            });
        }
        finally {
            this.usedMultiSectionIDs.remove(document);
        }
        Collection globalLevel = DocumentSupport.filterPresentersForClass((Collection)presenters, CodeGlobalLevelPresenter.class);
        for (CodeGlobalLevelPresenter presenter : globalLevel) {
            presenter.performGlobalGeneration(document);
        }
    }

    private void generateCodeCore(Collection<CodePresenter> presenters, StyledDocument document) {
        Collection classLevel = DocumentSupport.filterPresentersForClass(presenters, CodeClassLevelPresenter.class);
        MultiGuardedSection section = MultiGuardedSection.create(document, VMD_FIELDS_SECTION_ID);
        assert (section != null);
        section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Fields \">\n");
        for (CodeClassLevelPresenter presenter : classLevel) {
            presenter.generateFieldSectionCode(section);
        }
        section.getWriter().write("//</editor-fold>\n");
        section.getWriter().commit();
        section.close();
        section = MultiGuardedSection.create(document, VMD_METHODS_SECTION_ID);
        section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Methods \">\n");
        for (CodeClassLevelPresenter presenter : classLevel) {
            presenter.generateMethodSectionCode(section);
        }
        section.getWriter().write("//</editor-fold>\n");
        section.getWriter().commit();
        section.close();
        for (CodeClassLevelPresenter presenter : classLevel) {
            presenter.generateClassBodyCode(document);
        }
        this.removeUnusedSections(document);
    }

    private HashMap<String, String> getEditableUserCodes(StyledDocument document) {
        assert (document != null);
        HashMap<String, String> codes = this.userCodes.get(document);
        if (codes == null) {
            codes = new HashMap();
            this.userCodes.put(document, codes);
        }
        return codes;
    }

    String getUserCode(StyledDocument document, String multiGuardedID, String editableID) {
        HashMap<String, String> editableUserCodes = this.getEditableUserCodes(document);
        return editableUserCodes.get(multiGuardedID + "|" + editableID);
    }

    public void putUserCode(StyledDocument document, String multiGuardedID, String editableID, String userCode) {
        HashMap<String, String> editableUserCodes = this.getEditableUserCodes(document);
        editableUserCodes.put(multiGuardedID + "|" + editableID, userCode);
    }

    private void updateUserCodesFromEditorCore(StyledDocument document, DesignDocument designDocument) {
        Collection presenters = DocumentSupport.gatherAllPresentersOfClass((DesignDocument)designDocument, ModelUpdatePresenter.class);
        for (ModelUpdatePresenter presenter : presenters) {
            presenter.modelUpdated();
        }
        for (GuardedSection section : GuardedSectionManager.getInstance((StyledDocument)document).getGuardedSections()) {
            Object[] info;
            GuardedSection nextSection;
            if (!MultiGuardedSection.isPartOfMultiGuardedSection(section) || (nextSection = MultiGuardedSection.findNextPartOfMultiGuardedSectionAfter(document, info = MultiGuardedSection.parsePartOfMultiGuardedSection(section))) == null) continue;
            try {
                int begin = section.getEndPosition().getOffset() + 1;
                int end = nextSection.getStartPosition().getOffset();
                String userCode = document.getText(begin, end - begin);
                this.putUserCode(document, (String)info[0], (String)info[2], userCode);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void removeUnusedSections(StyledDocument document) {
        Iterable allSections = GuardedSectionManager.getInstance((StyledDocument)document).getGuardedSections();
        ArrayList<String> toDoIDs = new ArrayList<String>();
        for (GuardedSection section : allSections) {
            Object[] objects;
            String id;
            if (!MultiGuardedSection.isPartOfMultiGuardedSection(section) || this.isMultiSectionUsed(document, section) || toDoIDs.contains(id = (String)(objects = MultiGuardedSection.parsePartOfMultiGuardedSection(section))[0])) continue;
            toDoIDs.add(id);
        }
        for (String id : toDoIDs) {
            MultiGuardedSection.remove(document, id);
        }
    }

    private boolean isMultiSectionUsed(StyledDocument document, GuardedSection section) {
        ArrayList<String> multiGuardedIDs = this.usedMultiSectionIDs.get(document);
        return multiGuardedIDs != null && multiGuardedIDs.contains(MultiGuardedSection.parsePartOfMultiGuardedSection(section)[0]);
    }

    void registerUsedMultiGuardedSection(StyledDocument document, MultiGuardedSection section) {
        ArrayList<String> multiSections = this.usedMultiSectionIDs.get(document);
        if (multiSections == null) {
            multiSections = new ArrayList();
            this.usedMultiSectionIDs.put(document, multiSections);
        }
        multiSections.add(section.getMultiGuardedID());
    }
}

