/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.identity.profile.api.bridgeapi.RuntimeBridge;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.ui.support.SecurityCheckerImpl;
import org.netbeans.modules.identity.profile.ui.support.SunDDHelper;
import org.netbeans.modules.identity.profile.ui.support.WsdlData;
import org.netbeans.modules.identity.profile.ui.support.WsdlParser;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.AppClientMetadata;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityChecker;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class J2eeProjectHelper {
    private static final String SERVICE_REF_NAME_PREFIX = "service/";
    private static final String AM_DEPLOY_XML_PATH = "nbproject/am-deploy.xml";
    private static final String AM_DEPLOY_XSL = "resources/am-deploy.xsl";
    private static final String BUILD_SCRIPT = "/build.xml";
    private static final String BACKUP_EXT = ".bak";
    private static final String IMPORT_AM_DEPLOY_XML = "<import file=\"nbproject/am-deploy.xml\"/>";
    private static final String IMPORT_TAG = "<import";
    private static final String AM_CONSTRAINT_DISPLAY_NAME = "Access Manager Security Constraint";
    private static final String AM_WEB_RESOURCE_NAME = "AUTHENTICATED_RESOURCE";
    private static final String AM_URL_PATTERN = "/*";
    private static final String AM_ROLE_NAME = "AUTHENTICATED_USERS";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String EJB_WSDL_LOC = "META-INF";
    private static final String WEB_WSDL_LOC = "WEB-INF";
    private static final String CLIENT_WSDL_LOC = "META-INF";
    private static final String SUN_WEB_XML = "sun-web";
    private static final String SUN_WEB_TEMPLATE = "Templates/Identity/SunDD/sun-web.xml";
    private static final String SUN_EJB_JAR_TEMPLATE = "Templates/Identity/SunDD/sun-ejb-jar.xml";
    private static final String SUN_EJB_JAR_XML = "sun-ejb-jar";
    private static final String SUN_APPLICATION_CLIENT_TEMPLATE = "Templates/Identity/SunDD/sun-application-client.xml";
    private static final String SUN_APPLICATION_CLIENT_XML = "sun-application-client";
    private static final String XML_EXT = "xml";
    private static final String WEB_FOLDER = "web";
    private static final String WEB_INF_FOLDER = "WEB-INF";
    private static final String CONF_FOLDER = "conf";
    private static SecurityCheckerImpl securityChecker = new SecurityCheckerImpl();
    private Node node;
    private JaxWsModel jaxWsModel;
    private ProjectType projectType;
    private Version version;
    private File sunDD;
    private String endpointName;
    private List<String> endpointUri;
    private String portComponentName;
    private String serviceDescriptionName;
    private List<String> serviceRefNames;
    private List<WsdlData> wsdlData;
    private List<String> serviceNames;

    public static J2eeProjectHelper newInstance(Node node, JaxWsModel jaxWsModel) {
        J2eeProjectHelper j2eeProjectHelper = new J2eeProjectHelper(node, jaxWsModel);
        return j2eeProjectHelper;
    }

    protected J2eeProjectHelper(Node node, JaxWsModel jaxWsModel) {
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public boolean isSecurable() {
        if (this.getProject() == null || this.getProvider() == null) {
            return false;
        }
        if (this.isServer()) {
            if (this.getPortComponentName() != null && this.getServiceDescriptionName() != null) {
                return true;
            }
        } else {
            if (this.getProjectType() == ProjectType.CLIENT && this.getVersion() == Version.VERSION_1_4) {
                return false;
            }
            if (!this.getAllServiceRefNames().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean noServiceRefExists() {
        if (!this.isServer()) {
            if (this.getProjectType() == ProjectType.CLIENT && this.getVersion() == Version.VERSION_1_4) {
                return false;
            }
            if (this.getAllServiceRefNames().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean isServer() {
        return this.getService() != null;
    }

    public boolean isAMInstalled() {
        try {
            ServerProperties.getInstance((String)this.getServerID());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getServerID() {
        return this.getProvider().getServerInstanceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBuildScript() {
        File file;
        String string = FileUtil.toFile((FileObject)this.getProjectDirectory()).getPath() + BUILD_SCRIPT;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = null;
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(IMPORT_AM_DEPLOY_XML) == -1) continue;
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
        if (!bl) {
            try {
                file = new File(string);
                file.renameTo(new File(string + BACKUP_EXT));
                bufferedReader = new BufferedReader(new FileReader(string + BACKUP_EXT));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bl = false;
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!bl && (n = string2.indexOf(IMPORT_TAG)) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        stringBuffer = stringBuffer.replace(n, string2.length(), IMPORT_AM_DEPLOY_XML);
                        bufferedWriter.write(stringBuffer.toString());
                        bufferedWriter.newLine();
                        bl = true;
                    }
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
        file = new GeneratedFilesHelper(this.getProjectDirectory());
        try {
            file.refreshBuildScript(AM_DEPLOY_XML_PATH, J2eeProjectHelper.class.getResource(AM_DEPLOY_XSL), false);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public ProjectType getProjectType() {
        if (this.projectType == null) {
            J2eeModule.Type type = this.getProvider().getJ2eeModule().getType();
            this.projectType = J2eeModule.Type.WAR.equals(type) ? ProjectType.WEB : (J2eeModule.Type.EJB.equals(type) ? ProjectType.EJB : (J2eeModule.Type.CAR.equals(type) ? ProjectType.CLIENT : ProjectType.UNKNOWN));
        }
        return this.projectType;
    }

    public Version getVersion() {
        if (this.version == null) {
            String string = "";
            switch (this.getProjectType()) {
                case WEB: {
                    string = this.getWebModule().getJ2eePlatformVersion();
                    break;
                }
                case EJB: {
                    string = this.getEjbModule().getJ2eePlatformVersion();
                    break;
                }
                case CLIENT: {
                    string = this.getClientModule().getJ2eePlatformVersion();
                    break;
                }
            }
            this.version = string.equals("1.4") ? Version.VERSION_1_4 : (string.equals("1.5") ? Version.VERSION_1_5 : Version.UNKNOWN);
        }
        return this.version;
    }

    public String getEndpointName() {
        if (!this.isServer()) {
            return null;
        }
        if (this.endpointName == null) {
            Service service;
            Version version = this.getVersion();
            if (version == Version.VERSION_1_4) {
                String string = this.getJavaSourceName();
                switch (this.getProjectType()) {
                    case WEB: {
                        this.endpointName = this.getEndpointNameFromWebApp(string);
                        break;
                    }
                    case EJB: {
                        this.endpointName = this.getEndpointNameFromEjbJar(string);
                    }
                }
            } else if (version == Version.VERSION_1_5 && (service = this.getService()) != null) {
                this.endpointName = service.getWsdlUrl() == null ? service.getName() : service.getServiceName();
            }
        }
        return this.endpointName;
    }

    private String getEndpointNameFromWebApp(final String string) {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(WebAppMetadata.class);
        String string2 = null;
        try {
            string2 = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, String>(){

                public String run(WebAppMetadata webAppMetadata) {
                    WebApp webApp = webAppMetadata.getRoot();
                    for (Servlet servlet : webApp.getServlet()) {
                        if (!servlet.getServletClass().equals(string)) continue;
                        return servlet.getServletName();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return string2;
    }

    private String getEndpointNameFromEjbJar(final String string) {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(EjbJarMetadata.class);
        String string2 = null;
        try {
            string2 = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata ejbJarMetadata) {
                    EjbJar ejbJar = ejbJarMetadata.getRoot();
                    EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                    if (enterpriseBeans != null) {
                        for (Ejb ejb : enterpriseBeans.getEjbs()) {
                            String string2 = ejb.getEjbName();
                            if (string2 == null || string2.length() <= 0 || !ejb.getEjbClass().equals(string)) continue;
                            return string2;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return string2;
    }

    private void getServiceInfo() {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(WebservicesMetadata.class);
        try {
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, String>(){

                public String run(WebservicesMetadata webservicesMetadata) {
                    Webservices webservices = webservicesMetadata.getRoot();
                    String string = J2eeProjectHelper.this.getEndpointName();
                    ProjectType projectType = J2eeProjectHelper.this.getProjectType();
                    try {
                        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
                            for (PortComponent portComponent : webserviceDescription.getPortComponent()) {
                                String string2 = "";
                                if (projectType == ProjectType.WEB) {
                                    string2 = portComponent.getServiceImplBean().getServletLink();
                                } else if (projectType == ProjectType.EJB) {
                                    string2 = portComponent.getServiceImplBean().getEjbLink();
                                }
                                if (!string2.equals(string)) continue;
                                J2eeProjectHelper.this.portComponentName = portComponent.getPortComponentName();
                                J2eeProjectHelper.this.serviceDescriptionName = webserviceDescription.getWebserviceDescriptionName();
                            }
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    return J2eeProjectHelper.this.portComponentName;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public String getPortComponentName() {
        if (!this.isServer()) {
            return null;
        }
        if (this.portComponentName == null) {
            this.getServiceInfo();
        }
        return this.portComponentName;
    }

    public String getServiceDescriptionName() {
        if (this.serviceDescriptionName == null) {
            if (this.isServer()) {
                this.getServiceInfo();
            } else {
                this.serviceDescriptionName = this.getServiceName();
            }
        }
        return this.serviceDescriptionName;
    }

    public List<String> getAllServiceRefNames() {
        if (this.isServer()) {
            return null;
        }
        if (this.serviceRefNames == null) {
            switch (this.getProjectType()) {
                case WEB: {
                    this.serviceRefNames = this.getAllServiceRefNamesFromWebApp();
                    break;
                }
                case CLIENT: {
                    this.serviceRefNames = this.getAllServiceRefNamesFromAppClient();
                    break;
                }
                case EJB: {
                    this.serviceRefNames = this.getAllServiceRefNamesFromEjbJar();
                }
            }
        }
        return this.serviceRefNames;
    }

    private List<String> getAllServiceRefNamesFromWebApp() {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(WebAppMetadata.class);
        List list = null;
        try {
            list = (List)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<String>>(){

                public List<String> run(WebAppMetadata webAppMetadata) {
                    WebApp webApp = webAppMetadata.getRoot();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Version version = J2eeProjectHelper.this.getVersion();
                    try {
                        for (ServiceRef serviceRef : webApp.getServiceRef()) {
                            if (version == Version.VERSION_1_4) {
                                if (!serviceRef.getServiceRefName().equalsIgnoreCase(J2eeProjectHelper.this.getServiceRefName())) continue;
                                arrayList.add(serviceRef.getServiceRefName());
                                continue;
                            }
                            if (version != Version.VERSION_1_5 || !J2eeProjectHelper.this.isThisTheServiceRef(serviceRef)) continue;
                            arrayList.add(serviceRef.getServiceRefName());
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return list;
    }

    private List<String> getAllServiceRefNamesFromAppClient() {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(AppClientMetadata.class);
        List list = null;
        try {
            list = (List)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<AppClientMetadata, List<String>>(){

                public List<String> run(AppClientMetadata appClientMetadata) {
                    AppClient appClient = appClientMetadata.getRoot();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Version version = J2eeProjectHelper.this.getVersion();
                    try {
                        for (ServiceRef serviceRef : appClient.getServiceRef()) {
                            if (version == Version.VERSION_1_4) {
                                if (!serviceRef.getServiceRefName().equalsIgnoreCase(J2eeProjectHelper.this.getServiceRefName())) continue;
                                arrayList.add(serviceRef.getServiceRefName());
                                continue;
                            }
                            if (version != Version.VERSION_1_5) continue;
                            arrayList.add(serviceRef.getServiceRefName());
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return list;
    }

    private List<String> getAllServiceRefNamesFromEjbJar() {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(EjbJarMetadata.class);
        List list = null;
        try {
            list = (List)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, List<String>>(){

                public List<String> run(EjbJarMetadata ejbJarMetadata) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    EjbJar ejbJar = ejbJarMetadata.getRoot();
                    EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                    Version version = J2eeProjectHelper.this.getVersion();
                    if (enterpriseBeans != null) {
                        for (Ejb ejb : enterpriseBeans.getEjbs()) {
                            try {
                                for (ServiceRef serviceRef : ejb.getServiceRef()) {
                                    if (!J2eeProjectHelper.this.isThisTheServiceRef(serviceRef)) continue;
                                    arrayList.add(serviceRef.getServiceRefName());
                                }
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify(1, (Throwable)exception);
                            }
                        }
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return list;
    }

    private boolean isThisTheServiceRef(ServiceRef serviceRef) {
        String string = this.getWsdlFO().getPath();
        URI uRI = serviceRef.getWsdlFile();
        String string2 = uRI.getPath();
        int n = 0;
        if (string2.startsWith("META-INF")) {
            n = "META-INF".length();
        } else if (string2.startsWith("WEB-INF")) {
            n = "WEB-INF".length();
        } else if (string2.startsWith("META-INF")) {
            n = "META-INF".length();
        }
        string2 = string2.substring(n, string2.length());
        return string != null && uRI != null && string.contains(string2);
    }

    public List<WsdlData> getWsdlData() {
        if (this.isServer()) {
            return null;
        }
        if (this.wsdlData == null) {
            this.wsdlData = new ArrayList<WsdlData>();
            FileObject fileObject = this.getWsdlFO();
            if (fileObject != null) {
                try {
                    List<String> list = this.getAllServiceNames();
                    for (String string : list) {
                        this.wsdlData.add(WsdlParser.parseWSDLFile(FileUtil.toFile((FileObject)fileObject), string));
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
        return this.wsdlData;
    }

    protected FileObject getWsdlFO() {
        if (this.getVersion() == Version.VERSION_1_4) {
            switch (this.getProjectType()) {
                case WEB: {
                    return this.getWsdlFOFromWebApp(this.getServiceRefName());
                }
                case CLIENT: {
                    return this.getWsdlFOFromAppClient(this.getServiceRefName());
                }
            }
        } else if (this.getVersion() == Version.VERSION_1_5) {
            Client client = this.getClient();
            String string = client.getLocalWsdlFile();
            Enumeration enumeration = this.getProject().getProjectDirectory().getFolders(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                FileObject fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) continue;
                return fileObject2;
            }
        }
        return null;
    }

    private FileObject getWsdlFOFromWebApp(final String string) {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(WebAppMetadata.class);
        FileObject fileObject = null;
        try {
            fileObject = (FileObject)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, FileObject>(){

                public FileObject run(WebAppMetadata webAppMetadata) {
                    WebApp webApp = webAppMetadata.getRoot();
                    try {
                        for (ServiceRef serviceRef : webApp.getServiceRef()) {
                            if (!serviceRef.getServiceRefName().equalsIgnoreCase(string)) continue;
                            return J2eeProjectHelper.this.getProjectDirectory().getFileObject("web/" + serviceRef.getWsdlFile().getPath());
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return fileObject;
    }

    private FileObject getWsdlFOFromAppClient(final String string) {
        MetadataModel metadataModel = this.getJ2eeModule().getMetadataModel(AppClientMetadata.class);
        FileObject fileObject = null;
        try {
            fileObject = (FileObject)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<AppClientMetadata, FileObject>(){

                public FileObject run(AppClientMetadata appClientMetadata) {
                    AppClient appClient = appClientMetadata.getRoot();
                    try {
                        for (ServiceRef serviceRef : appClient.getServiceRef()) {
                            if (!serviceRef.getServiceRefName().equalsIgnoreCase(string)) continue;
                            return J2eeProjectHelper.this.getProjectDirectory().getFileObject("src/conf/" + serviceRef.getWsdlFile().getPath().substring(9));
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return fileObject;
    }

    public boolean isAppServerSun() {
        return RuntimeBridge.isAppServerSun((J2eeModuleProvider)this.getProvider());
    }

    public boolean providerExists() {
        return false;
    }

    public boolean isSecurityEnabled() {
        SunDDHelper sunDDHelper = new SunDDHelper(this.getSunDDFO(), this.getProjectType());
        if (this.isServer()) {
            return sunDDHelper.isServiceSecurityEnabled(this.getServiceDescriptionName(), this.getPortComponentName());
        }
        for (WsdlData wsdlData : this.getWsdlData()) {
            String string = wsdlData.getTargetNameSpace();
            String string2 = wsdlData.getPort();
            for (String string3 : this.getAllServiceRefNames()) {
                if (!sunDDHelper.isClientSecurityEnabled(string3, string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected void enableMessageLevelSecurity(String string) {
        SunDDHelper sunDDHelper = new SunDDHelper(this.getSunDDFO(), this.getProjectType());
        if (this.isServer()) {
            sunDDHelper.setServiceMessageSecurityBinding(this.getServiceDescriptionName(), this.getPortComponentName(), string);
        } else {
            for (WsdlData wsdlData : this.getWsdlData()) {
                String string2 = wsdlData.getTargetNameSpace();
                String string3 = wsdlData.getPort();
                for (String string4 : this.getAllServiceRefNames()) {
                    sunDDHelper.setServiceRefMessageSecurityBinding(string4, string2, string3);
                }
            }
        }
    }

    protected void disableMessageLevelSecurity() {
        SunDDHelper sunDDHelper = new SunDDHelper(this.getSunDDFO(), this.getProjectType());
        if (this.isServer()) {
            sunDDHelper.removeServiceMessageSecurityBinding(this.getServiceDescriptionName(), this.getPortComponentName());
        } else {
            for (WsdlData wsdlData : this.getWsdlData()) {
                String string = wsdlData.getTargetNameSpace();
                String string2 = wsdlData.getPort();
                for (String string3 : this.getAllServiceRefNames()) {
                    sunDDHelper.removeServiceRefMessageSecurityBinding(string3, string, string2);
                }
            }
        }
    }

    public FileObject getSunDDFO() {
        String string;
        FileObject fileObject = this.getConfRoot();
        FileObject fileObject2 = fileObject.getFileObject(string = this.getSunDDName(), XML_EXT);
        if (fileObject2 == null) {
            String string2 = this.getSunDDTemplate();
            try {
                fileObject2 = this.createSunDDFromTemplate(string2, fileObject, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fileObject2;
    }

    private String getSunDDName() {
        switch (this.getProjectType()) {
            case EJB: {
                return SUN_EJB_JAR_XML;
            }
            case WEB: {
                return SUN_WEB_XML;
            }
            case CLIENT: {
                return SUN_APPLICATION_CLIENT_XML;
            }
        }
        return null;
    }

    private String getSunDDTemplate() {
        switch (this.getProjectType()) {
            case EJB: {
                return SUN_EJB_JAR_TEMPLATE;
            }
            case WEB: {
                return SUN_WEB_TEMPLATE;
            }
            case CLIENT: {
                return SUN_APPLICATION_CLIENT_TEMPLATE;
            }
        }
        return null;
    }

    private FileObject getConfRoot() {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = this.getProvider().getSourceRoots()) {
            String string = fileObject.getName();
            if (this.getProjectType() == ProjectType.WEB) {
                if (!string.equals(WEB_FOLDER)) continue;
                return fileObject.getFileObject("WEB-INF");
            }
            if (!string.equals(CONF_FOLDER)) continue;
            return fileObject;
        }
        return null;
    }

    private FileObject createSunDDFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        assert (string != null);
        assert (fileObject != null);
        FileObject fileObject2 = FileUtil.getConfigFile((String)string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string2);
        return dataObject2.getPrimaryFile();
    }

    public boolean isWsitSecurityEnabled() {
        return WSITConfigProvider.getDefault().isWsitSecurityEnabled(this.node, this.jaxWsModel);
    }

    public void setTransientState(boolean bl) {
        securityChecker.setTransientState(bl);
    }

    public void clearTransientState() {
        securityChecker.clearTransientState();
    }

    public void enableWSPSecurity(String string) {
        this.enableMessageLevelSecurity(string);
    }

    public void disableWSPSecurity() {
        this.disableMessageLevelSecurity();
    }

    public void enableWSCSecurity(boolean bl) {
        if (this.getProjectType().equals((Object)ProjectType.WEB)) {
            if (bl) {
                this.enableLiberty();
            } else {
                this.disableLiberty();
            }
        }
        this.enableMessageLevelSecurity(null);
    }

    public void disableWSCSecurity() {
        if (this.getProjectType().equals((Object)ProjectType.WEB)) {
            this.disableLiberty();
        }
        this.disableMessageLevelSecurity();
    }

    private void enableLiberty() {
        this.addAMSecurityConstraint();
        SunDDHelper sunDDHelper = new SunDDHelper(this.getSunDDFO(), this.getProjectType());
        sunDDHelper.addSecurityRoleMapping();
    }

    private void disableLiberty() {
        this.removeAMSecurityConstraint();
        SunDDHelper sunDDHelper = new SunDDHelper(this.getSunDDFO(), this.getProjectType());
        sunDDHelper.removeSecurityRoleMapping();
    }

    private void addAMSecurityConstraint() {
        boolean bl = false;
        WebApp webApp = this.getWebApp();
        SecurityRole securityRole = this.getAMSecurityRole(webApp);
        try {
            if (securityRole == null) {
                securityRole = (SecurityRole)webApp.createBean("SecurityRole");
                securityRole.setRoleName(AM_ROLE_NAME);
                webApp.addSecurityRole(securityRole);
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        SecurityConstraint securityConstraint = this.getAMSecurityConstraint(webApp);
        try {
            if (securityConstraint == null) {
                securityConstraint = (SecurityConstraint)webApp.createBean("SecurityConstraint");
                securityConstraint.setDisplayName(AM_CONSTRAINT_DISPLAY_NAME);
                webApp.addSecurityConstraint(securityConstraint);
                WebResourceCollection webResourceCollection = (WebResourceCollection)securityConstraint.createBean("WebResourceCollection");
                webResourceCollection.setWebResourceName(AM_WEB_RESOURCE_NAME);
                webResourceCollection.setUrlPattern(new String[]{AM_URL_PATTERN});
                securityConstraint.setWebResourceCollection(new WebResourceCollection[]{webResourceCollection});
                AuthConstraint authConstraint = (AuthConstraint)securityConstraint.createBean("AuthConstraint");
                authConstraint.setRoleName(new String[]{AM_ROLE_NAME});
                securityConstraint.setAuthConstraint(authConstraint);
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        if (bl) {
            this.saveDD((RootInterface)webApp);
        }
    }

    private void removeAMSecurityConstraint() {
        SecurityConstraint securityConstraint;
        boolean bl = false;
        WebApp webApp = this.getWebApp();
        SecurityRole securityRole = this.getAMSecurityRole(webApp);
        if (securityRole != null) {
            webApp.removeSecurityRole(securityRole);
            bl = true;
        }
        if ((securityConstraint = this.getAMSecurityConstraint(webApp)) != null) {
            webApp.removeSecurityConstraint(securityConstraint);
            bl = true;
        }
        if (bl) {
            this.saveDD((RootInterface)webApp);
        }
    }

    private SecurityRole getAMSecurityRole(WebApp webApp) {
        SecurityRole[] securityRoleArray;
        for (SecurityRole securityRole : securityRoleArray = webApp.getSecurityRole()) {
            if (!securityRole.getRoleName().equals(AM_ROLE_NAME)) continue;
            return securityRole;
        }
        return null;
    }

    private SecurityConstraint getAMSecurityConstraint(WebApp webApp) {
        SecurityConstraint[] securityConstraintArray;
        for (SecurityConstraint securityConstraint : securityConstraintArray = webApp.getSecurityConstraint()) {
            if (!securityConstraint.getDefaultDisplayName().equals(AM_CONSTRAINT_DISPLAY_NAME)) continue;
            return securityConstraint;
        }
        return null;
    }

    private void saveDD(RootInterface rootInterface) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            rootInterface.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            FileObject fileObject = this.getWebModule().getDeploymentDescriptor();
            FileLock fileLock = fileObject.lock();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock));
            outputStreamWriter.write(byteArrayOutputStream.toString(DEFAULT_ENCODING));
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            fileLock.releaseLock();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (IllegalStateException illegalStateException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
        }
    }

    public String getConfigPath() {
        return FileUtil.toFile((FileObject)this.getProjectDirectory()).getPath() + File.separator + "src" + File.separator + CONF_FOLDER;
    }

    private String getServiceRefName() {
        return SERVICE_REF_NAME_PREFIX + this.getServiceName();
    }

    public List<String> getAllServiceNames() {
        if (this.serviceNames == null) {
            this.serviceNames = new ArrayList<String>();
            FileObject fileObject = this.getWsdlFO();
            if (fileObject != null) {
                try {
                    this.serviceNames = WsdlParser.getWsdlSvcNames(FileUtil.toFile((FileObject)fileObject));
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
        return this.serviceNames;
    }

    public List<String> getEndpointURI() {
        if (this.endpointUri == null) {
            this.endpointUri = new ArrayList<String>();
            if (this.isServer()) {
                this.endpointUri.add(this.getServiceDescriptionName());
            } else {
                this.endpointUri = this.getAllServiceNames();
            }
        }
        return this.endpointUri;
    }

    private String getServiceName() {
        if (this.isServer()) {
            return null;
        }
        return this.node.getName();
    }

    protected J2eeModuleProvider getProvider() {
        Project project = this.getProject();
        if (project != null) {
            return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        }
        return null;
    }

    protected Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.getFileObject());
    }

    protected FileObject getProjectDirectory() {
        return this.getProject().getProjectDirectory();
    }

    private FileObject getFileObject() {
        FileObject fileObject = this.getJavaSource();
        if (fileObject != null) {
            return fileObject;
        }
        FileObject fileObject2 = (FileObject)this.node.getLookup().lookup(FileObject.class);
        if (fileObject2 != null) {
            return fileObject2;
        }
        DataObject dataObject = (DataObject)this.node.getLookup().lookup(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    protected FileObject getJavaSource() {
        return (FileObject)this.node.getLookup().lookup(FileObject.class);
    }

    protected String getJavaSourceName() {
        return this.getService().getImplementationClass();
    }

    protected Client getClient() {
        return (Client)this.node.getLookup().lookup(Client.class);
    }

    protected Service getService() {
        return (Service)this.node.getLookup().lookup(Service.class);
    }

    protected WebModule getWebModule() {
        return WebModule.getWebModule((FileObject)this.getProjectDirectory());
    }

    protected org.netbeans.modules.j2ee.api.ejbjar.EjbJar getEjbModule() {
        return org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.getProjectDirectory());
    }

    protected Car getClientModule() {
        return Car.getCar((FileObject)this.getProjectDirectory());
    }

    protected J2eeModule getJ2eeModule() {
        return this.getProvider().getJ2eeModule();
    }

    protected WebApp getWebApp() {
        FileObject fileObject = this.getConfRoot();
        FileObject fileObject2 = fileObject.getFileObject(WEB_FOLDER, XML_EXT);
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject2);
            return webApp;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
    }

    static {
        SecurityCheckerRegistry.getDefault().register((SecurityChecker)securityChecker);
    }

    public static enum Version {
        VERSION_1_4,
        VERSION_1_5,
        UNKNOWN;

    }

    public static enum ProjectType {
        WEB,
        EJB,
        CLIENT,
        UNKNOWN;

    }
}

