/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.kenai.ui.dashboard.CategoryNode;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.dashboard.MyProjectNode;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.explorer.propertysheet.PropertySheet;

final class RendererPanel
extends JPanel {
    static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
    private static final Border NO_FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorManager.getDefault().getDefaultBackground()), BorderFactory.createEmptyBorder(1, 1, 0, 1));
    private static Border INNER_BORDER;
    private static Color expandableRootBackground;
    private static Color expandableRootForeground;
    private static Color expandableRootSelectedBackground;
    private static Color expandableRootSelectedForeground;
    private static final Icon EMPTY_ICON;
    private final boolean isRoot;
    private final TreeListNode node;
    private JButton expander;

    public RendererPanel(final TreeListNode node) {
        super(new BorderLayout());
        if (null == expandableRootBackground) {
            RendererPanel.deriveColorsAndMargin();
        }
        this.node = node;
        this.isRoot = node.getParent() == null;
        this.setOpaque(!this.isRoot || !isAqua || !node.isExpandable());
        if (node.isExpandable()) {
            this.expander = new LinkButton(EMPTY_ICON, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    node.setExpanded(!node.isExpanded());
                }
            });
            this.add((Component)this.expander, "West");
        } else if (!this.isRoot) {
            this.add((Component)new JLabel(new EmptyIcon()), "West");
        }
    }

    public void configure(Color foreground, Color background, boolean isSelected, boolean hasFocus, int nestingDepth, int rowHeight) {
        if (this.isRoot && this.node.isExpandable() || this.node instanceof MyProjectNode) {
            foreground = isSelected ? expandableRootSelectedForeground : expandableRootForeground;
            background = isSelected ? expandableRootSelectedBackground : expandableRootBackground;
        } else if (this.node instanceof CategoryNode) {
            background = isSelected ? expandableRootSelectedBackground : ColorManager.getDefault().getDisabledColor();
        }
        JComponent inner = this.node.getComponent(foreground, background, isSelected, hasFocus);
        if (this.node.isExpandable() || !this.isRoot) {
            inner.setBorder(INNER_BORDER);
        }
        this.add((Component)inner, "Center");
        this.setBackground(background);
        this.setForeground(foreground);
        if (null != this.expander) {
            this.expander.setIcon(this.node.isExpanded() ? RendererPanel.getExpandedIcon() : RendererPanel.getCollapsedIcon());
            this.expander.setPressedIcon(this.expander.getIcon());
        }
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        }
        if (null == border) {
            border = NO_FOCUS_BORDER;
        }
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 4 + nestingDepth * rowHeight / 2, 3, 4));
        try {
            this.setBorder(border);
        }
        catch (NullPointerException npe) {
            Logger.getLogger(RendererPanel.class.getName()).log(Level.INFO, "Bug #175940", npe);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isRoot && isAqua && this.node.isExpandable()) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight() / 2, this.getBackground()));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setPaint(oldPaint);
        } else {
            super.paintComponent(g);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        JComponent jc;
        String tooltip;
        Component c = SwingUtilities.getDeepestComponentAt(this, event.getX(), event.getY());
        if (c instanceof JComponent && null != (tooltip = (jc = (JComponent)c).getToolTipText())) {
            return tooltip;
        }
        return super.getToolTipText(event);
    }

    private static void deriveColorsAndMargin() {
        int blue;
        int green;
        int red;
        new PropertySheet();
        Color controlColor = UIManager.getColor("control");
        if (controlColor == null) {
            controlColor = Color.LIGHT_GRAY;
        }
        boolean windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        boolean nimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
        expandableRootBackground = UIManager.getColor("PropSheet.setBackground");
        expandableRootSelectedBackground = UIManager.getColor("PropSheet.selectedSetBackground");
        if (nimbus || isGtk) {
            expandableRootBackground = UIManager.getColor("Menu.background");
            expandableRootSelectedBackground = UIManager.getColor("Tree.selectionBackground");
        }
        if (expandableRootBackground == null && expandableRootBackground == null) {
            red = RendererPanel.adjustColorComponent(controlColor.getRed(), -25, -25);
            green = RendererPanel.adjustColorComponent(controlColor.getGreen(), -25, -25);
            blue = RendererPanel.adjustColorComponent(controlColor.getBlue(), -25, -25);
            expandableRootBackground = new Color(red, green, blue);
        }
        if (isAqua) {
            expandableRootBackground = new Color((int)Math.max(0.0, (double)expandableRootBackground.getRed() * 0.85), (int)Math.max(0.0, (double)expandableRootBackground.getGreen() * 0.85), (int)Math.max(0.0, (double)expandableRootBackground.getBlue() * 0.85));
        }
        if (expandableRootSelectedBackground == null) {
            Color col;
            Color color = col = windows ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (col == null) {
                col = Color.BLUE;
            }
            red = RendererPanel.adjustColorComponent(col.getRed(), -25, -25);
            green = RendererPanel.adjustColorComponent(col.getGreen(), -25, -25);
            blue = RendererPanel.adjustColorComponent(col.getBlue(), -25, -25);
            expandableRootSelectedBackground = new Color(red, green, blue);
        }
        expandableRootForeground = UIManager.getColor("PropSheet.setForeground");
        if (nimbus || isGtk) {
            expandableRootForeground = new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        if (expandableRootForeground == null && (expandableRootForeground = UIManager.getColor("Table.foreground")) == null && (expandableRootForeground = UIManager.getColor("textText")) == null) {
            expandableRootForeground = Color.BLACK;
        }
        if ((expandableRootSelectedForeground = UIManager.getColor("PropSheet.selectedSetForeground")) == null && (expandableRootSelectedForeground = UIManager.getColor("Table.selectionForeground")) == null) {
            expandableRootSelectedForeground = Color.WHITE;
        }
        if (isAqua) {
            expandableRootSelectedForeground = Color.black;
        }
        Integer i = (Integer)UIManager.get("netbeans.ps.iconmargin");
        int iconMargin = 0;
        iconMargin = i != null ? i : (windows ? 4 : 0);
        INNER_BORDER = BorderFactory.createEmptyBorder(0, iconMargin, 0, 0);
    }

    private static int adjustColorComponent(int base, int adjBright, int adjDark) {
        base = base > 128 ? (base -= adjBright) : (base += adjDark);
        if (base < 0) {
            base = 0;
        }
        if (base > 255) {
            base = 255;
        }
        return base;
    }

    static Icon getExpandedIcon() {
        Icon expandedIcon = UIManager.getIcon(isGtk ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
        assert (expandedIcon != null) : "no Tree.expandedIcon found";
        return expandedIcon;
    }

    static Icon getCollapsedIcon() {
        Icon collapsedIcon = UIManager.getIcon(isGtk ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
        assert (collapsedIcon != null) : "no Tree.collapsedIcon found";
        return collapsedIcon;
    }

    static {
        expandableRootBackground = null;
        expandableRootForeground = null;
        expandableRootSelectedBackground = null;
        expandableRootSelectedForeground = null;
        EMPTY_ICON = new EmptyIcon();
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return RendererPanel.getExpandedIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return RendererPanel.getExpandedIcon().getIconHeight();
        }
    }
}

