/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.html.editor.refactoring.api.ExtractInlinedStyleRefactoring;
import org.netbeans.modules.html.editor.refactoring.api.SelectorType;
import org.openide.util.WeakListeners;

public class HtmlPreferences {
    private static boolean autocompleQuotesAfterEQS;
    private static boolean autocompleQuotes;
    private static boolean completionOffersEndTagAfterLt;
    private static SelectorType selectorType;
    private static final String SELECTOR_TYPE_PROPERTY_NAME = "extractInlinedStylePanelSelectorType";
    private static SelectorType SELECTOR_TYPE_DEFAULT;
    private static ExtractInlinedStyleRefactoring.Mode sectionMode;
    private static final String SECTION_MODE_PROPERTY_NAME = "extractInlinedStylePanelSectionMode";
    private static ExtractInlinedStyleRefactoring.Mode SECTION_MODE_DEFAULT;
    private static AtomicBoolean initialized;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;

    private static void lazyIntialize() {
        if (initialized.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/html").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private HtmlPreferences() {
    }

    public static boolean autocompleteQuotesAfterEqualSign() {
        HtmlPreferences.lazyIntialize();
        return autocompleQuotesAfterEQS;
    }

    public static boolean autocompleteQuotes() {
        HtmlPreferences.lazyIntialize();
        return autocompleQuotes;
    }

    public static boolean completionOffersEndTagAfterLt() {
        HtmlPreferences.lazyIntialize();
        return completionOffersEndTagAfterLt;
    }

    public static SelectorType extractInlinedStylePanelSelectorType() {
        HtmlPreferences.lazyIntialize();
        return selectorType;
    }

    public static void setExtractInlinedStylePanelSelectorType(SelectorType type) {
        HtmlPreferences.lazyIntialize();
        preferences.put(SELECTOR_TYPE_PROPERTY_NAME, type.name());
    }

    public static ExtractInlinedStyleRefactoring.Mode extractInlinedStylePanelSectionMode() {
        HtmlPreferences.lazyIntialize();
        return sectionMode;
    }

    public static void setExtractInlinedStylePanelSectionMode(ExtractInlinedStyleRefactoring.Mode mode) {
        HtmlPreferences.lazyIntialize();
        preferences.put(SECTION_MODE_PROPERTY_NAME, mode.name());
    }

    static {
        SELECTOR_TYPE_DEFAULT = SelectorType.ID;
        SECTION_MODE_DEFAULT = ExtractInlinedStyleRefactoring.Mode.refactorToExistingEmbeddedSection;
        initialized = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || "htmlAutocompleteQuotesAfterEQS".equals(settingName)) {
                    autocompleQuotesAfterEQS = preferences.getBoolean("htmlAutocompleteQuotesAfterEQS", true);
                }
                if (settingName == null || "htmlAutocompleteQuotes".equals(settingName)) {
                    autocompleQuotes = preferences.getBoolean("htmlAutocompleteQuotes", true);
                }
                if (settingName == null || "htmlCompletionOffersEndTagsAfterLt".equals(settingName)) {
                    completionOffersEndTagAfterLt = preferences.getBoolean("htmlCompletionOffersEndTagsAfterLt", false);
                }
                if (settingName == null || HtmlPreferences.SELECTOR_TYPE_PROPERTY_NAME.equals(settingName)) {
                    selectorType = SelectorType.valueOf(preferences.get(HtmlPreferences.SELECTOR_TYPE_PROPERTY_NAME, SELECTOR_TYPE_DEFAULT.name()));
                }
                if (settingName == null || HtmlPreferences.SECTION_MODE_PROPERTY_NAME.equals(settingName)) {
                    sectionMode = ExtractInlinedStyleRefactoring.Mode.valueOf(preferences.get(HtmlPreferences.SECTION_MODE_PROPERTY_NAME, SECTION_MODE_DEFAULT.name()));
                }
            }
        };
    }
}

