/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.attach.GdbAttachPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class GdbServerAttachPanel
extends JPanel {
    private final Controller controller = new GdbServerAttachController();
    private static final String HOST_KEY = "last-gdbserver-host";
    private static final String PORT_KEY = "last-gdbserver-port";
    private JTextField hostTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField portTF;
    private JComboBox projectCB;
    private JLabel projectLabel;

    public GdbServerAttachPanel() {
        this.initComponents();
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.hostTF.setText(NbPreferences.forModule(GdbServerAttachPanel.class).get(HOST_KEY, ""));
        this.portTF.setText(NbPreferences.forModule(GdbServerAttachPanel.class).get(PORT_KEY, ""));
    }

    Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.hostTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.portTF = new JTextField();
        this.projectLabel.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.projectLabel.text"));
        this.jLabel1.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.jLabel2.text"));
        this.portTF.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.portTF.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabel).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portTF, -1, 335, Short.MAX_VALUE).addComponent(this.hostTF, -1, 335, Short.MAX_VALUE).addComponent(this.projectCB, 0, 335, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.hostTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.portTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectCB, -2, -1, -2))));
    }

    private class GdbServerAttachController
    implements Controller {
        private GdbServerAttachController() {
        }

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            String hostValue = GdbServerAttachPanel.this.hostTF.getText();
            if (hostValue.length() == 0) {
                return false;
            }
            String portValue = GdbServerAttachPanel.this.portTF.getText();
            if (portValue.length() == 0) {
                return false;
            }
            NbPreferences.forModule(GdbServerAttachPanel.class).put(GdbServerAttachPanel.HOST_KEY, hostValue);
            NbPreferences.forModule(GdbServerAttachPanel.class).put(GdbServerAttachPanel.PORT_KEY, portValue);
            GdbAttachPanel.ProjectCBItem pi = (GdbAttachPanel.ProjectCBItem)GdbServerAttachPanel.this.projectCB.getSelectedItem();
            if (pi != null) {
                String target = hostValue + ':' + portValue;
                try {
                    GdbDebugger.attachGdbServer(target, pi.getProjectInformation());
                }
                catch (DebuggerStartException dse) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbServerAttachPanel.class, (String)"ERR_UnexpecedAttachGdbServerFailure", (Object)target)));
                }
            }
            return true;
        }

        public boolean isValid() {
            return GdbServerAttachPanel.this.projectCB.getItemCount() > 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

