/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultEditorKit;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class MemoryViewTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static MemoryViewTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common/resources/memory.png";
    private static final String PREFERRED_ID = "MemoryViewTopComponent";
    private JPanel fakePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextArea taResult;
    private JTextField tfAddress;
    private JTextField tfLength;

    private MemoryViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"CTL_MemoryViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"HINT_MemoryViewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.taResult.setFont(new Font("Monospaced", 0, this.taResult.getFont().getSize()));
        this.getActionMap().put("copy-to-clipboard", new DefaultEditorKit.CopyAction());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.taResult = new JTextArea();
        this.fakePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfAddress = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfLength = new JTextField();
        this.taResult.setEditable(false);
        this.jScrollPane1.setViewportView(this.taResult);
        GroupLayout fakePanelLayout = new GroupLayout(this.fakePanel);
        this.fakePanel.setLayout(fakePanelLayout);
        fakePanelLayout.setHorizontalGroup(fakePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        fakePanelLayout.setVerticalGroup(fakePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 2, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.jLabel1.text"));
        this.tfAddress.setText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.tfAddress.text"));
        this.tfAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewTopComponent.this.tfAddressActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.jLabel2.text"));
        this.tfLength.setText(NbBundle.getMessage(MemoryViewTopComponent.class, (String)"MemoryViewTopComponent.tfLength.text"));
        this.tfLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewTopComponent.this.tfLengthActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fakePanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfAddress, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLength, -2, 90, -2).addContainerGap(93, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 432, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fakePanel, -2, -1, -2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfLength, -2, 21, -2).addComponent(this.tfAddress, -2, 21, -2).addComponent(this.jLabel1)).addGap(2, 2, 2).addComponent(this.jScrollPane1, -1, 240, Short.MAX_VALUE)));
    }

    private void tfAddressActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void tfLengthActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void update() {
        int len;
        this.taResult.setText("");
        final GdbDebugger debugger = GdbDebugger.getGdbDebugger();
        if (debugger == null) {
            return;
        }
        final String addr = this.tfAddress.getText();
        if (addr == null || addr.length() == 0) {
            return;
        }
        String length = this.tfLength.getText();
        if (length == null || length.length() == 0) {
            return;
        }
        try {
            len = Integer.decode(length);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (len < 1) {
            return;
        }
        debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (!debugger.isStopped()) {
                    return;
                }
                CommandBuffer cb = debugger.getGdbProxy().data_read_memory(addr, (len - 1) / 16 + 1);
                if (cb.isError()) {
                    MemoryViewTopComponent.this.taResult.setText(cb.getError());
                } else if (cb.isOK()) {
                    Map<String, String> res = GdbUtils.createMapFromString(cb.getResponse(), debugger.getCharSetEncoding());
                    String mem = res.get("memory");
                    List<String> lines = GdbUtils.createListOfValues(mem);
                    StringBuilder text = new StringBuilder();
                    for (String line : lines) {
                        if (text.length() > 0) {
                            text.append("\n");
                        }
                        Map<String, String> fields = GdbUtils.createMapFromString(line, debugger.getCharSetEncoding());
                        text.append(fields.get("addr"));
                        text.append("  ");
                        text.append(MemoryViewTopComponent.this.prepareHex(fields.get("data")));
                        text.append(" ");
                        text.append(fields.get("ascii"));
                    }
                    MemoryViewTopComponent.this.taResult.append(text.toString());
                    MemoryViewTopComponent.this.taResult.setCaretPosition(0);
                }
            }
        });
    }

    private String prepareHex(String source) {
        int end;
        StringBuilder res = new StringBuilder();
        int start = source.indexOf(34);
        while (start != -1 && (end = source.indexOf(34, start + 1)) != -1) {
            String number = source.substring(start + 1, end);
            if (number.startsWith("0x")) {
                number = number.substring(2);
            }
            res.append(number.toUpperCase() + " ");
            start = source.indexOf(34, end + 1);
        }
        return res.toString();
    }

    public static synchronized MemoryViewTopComponent getDefault() {
        if (instance == null) {
            instance = new MemoryViewTopComponent();
        }
        return instance;
    }

    public static synchronized MemoryViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(MemoryViewTopComponent.class.getName()).warning("Cannot find MemoryViewTopComponent component. It will not be located properly in the window system.");
            return MemoryViewTopComponent.getDefault();
        }
        if (win instanceof MemoryViewTopComponent) {
            return (MemoryViewTopComponent)win;
        }
        Logger.getLogger(MemoryViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'MemoryViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return MemoryViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        GdbContext.getInstance().addPropertyChangeListener("Step", this);
        GdbContext.getInstance().addPropertyChangeListener("Exit", this);
        this.update();
    }

    public void componentClosed() {
        GdbContext.getInstance().removePropertyChangeListener("Step", this);
        GdbContext.getInstance().removePropertyChangeListener("Exit", this);
    }

    protected void componentShowing() {
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return MemoryViewTopComponent.getDefault();
        }
    }
}

