/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectModePanel;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectModeWizard
implements WizardDescriptor.AsynchronousValidatingPanel,
ChangeListener {
    private DiscoveryDescriptor wizardDescriptor;
    private SelectModePanel component;
    private String name;
    private boolean inited = false;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SelectModeWizard() {
        this.name = NbBundle.getMessage(SelectProviderPanel.class, (String)"SelectModeName");
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new SelectModePanel(this);
            this.component.setName(this.name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("CodeAssistanceWizardP1");
    }

    public boolean isValid() {
        boolean valid = ((SelectModePanel)this.getComponent()).valid(this.wizardDescriptor);
        if (valid) {
            this.wizardDescriptor.setMessage(null);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    public void readSettings(Object settings) {
        if (!this.inited) {
            this.wizardDescriptor = DiscoveryWizardDescriptor.adaptee(settings);
            this.component.read(this.wizardDescriptor);
            this.inited = true;
        }
        ((WizardDescriptor)this.wizardDescriptor).putProperty("ShowAlert", (Object)Boolean.FALSE);
    }

    public void storeSettings(Object settings) {
        this.component.store(DiscoveryWizardDescriptor.adaptee(settings));
        if (this.wizardDescriptor instanceof WizardDescriptor) {
            ((WizardDescriptor)this.wizardDescriptor).putProperty("readOnlyToolchain", (Object)Boolean.TRUE);
        }
    }

    public void prepareValidation() {
        if (this.wizardDescriptor.isSimpleMode()) {
            this.component.enableControls(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        if (this.wizardDescriptor.isSimpleMode()) {
            boolean res;
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SelectProviderPanel.class, (String)"AnalyzingProjectProgress"));
            handle.setInitialDelay(100);
            handle.start();
            try {
                res = this.component.isApplicable(this.wizardDescriptor);
            }
            finally {
                handle.finish();
            }
            this.component.updateControls();
            if (!res) {
                this.fireChangeEvent();
                ((WizardDescriptor)this.wizardDescriptor).putProperty("ShowAlert", (Object)Boolean.TRUE);
            }
        }
    }
}

