/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.packets.BaseMessageChildElement;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.w3c.dom.Node;
import sun.misc.BASE64Decoder;

public class Property
extends BaseMessageChildElement {
    static final String PROPERTY = "property";
    private static final String NUMCHILDREN = "numchildren";
    static final String ENCODING = "encoding";
    private static final String KEY = "key";
    private static final String ADDRESS = "address";
    private static final String PAGESIZE = "pagesize";
    private static final String PAGE = "page";
    private static final String NAME = "name";
    private static final String FULL_NAME = "fullname";
    private static final String TYPE = "type";
    private static final String CLASS_NAME = "classname";
    private static final String CONSTANT = "constant";
    private static final String CHILDREN = "children";
    private static final String FACET = "facet";
    static final String SIZE = "size";

    Property(Node node) {
        super(node);
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public void setName(String value) {
        Node node = this.getNode().getAttributes().getNamedItem(NAME);
        if (node == null) {
            node = this.getNode().getOwnerDocument().createAttribute(NAME);
            this.getNode().appendChild(node);
        }
        node.setNodeValue(value);
    }

    public String getFullName() {
        return this.getAttribute(FULL_NAME);
    }

    public String getType() {
        return this.getAttribute(TYPE);
    }

    public String getClassName() {
        return this.getAttribute(CLASS_NAME);
    }

    public boolean isConstant() {
        return this.getInt(CONSTANT) > 0;
    }

    public boolean hasChildren() {
        return this.getInt(CHILDREN) > 0;
    }

    public int getSize() {
        return this.getInt(SIZE);
    }

    public int getPage() {
        return this.getInt(PAGE);
    }

    public int getPageSize() {
        return this.getInt(PAGESIZE);
    }

    public int getAddress() {
        return this.getInt(ADDRESS);
    }

    public String getKey() {
        return this.getAttribute(KEY);
    }

    public String getFacet() {
        return this.getAttribute(FACET);
    }

    public Encoding getEncoding() {
        String enc = this.getAttribute(ENCODING);
        return Encoding.forString(enc);
    }

    public int getChildrenSize() {
        return this.getInt(NUMCHILDREN);
    }

    public List<Property> getChildren() {
        List<Node> nodes = this.getChildren(PROPERTY);
        ArrayList<Property> result = new ArrayList<Property>(nodes.size());
        for (Node node : nodes) {
            result.add(new Property(node));
        }
        return result;
    }

    public byte[] getValue() throws UnsufficientValueException {
        String value = DbgpMessage.getNodeValue(this.getNode());
        byte[] result = null;
        if (value == null) {
            result = new byte[]{};
        } else {
            Encoding enc = this.getEncoding();
            if (Encoding.NONE.equals((Object)enc) || enc == null) {
                try {
                    result = value.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    assert (false);
                    result = new byte[]{};
                }
            }
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                result = decoder.decodeBuffer(value);
            }
            catch (IOException e) {
                result = new byte[]{};
            }
        }
        return this.getValue(result);
    }

    public String getStringValue() throws UnsufficientValueException {
        Encoding enc = this.getEncoding();
        if (Encoding.BASE64.equals((Object)enc)) {
            return new String(this.getValue());
        }
        String result = DbgpMessage.getNodeValue(this.getNode());
        try {
            if (result != null && result.getBytes("ISO-8859-1").length < this.getSize()) {
                throw new UnsufficientValueException();
            }
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return "";
        }
        return result;
    }

    public static boolean equals(Property one, Property two) {
        byte[] secondValue;
        byte[] value;
        if (one == null) {
            return two == null;
        }
        try {
            value = one.getValue();
        }
        catch (UnsufficientValueException e) {
            return false;
        }
        if (two == null) {
            return false;
        }
        try {
            secondValue = two.getValue();
        }
        catch (UnsufficientValueException e) {
            return false;
        }
        return Arrays.equals(value, secondValue);
    }

    private byte[] getValue(byte[] bytes) throws UnsufficientValueException {
        if (bytes.length >= this.getSize()) {
            return bytes;
        }
        throw new UnsufficientValueException();
    }

    public static enum Encoding {
        BASE64,
        NONE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        static Encoding forString(String str) {
            Encoding[] encodings;
            for (Encoding encoding : encodings = Encoding.values()) {
                if (!encoding.toString().equals(str)) continue;
                return encoding;
            }
            return null;
        }
    }
}

