/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class JPDAObjectWatchImpl
extends AbstractObjectVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, Value value) {
        super(jPDADebuggerImpl, value, "" + watch + (value instanceof ObjectReference ? "^" : ""));
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, String string) {
        super(jPDADebuggerImpl, null, "" + watch);
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.exceptionDescription = string;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String string) {
        this.watch.setExpression(string);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block26: {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrameImpl == null) {
                throw new InvalidExpressionException("No curent frame.");
            }
            try {
                Object object;
                try {
                    object = callStackFrameImpl.getLocalVariable(this.getExpression());
                    if (object != null) {
                        if (object instanceof Local) {
                            ((Local)object).setValue(value);
                        } else {
                            ((ObjectLocalVariable)object).setValue(value);
                        }
                        return;
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                object = LocationWrapper.declaringType(StackFrameWrapper.location(callStackFrameImpl.getStackFrame()));
                Field field = ReferenceTypeWrapper.fieldByName((ReferenceType)object, this.getExpression());
                if (field == null) {
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                if (TypeComponentWrapper.isStatic(field)) {
                    if (object instanceof ClassType) {
                        try {
                            ClassTypeWrapper.setValue((ClassType)object, field, value);
                            break block26;
                        }
                        catch (InvalidTypeException invalidTypeException) {
                            throw new InvalidExpressionException((Throwable)invalidTypeException);
                        }
                        catch (ClassNotLoadedException classNotLoadedException) {
                            throw new InvalidExpressionException((Throwable)classNotLoadedException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new InvalidExpressionException((Throwable)illegalArgumentException);
                        }
                    }
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                ObjectReference objectReference = StackFrameWrapper.thisObject(callStackFrameImpl.getStackFrame());
                if (objectReference == null) {
                    throw new InvalidExpressionException("no instance context.");
                }
                try {
                    ObjectReferenceWrapper.setValue(objectReference, field, value);
                }
                catch (IllegalArgumentExceptionWrapper illegalArgumentExceptionWrapper) {
                    throw new InvalidExpressionException((Throwable)illegalArgumentExceptionWrapper.getCause());
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new InvalidExpressionException((Throwable)invalidTypeException);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new InvalidExpressionException((Throwable)classNotLoadedException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidExpressionException((Throwable)illegalArgumentException);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
            }
            catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
                throw new InvalidExpressionException((Throwable)invalidStackFrameExceptionWrapper);
            }
        }
    }

    @Override
    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.exceptionDescription = null;
    }

    void setException(String string) {
        super.setInnerValue(null);
        this.exceptionDescription = string;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    @Override
    public JPDAObjectWatchImpl clone() {
        JPDAObjectWatchImpl jPDAObjectWatchImpl = this.exceptionDescription == null ? new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.getJDIValue()) : new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.exceptionDescription);
        return jPDAObjectWatchImpl;
    }
}

