/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.spi.CommentHandler;
import org.openide.util.Exceptions;

public class ToggleBlockCommentAction
extends ExtKit.ToggleCommentAction {
    static final long serialVersionUID = -1L;
    private final CommentHandler commentHandler;
    private final int COMMENT_START_LENGTH;
    private final int COMMENT_END_LENGTH;

    public ToggleBlockCommentAction(CommentHandler commentHandler) {
        super("");
        this.COMMENT_START_LENGTH = commentHandler.getCommentStartDelimiter().length();
        this.COMMENT_END_LENGTH = commentHandler.getCommentEndDelimiter().length();
        this.commentHandler = commentHandler;
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Caret caret = target.getCaret();
            final BaseDocument doc = (BaseDocument)target.getDocument();
            int from = Utilities.isSelectionShowing((Caret)caret) ? target.getSelectionStart() : caret.getDot();
            int to = Utilities.isSelectionShowing((Caret)caret) ? target.getSelectionEnd() : caret.getDot();
            boolean lineSelection = false;
            if (from == to && !this.isInComment((Document)doc, from)) {
                try {
                    if (Utilities.isRowEmpty((BaseDocument)doc, (int)from)) {
                        return;
                    }
                    from = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)Utilities.getRowStart((BaseDocument)doc, (int)from));
                    to = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)Utilities.getRowEnd((BaseDocument)doc, (int)to)) + 1;
                    lineSelection = true;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            final int[] comments = this.commentHandler.getCommentBlocks((Document)doc, from, to);
            assert (comments != null);
            this.check(comments, from, to);
            final int _from = from;
            final int _to = to;
            final boolean _lineSelection = lineSelection;
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int[] commentRange = ToggleBlockCommentAction.this.getCommentRange(comments, _from);
                        if (commentRange == null) {
                            ToggleBlockCommentAction.this.comment(target, doc, comments, _from, _to, _lineSelection);
                        } else if (comments.length > 0) {
                            ToggleBlockCommentAction.this.uncomment(target, doc, comments, _from, _to, _lineSelection);
                        }
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
    }

    private void comment(JTextComponent target, BaseDocument doc, int[] comments, int from, int to, boolean lineSelection) throws BadLocationException {
        int diff = 0;
        diff += this.insert((Document)doc, from, this.commentHandler.getCommentStartDelimiter());
        for (int i = 0; i < comments.length; i += 2) {
            int commentStart = comments[i];
            int commentEnd = comments[i + 1];
            diff += this.remove((Document)doc, commentStart + diff, this.COMMENT_START_LENGTH);
            if (commentEnd > to) continue;
            diff += this.remove((Document)doc, commentEnd + diff - this.COMMENT_END_LENGTH, this.COMMENT_END_LENGTH);
        }
        if (comments.length == 0 || comments[comments.length - 1] <= to) {
            diff += this.insert((Document)doc, to + diff, this.commentHandler.getCommentEndDelimiter());
        }
        if (!lineSelection) {
            target.setSelectionStart(from);
            target.setSelectionEnd(to + diff);
        }
    }

    private void uncomment(JTextComponent target, BaseDocument doc, int[] comments, int from, int to, boolean lineSelection) throws BadLocationException {
        int diff = 0;
        if (from == to) {
            assert (comments.length == 2);
            from = comments[0];
            to = comments[1];
            lineSelection = true;
        }
        if (comments[0] < from) {
            diff += this.insert((Document)doc, from, this.commentHandler.getCommentEndDelimiter());
        }
        int selectionStart = from + diff;
        for (int i = 0; i < comments.length; i += 2) {
            int commentStart = comments[i];
            int commentEnd = comments[i + 1];
            if (commentStart >= from) {
                diff += this.remove((Document)doc, commentStart + diff, this.COMMENT_START_LENGTH);
            }
            if (commentEnd > to) continue;
            diff += this.remove((Document)doc, commentEnd + diff - this.COMMENT_END_LENGTH, this.COMMENT_END_LENGTH);
        }
        int selectionEnd = to + diff;
        if (comments[comments.length - 1] > to) {
            diff += this.insert((Document)doc, to + diff, this.commentHandler.getCommentStartDelimiter());
        }
        if (!lineSelection) {
            target.setSelectionStart(selectionStart);
            target.setSelectionEnd(selectionEnd);
        }
    }

    private int insert(Document doc, int offset, String text) throws BadLocationException {
        doc.insertString(offset, text, null);
        return text.length();
    }

    private int remove(Document doc, int offset, int length) throws BadLocationException {
        doc.remove(offset, length);
        return -length;
    }

    private int[] getCommentRange(int[] comments, int offset) {
        for (int i = 0; i < comments.length; ++i) {
            int from = comments[i];
            int to = comments[++i];
            if (from > offset || to <= offset) continue;
            return new int[]{from, to};
        }
        return null;
    }

    private boolean isInComment(Document doc, int offset) {
        CharSequence text = DocumentUtilities.getText((Document)doc);
        int lastCommentStartIndex = CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)this.commentHandler.getCommentStartDelimiter(), (int)offset);
        int lastCommentEndIndex = CharSequenceUtilities.lastIndexOf((CharSequence)text, (CharSequence)this.commentHandler.getCommentEndDelimiter(), (int)offset);
        return lastCommentStartIndex > -1 && (lastCommentStartIndex > lastCommentEndIndex || lastCommentEndIndex == -1);
    }

    private void debug(Document doc, int[] comments, int start, int end) {
        System.out.println("TOGGLE_COMENT [" + start + "-" + end + "]");
        for (int i = 0; i < comments.length; ++i) {
            try {
                int from = comments[i];
                int to = comments[++i];
                if (from <= start && to > end) {
                    System.out.print("*");
                }
                System.out.print("[" + from + " - " + to + "]");
                System.out.println(doc.getText(from, to - from));
                continue;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        System.out.println("----------------");
    }

    private void check(int[] comments, int from, int to) {
        if (comments.length % 2 != 0) {
            throw new IllegalArgumentException("Comments array size must be even, e.g. contain just pairs.");
        }
        for (int i = 0; i < comments.length; ++i) {
            int cfrom = comments[i];
            int cto = comments[++i];
            if ((cfrom >= from || cto >= from) && (cto <= to || cfrom <= to)) continue;
            throw new IllegalArgumentException("Comment [" + cfrom + " - " + cto + " is out of the range [" + from + " - " + to + "]!");
        }
    }
}

