/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.language.ClassnameCompletionItem;
import org.netbeans.modules.profiler.oql.language.FunctionCompletionItem;
import org.netbeans.modules.profiler.oql.language.KeywordCompletionItem;
import org.netbeans.modules.profiler.oql.language.OQLTokenId;
import org.netbeans.modules.profiler.oql.language.PackageCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class OQLCompletionProvider
implements CompletionProvider {
    private final Set<String> keywords = new HashSet<String>();
    private final Set<String> functions = new HashSet<String>();
    private final Set<String> heapMethods = new HashSet<String>();

    public OQLCompletionProvider() {
        this.keywords.add("select");
        this.keywords.add("from");
        this.functions.add("map");
        this.functions.add("filter");
        this.functions.add("sort");
        this.functions.add("top");
        this.functions.add("classof");
        this.functions.add("forEachReferrer");
        this.functions.add("identical");
        this.functions.add("objectid");
        this.functions.add("reachables");
        this.functions.add("referrers");
        this.functions.add("referees");
        this.functions.add("refers");
        this.functions.add("root");
        this.functions.add("sizeof");
        this.functions.add("rsizeof");
        this.functions.add("toHtml");
        this.functions.add("concat");
        this.functions.add("contains");
        this.functions.add("count");
        this.functions.add("filter");
        this.functions.add("length");
        this.functions.add("map");
        this.functions.add("max");
        this.functions.add("min");
        this.functions.add("sort");
        this.functions.add("top");
        this.functions.add("sum");
        this.functions.add("toArray");
        this.functions.add("unique");
        this.heapMethods.add("objects");
        this.heapMethods.add("classes");
        this.heapMethods.add("forEachClass");
        this.heapMethods.add("forEachObject");
        this.heapMethods.add("findClass");
        this.heapMethods.add("findObject");
        this.heapMethods.add("finalizables");
        this.heapMethods.add("livepaths");
        this.heapMethods.add("roots");
    }

    public CompletionTask createTask(int queryType, final JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        final Document document = component.getDocument();
        final TokenHierarchy th = TokenHierarchy.get((Document)document);
        AsyncCompletionQuery query = new AsyncCompletionQuery(){

            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                TokenSequence ts = th.tokenSequence();
                Token currentToken = OQLCompletionProvider.this.findCurrentToken(component, (TokenSequence<OQLTokenId>)ts);
                if (currentToken == null) {
                    resultSet.finish();
                    return;
                }
                String tokentext = currentToken.toString();
                block0 : switch ((OQLTokenId)currentToken.id()) {
                    case UNKNOWN: {
                        if (!"instanceof".startsWith(tokentext.trim())) break;
                        resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "instanceof", ts.offset() + tokentext.trim().length(), tokentext.length()));
                        break;
                    }
                    case SELECT: {
                        resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "select", ts.offset() + tokentext.length(), tokentext.trim().length()));
                        break;
                    }
                    case FROM: {
                        resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "from", ts.offset() + tokentext.length(), tokentext.trim().length()));
                        break;
                    }
                    case INSTANCEOF: {
                        resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "instanceof", ts.offset() + tokentext.length()));
                        break;
                    }
                    case WHERE: {
                        resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "where", ts.offset() + tokentext.length(), tokentext.trim().length()));
                        break;
                    }
                    case ERROR: {
                        for (String keyword : OQLCompletionProvider.this.keywords) {
                            if (tokentext.trim().length() != 0 && !keyword.startsWith(tokentext.trim())) continue;
                            KeywordCompletionItem kci = new KeywordCompletionItem("00", keyword, ts.offset() + tokentext.trim().length(), tokentext.trim().length());
                            resultSet.addItem((CompletionItem)kci);
                        }
                        break;
                    }
                    case JSBLOCK: {
                        boolean isHeap = false;
                        int backout = 0;
                        if (ts.movePrevious()) {
                            ++backout;
                        }
                        if (ts.movePrevious()) {
                            ++backout;
                        }
                        isHeap = ts.token().toString().trim().toLowerCase().equals("heap");
                        for (int i = backout; i > 0; --i) {
                            ts.moveNext();
                        }
                        int wsPosDiff = tokentext.indexOf(tokentext.trim());
                        for (String function : OQLCompletionProvider.this.functions) {
                            if (tokentext.trim().length() != 0 && !function.startsWith(tokentext.trim())) continue;
                            resultSet.addItem((CompletionItem)new FunctionCompletionItem("00", function, ts.offset() + tokentext.trim().length() + wsPosDiff, tokentext.trim().length()));
                        }
                        if ("heap".startsWith(tokentext.trim())) {
                            resultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "heap", ts.offset() + tokentext.trim().length(), tokentext.trim().length()));
                        }
                        if (isHeap) {
                            tokentext = currentToken.toString().trim();
                            for (String method : OQLCompletionProvider.this.heapMethods) {
                                if (tokentext.length() != 0 && !method.startsWith(tokentext)) continue;
                                resultSet.addItem((CompletionItem)new FunctionCompletionItem("00", method, ts.offset() + tokentext.trim().length(), tokentext.trim().length()));
                            }
                        }
                        if (tokentext.trim().isEmpty()) {
                            resultSet.addItem((CompletionItem)new KeywordCompletionItem("01", "from", ts.offset() + tokentext.length(), tokentext.trim().length()));
                            break;
                        }
                        StringTokenizer t = new StringTokenizer(tokentext, " ");
                        while (t.hasMoreTokens()) {
                            String tt = t.nextToken();
                            if (!"FROM".startsWith(tt.trim().toUpperCase())) continue;
                            int pos = tokentext.indexOf(tt);
                            int wsPos = tokentext.indexOf(" ", pos);
                            if (tt.trim().length() == 3) {
                                ++pos;
                            }
                            resultSet.addItem((CompletionItem)new KeywordCompletionItem("01", "from", ts.offset() + pos + (wsPos > -1 ? 1 : 2), tt.trim().length()));
                            break block0;
                        }
                        break;
                    }
                    case DOT: {
                        ts.movePrevious();
                        if (!ts.token().toString().trim().toLowerCase().equals("heap")) break;
                        ts.moveNext();
                        for (String method : OQLCompletionProvider.this.heapMethods) {
                            resultSet.addItem((CompletionItem)new FunctionCompletionItem("00", method, ts.offset() + 1));
                        }
                        break;
                    }
                    case CLAZZ_E: 
                    case CLAZZ: {
                        String[] sig;
                        String className;
                        OQLEngine e = (OQLEngine)document.getProperty(OQLEngine.class);
                        String regex = ".*?" + tokentext.replace("[", "\\[").replace("]", "\\]").replace("$", "\\$") + ".*";
                        String camel = null;
                        if (tokentext.trim().equals(tokentext.trim().toUpperCase())) {
                            String trimmed = tokentext.trim();
                            StringBuilder sb = new StringBuilder(".*?");
                            for (int i = 0; i < trimmed.length(); ++i) {
                                if (trimmed.charAt(i) < 'A' || trimmed.charAt(i) > 'Z') {
                                    sb = null;
                                    break;
                                }
                                sb.append(trimmed.charAt(i));
                                sb.append("[a-z]*?");
                            }
                            if (sb != null) {
                                sb.append(".*");
                                camel = sb.toString();
                            }
                        }
                        String regexBody = tokentext.replace("[", "\\[").replace("]", "\\]").replace("$", "\\$");
                        String prefix = "^" + regexBody + ".*";
                        HashSet<String> pkgCompletions = new HashSet<String>();
                        HashSet<String> completions = new HashSet<String>();
                        Iterator clzs = e.getHeap().getJavaClassesByRegExp(regex).iterator();
                        while (clzs.hasNext()) {
                            className = ((JavaClass)clzs.next()).getName();
                            sig = OQLCompletionProvider.splitClassName(className);
                            if (sig[1].startsWith(tokentext)) {
                                completions.add("00 " + className);
                                continue;
                            }
                            if (!sig[1].contains(tokentext)) continue;
                            completions.add("01 " + className);
                        }
                        clzs = e.getHeap().getJavaClassesByRegExp(prefix).iterator();
                        while (clzs.hasNext()) {
                            className = ((JavaClass)clzs.next()).getName();
                            sig = OQLCompletionProvider.splitClassName(className);
                            if (sig[0].length() > tokentext.trim().length() && sig[0].startsWith(tokentext.trim())) {
                                int pkgSepPos = sig[0].indexOf(46, tokentext.trim().length() + 1);
                                if (pkgSepPos == -1) {
                                    pkgCompletions.add(sig[0]);
                                } else {
                                    pkgCompletions.add(sig[0].substring(0, pkgSepPos));
                                }
                            }
                            if (sig[0].indexOf(".", tokentext.trim().length() - 1) != -1) continue;
                            completions.add("01 " + className);
                        }
                        if (camel != null) {
                            clzs = e.getHeap().getJavaClassesByRegExp(camel).iterator();
                            while (clzs.hasNext()) {
                                className = ((JavaClass)clzs.next()).getName();
                                completions.add("02 " + className);
                            }
                        }
                        HashSet<String> usedTypeNames = new HashSet<String>();
                        for (String completion : completions) {
                            StringTokenizer tok = new StringTokenizer(completion);
                            String sortPre = tok.nextToken();
                            String clzName = tok.nextToken();
                            if (usedTypeNames.contains(clzName)) continue;
                            resultSet.addItem((CompletionItem)new ClassnameCompletionItem(sortPre, clzName, ts.offset(), tokentext.length()));
                            usedTypeNames.add(clzName);
                        }
                        for (String completion : pkgCompletions) {
                            if (usedTypeNames.contains(completion)) continue;
                            resultSet.addItem((CompletionItem)new PackageCompletionItem(completion, ts.offset(), tokentext.length()));
                        }
                        break;
                    }
                }
                resultSet.finish();
            }
        };
        return query != null ? new AsyncCompletionTask(query) : null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        if (typedText.endsWith(".")) {
            return 1;
        }
        return 9;
    }

    private Token<OQLTokenId> findCurrentToken(JTextComponent component, TokenSequence<OQLTokenId> ts) {
        Token currentToken = null;
        ts.moveStart();
        int forPosition = component.getCaretPosition();
        int position = 0;
        while (ts.moveNext()) {
            position = ts.offset();
            if (position >= forPosition) {
                ts.movePrevious();
                break;
            }
            currentToken = ts.token();
        }
        return currentToken;
    }

    private static String[] splitClassName(String className) {
        String typeName;
        String pkgName;
        int pkgPos = className.lastIndexOf(46);
        if (pkgPos > -1) {
            pkgName = className.substring(0, pkgPos);
            typeName = className.substring(pkgPos + 1);
        } else {
            pkgName = "";
            typeName = className;
        }
        return new String[]{pkgName, typeName};
    }
}

