/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.util.NbBundle;

public class BinaryToStringConverter {
    public static final int BINARY = 2;
    public static final int DECIMAL = 10;
    public static final int HEX = 16;
    public static final int OCTAL = 8;
    static ConversionConstants decimal = new ConversionConstants(3, 10);
    static ConversionConstants hex = new ConversionConstants(2, 16);
    private static ConversionConstants binary = new ConversionConstants(8, 2);
    private static ConversionConstants octal = new ConversionConstants(3, 8);
    private static String printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/? ";

    public static String convertToString(Byte[] data, int base, boolean showAscii) {
        if (data == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(20);
        ConversionConstants convConst = BinaryToStringConverter.getConstants(base);
        for (int i = 0; i < data.length; ++i) {
            int value = data[i].byteValue();
            String s = null;
            if (showAscii && printable.indexOf((char)value) > -1) {
                s = new Character((char)value) + "          ".substring(10 - (convConst.width - 1));
            }
            if (s == null) {
                switch (base) {
                    case 10: {
                        if (value < 0) {
                            value = 256 + value;
                        }
                        s = Integer.toString(value);
                        break;
                    }
                    case 8: {
                        s = Integer.toOctalString(value);
                        break;
                    }
                    case 2: {
                        s = Integer.toBinaryString(value);
                        break;
                    }
                    default: {
                        s = Integer.toHexString(value);
                    }
                }
                if (s.length() > convConst.width) {
                    s = s.substring(s.length() - convConst.width);
                }
                if (s.length() < convConst.width) {
                    buf.append("00000000".substring(8 - (convConst.width - s.length())));
                }
            }
            buf.append(showAscii ? s.trim() : s);
        }
        return buf.toString();
    }

    private static ConversionConstants getConstants(int base) {
        switch (base) {
            case 10: {
                return decimal;
            }
            case 8: {
                return octal;
            }
            case 2: {
                return binary;
            }
        }
        return hex;
    }

    public static byte[] convertBitStringToBytes(String s) throws DBException {
        int shtBits = s.length() % 8;
        s = shtBits > 0 ? "00000000".substring(0, 8 - shtBits) + s : s;
        byte[] buf = new byte[s.length() / 8];
        int bit = 0;
        int index = 0;
        for (int i = 0; i < s.length(); ++i) {
            if ('1' == s.charAt(i)) {
                int b = 1 << 7 - bit;
                int n = index;
                buf[n] = (byte)(buf[n] | b);
            } else if ('0' != s.charAt(i)) {
                throw new DBException(NbBundle.getMessage(BinaryToStringConverter.class, (String)"BinaryToStringConverter_InvalidBitFormat", (Object)Character.valueOf(s.charAt(i)), (Object)i));
            }
            if (++bit <= 7) continue;
            bit = 0;
            ++index;
        }
        return buf;
    }

    private BinaryToStringConverter() {
    }

    static class ConversionConstants {
        int radix;
        int width;

        ConversionConstants(int w, int r) {
            this.width = w;
            this.radix = r;
        }
    }
}

