/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment media rendering library
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Guillaume Emont <guillaume@fluendo.com>
 */

#ifndef __PGM_MODULE_H__
#define __PGM_MODULE_H__

typedef struct _PgmModule      PgmModule;
typedef struct _PgmModuleClass PgmModuleClass;

#include <gmodule.h>
#include <glib-object.h>
#include "pgmplugin.h"

G_BEGIN_DECLS

#define PGM_TYPE_MODULE (pgm_module_get_type ())
#define PGM_MODULE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_MODULE, PgmModule))
#define PGM_MODULE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_MODULE, PgmModuleClass))
#define PGM_IS_MODULE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_MODULE))
#define PGM_IS_MODULE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_MODULE))
#define PGM_MODULE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_MODULE, PgmModuleClass))

struct _PgmModule {
  GTypeModule parent;

  /* All access to this must be made between a call to g_type_module_use() and
   * g_type_module_unuse() on the considered PgmModule */
  PgmPluginDesc *plugin_desc;

  gchar   *name;
  GModule *handle;
};

struct _PgmModuleClass {
  GTypeModuleClass parent_class;
};

GType      pgm_module_get_type (void);

PgmModule *pgm_module_new      (const gchar *name);

G_END_DECLS

#endif /* __PGM_MODULE_H__ */
