#!/usr/bin/env python
'''This runs "ls -l" on a remote host using SSH.
    At the prompts enter hostname, user, and password.
'''
import pexpect
import getpass

def ssh_command (user, host, password, command):
    """This runs a command on the remote host. This returns a
    pexpect.spawn object. This handles the case when you try
    to connect to a new host and ssh asks you if you want to
    accept the public key fingerprint and continue connecting.
    """
    ssh_newkey = 'Are you sure you want to continue connecting'
    child = pexpect.spawn('ssh -l %s %s %s'%(user, host, command))
    i = child.expect([pexpect.TIMEOUT, ssh_newkey, 'password: '])
    if i == 0: # Timeout
        print 'ERROR!'
        print 'SSH could not login. Here is what SSH said:'
        print child.before, child.after
        return None
    if i == 1: # SSH does not have the public key. Just accept it.
        child.sendline ('yes')
        child.expect ('password: ')
        i = child.expect([pexpect.TIMEOUT, 'password: '])
        if i == 0: # Timeout
            print 'ERROR!'
            print 'SSH could not login. Here is what SSH said:'
            print child.before, child.after
            return None       
    child.sendline(password)
    return child

host = raw_input('Hostname: ')
user = raw_input('User: ')
password = getpass.getpass('Password: ')

child = ssh_command (user, host, password, '/bin/ls -l')
child.expect(pexpect.EOF)
print child.before

