/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pencil.commands;

import de.tu_darmstadt.sp.paul.PDFNumber;
import de.tu_darmstadt.sp.paul.PDFReal;
import de.tu_darmstadt.sp.pencil.PageCommand;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;

public abstract class RGBCmd
extends PageCommand {
    Color argument;

    public RGBCmd(float a, float b, float c) {
        this.argument = new Color(a, b, c);
    }

    public RGBCmd(PDFNumber a, PDFNumber b, PDFNumber c) {
        this.argument = new Color((float)a.value(), (float)b.value(), (float)c.value());
    }

    public RGBCmd(Color a) {
        this.argument = a;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RGBCmd)) {
            return false;
        }
        RGBCmd other = (RGBCmd)obj;
        if (this == other) {
            return true;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.argument.equals(other.argument);
    }

    public Color getArgument() {
        return this.argument;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        if (this.argument != null) {
            result += this.argument.hashCode();
        }
        return result;
    }

    public void write(Writer wr) throws IOException {
        PDFReal red = new PDFReal((double)this.argument.getRed() / 255.0);
        PDFReal blue = new PDFReal((double)this.argument.getBlue() / 255.0);
        PDFReal green = new PDFReal((double)this.argument.getGreen() / 255.0);
        red.write(wr);
        wr.write(" ");
        green.write(wr);
        wr.write(" ");
        blue.write(wr);
        wr.write(" ");
        super.write(wr);
    }
}

