/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure.node;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.structure.node.FancyNode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class ImageNode
extends FancyNode {
    private Image image;

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D graphic = (Graphics2D)g;
        Morcego o = Morcego.getApplication();
        g.drawImage(this.image, this.boundRectangle.x, this.boundRectangle.y, this.image.getWidth(o) * this.nodeSize / Config.getInteger("morcego.nodeSize"), this.image.getHeight(o) * this.nodeSize / Config.getInteger("morcego.nodeSize"), this);
        this.boundRectangle = new Rectangle(this.boundRectangle.x, this.boundRectangle.y, this.image.getWidth(o), this.image.getHeight(o));
        AffineTransform at = new AffineTransform(40.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f);
        FontRenderContext frc = new FontRenderContext(at, false, false);
        int interval = Config.getInteger("morcego.fontSizeInterval");
        Font font = new Font(null, 0, this.textSize / interval * interval);
        TextLayout l = new TextLayout((String)this.getProperty("title"), font, frc);
        Rectangle2D textBounds = l.getBounds();
        l.draw(graphic, (int)((double)this.getBody().projection.x - textBounds.getWidth() / 2.0), this.boundRectangle.y);
    }

    public void init() {
        super.init();
        if (this.getProperty("image") == null) {
            this.setProperty("image", Config.getString("morcego.nodeDefaultImage"));
        }
        String imgLocation = (String)this.getProperty("image");
        Pattern urlPattern = Pattern.compile("^http://");
        if (urlPattern.matcher(imgLocation).find()) {
            try {
                URL location = new URL(imgLocation);
                this.image = Toolkit.getDefaultToolkit().getImage(location);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            imgLocation = Config.getString(Config._imageLocation).concat(imgLocation);
            URL location = this.getClass().getClassLoader().getResource(imgLocation);
            this.image = Toolkit.getDefaultToolkit().getImage(location);
        }
    }
}

