/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.tomcat.dbcp.dbcp.cpdsadapter.PooledConnectionImpl;

class ConnectionImpl
implements Connection {
    private static final String CLOSED = "Attempted to use Connection after closed() was called.";
    private Connection connection;
    private PooledConnectionImpl pooledConnection;
    boolean isClosed;

    ConnectionImpl(PooledConnectionImpl pooledConnection, Connection connection) {
        this.pooledConnection = pooledConnection;
        this.connection = connection;
        this.isClosed = false;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            throw new SQLException("A ConnectionImpl was finalized without being closed which will cause leakage of  PooledConnections from the ConnectionPool.");
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    public void clearWarnings() throws SQLException {
        this.assertOpen();
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.assertOpen();
        this.isClosed = true;
        this.pooledConnection.notifyListeners();
    }

    public void commit() throws SQLException {
        this.assertOpen();
        this.connection.commit();
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        return this.connection.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertOpen();
        return this.connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.assertOpen();
        return this.connection.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertOpen();
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpen();
        return this.connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertOpen();
        return this.connection.getWarnings();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        this.assertOpen();
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.assertOpen();
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public void rollback() throws SQLException {
        this.assertOpen();
        this.connection.rollback();
    }

    public void setAutoCommit(boolean b) throws SQLException {
        this.assertOpen();
        this.connection.setAutoCommit(b);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.assertOpen();
        this.connection.setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpen();
        this.connection.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpen();
        this.connection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpen();
        this.connection.setTypeMap(map);
    }

    public int getHoldability() throws SQLException {
        this.assertOpen();
        return this.connection.getHoldability();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.assertOpen();
        this.connection.setHoldability(holdability);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, columnNames);
    }
}

