/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.webapp.balancer.RuleChain;
import org.apache.webapp.balancer.RulesParser;

public class BalancerFilter
implements Filter {
    private RuleChain ruleChain;
    private ServletContext context;

    protected RuleChain getRuleChain() {
        return this.ruleChain;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        String configUrlParam = filterConfig.getInitParameter("configUrl");
        if (configUrlParam == null) {
            throw new ServletException("configUrl is required.");
        }
        try {
            InputStream input = this.context.getResourceAsStream(configUrlParam);
            RulesParser parser = new RulesParser(input);
            this.ruleChain = parser.getResult();
            this.context.log(this.getClass().getName() + ": init(): ruleChain: " + this.ruleChain);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response.isCommitted()) {
            this.context.log(this.getClass().getName() + ": doFilter(): not inspecting committed response.");
            chain.doFilter(request, response);
        } else if (!(request instanceof HttpServletRequest)) {
            this.context.log(this.getClass().getName() + ": doFilter(): not inspecting non-Http request.");
            chain.doFilter(request, response);
        } else {
            HttpServletRequest hreq = (HttpServletRequest)request;
            HttpServletResponse hres = (HttpServletResponse)response;
            URL redirectUrl = this.getRuleChain().evaluate(hreq);
            if (redirectUrl != null) {
                String encoded = hres.encodeRedirectURL(redirectUrl.toString());
                this.context.log(this.getClass().getName() + ": doFilter(): redirecting request for " + hreq.getRequestURL().toString() + " to " + encoded);
                hres.sendRedirect(encoded);
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
        this.context = null;
        this.ruleChain = null;
    }
}

