[Contents]
Разделы помощи:

  ОПИСАНИЕDESCRIPTION
  КЛЮЧИOPTIONS
  Главное окно программыOverview
  Поддержка мышиMouse Support

  Клавиатурные командыKeys
    Переопределение клавиатурных командKeys_redefine
    Разные командыMiscellaneous Keys
    Панели каталоговDirectory Panels
    Командная строка оболочкиShell Command Line
    Клавиши управления перемещениемGeneral Movement Keys
    Редактирование строк вводаInput Line Keys
  Главное меню программы Midnight CommanderMenu Bar
    Меню левой и правой панелей ('Левая' и 'Правая')Left and Right Menus
      Формат списка...Listing Mode...
      Порядок сортировки...Sort Order...
      Фильтр...Filter...
      Перечитать (Reread)Reread
    ФайлFile Menu
      Быстрая смена каталога (Quick cd)Quick cd
    Меню 'Команды'Command Menu
      Дерево каталогов (Directory Tree)Directory Tree
      Поиск файлов (Find File)Find File
      Критерий панелизации (External panelize)External panelize
      Справочник каталогов (Hotlist)Hotlist
      Файл расширенийExtension File Edit
      Фоновые заданияBackground Jobs
      Редактирование файлов менюMenu File Edit
    Меню 'Настройки' ('Options')Options Menu
      КонфигурацияConfiguration
      Внешний видLayout
      ПодтвержденияConfirmation
      Биты символов...Display bits
      Распознавание клавиш...Learn keys
      Виртуальные файловые системыVirtual FS
      Сохранение установокSave Setup

  Выполнение команд операционной системыExecuting operating system commands
    Встроенная команда cdThe cd internal command
    МакроподстановкиMacro Substitution
    Поддержка subshellThe subshell support
  Права доступа (Chmod)Chmod
  Владелец/группа (Chown)Chown
  Расширенная команда ChownAdvanced Chown
  Операции с файламиFile Operations
  Маски файлов для операций копирования/переименованияMask Copy/Rename
  Select/Unselect FilesSelect/Unselect Files
  Встроенная программа просмотра файловInternal File Viewer
  Встроенный редакторInternal File Editor
  Опции в ини-файле для редактораInternal File Editor / options
  Завершение ввода (Completion)Completion
  Виртуальные файловые системыVirtual File System
    Файловая система ftpfs (FTP File System)FTP File System
    Файловая система tarTar File System
    Файловая система FISH (FIle transfer over SHell)FIle transfer over SHell filesystem
    Файловая система NFS (Network File System)Network File System
    Файловая система UFS (Undelete File System)Undelete File System
    Файловая система smbfsSMB File System
  ЦветаColors
  Внешний видSkins
    Описание секцийSkins sections
    Цветовые парыSkins colors
    Линии для отрисовки рамокSkins lines
    СовместимостьSkins oldcolors
  Подсветка имён файловFilenames Highlight
  Специальные установки (Special Settings)Special Settings
  Базы терминалов (Terminal databases)Terminal databases

  ФайлыFILES
  Обновление версийAVAILABILITY
  Другие источникиSEE ALSO
  АВТОРЫAUTHORS
  Недоработки (BUGS)BUGS
  Лицензия (оригинал на английском)Лицензия (оригинал на английском)
  ЛицензияЛицензия
  Диалоговые окна запросовQueryBox
  Как пользоваться помощьюHow to use help
[DESCRIPTION]
ОПИСАНИЕ

Что такое Midnight Commander

Midnight Commander - это программа, предназначенная для просмотра содержимого каталогов и выполнения основных функций управления файлами в UNIX-подобных операционных системах.[OPTIONS]
КЛЮЧИ

Ключи запуска программы Midnight Commander

-a      Отключить использование графических символов для рисования линий.

-b      Запуск программы в черно-белом режиме экрана.

-c      Включает цветной режим дисплея. Для получения более подробной информации смотрите раздел ЦветаColors.

-C arg  Используется для того, чтобы задать другой набор цветов в командной строке. Формат аргумента arg описан в разделе ЦветаColors.

-S arg  Используется для того, чтобы задать другой скин в командной строке. Технология скинов описана в разделе Внешний видSkins.

-d      Отключает поддержку мыши.

-D N    Используется только если код был скомпилирован с поддержкой виртуальной файловой системы smbfsSMB File System для установки уровня отладочных сообщений smbfs в N (0-10).

-e [файл]
        Запустить встроенный редактор. Если параметр файл задан, этот файл будет открыт при старте. Смотрите также mcedit(1).

-f      Выводит на экран определенный в процессе компиляции программы путь к файлам программы Midnight Commander.

-k      Восстанавливает значения команд, назначенных функциональным клавишам в предусмотренные по умолчанию значения, используя базу данных termcap/terminfo. Этот ключ используется только на терминалах HP, где функциональные клавиши не работают.

-K файл
        Задаёт файл клавиатурных команд для переопределения привязки хоткеев к действиям.

-l файл
        Сохранить диалог с ftp-сервером, а также отладочную информацию smbfs в файл file.

-P файл
        По окончании работы Midnight Commander запишет последний текущий каталог в указанный файл. Эту опцию не следует использовать напрямую. Она используется специальной функцией оболочки, которая меняет текущий каталог оболочки на последний каталог, использованный Midnight Commander.

        Для того чтобы эта функция была определена, используйте файл /usr/local/share/mc/bin/mc.sh для оболочек bash и zsh, а для оболочки tcsh соответственно файл /usr/local/share/mc/bin/mc.csh

-s      Включает медленный режим терминала, в котором программа выводит меньше псевдографических символов (в том числе в меню и экранах помощи) и отключается вывод дополнительных (избыточных) сообщений.

-t      Используется только в том случае, когда код был скомпилирован со Slang и terminfo: в этом случае Midnight Commander использует значение переменной TERMCAP для получения информации о терминале вместо использования системной базы терминалов.

-u      Отключает использование альтернативных оболочек shell (имеет смысл только в том случае, когда Midnight Commander был скомпилирован с поддержкой альтернативной оболочки).

-U      Делает возможным использование subshell (имеет смысл только в том случае, когда Midnight Commander был скомпилирован с поддержкой subshell как опции).

-v file Запустить встроенную программу просмотра Midnight Commander-а для просмотра указанного файла. После выхода из режима просмотра вы выходите из Midnight Commander и оказываетесь в shell.

-V      Отображает версию программы.

-x      Запускает программу в режиме xterm. Используется только на терминалах, работающих в режиме xterm (два режима работы экрана и возможность формировать экранирующие последовательности с помощью мыши) (two screen modes, and able to send mouse escape sequences).

Первое путевое имя (path name) в командной строке (если указано) задает каталог, который будет отображаться в активной панели; второй путь - каталог, отображаемый во второй панели.[Overview]
Главное окно программы

Главное окно программы Midnight Commander состоит из трех полей. Два поля, называемые "панелями", идентичны по структуре и обычно отображают перечни файлов и подкаталогов каких-то двух каталогов файловой структуры. Эти каталоги в общем случае различны, хотя, в частности, могут и совпасть. Каждая панель состоит из заголовка, списка файлов и информационной строки.

Третье поле экрана, расположенное в нижней части экрана, содержит командную строку текущей оболочки. В этом же поле (самая нижняя строка экрана) содержится подсказка по использованию функциональных клавиш F1 - F10. Самая верхняя строка экрана содержит строку горизонтального менюMenu Bar. Эта строка может не отображаться на экране; в этом случае доступ к ней можно получить, щелкнув мышью по верхней рамке или нажав клавишу F9.

Панели Midnight Commander обеспечивают просмотр одновременно двух каталогов. Одна из панелей является активной в том смысле, что пользователь может выполнять некоторые операции с отображаемыми в этой панели файлами и каталогами. В активной панели подсвечено имя одного из каталогов или файлов, а также выделен цветом заголовок панели в верхней строке. Этот заголовок совпадает с именем отображаемого в данной панели каталога, который является текущим каталогом той оболочки, из которой запущена программа. Вторая панель - пассивна. Почти все операции выполняются в активной панели, то есть в соответствующем (текущем) каталоге. Некоторые операции (типа копирования или переноса файлов) по умолчанию используют каталог, отображаемый в пассивной панели, как место назначения операции. Более подробное описание панелей дано в подразделе Панели каталоговDirectory Panels раздела Меню левой и правой панелейLeft and Right Menus и в разделе Меню "Файл"File Menu

Вы можете выполнить любую команду операционной системы или запустить на исполнение любую программу непосредственно из программы Midnight Commander, просто набрав имя этой команды (программы) в командной строке и нажав клавишу Enter. Прочитайте разделы Командная строка оболочкиShell Command Line и Редактирование строк вводаInput Line Keys для того, чтобы узнать больше о командной строке.[Mouse Support]
Поддержка мыши

Программа Midnight Commander обеспечивает поддержку мыши. Это свойство обеспечивается независимо от того, откуда запущен терминал xterm(1) (даже если xterm запущен на удаленном компьютере, используя соединение через telnet, ssh или rlogin) или если вы работаете за консолью Linux и запущена программа управления мышью gpm.

Если вы щелкаете мышью на имени файла в одной из панелей, файл выбирается (подсветка перемещается на это имя); если вы щелкнете правой кнопкой мыши, файл отмечается (или отметка с файла снимается, в зависимости от предыдущего состояния).

Двойной щелчок мыши на имени файла означает попытку запустить файл на исполнение (если это исполняемая программа); либо, если файл расширенийExtension File Edit содержит программу, ассоциированную с данным расширением, запускается эта программа и ей передается на обработку выбранный файл.

Точно также можно выполнить команду, ассоциированную с любой функциональной клавишей, щелкнув по соответствующей экранной кнопке в самой нижней строке экрана.

Если щелкнуть мышью по верхней рамке панели, отображающей очень длинный список файлов, происходит перемещение списка на одну колонку назад. Щелчок по нижней рамке панели приводит, соответственно, к перемещению по списку на целую колонку вперед. Этот метод перемещения работает также при просмотре встроенной подсказкиContents и просмотре окна Дерево каталоговDirectory Tree.

По умолчанию скорость эмуляции повторных нажатий на клавишу в случае ее удержания (auto repeat rate) составляет 400 миллисекунд. Это значение можно изменить путем изменения параметра mouse_repeat_rate в файле ~/.mc/iniSave Setup

Если Commander запущен с поддержкой мыши, вы можете обойти Commander и добиться того, что мышь будет вести себя так же, как она ведет себя по умолчанию (обеспечивая вырезание и вставку текста), если будете удерживать клавишу Shift.

[Keys]
Клавиатурные команды

Некоторые команды в Midnight Commander вызываются с использованием клавиш Control (иногда обозначается как CTRL или CTL) и Meta (иногда обозначается ALT или даже Compose). В настоящем руководстве будут использоваться следующие сокращения:

C-<символ> означает, что нужно нажать и удерживать клавишу Control и в это время нажать клавишу <символ>. Так C-f будет означать: нажмите Control и, удерживая ее, нажмите (коротким щелчком) клавишу f.

Аналогично M-<символ> означает, что надо удерживать в нажатом состоянии клавишу Meta или Alt во время удара по клавише <символ>. Если на клавиатуре нет клавиш Meta и Alt, нажмите ESC, отпустите ее, а потом щелкните по клавише <символ>.

S-<символ> означает, что нужно держать в нажатом состоянии клавишу Shift во время удара по клавише <символ>.

Все строки ввода в Midnight Commander по умолчанию поддерживают соглашения об использовании "горячих" клавиш, принятые в редакторе GNU Emacs.

Вы можете переопределить клавиатурные привязки хоткеев к командам, как это описано в разделе переопределение клавиатурных командKeys_redefine

Все последующие описания клавиатурных команд относятся к поведению по умолчанию.

Описания клавиатурных команд даются в нескольких разделах помощи. Наиболее важными являются следующие разделы:

В разделе Меню "Файл"File Menu приведены комбинации клавиш, которые служат для вызова команд, перечисленных в меню "Файл". В этом же разделе перечислены команды, ассоциированные с функциональными клавишами. Большинство из этих команд выполняют действия над подсвеченным файлом или группой отмеченных файлов.

В секции Панели каталоговDirectory Panels рассказано о клавишах, которые используются для выбора файла или группы файлов как объектов некоторого последующего действия (обычно действия из меню "Файл").

В разделе Командная строка оболочки (Shell)Shell Command Line перечисляются команды и комбинации клавиш, которые используются для ввода и редактирования команд в командной строке оболочки. Большая часть этих команд служит для переноса имен файлов и/или имен каталогов в командную строку (чтобы уменьшить трудоемкость ввода) или для доступа к истории команд.

Клавиши редактирования строк вводаInput Line Keys используются как при редактировании командной строки, так и других строк ввода, появляющихся в различных запросах программы.[Keys_redefine]
Переопределение клавиатурных команд

Клавиатурные команды могут быть прочитаны из внешнего файла. Поиск файла клавиатурных команд производится по следующему алгоритму (до первого нахождения файла):

        1) параметр командной строки -K <файл> или --keymap=<файл>
        2) Переменная окружения MC_KEYMAP
        3) В конфигурационном файле параметр keymap в секции [MidhightCommander]
        4) Файл ~/.mc/mc.keymap
        5) Файл /etc/mc/mc.keymap
        6) Файл /usr/local/share/mc/mc.keymap

Параметры в трёх первых случаях могут содержать абсолютный путь к файлу клавиатурных команд либо просто название схемы привязки (с расширением .keymap либо без него). В данном случае поиск файла клавиатурных команд будет происходить по следующим каталогам (до первого нахождения):

        1) ~/.mc/
        2) /etc/mc/
        3) /usr/local/share/mc/
[Miscellaneous Keys]
Разные команды

Имеется несколько действий, ассоциированных с некоторыми комбинациями клавиш, которые не попадают ни в одну из других категорий:

Enter. Если в командной строке (в нижней части экрана) набрано имя какой-либо команды, запускается соответствующая программа (если команды не существует, выдается соответствующее сообщение). Если в командной строке нет никакого текста, и если на активной панели подсвечено имя каталога, то Midnight Commander выполняет переход chdir(2) в выбранный каталог и отображает его содержимое в этой панели; если подсвечен исполняемый файл, то он запускается на выполнение. Наконец, если расширение подсвеченного в активной панели файла совпадает с одним из расширений, указанных в файле расширенийExtension File Edit, то выполняется команда, связанная с этим расширением.

C-l.    Обновляет всю информацию, отображаемую программой Midnight Commander.

C-x c.  Запускает команду ChmodChmod для подсвеченного файла или группы отмеченных файлов.

C-x o.  Запускает команду ChownChown для подсвеченного файла или группы отмеченных файлов.

C-x l.  Запускает команду создания жесткой ссылки.

C-x s.  Запускает команду создания символической ссылки.

C-x i.  Переводит пассивную панель в режим "Информация".

C-x q.  Переводит пассивную панель в режим быстрого просмотра.

C-x !.  Выполняется пункт меню "Критерий панелизации"External panelize.

C-x h   Добавить имя каталога в "Справочник каталогов"Hotlist.

M-!,    Выполняет пункт меню "Просмотр вывода команды", который описан подробнее в разделе "Меню "Файл"File Menu.

M-?,    Вызов диалогового окна "Поиск файла"Find File.

M-c,    Вызов диалогового окна "Быстрая смена каталога"Quick cd.

C-o,    Если Midnight Commander запущен в консоли Linux или FreeBSD, или через xterm, вам будет показан вывод предыдущей команды. При этом на Linux-консоли Midnight Commander использует встроенную программу (cons.saver) для сохранения выводимой информации и демонстрации ее на экране.

Если Midnight Commander скомпилирован с поддержкой подоболочки (subshell), вы можете в процессе выполнения приложения из-под Midnight Commander в любой момент набрать C-o и вернуться к главному экрану Midnight Commander-а. Для возврата к вашему приложению достаточно снова набрать C-o. Если вы застопорите выполнение приложения, использовав этот прием, вы не сможете запустить других программ из Midnight Commander пока отложенное приложение не закончит работу, либо пока вы не прервете его выполнение.[Directory Panels]
Панели каталогов

В настоящем разделе перечисляются команды, которые позволяют оперировать с содержимым панелей. Если вы хотите узнать, как изменить вид панели или способ представления информации на панели, смотрите раздел Меню левой и правой панелейLeft and Right Menus.

Tab, C-i. Сменить текущую (активную) панель. Подсветка перемещается с панели, которая была активной ранее, в другую панель, которая становится активной.

Insert, C-t Чтобы отметить файл, на который указывает в данный момент подсветка, используйте клавишу Insert (the kich1 terminfo sequence). Для снятия отметки с файла используются те же комбинации.

M-e. Чтобы поменять кодировку панели, используйте комбинацию M-e (Alt-e). Перекодировка производится из выбранной кодировки в системную. Для отмены перекодировки просто перейдите на каталог вверх '..'. Для отмены перекодировки всех каталогов выберите "Без перекодировки" в диалоге выбора кодировок.

M-g, M-r, M-j. Используются для перемещения подсветки, соответственно, на самый верхний, средний или нижний файл из числа отображаемых в данный момент на панели.

C-s, M-s. Инициирует режим поиска имен файлов в текущем каталоге по первым символам имени. После нажатия одной из этих комбинаций, вводимые символы отображаются не в командной строке, а в строке поиска. Если режим "Показ мини-статуса" включен, эта строка отображается на месте строки мини-статуса. В процессе ввода последующих символов линия подсветки перемещается к следующему файлу, название которого начинается с введенной строки символов. Клавиши backspace или DEL могут использоваться для исправления ошибок. Если C-s нажато снова, осуществляется поиск следующего подходящего файла.

M-t Циклически переключает режимы отображения списка файлов текущего каталога. С помощью этой комбинации клавиш можно быстро переключаться из режима стандартного вывода (long listing) к сокращенному или к режиму, определяемому пользователем.

C-\ (control-backslash). Показать Справочник каталоговHotlist и перейти к выбранному каталогу.

+ (plus). Эта клавиша используется для того, чтобы выбрать (отметить) группу файлов по регулярному выражению, задающему эту группу. Когда включена опция Только файлы, то выделены будут только файлы. Если опция Только файлы, отключена, то выделены будут как файлы, так и каталоги. Если включена опция Образцы в стиле shell (Shell Patterns), регулярные выражение строятся по тем же правилам, которые действуют в оболочке shell (* означает ноль или большее число любых символов, а ? заменяет один произвольный символ). Если опция Образцы в стиле shell (Shell Patterns) отключена, то пометка файлов производится по правилам обработки нормальных регулярных выражений (смотрите ed (1)). Если включена опция С учётом регистра то пометка файлов и каталогов будет производиться с учетом регистра символов имён. Если опция С учётом регистра отключена, то регистр символов учитываться не будет.

\ (backslash). Клавиша "\" снимает отметку с группы файлов, то есть производит действие, обратное тому, которое вызывается по клавише "+".

up-key, C-p. Перемещает подсветку на предыдущую позицию в списке файлов панели.

down-key, C-n. Перемещает подсветку на следующую позицию в списке файлов панели.

home, a1, M-<. Перемещает подсветку на первую позицию списка файлов.

end, c1, M->. Перемещает подсветку на последнюю позицию списка файлов.

next-page, C-v. Перемещает подсветку на одну страницу вниз.

prev-page, M-v. Перемещает подсветку на одну страницу вверх.

M-o. Если выделенным элементом активной панели является каталог, установить этот каталог текущим в неактивной панели и перейти к следующему файлу. Если выделенным элементом активной панели является не каталог, установить родительский каталог текущим в неактивной панели и также перейти к следующему файлу.

M-i. Сделать текущий каталог активной панели также текущим каталогом неактивной панели. Если необходимо, перевести неактивную панель в режим отображения списка файлов. Если активная панель находится в режиме панелизации, неактивная панель в этот режим не переводится.

C-PageUp, C-PageDown Только если mc запущен с консоли Linux: выполняется, соответственно, переход (chdir) к родительскому каталогу ("..") или к выделенному подсветкой каталогу.

M-y Перемещение к предыдущему каталогу из истории перемещения по каталогам; эквивалентно нажатию мышкой на символ '<' в верхнем углу панели.

M-u Перемещение к следующему каталогу из истории перемещения по каталогам; эквивалентно нажатию мышкой на символ '>'.

M-S-h, M-H Отображает историю перемещения по каталогам; эквивалентно нажатию мышкой на символ 'v' в верхнем углу панели.[Shell Command Line]
Командная строка оболочки

В этом разделе перечислены команды, которые позволяют сократить число нажатий на клавиши во время ввода и редактирования команд в командной строке.

M-Enter. Копирует подсвеченное имя файла или каталога в командную строку.

C-Enter. То же самое, что M-Enter, но работает только на консоли Linux.

M-Tab. Пытается выполнить операцию Завершение ввода (completion)Completion имени файла, названия команды, переменной, имени пользователя или имени машины (в зависимости от того, что вы начали набирать и какой элемент команды вводите).

C-x t, C-x C-t. Копирует в командную строку имена помеченных файлов (или подсвеченное имя, если нет помеченных) из активной панели (C-x t) или пассивной панели (C-x C-T).

C-x p, C-x C-p. Первая комбинация клавиш копирует в командную строку имя текущего каталога, а вторая - имя каталога, отображаемого в пассивной панели.

C-q. Эта команда (the quote command) используется для того, чтобы вставить символы, которые каким-то образом интерпретируются самим Midnight Commander-ом (например, символ '+').

M-p, M-n. Эти комбинации используются для перемещения по истории команд. M-p вызывает перемещение на команду назад по списку ранее запускавшихся команд, а M-n - перемещение на одну команду вперед.

M-h. Выводит историю текущей строки ввода (для командной строки - историю команд).[General Movement Keys]
Клавиши управления перемещением

Встроенная программа просмотра файлов, программа просмотра подсказки и программа просмотра каталогов используют один и тот же программный код для управления перемещением. Следовательно, для перемещения используются одни и те же комбинации клавиш. Но в каждой подпрограмме имеются и комбинации, применяющиеся только в ней.

Другие части Midnight Commander-а тоже используют некоторые из комбинаций клавиш управления перемещением, так что настоящая секция руководства может быть также полезна при изучении этих частей.

Up, C-p. Перемещение на одну строку назад или вверх

Down, C-n. Перемещение на одну строку вперед

Prev Page, Page Up, M-v. Перемещение на одну страницу назад

Next Page, Page Down, C-v. Перемещение на одну страницу вперед

Home, A1. Перемещение к началу.

End, C1. Перемещение к концу.

Программы просмотра файлов и помощи воспринимают в дополнение к перечисленным еще и следующие комбинации:

b, C-b, C-h, Backspace, Delete. Перемещение на одну страницу назад

Space bar. Перемещение на одну страницу вперед

u, d. Перемещение на половину страницы назад или вперед.

g, G. Перемещение к началу или к концу файла.[Input Line Keys]
Редактирование строк ввода

Строки ввода (это не только командная строкаShell Command Line оболочки, но и строки в диалоговых окнах различных подпрограмм) воспринимают следующие управляющие комбинации:

C-a. Перемещает курсор в началу строки.

C-e. Перемещает курсор в конец строки.

C-b, стрелка-влево. Перемещает курсор на одну позицию влево.

C-f, стрелка-вправо. Перемещает курсор на одну позицию вправо.

M-f. Перемещает курсор на одно слово вперед.

M-b. Перемещает курсор на одно слово назад.

C-h, backspace. Удаляет символ, предшествующий курсору.

C-d, Delete. Удаляет символ в позиции курсора.

C-@. Устанавливает метку для того, чтобы вырезать (скопировать в буфер) часть текста.

C-w. Копирует текст, расположенный между курсором и меткой, в буфер, удаляя текст из строки ввода.

M-w. Копирует текст, расположенный между курсором и меткой, в буфер.

C-y. Вставляет содержимое буфера в строку ввода перед позицией курсора.

C-k. Удаляет текст от курсора до конца строки.

M-p, M-n. Эти комбинации используются для перемещения по истории команд. M-p перемещает к предыдущей команде, M-n - к следующей.

M-C-h, M-Backspace. Удалить предшествующее слово.

M-Tab. Пытается выполнить завершение ввода (completion)Completion имени файла, команды, переменной, имени пользователя или имени машины.[Menu Bar]
Главное меню программы Midnight Commander

Строка главного меню появляется в верхней части экрана после нажатия клавиши F9 или щелчка мыши по верхней рамке экрана. Меню состоит из пяти пунктов: "Левая", "Файл", Команды", Настройки" и "Правая" (в английской версии соответственно "Left", "File", "Command", "Options" и "Right"). При выборе одного из этих пунктов появляется соответствующее выпадающее меню.

Пункты меню "Левая" и "Правая"Left and Right Menus позволяют изменить вид, соответственно, левой и правой панелей, и характер отображаемой в панели информации, в частности, выполнить соединения с удаленными компьютерами.

Меню "Файл"File Menu позволяет выполнить какие-то действия с выбранным файлом или группой помеченных файлов.

Меню "Команды"Command Menu перечисляет действия, которые имеют более общий характер и не относятся только к выделенному в данный момент файлу или группе помеченных файлов.

Меню "Настройки"Options Menu служит для задания ряда параметров, определяющих внешний вид и поведение программы Midnight Commander. Один из пунктов этого меню служит для сохранения настроек, заданных пользователем.[Left and Right Menus]
Меню левой и правой панелей ('Левая' и 'Правая')

Вид панелей, в которых отображаются списки файлов и каталогов, может быть изменен через пункты меню "Левая" ("Left") и "Правая" ("Right").[Listing Mode...]
Формат списка...

Этот пункт меню предназначен для определения формата вывода списка файлов в панели. Вы можете выбрать один из 4 вариантов представления списка файлов: Стандартный (Full), Укороченный (Brief), Расширенный (Long) и Определяемый пользователем (User).

В стандартном формате отображаются имя файла, его размер и время последней модификации.

В укороченном (brief) формате отображаются только имена файлов, за счет чего на панели умещаются две колонки (и видно вдвое больше имен).

В расширенном (long) формате содержимое каталога представляется так, как это делает команда ls -l. В этом формате панель занимает весь экран.

Если вы выберете формат "Определяемый пользователем" ("User"), вы должны будете задать структуру отображаемой информации.

При задании структуры вначале указывается размер панели: "half" (половина экрана) или "full" (весь экран).

После размера панели можно указать, что на панели должно быть две колонки. Это делается добавлением цифры 2 в строку задания формата.

Далее надо перечислить имена полей с необязательным параметром ширины поля. В качестве имен полей могут использоваться:

name    отображать имя файла.

size    отображать размер файла.

bsize   отображать размер в альтернативной форме, при которой выводятся размеры файлов, а для каталогов выводится только надпись "ПОД-КАТ" ("SUB-DIR") или "ВВЕРХ" ("UP--DIR").

type    отображать односимвольное поле типа. Этот символ может принимать значения из подмножества символов, выводимых командой ls -F: * (asterisk) для исполняемых файлов, / (slash) для каталогов, @ (at-sign) для ссылок (links), = (знак равенства) для сокетов (sockets), - дефис (hyphen) для байт-ориентированных устройств, + для блок-ориентированных устройств, | (pipe) для файлов типа FIFO, ~ (тильда) для символических ссылок на каталоги, ! (восклицательный знак) для оборванных (stale) символических ссылок (ссылок, указывающих в никуда).

mark    Звездочка (asterisk) если файл помечен, пробел - если не помечен.

mtime   время последней модификации файла.

atime   время последнего обращения к файлу.

ctime   время создания файла.

perm    строка, показывающая текущие права доступа к файлу.

mode    восьмеричное представление текущих прав доступа к файлу.

nlink   число ссылок на данный файл.

ngid    идентификатор группы (GID, в цифровой форме).

nuid    идентификатор пользователя (UID, в цифровой форме).

owner   владелец файла.

group   группа, имеющая права на файл.

inode   номер inode файла.

Вы также можете использовать следующие имена полей для организации вывода информации на дисплей:

space   Вставить пробел при выводе на дисплей.

|       Вставить вертикальную линию при выводе на дисплей.

Для того, чтобы задать фиксированную ширину поля, нужно добавить двоеточие ':', после которого указать число позиций, которое отводится под это поле. Если после числа поставить символ '+', то указанное число будет интерпретироваться как минимальная ширина поля, и, если экран позволяет, поле будет расширено.

Например, Стандартный формат вывода задается строкой:

half type name | size | mtime

а Расширенный - строкой:

full perm space nlink space owner space group space size space mtime space name

А вот пример удобного формата, определяемого пользователем:

half name | size:7 | type mode:3

Помимо того, что может задаваться формат вывода на панель списка файлов, любую панель можно перевести в один из следующих режимов:

Информация (Info)
        В этом режиме на панель выводится информация о подсвеченном в другой панели файле и о текущей файловой системе (тип, свободное пространство и число свободных inode).

Дерево (Tree)
        Режим отображения дерева каталогов подобен тому, который вы увидите, выбрав пункт Дерево каталоговDirectory Tree из меню "Команды" ("Commands"). Смотрите соответствующий раздел.

Быстрый просмотр (Quick View)
        В этом режиме панель переключается на отображение содержимого файла, подсвеченного в другой панели. Для вывода используется встроенная программа просмотра файловInternal File Viewer, так что, если переключиться клавишей Tab в панель просмотра, вы сможете использовать все команды управления просмотром.[Sort Order...]
Порядок сортировки...

Отображение списка файлов в любой из панелей может производиться в соответствии с одним из восьми порядков сортировки:
- по имени;
- по расширению;
- по размеру файла;
- по времени модификации;
- по времени последнего обращения к файлу;
- по времени последнего изменения атрибутов файла;
- по номеру узла (inode);
- без сортировки.

Порядок сортировки можно выбрать, вызвав диалоговое окно, в котором кроме того можно указать, что сортировка производится в обратном порядке (поставив с помощью клавиши пробела отметку в скобках возле слова "Обратный (reverse)".

По умолчанию каталоги отображаются в начале списка, но это можно изменить, проставив отметку возле опции "Смешивать файлы и каталоги" ("Mix all files") пункта "Конфигурация" меню "Настройки"Options Menu.[Filter...]
Фильтр...

Пункт меню "Фильтр" позволяет задать шаблон, которому должны соответствовать имена файлов, отображаемых в панели (например, *.tar.gz). Имена каталогов и ссылки на каталоги отображаются всегда, независимо от шаблона.[Reread]
Перечитать (Reread)

Команда "Перечитать" обновляет список, отображаемый на панели. Это бывает полезно в тех случаях, когда другие процессы создают или удаляют файлы. Если вы выполнили пункт меню "Критерий панелизации" (перенаправление вывода команды на панель), по этой команде будет снова выведено содержимое каталога, а выведенная на панель информация удалена (подробнее смотрите секцию Критерий панелизацииExternal panelize).[File Menu]
Файл

Программа Midnight Commander использует функциональные клавиши F1 - F10 как "горячие" клавиши для команд, включенных в меню "Файл". Escape-последовательности, генерируемые клавишами F1-F10, соответствуют функциям terminfo kf1 - kf10. На терминалах без поддержки функциональных клавиш можно достичь аналогичного эффекта, нажав клавишу ESC, а затем число в диапазоне от 1 до 9 или 0 (соответствует F1 - F9 и F10).

Меню "Файл" содержит следующие команды (соответствующие "горячие" клавиши указываются в скобках):

Просмотр файла (F3, Shift-F3)

Просмотреть файл, на который указывает подсветка. По умолчанию при этом вызывается встроенная программа просмотраInternal File Viewer, но, сняв отметку с опции "Встроенный просмотр" ("Use internal view") в пункте "Конфигурация" меню "Настройки" ("Options"), можно вызывать внешнюю программу просмотра, путь к которой должен быть указан в переменной окружения  PAGER. Если переменная PAGER не определена, вызывается встроенная программа. Если вместо F3 нажать Shift-F3, встроенная программа просмотра не выполняет предварительного форматирования или обработки файла.

Просмотр вывода команды (Filtered View) (M-!)

По этой команде на экране появляется строка ввода, в которой вы можете ввести любую команду с параметрами (по умолчанию предлагается использовать в качестве параметра имя подсвеченного файла). Вывод этой команды будет отображаться на экране через встроенную программу просмотра.

Редактирование (F4)

Вызывается редактор vi, либо редактор, указанный в переменной окружения EDITOR, либо встроенный редактор файловInternal File Editor (если включена опция "Встроенный редактор" (use_internal_edit) в меню "Настройки / Конфигурация").

Копирование (F5)

Вызывается диалоговое окно, в котором предлагается скопировать подсвеченный файл из каталога, отображаемого в активной панели (или группу отмеченных файлов, если в активной панели отмечен хотя бы один файл) в каталог, отображаемый в пассивной панели. Имя каталога, в который будет производиться копирование, можно изменить. О том, как задать шаблон для имен копируемых файлов (обычно это * или ^\(.*\)$, в зависимости от установки опции Образцы в стиле shell (Shell Patterns), и о допустимых символах замены (wildcards) в строке целевого каталога вы можете узнать, просмотрев раздел Маски файлов для операций копирования/переMask Copy/Rename

В процессе выполнения копирования можно нажать C-c или ESC для того, чтобы прервать выполнение операции.

В некоторых системах можно осуществлять копирование в фоновом режиме, если запустить процесс не кнопкой <Дальше> диалогового окна, а кнопкой <На фоне> (или нажав M-b в диалоговом окне). Используя пункт меню "Команды/Фоновые задания"Background Jobs, можно управлять выполнением фоновых процессов.

Права доступа (C-x c)

Позволяет изменить права доступа к выделенному или помеченным файлам.

Жесткая ссылка (C-x l)

Создает жесткую ссылку на текущий файл.

Символич. ссылка (C-x s)

Создает символическую ссылку на текущий файл. Если вы не знаете, что такое ссылки: создание ссылки в некотором смысле подобно копированию файла, но и исходное имя файла и ссылка указывают на один и тот же реальный файл на диске. Поэтому, если вы, например, редактируете файл, то изменения будут появляться в обеих копиях. Синонимами термина "ссылка" (link) являются термины алиас (alias) и ярлык (shortcut).

Жесткая ссылка выглядит как реальный файл. После создания жесткой ссылки невозможно различить, где исходный файл, а где ссылка. Если вы удаляете один из этих файлов (точнее одно из этих имен), то файл еще сохраняется на диске (пока у него есть хоть одно имя-ссылка). Очень трудно различить первоначальное имя файла и позже созданные жесткие ссылки на него. Поэтому жесткие ссылки применяются там, где отслеживать различия и не требуется.

Символическая ссылка - это ссылка на имя исходного файла. Если исходный файл удален, символическая ссылка становится бесполезной. Символическую ссылку легко отличить от первоначального имени файла и программа Midnight Commander указывает символические ссылки выводя знак "@" перед именем такой ссылки (кроме ссылок на каталоги, которые обозначаются знаком тильды "~"). Если на экран выводится строка мини-статуса (опция "Показывать мини-статус" ("Show mini-status") включена), то в ней отображается имя исходного файла. Используйте символические ссылки в тех случаях, когда хотите избежать путаницы, связанной с применением жестких ссылок.

Владелец/группа (C-x o) Позволяет выполнить команду chown.

Права (расширенные) Позволяет изменить права доступа и владения файлом.

Переименование (F6)

Вызывается диалоговое окно, в котором предлагается перенести подсвеченный файл из каталога, отображаемого в активной панели (или группу отмеченных файлов, если в активной панели отмечен хотя бы один файл) в каталог, отображаемый в пассивной панели. Имя каталога, в который будет производиться перенос, можно изменить, воспользовавшись соответствующей строкой ввода.

В остальном диалоговое окно аналогично окну, появляющемуся при вызове команды копировании файлов (смотрите выше).

Создание каталога (F7)

Появляется диалоговое окно и создается каталог с введенным именем.

Удаление (F8)

Удаляется файл, имя которого подсвечено (или группа файлов, имена которых помечены) в активной панели. Операцию можно прервать, нажав C-c или ESC во время ее исполнения.

Быстрая смена каталога (Quick cd) (M-c)

Используйте быструю смену каталогаThe cd internal command если вы знаете полный путь к каталогу, в который хотите перейти (который хотите сделать текущим).

Отметить группу (+)

Эта команда используется для отметки группы файлов по заданному шаблону. Midnight Commander выдаст диалоговое окно, в которой надо задать опции выделения группы файлов и каталогов. Если включена опция Только файлы, то выделены будут только файлы. Если опция Только файлы, отключена, то выделены будут как файлы, так и каталоги. Если включена опция Образцы в стиле shell (Shell Patterns), регулярные выражение строятся по тем же правилам, которые действуют в оболочке shell (* означает ноль или большее число любых символов, а ? заменяет один произвольный символ). Если опция Образцы в стиле shell (Shell Patterns) отключена, то пометка файлов производится по правилам обработки нормальных регулярных выражений (смотрите ed (1)). Если включена опция С учётом регистра то пометка файлов и каталогов будет производиться с учетом регистра символов имён. Если опция С учётом регистра отключена, то регистр символов учитываться не будет.

Снять отметку (\ - обратный слэш)

Используется для снятия отметки с группы файлов. Эта операция является обратной по отношению к операции отметки группы файлов и использует те же правила формирования шаблонов.

Выход (F10, Shift-F10)

Выйти из программы Midnight Commander. Shift-F10 используется для выхода в тех ситуациях, когда используется shell wrapper. После Shift-F10 текущим каталогом будет не последний каталог, в котором вы были при работе в Midnight Commander, а тот, в котором вы были, когда запустили Midnight Commander.[Quick cd]
Быстрая смена каталога (Quick cd)

Эта команда полезна тогда, когда вы знаете полный путь к каталогу, который хотите сделать текущим, и желаете использовать встроенную команду cdThe cd internal command.

По этой команде вызывается диалоговое окно, в строке ввода которого вы должны ввести тот путь, который вы ввели бы в командной строке оболочки при выполнении команды cd.

После этого надо нажать клавишу <Enter>.[Command Menu]
Меню 'Команды'


Меню пользователя (F2)

Вызывает меню пользователяMenu File Edit. Меню пользователя предоставляет простой способ расширения возможностей Midnight Commander за счет добавления в личное меню пользователя вызова часто используемых программ. При обращении к пункту меню Дерево каталоговDirectory Tree выводится окно, отображающее структуру каталогов файловой системы.

Команда Поиск файлаFind File позволяет найти на диске файл с заданным именем. "Горячие" клавиши - M-?.

Команда "Переставить панели" ("Swap panels") меняет местами содержимое правой и левой панелей. "Горячие" клавиши - C-u.

По команде "Отключить панели" ("Panels on/off") показывается вывод последней из выполнявшихся команд shell. Эта команда работает только через xterm и на консоли Linux и FreeBSD. "Горячие" клавиши - C-o.

По команде "Сравнить каталоги" ("Compare directories", "горячие" клавиши - C-x d) сравнивается содержимое каталогов, отображаемых на левой и правой панелях. После сравнения можно воспользоваться командой "Копировать" (F5) для того, чтобы сделать содержимое каталогов одинаковым. Существует три метода сравнения. При быстром методе сравниваются только размер и дата создания файлов с одинаковыми именами. При побайтном методе сравнивается содержимое файлов (побайтно). Этот метод недоступен, если машина не поддерживает системный вызов mmap(2). При сравнении по размеру сравниваются только размеры соответствующих файлов, а дата создания не проверяется.

Пункт меню "Критерий панелизации"External panelize позволяет выполнить внешнюю программу, сделав ее вывод содержимым текущей панели (характерный пример - панелизация вывода команды find).


Пункт меню "История команд" выводит окно со списком ранее выполнявшихся команд. Подсвеченную строку из истории можно скопировать в командную строку оболочки (перемещение подсветки - стрелками вверх/вниз, копирование - по клавише Enter). Доступ к истории команд можно получить также по комбинациям клавиш M-p или M-n, однако в этом случае вы не видите окна с перечнем команд. Вместо этого в командную строку выводится одна команда из списка и по комбинации M-p происходит смена этой команды на предыдущую, а по M-n - на следующую команду из истории команд.

Пункт меню "Быстрый доступ к каталогам"Hotlist C-\ позволяет создать список каталогов, которые часто используются, и обеспечить быстрый переход к нужному каталогу из этого списка.

Пункт меню "Список активных ВФС" C-x a отображает список виртуальных файловых систем, активных на настоящий момент. Можно перейти на выбранную виртуальную файловую систему. Для Обновления списка выберите кнопку "Освежить" в диалоговом окне. Кнопка "Освободить ВФС сейчас" поможет при обновлении содержимого архива или при разорванном сетевом соединении.

Пункт меню "Фоновые задания"Background Jobs C-x j отображает список фоновых заданий, запущенных в диалоге копирования/перемещения кнопкой "В фоне".

После выбора пункта меню "Файл расширений"Extension File Edit вы можете связать с определенным расширением файла (окончанием имени после последней точки) программу, которая будет запускаться для обработки (просмотра, редактирования или выполнения) файла с таким расширением. Запуск выбранной программы будет осуществляться после установки подсветки на имя файла и нажатия клавиши <Enter>.

Пункт меню "Файл меню"Menu File Edit используется для редактирования пользовательского меню (которое появляется после нажатия клавиши F2).[Directory Tree]
Дерево каталогов (Directory Tree)

После выбора пункта меню "Дерево каталогов" появляется окно, в котором отображена иерархическая структура каталогов.

Дерево каталогов может быть вызвано двумя способами: через пункт "Дерево каталогов" из меню "Команды" и пункт "Дерево" из меню правой или левой панелей.

Чтобы избавиться от долгих задержек во время создания дерева каталогов, Midnight Commander создает дерево путем просмотра только небольшого подмножества всех каталогов. Если каталог, который вам нужен, не отображен, перейдите в его родительский каталог и нажмите C-r (или F2).

Для управления просмотром дерева каталогов могут использоваться следующие комбинации клавиш:

Работают все клавиши управления перемещениемGeneral Movement Keys.

Enter. В окне просмотра дерева каталогов нажатие этой клавиши вызывает выход из режима просмотра и отображение списка файлов выбранного каталога в активной панели. При отображении дерева каталогов в одной из панелей при нажатии клавиши Enter соответствующий каталог отображается во второй панели, а на текущей панели остается дерево.

C-r, F2 (Rescan). Перечитать содержимое каталога. Используется в тех случаях, когда дерево каталогов не соответствует реальной структуре: некоторые каталоги не показаны или показаны более не существующие.

F3 (Forget). Удалить текущий каталог из дерева. Эта команда используется для удаления ошибочно отображаемых ветвей дерева. Если вам необходимо вернуть подкаталог в дерево, перейдите в его родительский каталог и нажмите клавишу F2.

F4 (Static/Dynamic). Переключение между статическим (применяемым по умолчанию) и динамическим режимами перемещения по дереву.

В статическом режиме перемещения для выбора каталога (т.е. перемещения подсветки на имя другого каталога) используются только стрелки вверх/вниз. Показываются все известные программе на данный момент подкаталоги.

В динамическом режиме стрелки вверх/вниз используются для перехода на соседний каталог того же уровня. Для перехода в родительский каталог используется клавиша "стрелка влево", а по стрелке вправо происходит переход к потомкам текущего каталога, то есть на один уровень ниже. При этом отображаются только вышележащие каталоги (включая родительский и выше), соседние каталоги того же уровня и непосредственные потомки. Вид дерева каталогов динамически изменяется после каждого перемещения по дереву.

F5 (Copy). Копировать подкаталог (появляется строка ввода, в которой надо указать, куда копировать).

F6 (RenMov). Переместить подкаталог.

F7 (Mkdir). Создать подкаталог в текущем (подсвеченном) каталоге.

F8 (Delete). Удалить подсвеченный каталог из файловой системы.

C-s, M-s. Найти следующий каталог, соответствующий заданному шаблону поиска. Если такого каталога не существует, происходит просто смещение подсветки на одну строку вниз.

C-h, Backspace. Удаляет последний символ в строке (шаблоне) поиска.

Любой другой символ. Этот символ добавляется в шаблон поиска и производится перемещение на имя следующего каталога, удовлетворяющее шаблону. В режиме просмотра дерева каталогов вначале необходимо активизировать режим поиска клавишами C-s. Шаблон поиска будет отображаться в строке мини-статуса.

Следующие действия возможны только в окне просмотра дерева каталогов и не поддерживаются при просмотре дерева в одной из панелей:

F1 (Help). Вызов подсказки с отображением настоящего раздела помощи.

Esc, F10. Выход из окна дерева каталогов. Смены текущего каталога не происходит.

В окне просмотра дерева каталогов поддерживается мышка. Двойной щелчок аналогичен нажатию клавиши Enter. Смотрите также секцию о поддержке мышиMouse Support.[Find File]
Поиск файлов (Find File)

После выбора пункта меню "Поиск файла" ("Find File") вначале запрашивается имя искомого файла и имя каталога, с которого необходимо начинать поиск. Нажав кнопку <Дерево> (<Tree>), можно выбрать начальный каталог поиска из дерева каталоговDirectory Tree.

В поле "Содержание" (Content) можно задать расширенное регулярное выражение. Это значит, что перед символами, имеющими специальное значение, необходимо вставить символ "\". Например, если нужно найти строку "strcmp (", необходимо указать шаблон поиска в виде "strcmp \(" (без двойных кавычек).

Опция "Только целые слова" устанавливает, что шаблон поиска соответствует только целым словам (например, если указано "foo", не будет найдено слово "foobar").

Для того, чтобы начать поиск, нажмите экранную кнопку <Дальше> (<Ok>). Во время поиска его можно приостановить кнопкой <Приостановить> (<Suspend>) и продолжить по кнопке <Продолжить> (<Continue>).

Список найденных файлов можно просматривать, перемещаясь с помощью клавиш "стрелка вверх" и "стрелка вниз". Кнопка <Перейти> (<Chdir>) используется для перехода в каталог, в котором находится подсвеченный файл. Кнопка <Повтор> (<Again>) служит для задания параметров нового поиска. Кнопка <Выход> (<Quit>) служит для выхода из режима поиска. Нажатие на кнопку <Панелизация> (<Panelize>) приведет к тому, что результаты поиска будут отображены на текущую активную панель, так что вы можете производить с выбранными файлами еще какие-то действия (просматривать, копировать, перемещать, удалять и так далее). После вывода на панель можно нажать C-r для возврата к обычному списку файлов.

Можно задать список каталогов, которые команда "Поиск файла" будет пропускать в ходе поиска (например, вы знаете, что искомого файла нет на CDROM или не хотите искать в каталогах, подключенных через NFS по очень медленному каналу).

Каталоги, которые надо пропустить, должны быть указаны в переменной ignore_dirs в секции FindFile вашего файла ~/.mc/ini. Имена каталогов разделяются двоеточиями, следующим образом:

[FindFile]
ignore_dirs=/cdrom:/nfs/wuarchive:/afs

Вы можете использовать перенаправление вывода на панель (см. Критерий панелизацииExternal panelize) для выполнения некоторых усложненных последовательностей действий, в то время как "Поиск файла" позволяет выполнять только простые запросы.[External panelize]
Критерий панелизации (External panelize)

Пункт меню "Критерий панелизации" (который правильнее было бы назвать "Перенаправление вывода на панель") позволяет выполнить внешнюю программу и отобразить вывод этой программы на текущей активной панели.

Например, если вы хотите выполнить какое-то действие над всеми символическими ссылками текущего каталога, вы можете использовать пункт "Критерий панелизации" для запуска следующей команды:

find . -type l -print

После выполнения этой команды в текущей панели будет отображено не содержимое соответствующего каталога, а только все символические ссылки, в нем расположенные.

Если вы хотите вывести на панель все файлы, которые были скачаны с вашего FTP-сайта, вы можете использовать следующую команду для извлечения нужных имен из файла протокола:

awk '$9 ~! /incoming/ { print $9 }' < /var/log/xferlog

Если вы захотите, то можете сохранить часто используемые команды панелизации под отдельными информативными именами, чтобы иметь возможность их быстро вызвать по этим именам. Для этого нужно набрать команду в строке ввода и нажать кнопку <Добавить>. После этого вам потребуется ввести имя, по которому вы будете вызывать команду. В следующий раз вам достаточно будет выбрать нужное имя из списка, а не вводить всю команду заново.[Hotlist]
Справочник каталогов (Hotlist)

Пункт меню "Справочник каталогов" служит для вывода списка меток (условных имен), присвоенных наиболее часто используемым каталогам. Этот список можно использовать для быстрого перехода в нужный каталог. Пользуясь диалоговым окном справочника каталогов, вы можете добавить новую метку в список или удалить ранее созданную пару метка/каталог. Для добавления метки можно также использовать комбинацию клавиш C-x h, по которой текущий каталог добавляется в справочник каталогов. Программа выдаст запрос на ввод метки для этого каталога.

Использование этого пункта меню обеспечивает более быстрый переход к часто используемым каталогам. Другим способом ускорения процедуры переключения на часто используемые каталоги является задание переменной CDPATH (смотрите описание встроенной команды cdThe cd internal command.[Extension File Edit]
Файл расширений

Этот пункт меню "Команда" служит для вызова редактора и редактирования файла ~/.mc/bindings. Этот файл имеет следующий формат (формат был изменен в версии 3.0):

Все строки, начинающиеся с # или пустые строки игнорируются.

Строки, начинающиеся с первой колонки (будем говорить, что с таких строк начинаются секции файла расширений), должны иметь следующий формат:

keyword/desc, т.е. все, что стоит после keyword/ и до конца строки, интерпретируется как desc.

В качестве keyword может стоять одно из следующих слов:

shell   если desc начинается с точки (мета-символы не допускаются), то desc - это расширение имени файла, т.е. шаблону соответствуют все файлы, оканчивающиеся на desc. Пример: .tar будет означать *.tar. Если desc не начинается с точки, то desc трактуется как полное имя файла.

regex   desc - регулярное выражение. Обратите внимание на то, что используется библиотека GNU regex, в силу чего "\|" соответствует просто символу "|", а "|" имеет специальное значение (логическое ИЛИ). Аналогично, вместо скобок "(" и ")" надо использовать "\(" и "\)".

directory
        Файл является каталогом и его имя соответствует регулярному выражению desc.

type    в этом случае выбираются такие файлы, для которых `file %f` соответствует регулярному выражению desc (часть filename: из `file %f` удалена).

default подходит любой файл, независимо от того, какое значение принимает desc.

include - означает общую секцию.

Все строки в секции, кроме первой, должны начинаться с пробела или символа табуляции и иметь следующий формат:

keyword=command (без пробелов возле "="), где keyword должно быть:

Open (строка задает действия, выполняемые в том случае, когда пользователь нажимает Enter или дважды щелкает мышкой по имени файла), View (F3), Edit (F4) или Include (для добавления правил из общей секции).

command - любая однострочная команда оболочки, в которой допускаются простые макроподстановкиMacro Substitution.

Действие вычисляется сверху вниз (таким образом порядок следования важен). Если некоторое действие пропущено, поиск продолжается как в случае, если это действие не соответствует условию. Другими словами если файл соответствует первой и второй секции, но действие View пропущено в первой секции, то при нажатии клавиши F3 будет использовано действие View из второй секции. default должно описывать все действия.[Background Jobs]
Фоновые задания

Этот пункт меню позволяет вам управлять фоновыми заданиями, запущенными из Midnight Commander (такими заданиями могут быть только операции копирования и перемещения файлов). Используя этот пункт меню или "горячие" клавиши C-x j, вы можете остановить, возобновить или снять любое из фоновых заданий.[Menu File Edit]
Редактирование файлов меню

Файлы меню содержат списки команд для выполнения часто повторяемых пользователем операций. Эти меню создаются и поддерживаются самими пользователями. Могут быть созданы три файла меню: в текущем каталоге, в домашнем каталоге пользователя и общесистемный. Когда вы нажимаете клавишу F2 для вызова меню, Midnight Commander вначале ищет файл .mc.menu в текущем каталоге и отображает соответствующее меню (если находит и если владельцем этого файла является данный пользователь или root и этот файл не доступен на запись всем). Если такого файла не найдено, таким же образом ищется файл ~/.mc/menu и, в последнюю очередь, mc использует общесистемное меню /usr/local/share/mc/mc.menu.

Формат всех трех файлов меню одинаков и очень прост. Строки комментариев начинаются с '#'. Дополнительные комментарии должны начинаться с '#', пробела или символа табуляции. Строки, начинающиеся с любого символа, отличного от пробела и символа табуляции, интерпретируются как названия пунктов меню, причем если первый символ является буквой или цифрой, то соответствующая клавиша будет служить "горячей" клавишей для вызова этого пункта меню. Строки, начинающиеся с пробела или символа табуляции, интерпретируются как команды, которые должны выполняться при вызове соответствующего пункта меню. Эти строки должны следовать за строкой названия и их может быть несколько.

Когда пользователь выбирает какой-то пункт меню, соответствующие командные строки копируются во временный файл во временном каталоге (обычно /usr/tmp) и затем этот файл запускается на выполнение. Это позволяет пользователю вставлять в команды меню любые конструкции, допустимые в командном языке оболочки. Можно также использовать макроподстановки, которые производятся перед выполнением кода меню (подробнее смотрите в секции МакроподстановкиMacro Substitution).

Вот пример файла mc.menu:

A	Dump the currently selected file
	od -c %f

B	Edit a bug report and send it to root
	I=`mktemp ${MC_TMPDIR:-/tmp}/mail.XXXXXX` || exit 1
	vi $I
	mail -s "Midnight Commander bug" root < $I
	rm -f $I

M	Read mail
	emacs -f rmail

N	Read Usenet news
	emacs -f gnus

H	Call the info hypertext browser
	info

J	Copy current directory to other panel recursively
	tar cf - . | (cd %D && tar xvpf -)

K	Make a release of the current subdirectory
	echo -n "Name of distribution file: "
	read tar
	ln -s %d `dirname %d`/$tar
	cd ..
	tar cvhf ${tar}.tar $tar

= f *.tar.gz | f *.tgz & t n
X	Extract the contents of a compressed tar file
	tar xzvf %f

Условия выполнения (Default Conditions)

Каждому пункту меню может предшествовать условие. Строка, задающая условие, должна содержать символ '=' в первой колонке. Команды, задаваемые этим пунктом меню, будут выполняться только если условие выполняется.

Синтаксис строки условия:   = <sub-cond>
                или:        = <sub-cond> | <sub-cond> ...
                или:        = <sub-cond> & <sub-cond> ...

где <sub-condition> может принимать следующие значения:

  y <pattern>     синтаксис текущего файла соответствует шаблону.
                  Только для меню редактора.
  f <pattern>     соответствует шаблону имя текущего файла?
  F <pattern>     соответствует шаблону файл в пассивной
                  панели?
  d <pattern>     соответствует шаблону имя текущего
                  каталога?
  D <pattern>     соответствует шаблону имя текущего
                  каталога в пассивной панели?
  t <type>        тип файла соответствует <type>?
  T <type>        тип файла в пассивной панели
                  соответствует <type>?
  x <filename>    filename является исполнимым?
  ! <sub-cond>    логическое отрицание условия <sub-cond>

Шаблон (pattern) - это обычный шаблон оболочки (shell pattern) или регулярное выражение, в соответствии с опцией "shell patterns". Вы можете задать значение опции "shell patterns" путем записи строки "shell_patterns=x" в самую первую строку файла меню (здесь "x" равно 0 или 1).

Типы файлов определяются следующими символами:

  n     не каталог
  r     обычный файл (regular file)
  d     каталог
  l     ссылка (link)
  c     байт-ориентированное устройство (char special)
  b     блок-ориентированное устройство (block special)
  f     fifo
  s     socket
  x     исполняемый файл
  t     помеченный файл (tagged)

Например, 'rlf' означает либо обычный файл, либо ссылку, либо файл типа fifo. Тип 't' стоит несколько особняком, потому что этот тип определяется не типом самого файла, а тем, помечен ли файл на панели. Условие '=t t' истинно, если в текущей панели имеются помеченные файлы, и ложно, если таковых нет.

Если условие начинается с '=?' вместо '=', то во время выполнения проверки условия будет отображаться ход вычисления условия (a debug trace will be shown whenever the value of the condition is calculated).

Значение условия вычисляется слева направо. Это значит, что
	= f *.tar.gz | f *.tgz & t n
вычисляется как
	( (f *.tar.gz) | (f *.tgz) ) & (t n)

Вот пример использования условий:

= f *.tar.gz | f *.tgz & t n
L	List the contents of a compressed tar-archive
	gzip -cd %f | tar xvf -

Условия включения пункта в меню (Addition Conditions)

Если строка условия начинается с '+' (или '+?') вместо '=' (или '=?') - это условие трактуется как условие включения данного пункта в меню. Если условие истинно, пункт включается в отображаемое на экране меню, если условие не выполняется - не включается.

Вы можете использовать одно и то же условие и как условие выполнения и как условие включения пункта в меню, если начнете строку условия с '+=' или '=+' (если надо отображать ход вычисления, то с '+=?' или '=+?'). Если вы хотите использовать два разных условия, одно для включения в меню, а другое - для выполнения, надо предпослать пункту меню две строки условий, одну - начинающуюся с '+', и другую - начинающуюся с '='.[Options Menu]
Меню 'Настройки' ('Options')

Программа Midnight Commander имеет ряд установок (опций), каждая из которых может быть включена или выключена, для чего служат несколько диалоговых окон, доступных через меню "Настройки". Опция включена, если поставлена звездочка или знак "x" в скобках перед названием опции.

Пункт КонфигурацияConfiguration вызывает диалоговое окно, в котором вы можете поменять большинство установок программы Midnight Commander.

Пункт Внешний вид (Layout)Layout служит для задания настроек, определяющих положение и вид окна программы mc на экране.

Пункт Подтверждение (Confirmation)Confirmation вызывает диалоговое окно, в котором вы указываете, на выполнение каких действий программа будет требовать подтверждения.

Пункт Биты символов (Display bits)Display bits вызывает диалоговое окно, в котором вы указываете, в каком формате ваш терминал будет обрабатывать (вводить и отображать на дисплее) информацию, представленную байтами (например, записанную в файле).

Пункт Распознавание клавиш (Learn keys)Learn keys вызывает диалоговое окно, в котором вы можете протестировать работу некоторых клавиш, которые работают не на всех типах терминалов, и связать ту реакцию системы, которая должна была последовать за нажатием отсутствующей клавиши, с нажатием другой клавиши или комбинации клавиш.

Пункт Виртуальные ФС (Virtual FS)Virtual FS вызывает диалоговое окно, в котором вы можете задать значения некоторых параметров, связанных с использованием виртуальных файловых систем.

По команде Сохранить настройки (Save setup)Save Setup введенные значения параметров сохраняются в ini-файле программы.[Configuration]
Конфигурация

Параметры конфигурации, задаваемые в этом окне, делятся на три группы: "Настройки панелей", "Пауза после исполнения" и "Прочие настройки".

Настройки панелей (Panel Options)

Размеры в единицах СИ. Если эта опция включена, то Midnight Commander отображает размеры файлов и каталогов в единицах СИ (по основанию 1000). Суффиксы к, м, и т. д. отображаются в нижнем регистре. По умолчанию опция выключена. В этом случае Midnight Commander отображат размеры в двоичных единицах (по снованию 1024), и суффиксы К, М, и т. д. отображаются в верхнем регистре.

Показывать резервные (Backup) файлы. По умолчанию программа Midnight Commander не показывает файлы, имена которых заканчиваются на '~' (подобно ключу -B команды ls в GNU).

Показывать скрытые файлы. По умолчанию Midnight Commander показывает все файлы, имена которых начинаются точкой (как ls -a).

Отметка перемещает курсор. Когда вы отмечаете файл (клавишей Insert), то по умолчанию подсветка на имени файла смещается на одну строку вниз.

Выпадение меню при вызове. Если эта опция включена, то при вызове главного меню нажатием клавиши F9, будет сразу отображаться перечень пунктов меню (выпадающее меню). В противном случае активизируются только пункты главного меню и вы должны (после выбора одного из них клавишами стрелок) нажать клавишу Enter, либо выбрать нужный пункт по первой букве названия, и только после этого получите возможность выбрать пункт выпадающего меню.

Смешивать файлы/каталоги. Если эта опция включена, имена файлов и каталогов отображаются вперемежку. Если опция отключена, каталоги (и ссылки на каталоги) показываются в начале списка, а имена файлов - после имен всех каталогов.

Быстрая загрузка каталога. По умолчанию эта опция выключена. Если вы активизируете ее, Midnight Commander будет использовать для вывода содержимого каталога следующий трюк: содержимое каталога перечитывается только в том случае, если изменилась запись в i-node каталога, то есть если в каталоге создавались или удалялись файлы; если изменялись только записи в i-node файлов каталога (изменялся размер файла, режим доступа или владелец и т.п.) содержимое панели не обновляется. В этом случае (если опция включена) вы должны обновлять список файлов вручную (клавишами C-r).

Пауза после исполнения

После выполнения вашей команды Midnight Commander может обеспечить паузу, чтобы вы могли просмотреть и изучить вывод команды. Есть три варианта установки этой опции:

        <Никогда> Это значит, что вы не хотите видеть вывод команды. На консоли Linux или FreeBSD или при использовании xterm вы можете просмотреть этот вывод, нажав C-o.

        <На "тупых" терминалах> Пауза будет создаваться на терминалах, которые не способны обеспечить показ вывода последней из выполнявшихся команд (это любые терминалы, отличные от xterm или Linux-консоли).

        <Всегда> Программа обеспечит паузу после выполнения любой команды.


Прочие настройки

Mkdir autoname. При создании нового каталога по F7 в поле ввода имени нового каталога будет автоматически подставляться имя файла или каталога, находящегося под курсором.

Детали операций (Verbose operation). Этот переключатель определяет, будет ли при выполнении операций копирования, перемещения и удаления выводится дополнительное окно, отображающее ход выполнения операции. Если у вас медленный терминал, вы можете отключить этот вывод. Он отключается автоматически, если скорость вашего терминала меньше 9600 bps.

Подсчитывать общий размер. Если эта опция включена, Midnight Commander перед выполнением операций копирования, перемещения и удаления подсчитывает общее число обрабатываемых файлов и их суммарный размер и показывает ход выполнения операции над этими файлами в виде диаграммы-полоски (правда, это слегка замедляет выполнение операций). Эта опция не работает, если отключена опция Детали операций.

Образцы в стиле shell (Shell Patterns). По умолчанию команды Select, Unselect и Filter используют регулярные выражения, которые строятся по правилам, действующим в оболочке (shell- like regular expressions). Для того, чтобы достичь такого эффекта, выполняются следующие преобразования: '*' заменяется на '.*' (ноль или больше символов); '?' заменяется на '.' (в точности один символ) и '.' заменяется на обычную точку. Если опция отключена, то регулярные выражения должны строиться так, как описано в ed(1).

Автосохранение настроек. Если эта опция включена, то при выходе из программы Midnight Commander значения всех настраиваемых параметров сохраняются в файле ~/.mc/ini.

Автоматические меню. Если эта опция включена, пользовательское меню будет автоматически вызываться на экран при запуске программы. Это бывает полезно, если на компьютере работают неопытные пользователи (операторы), которые должны выполнять только стандартные операции.

Встроенный редактор. Если эта опция включена, то для редактирования файлов вызывается встроенный редактор. Если опция выключена, то будет использоваться редактор, указанный в переменной окружения EDITOR. Если такой редактор не задан, будет вызываться vi Смотрите раздел Встроенный редактор файловInternal File Editor.

Встроенный просмотр. Если эта опция включена, для просмотра файлов вызывается встроенная программа просмотра. Если опция выключена, вызывается программа, указанная в переменной окружения PAGER. Если такая программа не задана, используется команда view. Смотрите раздел Встроенная программа просмотра файловInternal File Viewer.

Дополнение: показывать все (Complete: show all). В процессе ввода команд Midnight Commander может выполнять Завершение вводаCompletion при нажатии на клавиши M-Tab, пытаясь угадать окончание вводимой команды. По умолчанию при первом нажатии M-Tab он ищет все возможные варианты завершения и, если завершения неоднозначны (имеется много разных вариантов), то только издает звуковой сигнал. При втором нажатии M-Tab отображаются все возможные завершения. Если вы хотите видеть все возможные варианты завершения после первого нажатия M-Tab, включите эту опцию.

Вращающийся индикатор Если эта опция включена, Midnight Commander отображает в верхнем правом углу вращающуюся черточку, как индикатор того, что выполняется какое-то задание (операция).

Навигация в стиле lynx (Lynx-like motion). Если эта опция включена, вы имеете возможность использовать клавиши "стрелка вправо" для перехода в подсвеченный в данный момент каталог и "стрелка влево" для перехода в родительский по отношению к текущему каталог (при условии, что командная строка пуста). По умолчанию опция отключена.

Смена каталога по ссылкам. Установка этой опции приводит к тому, что Midnight Commander будет следовать логической цепочке подкаталогов при выполнении команд смены каталога как в панели, так и по команде cd. Так же ведет себя по умолчанию bash. Если же опция не включена, Midnight Commander будет при выполнении команды cd следовать реальной структуре каталогов, так что если вы вошли в текущий каталог по ссылке на него, то по команде cd .. вы окажетесь в его родительском каталоге, а не в том каталоге, где расположена ссылка.

Безопасное удаление. Если эта опция включена, непреднамеренно удалить файл будет сложнее. В диалоговых окнах подтверждения удаления предлагаемая по умолчанию кнопка изменяется с Да на Нет. По умолчанию эта опция отключена.[Layout]
Внешний вид

Диалоговое окно "Внешний вид" дает вам возможность изменить некоторые параметры отображения на экране главного окна программы Midnight Commander. Вы можете вывести на экран или отменить вывод строки главного меню, командной строки, строки подсказок, мини-статуса, строки с подсказкой по функциональным клавишам. На консоли Linux или FreeBSD можно задать число строк, которые будут оставлены для отображения вывода команды.

Можно также указать, должны ли панели располагаться горизонтально или вертикально, изменить размеры панелей.

По умолчанию вся информация отображаются одним цветом, но вы можете сделать так, чтобы права доступа и типы файлов были выделены другими цветамиColors. Если включено выделение цветом прав доступа, поля perm и mode в форматах выводаListing Mode..., показывающие права пользователя, запустившего программу Midnight Commander, выделены цветом, определенным ключевым словом selected. Если разрешено, подсветка имён файлов производится на основании правил из файла /etc/mc/filehighlight.ini. Смотрите Подсветка имён файловFilenames Highlight для получения большей информации.

При включенной опции Линейкаменю вызываемое при нажатии клавиши F9 меню будет отображаться постоянно.

Если включена опция Мини-статус, в нижней части каждой панели выводится строка информации о выделенном подсветкой файле или каталоге каждой панели.

Если включена опция Команднаястрока, в нижней части экрана будет отображаться приглашение командной строки.

Включение опции Меткиклавиш будет постоянно отображать в нижней части экрана строку подсказок функциональных клавиш.

Если включена опция Строкаподсказки, в нижней части экрана будут отображаться произвольно выбранные подсказки (tips) по приёмам работы с Midmight Commander.

При исполнении в эмуляторе терминала системы X11 Midnight Commander отображает в заголовке xterm текущий каталог и изменяет этот заголовок при необходимости. Если ваш эмулятор терминала неисправен и вы видите неверный заголовок при старте или изменении каталога, выключите параметр Заголовок xterm (Xterm Window Title).

Включение опции showfreespace, покажет свободное место / всего места на разделах.[Confirmation]
Подтверждения

Используя этот пункт меню, вы можете сделать так, чтобы перед выполнением операций удаления, перезаписи и запуска файла на выполнение, а также перед выходом из программы mc, выдавался дополнительный запрос на подтверждение.[Display bits]
Биты символов...

Этот пункт меню используется для задания диапазона отображаемых на дисплее символов. Если терминал поддерживает только 7-битный вывод, то нужно выбрать установку "7 бит". Выбрав "ISO-8859-1" вы получите все символы из таблицы ISO-8859-1, а выбор установки "Полный 8-битный вывод" имеет смысл на тех терминалах, которые могут отображать все 8-битовые символы.[Learn keys]
Распознавание клавиш...

Пункт Распознавание клавиш (Learn keys)Learn keys вызывает диалоговое окно, в котором вы можете протестировать работу некоторых клавиш (F1-F20, Home, End), которые работают не на всех типах терминалов.

В диалоговом окне появляется таблица с названиями клавиш, которые могут тестироваться. Вы можете перемещать подсветку по названиям, используя клавишу Tab или клавиши, применяемые в редакторе vi ('h' влево, 'j' вниз, 'k' вверх 'l' вправо). Если один раз нажать на клавиши со стрелками, после чего возле их названий в таблице появится пометка OK, то их тоже можно будет использовать для управления перемещением.

Для тестирования работы клавиш нужно нажать каждую клавишу из перечисленных в таблице. Если она работает нормально, возле ее названия в таблице появится пометка OK. После появления такой пометки клавиша начинает работать в ее обычном режиме. Например, первое нажатие на клавишу F1 приводит только к появлению пометки (если она работает нормально), а при следующих нажатиях будет вызываться окно подсказки. То же самое относится к клавишам стрелок. Клавиша Tab работает всегда.

Если какая-то клавиша не работает, то после нажатия на нее пометка OK не появится. В таком случае можно связать ту реакцию системы, которая должна была последовать за нажатием неработающей (отсутствующей) клавиши, с нажатием другой клавиши или комбинации клавиш. Для этого надо переместить подсветку на название неработающей клавиши (используя мышь или клавишу Tab) и нажать Enter или клавишу пробела. Должно появиться окно красного цвета, в котором вас просят нажать клавишу, которая будет использоваться вместо неработающей. Для отмены операции нажмите Esc и дождитесь, пока красное окно исчезнет. Либо выберите и нажмите ту комбинацию клавиш, которая будет служить заменой для неработающей клавиши (и тоже дождитесь закрытия окна).

Когда закончите тестирование и настройку всех клавиш, вы можете сохранить эти настройки в секции [terminal:TERM] вашего файла ~/.mc/ini (где TERM - название используемого терминала) либо отказаться от запоминания изменений. Если все клавиши работают нормально, то сохранение, конечно, не требуется.[Virtual FS]
Виртуальные файловые системы

Этот пункт меню позволяет задать некоторые параметры кэширования информации о виртуальных файловых системахVirtual File System.

С целью ускорения доступа к файлам Midnight Commander сохраняет в оперативной памяти информацию, относящуюся к некоторым виртуальным файловым системам (например, списки файлов в каталогах удаленных ftp серверов).

Кроме того, для получения доступа к содержимому сжатых архивов (например, сжатых tar-файлов) Midnight Commander создает временные файлы на жестком диске.

Поскольку в обоих этих случаях расходуются ресурсы компьютера, у вас может появиться желание настроить некоторые параметры таким образом, чтобы уменьшить эти расходы или повысить скорость доступа к часто используемым файловым системам.

Файловая система архиватора tar очень разумно организует работу с архивными файлами: она сохраняет на диске структуру каталогов архива и, когда возникает необходимость обращения к информации из tar-файла, использует этот список для извлечения нужного файла.

В общем случае tar-файлы обычно хранятся в сжатом виде (простые tar-файлы - вымирающее явление), и в силу природы таких файлов (структура подкаталогов для tar-файлов недоступна для мгновенной загрузки/отображения), файловая система tar должна разархивировать файлы на диск во временный каталог и затем представить обращение к разархивированным файлам как обращение к tar-файлу.

А поскольку мы все любим быстро пролистывать файлы и хранить их в виде tar-архивов, стало самой обычной ситуацией когда сначала просматривают такой файл, выходят из него, а потом обращаются к нему снова. Поскольку разархивация - операция медленная, Midnight Commander кеширует информацию в памяти на некоторое время. По истечении этого интервала времени все ресурсы, выделенные этой файловой системе, будут освобождены. По умолчанию величина этого интервала устанавливается равной 1 минуте. Смотрите также Файловая система tarTar File System.

Файловая система FTP сохраняет список каталогов, полученный с FTP-сервера, в памяти (в кеше). Время, в течение которого этот список хранится в кеше, задается опцией Тайм-аут кеша каталога FTP. Слишком маленькое значение этого параметра будет замедлять все операции с файловой системой ftp, потому что каждое обращение к ней будет означать реальное обращение к удаленному ftp серверу.

Кроме того, в том же диалоговом окне можно задать имя прокси-сервера (proxy host), который будет использоваться для перекачки файлов по ftp и сконфигурировать Midnight Commander таким образом, чтобы всегда работать через прокси-сервер.

Пароль анонимного FTP: - пароль, используемый когда вы регистрируетесь как анонимный пользователь "anonymous". Для некоторых сайтов требуется полноценный электронный адрес, с другой стороны, вероятно, вы не захотите указывать свой настоящий электронный адрес для сайтов, которым не доверяете, особенно если не используется фильтрация нежелательной корреспонденции.

Также можно разрешить использование файла ~/.netrc, содержащего имена пользователей и пароли серверов FTP. Формат файла .netrc описан в .netrc (5).

Смотрите раздел о файловой системе FTPFTP File System для получения дополнительной информации.[Save Setup]
Сохранение установок

При загрузке Midnight Commander пытается считать значения различных установочных параметров из файла ~/.mc/ini. Если такого файла не существует, необходимая информация ищется в общесистемном конфигурационном файле mc.ini. Этот файл располагается в каталоге, путь к которому можно определить, запустив команду mc -f. (это можно сделать даже из командной строки MC). Если и этого файла не существует, MC использует установки по умолчанию.

Команда Сохранить настройки создает файл ~/.mc/ini, в котором записываются текущие значения параметров, задаваемых опциями меню Левая, ПраваяLeft and Right Menus и НастройкиOptions Menu.

Если вы включите опцию Автосохранение настроек (пункт меню "Настройки/Конфигурация"), MC будет автоматически сохранять текущие настройки при выходе из программы.

Значения некоторых параметров не могут быть изменены через пункты меню. Для изменения значений этих параметров вы должны отредактировать файл настроек с помощью какой-либо программы- редактора. Подробнее об этих параметрах смотрите в разделе Специальные установкиSpecial Settings.

[Executing operating system commands]
Выполнение команд операционной системы

Для того, чтобы во время работы с MC запустить любую команду ОС, вы должны либо набрать имя соответствующей программы в командной строке, либо выбрать имя программы в одной из панелей (переместив подсветку на имя файла программы), а затем нажать клавишу Enter.

Если вы нажимаете клавишу Enter в тот момент, когда подсветка указывает на имя файла, не являющегося исполняемым, Midnight Commander сравнивает расширение выбранного файла с расширениями, прописанными в файле расширенийExtension File Edit. Если в файле расширений найдется подраздел, задающий процедуры обработки файлов с данным расширением, то обработка файла производится в соответствии с заданными в этом подразделе командами. Перед обработкой выполняются простые макроподстановкиMacro Substitution.[The cd internal command]
Встроенная команда cd

Команда cd не передается на исполнение оболочке, а интерпретируется самой программой Midnight Commander. Поэтому при ее запуске возможны не все удобные макрорасширения и подстановки, доступные в оболочке, а только часть из них:

Замена тильды Символ тильды (~) будет заменен именем вашего домашнего каталога, а если вы добавите после тильды имя пользователя, эта конструкция будет заменена на имя домашнего каталога указанного пользователя.

Например, ~guest - это домашний каталог пользователя guest, в то время как ~/guest - это каталог guest в вашем домашнем каталоге.

Предыдущий каталог вы можете перейти в предыдущий каталог, используя специальное имя '-', то есть выполнив команду: cd -

Каталоги в CDPATH Если каталог, указанный команде cd, не является подкаталогом текущего каталога, то Midnight Commander использует значение переменной окружения CDPATH для поиска указанного каталога во всех каталогах, перечисленных в этой переменной.

Например, если переменной CDPATH присвоено значение ~/src:/usr/src, то из любого места в файловой системе вы сможете перейти в любой подкаталог каталогов ~/src и /usr/src, используя только относительные имена (cd linux вызовет переход в /usr/src/linux).[Macro Substitution]
Макроподстановки

Перед выполнением команд, задаваемых пунктами пользовательского менюMenu File Edit, вызываемых по расширению имени файлаExtension File Edit, или запускаемых из командной строки ввода, вначале выполняются простые макроподстановки.


"%i"    Отступ из пробелов, равный текущему положению курсора. Только для меню редактора.

"%y"    Тип синтаксиса текущего файла. Только для меню редактора.

"%k"    Имя файла блока редактора.

"%e"    Имя файла протокола ошибок исполнения сценариев редактора.

"%m"    Имя текущего файла меню.

"%f" и "%p"
        Текущее имя файла.

"%x"    Расширение текущего файла.

"%b"    Имя текущего файла без расширения.

"%d"    Имя текущего каталога.

"%F"    Текущее имя файла в неактивной панели.

"%D"    Имя текущего каталога в неактивной панели.

"%t"    Отмеченные файлы.

"%T"    Файлы, отмеченные в неактивной панели.

"%u" и "%U"
        Подобны макросам %t и %T, но дополнительно снимается отметка с файлов. Их можно использовать в скриптах, заданных для пункта меню или ассоциированных с расширением файла, только один раз, поскольку после их использования помеченных файлов не будет.

"%s" и "%S"
        Выбранные файлы: помеченные файлы, если такие есть; в противном случае файл, имя которого подсвечено.

"%cd"   Это специальный макрос, используемый для перехода из текущего каталога в каталог, указанный перед этим макросом. Используется в основном для обращения к виртуальным файловым системамVirtual File System.

"%view" Этот макрос используется для вызова встроенной программы просмотра. Может использоваться как с аргументами, так и без них. Если заданы аргументы, они должны быть заключены в фигурные скобки.

        Аргументами могут быть: ascii - для перевода программы просмотра в режим ascii; hex - для перевода программы просмотра в режим hex; nroff - для указания программе просмотра, что необходимо интерпретировать выделенные (bold) и подчеркнутые последовательности nroff; unformatted - указывает программе просмотра, что не нужно использовать команды nroff для выделения или подчеркивания текста;

"%%"    Символ %

"%{любой текст}"
        Запрос на подстановку. Будет выдаваться окно ввода, а текст из скобок выводится как подсказка. Макрос заменяется на текст, введенный пользователем в окне ввода. Пользователь может нажать ESC или F10 для того, чтобы отказаться от ввода. Этот макрос пока не работает в командной строке.

"%var{ENV-VAR:default}"
        Этот макрос будет заменяться на значение переменной окружения ENV-VAR, если она установлена, в противном случае будет использовано значение default. Это подобно конструкции ${VAR-def} в оболочке Борна.[The subshell support]
Поддержка subshell

Поддержка subshell - это опция компиляции, которая работает с оболочками bash, tcsh и zsh.

Если поддержка subshell включена, то Midnight Commander будет порождать точную копию (a concurrent copy) вашей оболочки (которая определена в переменной окружения SHELL или, если эта переменная не определена, в файле /etc/passwd) и запускать ее в псевдо-терминале, вместо того, чтобы каждый раз вызывать новую оболочку для выполнения команды. Введенная команда передается subshell. Это позволяет изменять значения переменных окружения, использовать функции shell и определять алиасы (aliases), которые будут действовать до выхода из программы Midnight Commander.

Если вы используете bash, можно указать команды, которые будут выполняться при запуске subshell, в файле ~/.mc/bashrc и специальную карту раскладки клавиатуры в файле ~/.mc/inputrc. Пользователи tcsh могут задать выполняемые при запуске команды в файле ~/.mc/tcshrc.

Во время выполнения приложения в subshell можно в любой момент нажать комбинацию клавиш C-o для переключения в Midnight Commander (выполняемая команда или приложение будут остановлены). Если вы прервали таким образом исполнение команды, вы не сможете запустить другую внешнюю команду, пока не завершите работу остановленного приложения.

Особенностью использования subshell является то, что подсказка (prompt), выводимая Midnight Commander будет той же самой, что и в вашей обычной оболочке.

В разделе Опции запускаOPTIONS приведена дополнительная информация о том, как можно управлять (настроить) subshell.[Chmod]
Права доступа (Chmod)

Диалоговое окно "Права доступа" предоставляет удобный интерфейс к команде chmod - команде изменения атрибутов доступа к файлам и каталогам. Доступ к этому окну можно получить по "горячей" комбинации клавиш C-x c.

Диалоговое окно "Права доступа" состоит из двух частей - Права доступа и Файл.

В части "Файл" отображается имя файла или каталога и права доступа на него в восьмеричной форме, а также указаны владелец и группа файла.

В части "Права доступа" перечислены атрибуты прав доступа к текущему файлу. В квадратных скобках возле соответствующего атрибута крестиком помечены те атрибуты, которые установлены для данного файла. Изменять установки атрибутов можно двумя способами. При первом способе непосредственно изменяется значение атрибута в квадратных скобках возле его названия. Для изменения значений атрибутов надо переместить подсветку на название соответствующего атрибута и нажать клавишу пробела.

Для перемещения подсветки по названиям атрибутов можно использовать клавиши-стрелки или клавишу Tab. Названия изменяемых атрибутов помечаются звездочкой и предполагаемое значение всех атрибутов в восьмеричном представлении прав доступа сразу же отображаются в части окна "Файл".

Для того, чтобы выбранные вами значения атрибутов прав доступа вступили в силу, надо нажать клавишу Enter или экранную кнопку [Установить] (с помощью мышки). Для отказа от изменения атрибутов нужно выбрать кнопку [Прервать]. Вместо выбора экранных кнопок можно воспользоваться "горячими" клавишами (выделенные буквы в названии атрибута).

Изменять права доступа к отдельному файлу можно только первым способом (описанным выше). Если вы хотите изменить атрибуты прав доступа сразу группы файлов или каталогов, вы тоже можете воспользоваться этим способом, только вместо экранной кнопки [Установить] или клавиши <Enter> должны выбрать кнопку [Установить все]. Второй способ заключается в том, что вы сначала помечаете те атрибуты, которые хотите изменить, с помощью клавиш <Ins> или <T>. Обратите внимание, что значение в квадратных скобках при этом не изменяется. После этого вы выбираете один из следующих вариантов действий (то есть одну из экранных кнопок):

[Отметить все] отмеченные атрибуты (и только они) будут установлены в те значения, которые указаны в квадратных скобках возле названия атрибута, причем для всех выбранных (помеченных) файлов; если атрибут не был отмечен, его значение для выбранных файлов не изменяется.

[Установить помеченное] для всех выбранных файлов бит, соответствующий данному атрибуту, будет установлен в 1.

[Очистить помеченное] для всех выбранных файлов бит, соответствующий данному атрибуту, будет установлен в 0.

[Установить] будут установлены атрибуты только для одного файла (первого из помеченных), причем установка производится так же, как по клавише [Отметить все].

[Прервать] отказаться от выполнения команды Chmod.[Chown]
Владелец/группа (Chown)

Пункт меню "Владелец/группа" используется для того, чтобы изменить владельца файла или группу, которая имеет какие-то права на файл. "Горячая" клавиша для вызова этого пункта меню - C-x o.[Advanced Chown]
Расширенная команда Chown

Выбрав пункт меню "Расширенная команда Chown", вы увидите окно, совмещающее в себе окна, появляющиеся при выборе пунктов Права доступа (Chmod)Chmod и Владелец/группа (Chown)Chown. В этом окне можно изменить как права доступа к файлу, так и владельцев файла.[File Operations]
Операции с файлами

Когда вы выполняете операции копирования, перемещения или удаления файлов, Midnight Commander отображает на экране диалоговое окно, в котором показано, какой(ие) файл(ы) в данный момент обрабатывается и как идет процесс обработки. Для отображения процесса обработки на экран выводится до трех диаграмм-полосок (progress bars). Первая (file bar) показывает, какая часть текущего файла обработана (например, скопирована). Вторая (count bar) показывает, какая доля помеченных файлов обработана на текущий момент. Третья (bytes bar) показывает долю выполненных работ (в процентах от суммарного объема помеченных файлов). Если отключена опция "Детали операций" (см. "Настройки/Конфигурация"), две последних диаграммы не отображаются.

В нижней части этого диалогового окна имеются две кнопки. Нажатие на кнопку <Пропустить> приведет к тому, что будет пропущена обработка текущего файла. Нажатие на кнопку <Прервать> прерывает выполнение заданной операции, все оставшиеся файлы будут пропущены.

В процессе выполнения файловых операций вы можете увидеть окна еще трех видов.

Окно ошибок информирует об ошибке и предлагает три варианта продолжения. Обычно вы выбираете либо вариант <Пропустить> для того, чтобы исключить из обработки файл, на котором споткнулась программа, либо <Прервать>, чтобы вообще отменить выполнение заданной операции. Третий вариант, <Повторить>, выбирается тогда, когда вам удалось устранить причину сбоя (например, воспользовавшись другим терминалом).

Окно подтверждения перезаписи появляется тогда, когда вы пытаетесь переписать существующий файл. В этом окне отображаются время создания и размер файла-источника и файла-приемника (то есть перезаписываемого файла, который фактически будет уничтожен). Ниже выведены два вопроса. На первый вопрос ("Переписать этот файл?") предлагается три варианта ответа:

согласиться (кнопка <Да>);

отказаться, то есть пропустить перезапись текущего файла (кнопка <Нет>);

дописать содержимое файла-источника в конец файла-приемника (кнопка <дописать в Конец>).

Выбор одного из вариантов ответа на второй вопрос ("Переписать все файлы?") позволяет принять одно решение по всем выбранным для обработки файлам (чтобы окно запроса не появлялось каждый раз). Предлагается 4 варианта решения:

<Все>
        перезаписались без дополнительных вопросов все выбранные файлы;

<Устаревшие>
        перезапишутся (затрутся) только файлы, которые созданы раньше файла-источника;

<ни Одного>
        не перезаписывать файлы (но если не существует файла-приемника, то копирование источника будет произведено);

<Различающиеся по длине>
        Вы можете отказаться от выполнения операции, если нажмете клавишу <Прервать> в нижней части окна запроса. Выбор экранной кнопки производится клавишами стрелок или клавишей табуляции.

Окно запроса на рекурсивное удаление появляется в том случае, когда вы пытаетесь удалить непустой каталог. По кнопке <Да> каталог будет удален вместе со всеми файлами, <Нет> означает отказ от удаления каталога, <Все> надо выбирать, если вы отметили группу подкаталогов для удаления и уверены в своем выборе, <ни Одного> - чтобы пропустить все непустые каталоги из числа помеченных, <Прервать> означает отказ от выполнения операции удаления. Выбирайте <Да> или <Все> только в том случае, когда вы действительно уверены, что хотите удалить каталог со всеми вложенными подкаталогами.

Если вы пометили для обработки группу файлов, то после выполнения операции будет снята отметка только с тех файлов, которые успешно обработаны. Пропущенные файлы останутся помеченными.[Mask Copy/Rename]
Маски файлов для операций копирования/переименования

При выполнении операций копирования и перемещения (или переименования) файлов вы имеете возможность изменить имена копируемых или перемещаемых файлов. Для этого вы должны задать маску для имен файлов-источников и маску для имен файлов, которые будут созданы (файлы-приемники). Обычно эта вторая маска представляет собой несколько символов замены (wildcards) в конце строки, определяющей место назначение создаваемых файлов. Все файлы, удовлетворяющие маске источника, будут переименованы (скопированы или перемещены с новыми именами) в соответствии с маской файла-приемника. Если имеются помеченные файлы, то копируются (перемещаются) только помеченные файлы, удовлетворяющие заданной маске для файлов-источников.

Есть еще несколько опций, которые влияют на выполнение операций копирования/перемещения файлов, и которые устанавливаются в том же окне запроса, где задаются маски имен файлов:

"Разыменовывать ссылки" (Follow links) определяет, будут ли при копировании жестких или символических ссылок в каталоге- приемнике (и рекурсивно в подкаталогах) создаваться такие же ссылки, или будут копироваться файлы (и подкаталоги), на которые эти ссылки указывают.

"Внутрь каталога, если есть" (Dive into subdirs) определяет, что делать, если в каталоге-приемнике уже существует подкаталог, имя которого совпадает с именем файла (каталога), который копируется (источника). По умолчанию (опция отключена) содержимое каталога-источника копируется в каталог-приемник. Если опция включена, то в каталоге приемнике будет создан новый подкаталог с тем же именем, в который и будет осуществляться копирование. Лучше показать это на примере:

Пусть вы хотите скопировать содержимое каталога foo в каталог /bla/foo, который уже существует. Обычно (опция отключена) mc будет просто копировать все файлы из foo в /bla/foo. Если опцию включить, копирование файлов будет производиться в /bla/foo/foo.

"Сохранять атрибуты" (Preserve attributes) определяет, будут ли при копировании/перемещении сохранены атрибуты исходного файла: права доступа, временные метки и, если вы root, UID и GID исходного файла. Если опция отключена, атрибуты будут установлены в соответствии с текущим значением umask.

Опция "Образцы в стиле shell" включена.

Когда опция "Образцы в стиле shell" включена, можно использовать символы замены (wildcards) '*' и '?' в маске источника. Они обрабатываются аналогично тому, как это делается в shell. В маске приемника разрешается использовать только '*' и '\<цифра>'. Первый символ '*' в маске приемника соответствует первой группе символов замены в маске источника, второй символ '*' соответствует второй группе и т.д. Аналогично, символ замены &'\1' соответствует первой группе символов замены в маске источника, символ '\2' - второй группе и т.д. до &'\9'. Символ &'\0' соответствует целому имени файла-источника.

Два примера:

Если маска источника "*.tar.gz", а приемник - "/bla/*.tgz" и имя копируемого файла - "foo.tar.gz", копия будет называться "foo.tgz" и будет находиться в каталоге "/bla".

Предположим вы хотите поменять местами имя и расширение файла, так чтобы "file.c" стал файлом "c.file". Маска источника для этого должна иметь вид "*.*", а маска приемника - "\2.\1".

Опция "Образцы в стиле shell" выключена.

Когда опция "Образцы в стиле shell" (Use shell patterns) выключена, MC не осуществляет автоматической группировки. Для указания групп символов в маске источника, которые будут соответствовать символам замены в маске приемника, вы должны в этом случае использовать скобки '\(...\)'. Этот способ более гибкий, но требует больше усилий при вводе.

Два примера:

Если маска источника имеет вид "^\(.*\)\.tar\.gz$", копирование производится в "/bla/*.tgz" и копируется файл "foo.tar.gz", то результатом будет "/bla/foo.tgz".

Предположим, что вы хотите поменять местами имя файла и его расширение, так чтобы имена вида "file.c" приняли вид "c.file". Маска источника для этого - "^\(.*\)\.\(.*\)$", а маска приемника - "\2.\1".

"Преобразование регистра"

Вы можете также преобразовать регистр символов в именах файлов. Если вы используете '\u' или '\l' в маске приемника, то следующий символ имени будет образован в верхнем (заглавные символы) или нижнем (строчные) регистре соответственно.

Если использовать в маске приемника '\U' или '\L', то к соответствующему регистру будут преобразованы все последующие символы, вплоть до следующего вхождения '\E' или '\U', появления символа '\L' или конца имени файла.

Применение '\u' и '\l' обеспечивает более широкие возможности, чем '\U' и '\L'.

Например, если маска источника есть '*' (опция "Образцы в стиле shell" включена) или '^\(.*\)$' (опция "Образцы в стиле shell" выключена), а маска приемника есть '\L\u*', имена файлов будут преобразованы таким образом, что первые буквы имени будут заглавными, а все остальные - строчными.

Символ '\' в масках используется для отмены специальной интерпретации отдельных символов. Например, '\\' означает просто backslash и '\*' означает просто звездочку (asterisk).

"Изменять относительные ссылки" (Stable Symlinks) указывает, что Midnight Commander, должен изменять символические ссылки. Скопированные символические ссылки будут указывать на то же расположение, что и оригинальная ссылка, при этом дописываются необходимые ../ и другие каталоги[Select/Unselect Files]
Select/Unselect Files

Диалоговое окно параметров отметки группы файлов по заданному шаблону. Строка вводаInput Line Keys предназначена для ввода регулярного выражения (маски) для помети файлов. Если включена опция Только файлы, то выделены будут только файлы. Если опция Только файлы, отключена, то выделены будут как файлы, так и каталоги. Если включена опция Образцы в стиле shell (Shell Patterns), регулярные выражение строятся по тем же правилам, которые действуют в оболочке shell (* означает ноль или большее число любых символов, а ? заменяет один произвольный символ). Если опция Образцы в стиле shell (Shell Patterns) отключена, то пометка файлов производится по правилам обработки нормальных регулярных выражений (смотрите ed (1)). Если включена опция С учётом регистра то пометка файлов и каталогов будет производиться с учетом регистра символов имён. Если опция С учётом регистра отключена, то регистр символов учитываться не будет.[Internal File Viewer]
Встроенная программа просмотра файлов

Встроенная программа просмотра файлов имеет два режима просмотра: режим ASCII и шестнадцатеричный (hex). Для переключения режимов используется клавиша F4. Если у вас установлена программа gzip проекта GNU, она будет использована для автоматического просмотра сжатых файлов.

Встроенная программа просмотра всегда пытается использовать для отображения информации лучший из методов, предоставляемых вашей системой для данного типа файла. Некоторые последовательности символов интерпретируются для задания таких атрибутов, как жирный шрифт и подчеркивание, обеспечивая более наглядное представление информации.

В шестнадцатеричном режиме функция поиска позволяет задать строку поиска как в обычном текстовом виде (заключенном в кавычки), так и в виде шестнадцатеричных констант. Можно даже одновременно использовать в шаблоне поиска как ту, так и другую форму представления, например:

"String" -1 0xBB 012 "more text"

Обратите внимание, что 012 является восьмеричным числом, -1 преобразовывается в 0xFF, а текст между кавычками и константами игнорируется.

Некоторые детали внутренней реализации программы просмотра: на системах, которые предоставляют системный вызов mmap(2) программа отображает файл в память вместо его загрузки; иначе, а также если при вызове mmap возникает сбой или c файлом связано некоторое действие, которое требует фильтр, программа использует динамически распределяемые буфера памяти, загружая только те части файла, к которым вы обращаетесь (это относится к архивированным файлам).

Ниже приводится перечень всех клавиш и их комбинаций, с которыми ассоциированы некие действия встроенной программы просмотра.

F1 Вызывает просмотр встроенной гипертекстовой подсказки.

F2 Переключает режим переноса строки.

F4 Переключает между ASCII и шестнадцатеричным режимами.

F5 Переход к строке по номеру. Будет запрошен номер строки, к просмотру которой вы хотите перейти.

F6, / Поиск по регулярному выражению.

? Поиск назад по регулярному выражению.

F7 Вызов диалогового окна для задания шаблона поиска для обычного и шестнадцатеричного поиска.

C-s, F17, n Если шаблон поиска еще не задан, вызывается диалоговое окно для его задания, иначе повторяется поиск (дальше по тексту) в соответствии с ранее определенным шаблоном.

C-r То же, что и C-s, но поиск производится в обратном направлении.

n Найти следующее совпадение.

F8 Переключение между режимами Raw/Parsed: файл отображается либо в том виде, как он записан на диске, либо пропущенным через фильтр, который задан для этого типа файлов в mc.ext. Текущий режим отображения всегда обратный по отношению к тому, который указан на экранной кнопке F8, поскольку на кнопке указывается режим, к которому осуществляется переход по данной кнопке.

F9 Переключение между режимами отображения текста в форматированном и неформатированном виде: в режиме отображения форматированного текста некоторые последовательности символов отображаются другим цветом для выделения жирного и подчеркнутого шрифта. Как и в предыдущем случае, на кнопке указан режим, обратный по отношению к текущему.

F3, F10, Esc, q Выйти из встроенной программы просмотра.

PageDown, пробел, C-v Переместиться на страницу вперед.

PageUp, M-v, backspace. Переместиться на страницу назад.

стрелка вниз Переместиться на одну строку вперед.

стрелка вверх Переместиться на одну строку назад.

C-l Обновить изображение на экране.

C-o Переключиться в subshell и показать окно команд.

! Запустить новый экземпляр оболочки в текущем каталоге (временный выход в shell, возврат в программу просмотра по C-d).

"[n] m" Установить метку с номером n (кавычки не вводятся).

"[n] r" Переместиться к метке с номером n.

C-f Перейти к просмотру следующего файла текущего каталога.

C-b Перейти к просмотру предыдущего файла в текущем каталоге.

M-r Переключение режима отображения линейки (вверху/внизу/отключена).

Можно настроить режимы отображения файлов встроенной программой просмотра, воспользовавшись файлом расширенийExtension File Edit.[Internal File Editor]
Встроенный редактор

Встроенный редактор обеспечивает выполнение большинства функций редактирования, присущих полноэкранным редакторам текста. Он вызывается нажатием клавиши F4 при условии, что в инициализационном файле установлена в 1 опция use_internal_edit. Размер редактируемого файла не может превышать 16 Мегабайт. С помощью этого редактора можно редактировать двоичные файлы без потери данных.

Поддерживаются следующие возможности: копирование, перемещение, удаление, вырезание и вставка блоков текста; отмена предыдущих операций (key for key undo); выпадающие меню; вставка файлов; макроопределения; поиск и замена по регулярным выражениям; выделение текста по комбинации клавиш shift-стрелки в стиле MSW-MAC (только для linux-консоли); переключение между режимами вставки-замены символа; а также операция обработки блоков текста командами оболочки (an option to pipe text blocks through shell commands like indent).

Разделы:

        Опции в ини-файле для редактораInternal File Editor / options

Редактор очень прост и практически не требует обучения. Для того, чтобы узнать, какие клавиши вызывают выполнение определенных действий, достаточно просмотреть выпадающие меню, которые вызываются нажатием клавиши F9 в окне редактора. Не перечисленные в меню комбинации клавиш: Shift-<клавиши стрелок> выделение блока текста. Ctrl-Ins копирует блок в файл cooledit.clip. Shift-Ins производит вставку последнего скопированного в cooledit.clip блока в позицию курсора. Shift-Del удаляет выделенный блок текста, запоминая его в файле cooledit.clip. По клавише Enter вставляются символы конца строки, причем на следующей строке автоматически устанавливается отступ. Работает выделение текста с помощью мыши, причем если удерживать клавишу Shift, то управление мышью осуществляется терминальным драйвером мыши.

Для того, чтобы определить макрос, нажмите Ctrl-R, после чего введите строки команд, которые должны быть выполнены. После завершения ввода команд снова нажмите Ctrl-R и свяжите макрос с какой-нибудь клавишей или комбинацией клавиш, нажав эту клавишу (комбинацию). Макрос будет вызываться нажатием Ctrl-A и назначенной для него клавиши. Макрос можно также вызвать нажатием любой из клавиш Meta (Alt), Ctrl, или Esc и назначенной макросу клавиши, при условии, что данная комбинация не используется для вызова какой-либо другой функции. Макрокоманды после определения записываются в файл .mc/cedit/cooledit.macros в вашем домашнем каталоге. Вы можете удалить макрос удалением соответствующей строки в этом файле.

По клавише F19 (ее нет на обычной клавиатуре IBM PC, так что придется пользоваться соответствующим пунктом меню, вызываемым по клавише F9, или переназначить клавишу) будет осуществляться форматирование выделенного блока кода на языке C, C++ или других. Форматирование управляется файлом /usr/local/share/mc/edit.indent.rc который при первом вызове копируется в .mc/cedit/edit.indent.rc в вашем домашнем каталоге.

Встроенный редактор обрабатывает символы из второй половины кодовой таблицы (160+). Но когда редактируете бинарные файлы, лучше установить опцию "Биты символов" (Display bits) из меню "Настройки" в положение "7 бит", чтобы сохранить формат файла (to keep the spacing clean).

Описать все функции встроенного редактора в данной подсказке невозможно. Запомните только, что все основные операции можно выполнить через пункты меню, которое вызывается нажатием клавиши F9 в окне редактирования. Кроме того, можно прочитать man-страницу по команде man mcedit или info mcedit[Internal File Editor / options]
Опции в ини-файле для редактора

В данном разделе кратко описаны опции ini-файла, относящиеся к редактору. Опции записываются в секцию '[Midnight Commander]'

editor_wordcompletion_collect_entire_file
        При автодополнении для сбора похожих слов слов просматривать весь файл(1) или только от начала до курсора (0)[Completion]
Завершение ввода (Completion)

Заставьте Midnight Commander работать на клавиатуре вместо вас!

Завершение ввода - это попытка закончить за вас ввод текста, набранного до текущей позиции курсора. MC пытается завершить ввод, трактуя уже введенный текст как переменную (если текст начинается с $), имя пользователя (если текст начинается с ~), имя машины (если текст начинается на @) или как команду (если вы в командной строке в позиции, где вы можете вводить команду; в этом случае для завершения ввода используются зарезервированные слова оболочки, в том числе любая из встроенных команд оболочки). Если введенный текст не попадает ни в одну из перечисленных категорий, выполняется попытка завершения текста как имени файла.

Завершение имен файлов, пользователей, переменных и машин работает во всех строках ввода, завершение команд - только в командной строке. Если однозначно выполнить завершение ввода невозможно (имеется несколько вариантов), MC издает звуковой сигнал и выполняет следующие действия, в зависимости от установки опции Дополнение: показывать все в пункте меню Настройки/КонфигурацияConfiguration. Если эта опция включена, список всех возможных вариантов завершения появляется возле текущей позиции и вы можете выбрать нужный вариант с помощью клавиш стрелок и Enter. Вы можете также набрать следующую букву, чтобы перейти к подмножеству всех возможных завершений. Если вы снова нажмете M-Tab, будет выведено уже сокращенное множество вариантов, причем в строку ввода добавляются те символы, которые определяются однозначно (даже если полное завершение ввода еще невозможно). Как только неопределенность выбора исчезает, пропадает и диалоговое окно с вариантами. Вы можете отказаться от вывода на экран этого окна в любое время, нажав одну из клавиш Esc, F10 или стрелку влево / вправо. Если опция Дополнение: показывать всеConfiguration отключена, окно с вариантами завершения появляется только тогда, когда вы нажмете клавиши M-Tab второй раз, при первом нажатии MC только издает звуковой сигнал.[Virtual File System]
Виртуальные файловые системы

Программа Midnight Commander содержит подпрограммы, обеспечивающие доступ к различным файловым системам. Эти подпрограммы (их совокупность называется переключателем виртуальных файловых систем - virtual file system switch) позволяют Midnight Commander-у манипулировать файлами, расположенными на не-Unix-овых файловых системах.

В настоящее время Midnight Commander обеспечивает поддержку нескольких Виртуальных Файловых Систем - ВФС (VFS):
- локальной файловой системы, используемой для обычных файловых систем Unix;
- файловой системы ftpfs, используемой для манипулирования файлами на удаленных компьютерах по протоколу FTP;
- файловой системы tarfs, используемой для обработки tar- и сжатых tar-файлов;
- файловой системы undelfs, используемой для восстановления удаленных файлов в файловой системе ext2 (файловая система, используемая в Linux по умолчанию);
- файловой системы fish (для манипулирования файлами при работе с оболочкой через такие программы как rsh и ssh);
- и, наконец, сетевой файловой системы nfs.
MC может быть собран с поддержкой файловой системы smbfs, используемой для манипулирования файлами на удаленных компьютерах по протоколу SMB (CIFS).

Подпрограммы работы с виртуальными файловыми системами интерпретируют все встречающиеся имена путей и формируют корректные обращения к различным файловым системам. Форматы обращения к каждой из виртуальных файловых систем описаны в отдельных разделах по каждой ВФС:

        Файловая система ftpfs (FTP File System)FTP File System
        Файловая система tarTar File System
        Файловая система FISH (FIle transfer over SHell)FIle transfer over SHell filesystem
        Файловая система NFS (Network File System)Network File System
        Файловая система UFS (Undelete File System)Undelete File System
        Файловая система smbfsSMB File System[FTP File System]
Файловая система ftpfs (FTP File System)

Файловая система ftpfs позволяет работать с файлами на удаленных компьютерах. Для этого можно использовать команду "FTP-соединение" (доступную из меню левой и правой панелей) или же непосредственно сменить текущий каталог командой cd, задав путь к каталогу следующим образом:

/#ftp:[!][user[:pass]@]machine[:port][remote-dir]

Элементы user, port и remote-dir не обязательны. Если элемент user указан, то Midnight Commander будет пытаться регистрироваться на удаленном компьютере с эти именем, в противном случае будет использовано имя anonymous или имя из файла ~/.netrc. Необязательный элемент pass (если указан) используется как пароль для входа. Однако явно задавать его не рекомендуется (также не записывайте его в ваши hotlist, если только вы не обеспечили соответствующую защиту этих файлов; но и тогда нельзя быть полностью уверенным в безопасности).

    /#ftp:ftp.nuclecu.unam.mx/linux/local
    /#ftp:tsx-11.mit.edu/pub/linux/packages
    /#ftp:!behind.firewall.edu/pub
    /#ftp:guest@remote-host.com:40/pub
    /#ftp:miguel:xxx@server/pub

Для того, чтобы соединиться с сервером, который расположен за firewall, нужно использовать префикс /#ftp:! (то есть добавить восклицательный знак перед именем сервера), чтобы указать Midnight Commander на необходимость использовать прокси для осуществления передач по ftp. Вы можете задать имя прокси в диалоговом окне Виртуальные ФС...Virtual FS меню "Настройки".

Чтобы не задавать имя прокси-сервера каждый раз, можно поставить отметку в квадратных скобках возле опции Всегда использовать FTP прокси в диалоговом окне Виртуальные ФС...Virtual FS меню "Настройки". В таком случае программа всегда будет использовать указанный прокси-сервер. При этом (если опция установлена) программа делает следующее: считывает из файла /usr/local/share/mc/mc.no_proxy имена локальных машин (если имя начинается с точки, оно считается именем домена), и, если заданное при установлении FTP-соединения имя машины совпадает с одним из имен, указанных в файле mc.no_proxy без точки, то производит прямое обращение к данной машине.

При подключении к ftp-серверу через фильтрующий пакеты маршрутизатор (If you are using the ftpfs code with a filtering packet router), который не позволяет использовать обычный режим открытия файлов, можно заставить программу работать в режиме пассивного открытия файла (the passive-open mode). Для этого установите в инициализационном файле опцию ftpfs_use_passive_connections в 1.

Midnight Commander сохраняет в течение заданного интервала времени список файлов удаленного каталога, прочитанный по FTP, в оперативной памяти. Величина этого интервала времени задается в диалоговом окне Виртуальные ФС...Virtual FS меню "Настройки". В силу этого возможен побочный эффект, заключающийся в том, что даже если вы сделали какие-то изменения в каталоге, они не будут отображаться в панели до тех пор, пока вы не обновите содержимое панели командой C-r. Это не является недоработкой (если вы думаете, что это ошибка, поразмыслите над тем, как происходит работа по FTP с файлами, находящимися на другой стороне Атлантического океана).[Tar File System]
Файловая система tar

Файловая система tar обеспечивает доступ по чтению к tar- и сжатым tar-файлам, используя команду chdir. Для перехода в каталог, представляющий список файлов tar-файла, нужно использовать команду, имеющую следующий формат:

cd ./filename.tar#utar/[dir-inside-tar]

Файл mc.ext по умолчанию содержит команды для просмотра tar-файлов, то есть обычно для получения списка файлов tar-архива достаточно просто переместить указатель на имя tar-файла и нажать Enter. Чтобы понять, как это достигается, смотрите раздел Файл расширенийExtension File Edit.

Примеры:

    mc-3.0.tar.gz#utar/mc-3.0/vfs
    /ftp/GCC/gcc-2.7.0.tar#utar

В последнем примере указан полный путь к tar-архиву.[FIle transfer over SHell filesystem]
Файловая система FISH (FIle transfer over SHell)

Файловая система fish - это сетевая файловая система, которая позволяет работать с файлами на удаленном компьютере так, как если бы они были расположены на вашем диске. Для того, чтобы это было возможно, на удаленном компьютере должен быть запущен fish-сервер, или bash-совместимая оболочка shell.

Для соединения с удаленным компьютером нужно выполнить команду перехода в каталог (chdir), имя которого задается в следующем формате:

/#sh:[user@]machine[:options]/[remote-dir]

Элементы user, options и remote-dir не обязательны. Если задан элемент user, то Midnight Commander будет регистрироваться на удаленный компьютер под этим именем, в противном случае - под тем именем, с которым вы зарегистрированы в локальной системе.

В качестве options могут использоваться:
  'C' - использовать сжатие;
  'r' - использовать rsh вместо ssh;
  port - использовать данный порт для поключения
к удалённому компьютеру.
Если задан элемент remote-dir, то указанный каталог станет текущим после соединения с удаленным компьютером.

Примеры:

    /#sh:onlyrsh.mx:r/linux/local
    /#sh:joe@want.compression.edu:C/private
    /#sh:joe@noncompressed.ssh.edu/private
    /#sh:joe@somehost.ssh.edu:2222/private
[Network File System]
Файловая система NFS (Network File System)

Файловая система mc - это еще одна сетевая файловая система, которая позволяет работать с файлами на удаленном компьютере. Для того, чтобы можно было воспользоваться этой ФС, на удаленном компьютере должна быть запущена серверная программа mcserv(8).

Для соединения с удаленным компьютером нужно выполнить команду перехода в каталог, имя которого строится в соответствии со следующим форматом:

/#mc:[user@]machine[:port][remote-dir]

Элементы user, port и remote-dir не обязательны.

Если задан элемент user, то Midnight Commander будет регистрироваться на удаленный компьютер под этим именем, в противном случае - под тем именем, с которым вы зарегистрированы в локальной системе.

Элемент port используется в том случае, если удаленный компьютер использует специальный порт (чтобы узнать, что такое порт и как его использовать, смотрите страницу руководства mcserv(8). Если задан элемент remote-dir, то указанный каталог станет текущим после соединения с удаленным компьютером.

Примеры:

    /#mc:ftp.nuclecu.unam.mx/linux/local
    /#mc:joe@foo.edu:11321/private
[Undelete File System]
Файловая система UFS (Undelete File System)

В ОС Linux можно сконфигурировать файловую систему ext2fs, используемую по умолчанию, таким образом, что появится возможность восстанавливать удаленные файлы (но только в файловой системе ext2). Файловая система UFS (Undelete File System) представляет собой интерфейс к библиотекам ext2fs, позволяющий восстановить имена всех удаленных файлов, выбрать некоторое количество таких файлов и восстановить их.

Для того, чтобы воспользоваться этой возможностью (этой файловой системой), нужно выполнить команду перехода (chdir) в специальный каталог, имя которого образуется из префикса "/#undel" и имени специального файла устройства, на котором находится реальная файловая система.

Например, чтобы восстановить удаленные файлы на втором разделе первого SCSI-диска, нужно использовать следующее имя:

    /#undel:sda2

Загрузка списка удаленных файлов требует некоторого времени, так что наберитесь терпения. Имейте в виду, что имена файлов в полученном списке будут цифровыми, так что поиск нужного придется проводить либо по дате, либо последовательным просмотром содержимого (в общем, я вам не завидую!).[SMB File System]
Файловая система smbfs

Файловая система smbfs позволяет работать с файлами на удаленных компьютерах по протоколу SMB (CIFS) (Windows for Workgroups, Windows 9x/ME/XP, Windows NT, Windows 2000 и Samba). Для этого можно использовать пункт "SMB связь..." (доступный из меню левой и правой панелей) или же непосредственно сменить текущий каталог командой cd, задав путь к каталогу следующим образом:

/#smb:[username@]machine[/service][/remote-dir]

Элементы username, service и remote-dir необязательны. username, domain и password могут быть указаны в окне диалога.

Примеры:

    /#smb:machine/Share
    /#smb:other_machine
    /#smb:guest@machine/Public/Irlex
[Colors]
Цвета

Программа Midnight Commander пытается определить, поддерживает ли ваш терминал цвета, используя для этого базу данных о терминалах и имя вашего терминала. Иногда это не удается. В таких случаях можно включить или отключить цветной вывод, используя ключи запуска программы -c и -b, соответственно.

Программа может быть скомпилирована с использованием библиотек ncurses или slang. ncurses не дает возможности включать цветной режим: ncurses использует только информацию из базы данных о терминалах. Для того, чтобы узнать, какая библиотека была использована при компиляции, дайте команду mc -V.

Если программа скомпилирована с использованием менеджера экрана S-Lang, она проверяет значение переменной COLORTERM. Задание этой переменной дает тот же эффект, что и задание ключа -c.

Можно указать терминалы, которые всегда должны работать в цветном режиме, добавив строку color_terminals в секцию Colors инициализационного файла. В этом случае Midnight Commander не будет пытаться определить, поддерживает ли ваш терминал цветной вывод. Пример:

[Colors]
color_terminals=linux,xterm
color_terminals=terminal-name1,terminal-name2...

Midnight Commander обеспечивает также возможность изменять цвета, заданные по умолчанию. В настоящее время таблица используемых цветов задается переменной MC_COLOR_TABLE или в секции Colors инициализационного файла.

В секции Colors загружаемая по умолчанию таблица цветов определяется переменной (строкой) base_color. Вы можете указать альтернативную таблицу цветов для терминала, используя имя терминала как ключ в этой секции. Пример:

[Colors]
base_color=
xterm=menu=magenta:marked=,magenta:markselect=,red

Формат определения цвета:

  <keyword>=<foregroundcolor>,<backgroundcolor>:<keyword>= ...

Цвета не являются обязательными, а в качестве ключевых слов (keywords) могут использоваться: для задания цветовой палитры в панелях: normal, selected, marked, markselect, errors, input, reverse, gauge; Цвета пунктов меню: menunormal, menusel, menuhot, menuhotsel, menuinactive; Цвета в окне диалога: dnormal, dfocus, dhotnormal, dhotfocus; Цвета в окне подсказки: helpnormal, helpitalic, helpbold, helplink, helpslink; в окне программы просмотра: viewunderline; специальные подсветки: executable, directory, link, device, special, core; в окне редактора: editnormal, editbold, editmarked.

Цвета задавать не обязательно. Цвет какого именно поля определяется каждым ключевым словом, можно понять из перевода этого ключевого слова. Некоторые случаи требуют пояснений.

input определяет цвета в строке ввода в диалоговых окнах.

gauge определяет цвет заполненной части полоски (progress bar), при графическом отображении хода выполнения файловых операций (копирование и др.).

Диалоговые окна используют следующие цвета: dnormal используется для нормального текста, dfocus - цвет, используемый для выделенного в данный момент компонента окна, dhotnormal - цвет, используемый для выделения "горячих" клавиш в обычных компонентах, в то время как цвет dhotfocus используется для выделения "горячих" клавиш в выбранных в данный момент компонентах окна.

В меню используется та же самая схема, только в качестве названий элементов используются menunormal, menusel, menuhot, menuhotsel и menuinactive.

Окно подсказки использует следующие цвета: helpnormal - для отображения простого текста, helpitalic - для вывода текста, выделенного в man-страницах курсивом, helpbold - для вывода текста, выделенного в man-страницах жирным шрифтом, helplink - для выделения неактивных гиперссылок, helpslink - для выделения активной в данный момент гиперссылки.

Возможные цвета: black, gray, red, brightred, green, brightgreen, brown, yellow, blue, brightblue, magenta, brightmagenta, cyan, brightcyan, lightgray и white.

Для прозрачного фона используются специальное ключевое слово 'default'. Слово 'default' можно использовать только при задании цвета фона. Пример:

[Colors]
base_color=normal=white,default:marked=magenta,default
[Skins]
Внешний вид

Вы можете изменить внешний вид Midhight Commander'а. Для этого необходимо указать файл, в котором указаны цвета и линии для отрисовки рамок. Такой файл называется далее скин-файл. переопределение внешнего вида полностью совместимо с заданием цветов, описанным в секции ЦветаColors.

Поиск скин-файла производится по следующему алгоритму (до первого нахождения файла):

        1) параметр командной строки -S <скин> или --skin=<скин>
        2) Переменная окружения MC_SKIN
        3) В конфигурационном файле параметр skin в секции [MidhightCommander]
        4) Файл /etc/mc/skins/default.ini
        5) Файл /usr/local/share/mc/skins/default.ini

Параметры в трёх первых случаях могут содержать абсолютный путь к скин-файлу либо просто название скина (с расширением .ini либо без него). В данном случае поиск скин-файла будет происходить по следующим каталогам (до первого нахождения):

        1) ~/.mc/skins/
        2) /etc/mc/skins/
        3) /usr/local/share/mc/skins/

Для получения расширенной информации, обратитесь к подразделам:

        Описание секций и параметровSkins sections
        Опеределения цветовых парSkins colors
        Линии для отрисовки рамокSkins lines
        СовместимостьSkins oldcolors
[Skins sections]
Описание секций

Секция [skin] содержит информацию, относящуюся к самому скин-файлу. Параметр description кратко описывает скин.

Секция [filehighlight] содержит описания цветовых пар для групп подсветок имен файлов. Названия параметров в секции должно совпадать с названиями секций в файле подсветки. Смотрите раздел Подсветка имён файловFilenames Highlight для получения подробной информации.

Секция [core] содержит описание элементов, используемых повсеместно.

_default_
        Цвет по умолчанию. Используется во всех остальных секциях (глобальный параметр), если в них нет переопределения

selected
        курсор

marked  отмеченные данные

markselect
        курсор на отмеченных данных

gauge   цвет заполненной части полоски (progress bar)

input   элемент ввода данных

reverse инвертированный цвет

Секция [dialog] содержит описания элементов диалоговых окон (кроме сообщений об ошибках).

_default_
        Цвет по умолчанию для данной секции. Если не указан, то используется [core]._default_

dfocus  Цвет элемента, находящегося в фокусе

dhotnormal
        Цвет хоткеев

dhotfocus
        Цвет хоткеев, находящихся в фокусе

Секция [error] содержит описания элементов диалога об ошибках.

_default_
        Цвет по умолчанию для данной секции. Если не указан, то используется [core]._default_

errdhotnormal
        Цвет хоткеев

errdhotfocus
        Цвет хоткеев, находящихся в фокусе

Секция [menu] содержит описание элементов, отображающихся в меню. Это касается как системного меню (вызываемого клавишей F9), так и пользовательских меню (F2 в панелях или F11 в редакторе).

_default_
        Цвет по умолчанию для данной секции. Если не указан, то используется [core]._default_

entry   Цвет пунктов меню

menuhot Цвет хоткеев

menusel Цвет выделенного пункта меню

menuhotsel
        Цвет хоткеев, находящихся в фокусе

menuinactive
        Цвет неактивного меню

Секция [help] содержит описания цветов для окна отображения помощи.

_default_
        Цвет по умолчанию для данной секции. Если не указан, то используется [core]._default_

helpitalic
        Цветовыделение элементов с атрибутом italic

helpbold
        Цветовыделение элементов с атрибутом bold

helplink
        Цвет ссылок

helpslink
        Цвет ссылки, находящейся под курсором

Секция [editor] содержит описания элементов редактора

_default_
        Цвет по умолчанию для данной секции. Если не указан, то используется [core]._default_

editbold
        Цветовыделение элементов с атрибутом bold

editmarked
        Цвет выделенного текста

editwhitespace
        Подсветка знаков табуляции и "висящих" пробелов

editlinestate
        Цвет области отображения состояния строки.

Секция [viewer] содержит описания элементов редактора

viewunderline
        Цветовыделение элементов с атрибутом underline[Skins colors]
Цветовые пары

Каждый параметр в скин-файле содержит цветовые пары

Цветовые пары описываются как два цвета, разделённых символом ';' первый цвет задаёт цвет написания символов, второй - цвет фона. Один из цветов может быть пропущен, в этом случае будет взят цвет по умолчанию (глобальный или для данной секции).

Например:
[core]
    # зелёным по чёрному
    _default_=green;black
    # зелёным (умолч.)  по синему
    selected=;blue
    # жёлтым по чёрному(умолч.)
    marked=yellow;

Возможные цвета (названия) описаны в секции ЦветаColors.[Skins lines]
Линии для отрисовки рамок

Линии задаются в секции [Lines] в скин-файле. По умолчанию используются одинарные линии, но возможно переназначить на использование любых utf-8 символов, похожих на линии

ВНИМАНИЕ!!! При сборке Midnight Commander с библиотекой Ncurses использование линий ограничено! Возможна только отрисовка одинарных линий. По всем вопросам и предложениям обращайтесь к разработчикам Ncurses.

Описание параметров секции [Lines]:

lefttop изображение левого верхнего угла рамки

righttop
        изображение правого верхнего угла рамки

centertop
        изображение ответвления горизонтальной линии вниз

centerbottom
        изображение ответвления горизонтальной линии вверх

leftbottom
        изображение левого нижнего угла рамки

rightbottom
        изображение правого нижнего угла рамки

leftmiddle
        изображение ответвления вертикальной линии вправо

rightmiddle
        изображение ответвления вертикальной линии влево

centermiddle
        изображение пересечения вертикальной и горизонтальной линий

horiz   изображение горизонтальной линии

vert    изображение вертикальной линии

thinhoriz
        изображение тонкой горизонтальной линии

thinvert
        изображение тонкой вертикальной линии[Skins oldcolors]
Совместимость

Назначение цветов элементов посредством скин-файлов полностью совместимо с назначением цветов, описанном в секции ЦветаColors.

В данном случае переназначение цветов имеет приоритет над скин-файлами и носит дополняющий характер.[Filenames Highlight]
Подсветка имён файлов

Секция [filehighlight] из текущего скин-файла содержит имена параметров (в качестве групп подсветки) и значения параметров как цветовые пары. Описания цветовых пар смотрите в разделе Внешний видSkins

Правила подсветки находятся в файле /etc/mc/filehighlight.ini (~/.mc/filehighlight.ini). Названия групп должны совпадать с названиями параметров в секции [filehighlight] в текущем скин-файле.

Ключи в группах могут принимать следующие значения:

type    Тип файла. Если параметр присутствует, остальные опции игнорируются

regexp  Регулярное выражение. Если присутствует, параметр 'extensions' игнорируется.

extensions
        Список расширений файлов. Раасширения разделяются символом ';'.

extensions_case
        (имеет смысл только с параметром 'extensions') делает правило 'extensions' чувствительным к регистру букв (true) или не чувтсвительным (false).

Параметр 'type' (тип файла) может принимать значения:
- FILE (все файлы)
  - FILE_EXE
- DIR (все каталоги)
  - LINK_DIR
- LINK (все ссылки (линки), исключая "битые" линки)
  - HARDLINK
  - SYMLINK
- STALE_LINK
- DEVICE (все файлы устройств)
  - DEVICE_BLOCK
  - DEVICE_CHAR
- SPECIAL (все специальные файлы)
  - SPECIAL_SOCKET
  - SPECIAL_FIFO
  - SPECIAL_DOOR
[Special Settings]
Специальные установки (Special Settings)

Большинство установок Midnight Commander может быть изменено путем использования меню. Однако имеется несколько установок, которые могут быть изменены только путем непосредственного редактирования конфигурационного файла ~/.mc/ini.

clear_before_exec

        По умолчанию Midnight Commander очищает экран перед выполнением команды. Если вы хотите, чтобы вывод предыдущей команды не исчезал, измените значение поля clear_before_exec на 0.

confirm_view_dir

        Если вы нажимаете F3 на имени каталога, обычно MC переходит в этот каталог. Если этот флаг будет установлен в 1, MC будет спрашивать подтверждение перед тем, как перейти в указанный каталог, если в текущем каталоге были помечены какие-либо файлы.

ftpfs_retry_seconds

        Этот параметр задает интервал времени (в секундах), по истечении которого Midnight Commander будет предпринимать повторную попытку соединиться с ftp-сервером после того, как предыдущая попытка окончилась неудачей. Если задано нулевое значение, программа не будет повторять попытку соединиться.

ftpfs_use_passive_connections

        По умолчанию эта опция отключена. Она включается для передачи файлов по протоколу FTP в тех случаях, когда компьютер пользователя располагается за маршрутизатором, фильтрующим пакеты (behind a filtering packet router). Эта опция работает только в том случае, если вы не используете прокси (you are not using an ftp proxy).

max_dirt_limit

        Определяет, сколько раз может быть пропущена операция обновления изображения на экране при работе во встроенной программе просмотра. Обычно этот параметр не имеет большого значения, поскольку программа автоматически выбирает оптимальное значение в зависимости от скорости нажатий на клавиши. Однако на очень медленных машинах или терминалах с большой скоростью автоповторения (keyboard auto repeat) слишком большое значение этого параметра может привести к тому, что процедура обновления экрана начнет вaс раздражать.

        По-видимому значение max_dirt_limit, равное 10, обеспечивает наилучший выбор, и именно такое значение устанавливается по умолчанию.

mouse_move_pages

        Определяет, будет ли прокрутка информации (scrolling) в панелях, осуществляемая с помощью мышки, производиться страницами или на одну строку.

mouse_move_pages_viewer

        Определяет, будет ли прокрутка информации (scrolling) во встроенной программе просмотра, осуществляемая с помощью мышки, производиться страницами или на одну строку.

old_esc_mode

        По умолчанию Midnight Commander трактует нажатие на клавишу ESC как действие, предшествующее нажатию какой-то другой клавиши (old_esc_mode=0), и совместно обрабатывает комбинацию <Esc-key>. Если установить эту опцию в 1 (old_esc_mode=1), то программа будет ожидать нажатия второй клавиши только в течение 1 секунды, и если за это время ни одна клавиша не нажата, то ESC интерпретируется как требование отказа от выполнения предыдущей команды (ESC ESC).

only_leading_plus_minus

        Устанавливает специальный режим обработки символов '+', '-', '*' в командной строке. Эти символы используются для выбора, отмены выбора и инвертирования выбора, но выполняют такую функцию только если командная строка пуста. В середине командной строки эти символы уже не вызывают выполнения операций группового выбора, но зато вы не сможете использовать эти символы для таких операций, если командная строка не пуста.

reverse_files_only

        Если опция установлена (по умолчанию она установлена), инвертирование выбора применяется только к файлам, но не к каталогам. Выбор каталогов не изменяется. Если не установлена, производится инвертирование как файлов, так и каталогов. Все невыбранные объекты становятся выбранными и наоборот.

panel_scroll_pages

        Если опция установлена (по умолчанию она установлена), то когда курсор (подсветка) достигает конца или начала списка файлов, отображаемого на панели, будет производиться смещение на половину этого списка (то есть половина отображаемого списка остается на экране, а половина пропадает, заменяясь следующими пунктами общего списка). Если опция не установлена, происходит смещение только на одну строку.

show_output_starts_shell

        Эта переменная работает только в том случае, когда не включена поддержка subshell. Если она установлена, то при нажатии C-o для перехода в экран пользователя будет запускаться новый экземпляр оболочки.

torben_fj_mode

        Установка этой опции слегка изменяет реакцию программы на нажатие клавиш Home и End в активной панели. Вместо того, чтобы перемещать подсветку (курсор) к первому или последнему из имен файлов, отображенных на панели, нажатие этих клавиш будет вызывать следующую реакцию:

        клавиша Home - перемещение курсора вверх до середины панели, если курсор был ниже, в противном случае перемещение на самую верхнюю строку; если только курсор уже на самой верхней строке, то перемещение на самую первую строку списка файлов.

        клавиша End вызывает аналогичную реакцию - смещение вниз до середины панели, если курсор был выше; если ниже - то переход на последнюю отображаемую в панели строку; если уже на последней строке, то перемещение курсора на самую последнюю строку списка файлов.

use_file_to_guess_type

        Когда эта опция включена (что сделано по умолчанию), mc будет вызывать программу file для определения типа файла в соответствии с типами файлов, указанными в mc.extExtension File Edit.

xtree_mode

        Если эта переменная включена (по умолчанию она отключена), то при просмотре в одной из панелей структуры дерева каталогов во второй панели автоматически будет отображаться список файлов выбранного каталога.[Terminal databases]
Базы терминалов (Terminal databases)

Midnight Commander обеспечивает возможность внесения исправлений в системную базу терминалов, даже если вы не обладаете правами суперпользователя. Midnight Commander ищет в системном инициализационном файле (файл mc.lib в библиотечном каталоге программы Midnight Commander) или в файле ~/.mc/ini секцию с названием "terminal:your-terminal-name", а затем секцию "terminal:general". Каждая строка в этих секциях содержит ключевое слово, которое вы хотите определить, за которым следует знак равенства и определение ключевого слова. Специальный символ \e используется для задания экранирующих последовательностей, а ^x служит для задания последовательностей вида control-x

В качестве ключевых слов используются:

f0 - f20      определяет последовательность символов,
              генерируемых при нажатии на функциональные
              клавиши f0-f20
bs            определяет последовательность символов, которая
              будет использоваться вместо клавиши backspace
home          то же для клавиши Home
end           то же для клавиши end
up            то же для клавиши "стрелка вверх"
down          то же для клавиши "стрелка вниз"
left          то же для клавиши "стрелка влево"
right         то же для клавиши "стрелка вправо"
pgdn          то же для клавиши page down
pgup          то же для клавиши page up
insert        то же для клавиши insert
delete        то же для клавиши delete
complete      комбинация клавиш для выполнения операции
              "завершение ввода"

Например, для того, чтобы задать, что клавише insert соответствует экранирующая последовательность Escape + [ + O + p нужно в файле ini прописать строку:

insert=\e[Op

Операция "завершение ввода" обычно вызывается по клавишам M-tab, но задав значение ключевого слова complete можно вызывать такую же реакцию системы по другой комбинации клавиш (почему бы не сделать это, если у вас клавиатура, имеющая массу неиспользуемых клавиш!).

[FILES]
Файлы

Программа извлекает всю нужную ей информацию из файлов, пути к которым определяются относительно переменной окружения MC_DATADIR. Если эта переменная не задана, происходит обращение к так называемому библиотечному каталогу программы Midnight Commander. Для того, чтобы узнать имя этого каталога, дайте команду mc -f.

/usr/local/share/mc/mc.hlp

        Файл подсказки для программы.

/usr/local/share/mc/mc.ext

        Используемый по умолчанию общесистемный файл расширений.

~/.mc/bindings

        Файл расширений пользователя. Если этот файл существует, он используется вместо общесистемного файла расширений.

/usr/local/share/mc/mc.ini

        Используемый по умолчанию общесистемный файл установок для Midnight Commander; используется только в тех случаях, когда пользователь не имеет своего файла ~/.mc/ini

/usr/local/share/mc/mc.lib

        Глобальные установки для Midnight Commander. Установки из этого файла действительны для всех пользователей, независимо от того, имеют ли они ~/.mc/ini или нет. В настоящий момент только настройки терминаловTerminal databases загружаются из mc.lib.

~/.mc/ini

        Собственные установки пользователя. Если такой файл существует, то установки загружаются из него, а не из общесистемного инициализационного файла программы.

/usr/local/share/mc/mc.hint

        Этот файл содержит подсказки (hints или cookies), циклически отображаемые программой.

/usr/local/share/mc/mc.menu

        Этот файл содержит общесистемное меню приложений.

~/.mc/menu

        Собственное меню пользователя. Если этот файл существует, он используется вместо общесистемного меню.

~/.mc/Tree

        Список каталогов для окна, выводимого при выборе пункта меню "Команда/Дерево каталогов" или при просмотре дерева каталогов в одной из панелей. Каждая строка файла соответствует подкаталогу. Строки, начинающиеся со слэша ("/") соответствуют полным путям. Если строка начинается с цифры, то надо взять указанное число символов из имени предыдущего каталога. При желании можно создать этот файл, дав команду

 find / -type d -print | sort > ~/.mc/Tree

        Обычно не имеет смысла делать это, потому что Midnight Commander автоматически обновляет этот файл.

./.mc.menu

        локальное меню, задаваемое пользователем. Если этот файл существует, он используется вместо файла меню из домашнего каталога пользователя и общесистемного меню.[AVAILABILITY]
Обновление версий

Последние версии программы Midnight Commander можно найти на сайте ftp://ftp.gnu.org/gnu/mc/.[SEE ALSO]
Другие источники

ed(1), gpm(1), mcserv(8), terminfo(1), view(1), sh(1), bash(1), tcsh(1), zsh(1), mcedit(1).

Страница, посвященная Midnight Commander, в World Wide Web:
	http://www.midnight-commander.org/

Данная страница оперативного руководства содержит информацию, актуальную для версии 4.6.0 (январь 2003 года). Если вы используете более свежую версию программы, оригинальная страница на английском языке может содержать более полную и актуальную информацию. Для просмотра оригинальной страницы в оболочке bash можно использовать команду
LANG= man mc
[AUTHORS]
АВТОРЫ

Miguel de Icaza (miguel@ximian.com), Janne Kukonlehto (jtklehto@paju.oulu.fi), Radek Doulik (rodo@ucw.cz), Fred Leeflang (fredl@nebula.ow.org), Dugan Porter (dugan@b011.eunet.es), Jakub Jelinek (jj@sunsite.mff.cuni.cz), Ching Hui (mr854307@cs.nthu.edu.tw), Andrej Borsenkow (borsenkow.msk@sni.de), Norbert Warmuth (nwarmuth@privat.circular.de), Mauricio Plaza (mok@roxanne.nuclecu.unam.mx), Paul Sheer (psheer@icon.co.za), Pavel Machek (pavel@ucw.cz) and Pavel Roskin (proski@gnu.org) are the developers of this package. Alessandro Rubini (rubini@ipvvis.unipv.it) has been especially helpful debugging and enhancing the program's mouse support, John Davis (davis@space.mit.edu) also made his S-Lang library available to us under the GPL and answered my questions about it, and the following people have contributed code and many bug fixes (in alphabetical order):

Adam Tla/lka (atlka@sunrise.pg.gda.pl), alex@bcs.zp.ua (Alex I. Tkachenko), Antonio Palama, DOS port (palama@posso.dm.unipi.it), Erwin van Eijk (wabbit@corner.iaf.nl), Gerd Knorr (kraxel@cs.tu-berlin.de), Jean-Daniel Luiset (luiset@cih.hcuge.ch), Jon Stevens (root@dolphin.csudh.edu), Juan Francisco Grigera, Win32 port (j-grigera@usa.net), Juan Jose Ciarlante (jjciarla@raiz.uncu.edu.ar), Ilya Rybkin (rybkin@rouge.phys.lsu.edu), Marcelo Roccasalva (mfroccas@raiz.uncu.edu.ar), Massimo Fontanelli (MC8737@mclink.it), Sergey Ya. Korshunoff (root@seyko.msk.su), Thomas Pundt (pundtt@math.uni-muenster.de), Timur Bakeyev (timur@goff.comtat.kazan.su), Tomasz Cholewo (tjchol01@mecca.spd.louisville.edu), Torben Fjerdingstad (torben.fjerdingstad@uni-c.dk), Vadim Sinolitis (vvs@nsrd.npi.msu.su) and Wim Osterholt (wim@djo.wtm.tudelft.nl).

Перевод текста подсказки на русский язык - Костромин В.А., 1999г. Исправления, адаптация к текущей версии и конвертация в формат mandoc - Самойлов А.В. <sav@bcs.zp.ua>, 2002 г.[BUGS]
Недоработки (BUGS)

Известные авторам недоработки программы перечислены в файле TODO, который можно найти в составе поставляемого пакета.

Если вы обнаружили в программе какие-то недостатки или недоработки, пришлите, пожалуйста, ваши замечания по e-mail на адрес: mc-devel@gnome.org.

Дайте в письме подробное описание обнаруженных недостатков (и/или ваших предложений по усовершенствованию программы), сообщите версию программы с которой вы работаете (для получения номера версии используйте команду mc -V), в какой операционной системе вы запускали программу. В случае фатальной ошибки программы, мы будем очень благодарны, если вы пришлете след вызовов.
[main]
 lqwqk     k           k     
 x x x .   x     .     x     
 x x x k lqu wqk k lqw tqk n 
 x x x x x x x x x x x x x x 
 v   v v mqv v v v mqu v v mj
     qqqqqqCommanderqj 

Вы сейчас видите главное окно интерактивной подсказки программы GNU Midnight Commander.

Чтобы узнать, как пользоваться подсказкой, нажмите клавишу EnterHow to use help, иначе переходите к перечню разделовContents подсказки.

Программа Midnight Commander поставляется АБСОЛЮТНО БЕЗ ВСЯКИХ ГАРАНТИЙГарантия. Это свободно распространяемое программное обеспечение, созданное группой авторовAUTHORS. Вы можете передавать его другим при условии соблюдения требований лицензии GNUЛицензия (оригинал на английском) (прочитайте неофициальный переводЛицензия этой лицензии).

Русский перевод текста подсказки - Костромин В.А., 1999 г.

[Лицензия (оригинал на английском)]

                GNU GENERAL PUBLIC LICENSE
                   Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

 Everyone is permitted to copy and distribute verbatim
copies of this license document, but changing it is not
allowed.

                         Preamble

  The licenses for most software are designed to take away
your freedom to share and change it.  By contrast, the GNU
General Public License is intended to guarantee your
freedom to share and change free software--to make sure
the software is free for all its users.  This General
Public License applies to most of the Free Software
Foundation's software and to any other program whose
authors commit to using it.  (Some other Free Software
Foundation software is covered by the GNU Library General
Public License instead.)  You can apply it to your
programs, too.

  When we speak of free software, we are referring to
freedom, not price.  Our General Public Licenses are
designed to make sure that you have the freedom to
distribute copies of free software (and charge for this
service if you wish), that you receive source code or can
get it if you want it, that you can change the software or
use pieces of it in new free programs; and that you know
you can do these things.

  To protect your rights, we need to make restrictions
that forbid anyone to deny you these rights or to ask you
to surrender the rights.  These restrictions translate to
certain responsibilities for you if you distribute copies
of the software, or if you modify it.

  For example, if you distribute copies of such a program,
whether gratis or for a fee, you must give the recipients
all the rights that you have.  You must make sure that
they, too, receive or can get the source code.  And you
must show them these terms so they know their rights.

  We protect your rights with two steps: (1) copyright the
software, and (2) offer you this license which gives you
legal permission to copy, distribute and/or modify the
software.

  Also, for each author's protection and ours, we want to
make certain that everyone understands that there is no
warranty for this free software.  If the software is
modified by someone else and passed on, we want its
recipients to know that what they have is not the
original, so that any problems introduced by others will
not reflect on the original authors' reputations.

  Finally, any free program is threatened constantly by
software patents.  We wish to avoid the danger that
redistributors of a free program will individually obtain
patent licenses, in effect making the program proprietary.
To prevent this, we have made it clear that any patent
must be licensed for everyone's free use or not licensed
at all.

  The precise terms and conditions for copying,
distribution and modification follow.

                GNU GENERAL PUBLIC LICENSE
            TERMS AND CONDITIONS FOR COPYING,
              DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work
which contains a notice placed by the copyright holder
saying it may be distributed under the terms of this
General Public License.  The "Program", below, refers to
any such program or work, and a "work based on the
Program" means either the Program or any derivative work
under copyright law: that is to say, a work containing the
Program or a portion of it, either verbatim or with
modifications and/or translated into another language.
(Hereinafter, translation is included without limitation
in the term "modification".)  Each licensee is addressed
as "you".

Activities other than copying, distribution and
modification are not covered by this License; they are
outside its scope.  The act of running the Program is not
restricted, and the output from the Program is covered
only if its contents constitute a work based on the
Program (independent of having been made by running the
Program).  Whether that is true depends on what the
Program does.

  1. You may copy and distribute verbatim copies of the
Program's source code as you receive it, in any medium,
provided that you conspicuously and appropriately publish
on each copy an appropriate copyright notice and
disclaimer of warranty; keep intact all the notices that
refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of
this License along with the Program.

You may charge a fee for the physical act of transferring
a copy, and you may at your option offer warranty
protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or
any portion of it, thus forming a work based on the
Program, and copy and distribute such modifications or
work under the terms of Section 1 above, provided that you
also meet all of these conditions:

    a) You must cause the modified files to carry
prominent notices stating that you changed the files and
the date of any change.

    b) You must cause any work that you distribute or
publish, that in whole or in part contains or is derived
from the Program or any part thereof, to be licensed as a
whole at no charge to all third parties under the terms of
this License.

    c) If the modified program normally reads commands
interactively when run, you must cause it, when started
running for such interactive use in the most ordinary way,
to print or display an announcement including an
appropriate copyright notice and a notice that there is no
warranty (or else, saying that you provide a warranty) and
that users may redistribute the program under these
conditions, and telling the user how to view a copy of
this License.  (Exception: if the Program itself is
interactive but does not normally print such an
announcement, your work based on the Program is not
required to print an announcement.)

These requirements apply to the modified work as a whole.
If identifiable sections of that work are not derived from
the Program, and can be reasonably considered independent
and separate works in themselves, then this License, and
its terms, do not apply to those sections when you
distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a
work based on the Program, the distribution of the whole
must be on the terms of this License, whose permissions
for other licensees extend to the entire whole, and thus
to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights
or contest your rights to work written entirely by you;
rather, the intent is to exercise the right to control the
distribution of derivative or collective works based on
the Program.

In addition, mere aggregation of another work not based on
the Program with the Program (or with a work based on the
Program) on a volume of a storage or distribution medium
does not bring the other work under the scope of this
License.

  3. You may copy and distribute the Program (or a work
based on it, under Section 2) in object code or executable
form under the terms of Sections 1 and 2 above provided
that you also do one of the following:

    a) Accompany it with the complete corresponding
machine-readable source code, which must be distributed
under the terms of Sections 1 and 2 above on a medium
customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at
least three years, to give any third party, for a charge
no more than your cost of physically performing source
distribution, a complete machine-readable copy of the
corresponding source code, to be distributed under the
terms of Sections 1 and 2 above on a medium customarily
used for software interchange; or,

    c) Accompany it with the information you received as
to the offer to distribute corresponding source code.
(This alternative is allowed only for noncommercial
distribution and only if you received the program in
object code or executable form with such an offer, in
accord with Subsection b above.)

The source code for a work means the preferred form of the
work for making modifications to it.  For an executable
work, complete source code means all the source code for
all modules it contains, plus any associated interface
definition files, plus the scripts used to control
compilation and installation of the executable.  However,
as a special exception, the source code distributed need
not include anything that is normally distributed (in
either source or binary form) with the major components
(compiler, kernel, and so on) of the operating system on
which the executable runs, unless that component itself
accompanies the executable.

If distribution of executable or object code is made by
offering access to copy from a designated place, then
offering equivalent access to copy the source code from
the same place counts as distribution of the source code,
even though third parties are not compelled to copy the
source along with the object code.

  4. You may not copy, modify, sublicense, or distribute
the Program except as expressly provided under this
License.  Any attempt otherwise to copy, modify,
sublicense or distribute the Program is void, and will
automatically terminate your rights under this License.
However, parties who have received copies, or rights, from
you under this License will not have their licenses
terminated so long as such parties remain in full
compliance.

  5. You are not required to accept this License, since
you have not signed it.  However, nothing else grants you
permission to modify or distribute the Program or its
derivative works.  These actions are prohibited by law if
you do not accept this License.  Therefore, by modifying
or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to
do so, and all its terms and conditions for copying,
distributing or modifying the Program or works based on
it.

  6. Each time you redistribute the Program (or any work
based on the Program), the recipient automatically
receives a license from the original licensor to copy,
distribute or modify the Program subject to these terms
and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights
granted herein.  You are not responsible for enforcing
compliance by third parties to this License.

  7. If, as a consequence of a court judgment or
allegation of patent infringement or for any other reason
(not limited to patent issues), conditions are imposed on
you (whether by court order, agreement or otherwise) that
contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you
cannot distribute so as to satisfy simultaneously your
obligations under this License and any other pertinent
obligations, then as a consequence you may not distribute
the Program at all.  For example, if a patent license
would not permit royalty-free redistribution of the
Program by all those who receive copies directly or
indirectly through you, then the only way you could
satisfy both it and this License would be to refrain
entirely from distribution of the Program.

If any portion of this section is held invalid or
unenforceable under any particular circumstance, the
balance of the section is intended to apply and the
section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to
infringe any patents or other property right claims or to
contest validity of any such claims; this section has the
sole purpose of protecting the integrity of the free
software distribution system, which is implemented by
public license practices.  Many people have made generous
contributions to the wide range of software distributed
through that system in reliance on consistent application
of that system; it is up to the author/donor to decide if
he or she is willing to distribute software through any
other system and a licensee cannot impose that choice.

This section is intended to make thoroughly clear what is
believed to be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is
restricted in certain countries either by patents or by
copyrighted interfaces, the original copyright holder who
places the Program under this License may add an explicit
geographical distribution limitation excluding those
countries, so that distribution is permitted only in or
among countries not thus excluded.  In such case, this
License incorporates the limitation as if written in the
body of this License.

  9. The Free Software Foundation may publish revised
and/or new versions of the General Public License from
time to time.  Such new versions will be similar in spirit
to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If
the Program specifies a version number of this License
which applies to it and "any later version", you have the
option of following the terms and conditions either of
that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a
version number of this License, you may choose any version
ever published by the Free Software Foundation.

  10. If you wish to incorporate parts of the Program into
other free programs whose distribution conditions are
different, write to the author to ask for permission.  For
software which is copyrighted by the Free Software
Foundation, write to the Free Software Foundation; we
sometimes make exceptions for this.  Our decision will be
guided by the two goals of preserving the free status of
all derivatives of our free software and of promoting the
sharing and reuse of software generally.

[Warranty]
                       NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE,
THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT
PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED
IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.
SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR
AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY
OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM
AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR
CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY
TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO
OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR
OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

               END OF TERMS AND CONDITIONS

      How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of
the greatest possible use to the public, the best way to
achieve this is to make it free software which everyone
can redistribute and change under these terms.

  To do so, attach the following notices to the program.
It is safest to attach them to the start of each source
file to most effectively convey the exclusion of warranty;
and each file should have at least the "copyright" line
and a pointer to where the full notice is found.

<one line to give the program's name and a brief idea of
what it does.>
Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any
later version.

    This program is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

    You should have received a copy of the GNU General
Public License along with this program; if not, write to
the Free Software Foundation, Inc., 51 Franklin Street,
Fifth Floor, Boston, MA  02110-1301  USA

Also add information on how to contact you by electronic
and paper mail.

If the program is interactive, make it output a short
notice like this when it starts in an interactive mode:

Gnomovision version 69, Copyright (C) year name of author
Gnomovision comes with ABSOLUTELY NO WARRANTY; for details
type `show w'.  This is free software, and you are welcome
to redistribute it under certain conditions; type `show c'
for details.

The hypothetical commands `show w' and `show c' should
show the appropriate parts of the General Public License.
Of course, the commands you use may be called something
other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a
programmer) or your school, if any, to sign a "copyright
disclaimer" for the program, if necessary.  Here is a
sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest
in the program `Gnomovision' (which makes passes at
compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating
your program into proprietary programs.  If your program
is a subroutine library, you may consider it more useful
to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU
Library General Public License instead of this License.

[Лицензия]

        УНИВЕРСАЛЬНАЯ ОБЩЕСТВЕННАЯ ЛИЦЕНЗИЯ GNU

                  Версия 2, июнь 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
(C) Перевод.  О.В. Кузина, В.М. Юфа, 1993
(C) Перевод.  О.С. Тихонов, 1998

Всем разрешается копировать и распространять дословные копии
этого лицензионного документа, но изменять его нельзя.

Преамбула

Лицензии на большую часть программного обеспечения (ПО) сос-
тавлены так, чтобы лишить вас свободы совместно использовать
и изменять его. Напротив, Универсальная Общественная Лицензия
GNU предназначена гарантировать вашу свободу совместно ис-
пользовать и изменять свободное ПО, т.е. удостоверить, что ПО
является свободным для всех его пользователей. Эта Универ-
сальная Общественная Лицензия применима к большей части ПО
Фонда Свободного ПО и ко всем другим программам, чьи авторы
принимают на себя обязательства ее использовать. (Вместо нее
для части ПО Фонда Свободного ПО применяется Универсальная
Общественная Лицензия GNU для библиотек.) Вы тоже можете
использовать ее для своих программ.

Когда мы говорим о свободном ПО, мы имеем в виду свободу, а
не цену. Предполагается, что наши Универсальные Общественные
Лицензии гарантируют, что вы пользуетесь свободой распростра-
нять копии свободного ПО (и получать за это вознаграждение,
если вы того желаете); что вы получаете исходный код или
можете получить его, если захотите; что вы можете изменять
ПО или использовать его части в новых свободных программах;
и что вы знаете, что вы можете все это делать.

Чтобы защитить ваши права, нам нужно ввести такие ограниче-
ния, которые запретят кому бы то ни было отказывать вам в
этих правах или потребовать от вас отказаться от этих прав.
Эти ограничения переводятся в некоторые обязательства для
вас, если вы распространяете копии ПО или если вы модифици-
руете его.

Например, если вы распространяете копии такой программы
бесплатно или за вознаграждение, вы должны предоставить
получателям все права, которыми вы обладаете. Вы должны
гарантировать, что они тоже получат или смогут получить
исходный код. И вы должны показать им эти условия, чтобы
они знали о своих правах.

Мы защищаем ваши права в два этапа: (1) сохраняем авторские
права на ПО и (2) предлагаем вам эту лицензию, которая дает
вам законное право копировать, распространять и/или модифи-
цировать ПО.

Также, чтобы защитить нас и каждого автора, мы хотим удосто-
вериться, что все понимают, что гарантий на это свободное ПО
нет. Если ПО модифицируется и передается кем-то еще, мы
хотим, чтобы получатели ПО знали, что то, что у них есть --
это не оригинал, чтобы любые проблемы, созданные другими, не
отразились на репутации первоначальных авторов.

И наконец, каждой свободной программе постоянно угрожают па-
тенты на ПО. Мы хотим избежать опасности, что повторные рас-
пространители свободной программы самостоятельно получат па-
тенты, делая программу таким образом частной собственностью.
Чтобы предотвратить это, мы явно заявляем, что любой патент
должен быть либо предоставлен всем для свободного использо-
вания, либо не предоставлен никому.

Ниже следуют точные определения и условия для копирования,
распространения и модификации.

ОПРЕДЕЛЕНИЯ И УСЛОВИЯ ДЛЯ КОПИРОВАНИЯ, РАСПРОСТРАНЕНИЯ И
МОДИФИКАЦИИ

 1. Эта Лицензия применима к любой программе или другому
    произведению, содержащему уведомление, помещенное держа-
    телем авторских прав и сообщающее о том, что оно может
    распространяться при условиях, оговоренных в данной Уни-
    версальной Общественной Лицензии. В последующем термин
    "Программа" относится к любой такой программе или произ-
    ведению, а термин "произведение, основанное на Программе"
    означает Программу или любое произведение, содержащее
    Программу или ее часть, дословную, или модифицированную,
    и/или переведенную на другой язык. (Здесь и далее перевод
    включается без ограничений в понятие "модификация".)
    Каждый обладатель лицензии адресуется как "вы". Виды дея-
    тельности, не являющиеся копированием, распространением
    или модификацией не охватываются этой Лицензией; они за
    пределами ее влияния. Использование Программы по ее функ-
    циональному назначению не ограничено, и выходные данные
    Программы охватываются этой Лицензией, только если их со-
    держание является произведением, основанным на Программе
    (вне зависимости от того, были ли они получены в процессе
    использования Программы). Являются ли они таковыми, зави-
    сит от того, что именно делает Программа.
 2. Вы можете копировать и распространять дословные копии ис-
    ходного кода Программы по его получении на любом носите-
    ле, при условии что вы соответствующим образом помещаете
    на видном месте в каждой копии соответствующее уведомле-
    ние об авторских правах и отказ от гарантий; оставляете
    нетронутыми все уведомления, относящиеся к данной Лицен-
    зии и к отсутствию каких-либо гарантий; и передаете всем
    другим получателям Программы копию данной Лицензии вместе
    с Программой. Вы можете назначить плату за физический акт
    передачи копии и можете по своему усмотрению предостав-
    лять гарантии за вознаграждение.
 3. Вы можете изменять свою копию или копии Программы или
    любой ее части, создавая таким образом произведение, ос-
    нованное на Программе, и копировать и распространять эти
    модификации или произведение в соответствии с Разделом 1,
    приведенным выше, при условии, что вы выполните все ниже-
    следующие условия:
      1. Вы обязаны снабдить модифицированные файлы заметными
         уведомлениями, содержащими указания на то, что вы
         изменили файлы, и дату каждого изменения.
      2. Вы обязаны предоставить всем третьим лицам лицензию
         на бесплатное использование каждого произведения,
         которое вы распространяете или публикуете, целиком,
         и которое полностью или частично содержит Программу
         или какую-либо ее часть, на условиях, оговоренных в
         данной Лицензии.
      3. Если модифицированная программа обычно читает коман-
         ды в интерактивном режиме работы, вы должны сделать
         так, чтобы при запуске для работы в таком интер-
         активном режиме обычным для нее способом она печа-
         тала или выводила на экран объявление, содержащее
         соответствующее уведомление об авторских правах и
         уведомление о том, что гарантий нет (или, наоборот,
         сообщающее о том, что вы обеспечиваете гарантии), и
         что пользователи могут повторно распространять про-
         грамму при этих условиях, и указывающее пользовате-
         лю, как просмотреть копию данной Лицензии.
          (Исключение: если сама Программа работает в интер-
           активном режиме, но обычно не выводит подобное
           объявление, то ваше произведение, основанное на
           Программе, не обязано выводить объявление.)
    Эти требования применяются к модифицированному произве-
    дению в целом. Если известные части этого произведения
    не были основаны на Программе и могут обоснованно счи-
    таться независимыми и самостоятельными произведениями,
    то эта Лицензия и ее условия не распространяются на эти
    части, если вы распространяете их как отдельные произве-
    дения. Но если вы распространяете эти части как часть
    целого произведения, основанного на Программе, то вы
    обязаны делать это в соответствии с условиями данной Ли-
    цензии, распространяя права получателей лицензии на все
    произведение и, таким образом, на каждую часть, вне за-
    висимости от того, кто ее написал. Таким образом, содер-
    жание этого раздела не имеет цели претендовать на ваши
    права на произведение, написанное полностью вами, или
    оспаривать их; цель скорее в том, чтобы развить право
    управлять распространением производных или коллективных
    произведений, основанных на Программе. Кроме того, прос-
    тое нахождение другого произведения, не основанного на
    этой Программе, совместно с Программой (или с произведе-
    нием, основанным на этой Программе) на том же носителе
    для постоянного хранения или распространяемом носителе
    не распространяет действие этой Лицензии на другое произ-
    ведение.
 4. Вы можете копировать и распространять Программу (или
    произведение, основанное на ней) согласно Разделу 2) в
    объектном коде или в выполнимом виде в соответствии с
    Разделами 1 и 2, приведенными выше, при условии, что вы
    также выполните одно из следующих требований:
      1. Сопроводите ее полным соответствующим машиночитаемым
         исходным кодом, который должен распространяться в
         соответствии с Разделами 1 и 2, приведенными выше,
         на носителе, обычно используемом для обмена ПО; или,
      2. Сопроводите ее письменным предложением, действитель-
         ным по крайней мере в течение трех лет, предоставить
         любому третьему лицу за вознаграждение не большее
         стоимости физического акта изготовления копии полную
         машиночитаемую копию соответствующего исходного
         кода, подлежащую распространению в соответствии с
         Разделами 1 и 2, приведенными выше; или
      3. Сопроводите ее информацией, полученной вами в ка-
         честве предложения распространить соответствующий
         исходный код. (Эта возможность допустима только для
         некоммерческого распространения, и только если вы
         получили программу в объектном коде или в выполнимом
         виде с предложением в соответствии с Пунктом b)
         выше.)
    Исходный код для произведения означает его вид, пред-
    почтительный для  выполнения в нем модификаций. Для ис-
    полняемого произведения полный исходный код означает все
    исходные коды для всех модулей, которые он содержит, плюс
    любые связанные с произведением файлы определения
    интерфейса, плюс сценарии, используемые для управления
    компиляцией и установкой исполняемого произведения.
    Однако, в виде особого исключения распространяемый исход-
    ный код не обязан включать то, что обычно предоставляется
    с основными компонентами операционной системы, под
    управлением которой работает исполняемое произведение, за
    исключением случая, когда сам компонент сопровождает
    исполняемое произведение. Если распространение исполня-
    емого произведения или объектного кода происходит путем
    предоставления доступа для копирования с обозначенного
    места, то предоставление доступа для копирования исходно-
    го кода с того же места считается распространением исход-
    ного кода, даже если третьи лица не принуждаются к копи-
    рованию исходного кода вместе с объектным кодом.
 5. Вы не можете копировать, изменять, повторно лицензиро-
    вать, или распространять Программу иначе, чем это явно
    предусмотрено данной Лицензией. Любая попытка копировать,
    изменять, повторно лицензировать, или распространять Про-
    грамму каким-либо другим способом неправомерна и автома-
    тически прекращает ваши права данные вам этой Лицензией.
    Однако лицензии лиц, получивших от вас копии или права
    согласно данной Универсальной Общественной Лицензии, не
    прекратят своего действия до тех пор, пока эти лица пол-
    ностью соблюдают условия.
 6. Вы не обязаны соглашаться с этой Лицензией, так как вы
    не подписывали ее. Однако тогда вы не получаете права
    модифицировать или распространять Программу или основан-
    ные на Программе произведения. Эти действия запрещены
    законом, если вы не принимаете к соблюдению эту Лицензию.
    А значит, изменяя или распространяя Программу (или
    произведение, основанное на Программе), вы изъявляете
    свое согласие с этой Лицензией и всеми ее условиями о
    копировании, распространении или модификации Программы
    или произведений, основанных на ней.
 7. Каждый раз, когда вы повторно распространяете Программу
    (или любое произведение, основанное на Программе), полу-
    чатель этого произведения автоматически получает лицензию
    от первоначального держателя лицензии на копирование,
    распространение или модификацию Программы, обсуждаемую
    в этих определениях и условиях. Вы не можете налагать
    каких-либо дополнительных ограничений на осуществление
    получателем прав, предоставленных данным документом. Вы
    не несете ответственности за соблюдение третьими лицами
    условий этой Лицензии.
 8. Если в результате судебного разбирательства, или обвине-
    ния в нарушении патента или по любой другой причине (не
    обязательно связанной с патентами), вам навязаны условия,
    противоречащие данной Лицензии (как по решению суда, так
    и нет), то это не освобождает вас от соблюдения Лицензии.
    Если вы не можете заниматься распространением так, чтобы
    одновременно удовлетворить требованиям и этой Лицензии,
    и всем другим требованиям, то вы не должны заниматься
    распространением Программы.
    Например, если патент не позволяет безвозмездное повтор-
    ное распространение Программы всем, кто получил копии от
    вас непосредственно или через посредников, то единствен-
    ным способом удовлетворить и патенту, и этой Лицензии
    будет ваш полный отказ от распространения Программы. Если
    какая-либо часть этого раздела не имеет силы или не может
    быть применена при любых конкретных обстоятельствах, то
    подразумевается, что имеет силу остальная часть раздела,
    и весь Раздел имеет силу при других обстоятельствах. Цель
    этого раздела -- не побудить вас делать заявления о нару-
    шениях прав на патент, или заявлять о других претензиях
    на право собственности, или оспаривать правильность по-
    добных претензий; единственная цель этого раздела -- за-
    щита целостности системы распространения свободного ПО,
    которая реализуется использованием общих лицензий. Многие
    люди благодаря этой системе внесли щедрый вклад в широкий
    спектр распространяемого ПО полагаясь на согласованное
    применение этой системы; автору принадлежит право решать
    хочет ли он или она распространять ПО в этой системе или
    в какой-то другой, и получатель лицензии не может влиять
    на принятие этого решения. Этот раздел предназначен для
    того, чтобы тщательно прояснить, что полагается следстви-
    ем из остальной части данной Лицензии.
 9. Если распространение и/или применение Программы ограниче-
    но в ряде стран либо патентами, либо авторскими правами
    на интерфейсы, первоначальный обладатель авторских прав,
    выпускающий Программу с этой Лицензией, может добавить
    явное ограничение на географическое распространение,
    исключив такие страны, так что распространение разреша-
    ется только в тех странах, которые не были исключены. В
    этом случае данная Лицензия включает в себя это ограниче-
    ние, как если бы оно было написано в тексте данной Лицен-
    зии.
10. Фонд Свободного ПО может время от времени публиковать
    пересмотренные и/или новые версии Универсальной Общест-
    венной Лицензии. Такие новые версии будут сходны по духу
    с настоящей версией, но могут отличаться в деталях,
    направленных на новые проблемы или обстоятельства. Каждой
    версии придается отличительный номер версии. Если в Про-
    грамме указан номер версии данной Лицензии, которая к ней
    применима, и слова "любая последующая версия", вы можете
    по выбору следовать определениям и условиям либо данной
    версии, либо любой последующей версии, опубликованной
    Фондом Свободного ПО. Если в Программе не указан номер
    версии данной Лицензии, вы можете выбрать любую версию,
    когда-либо опубликованную Фондом Свободного ПО.
11. Если вы хотите встроить части Программы в другие свобод-
    ные программы с иными условиями распространения, напишите
    автору с просьбой о разрешении. Для ПО, которое охраняет-
    ся авторскими правами Фонда Свободного ПО, напишите в
    Фонд Свободного ПО; мы иногда делаем исключения для
    этого. Наше решение будет руководствоваться двумя целями:
    сохранения свободного статуса всех производных нашего
    свободного ПО и содействия совместному и повторному ис-
    пользованию ПО вообще.

[Гарантия]
                    НИКАКИХ ГАРАНТИЙ

12. ПОСКОЛЬКУ ПРОГРАММА ПРЕДОСТАВЛЯЕТСЯ БЕСПЛАТНО, НА ПРО-
    ГРАММУ НЕТ ГАРАНТИЙ В ТОЙ МЕРЕ, КАКАЯ ДОПУСТИМА ПРИМЕНИ-
    МЫМ ЗАКОНОМ, ЗА ИСКЛЮЧЕНИЕМ ТЕХ СЛУЧАЕВ, КОГДА ПРОТИВНОЕ
    ЗАЯВЛЕНО В ПИСЬМЕННОЙ ФОРМЕ.
    ДЕРЖАТЕЛИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИЕ СТОРОНЫ ПОСТАВЛЯЮТ
    ПРОГРАММУ "КАК ОНА ЕСТЬ" БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ,
    ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ
    ОГРАНИЧИВАЯСЬ ПОДРАЗУМЕВАЕМЫМИ ГАРАНТИЯМИ КОММЕРЧЕСКОЙ
    ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. ВЕСЬ РИСК В
    ОТНОШЕНИИ КАЧЕСТВА И ПРОИЗВОДИТЕЛЬНОСТИ ПРОГРАММЫ
    ОСТАЕТСЯ ПРИ ВАС. ЕСЛИ ПРОГРАММА ОКАЖЕТСЯ ДЕФЕКТИВНОЙ,
    ВЫ ПРИНИМАЕТЕ НА СЕБЯ СТОИМОСТЬ ВСЕГО НЕОБХОДИМОГО
    ОБСЛУЖИВАНИЯ, ВОССТАНОВЛЕНИЯ ИЛИ ИСПРАВЛЕНИЯ.
13. НИ В КОЕМ СЛУЧАЕ, ЕСЛИ НЕ ТРЕБУЕТСЯ ПОДХОДЯЩИМ ЗАКОНОМ
    ИЛИ НЕ УСЛОВЛЕНО В ПИСЬМЕННОЙ ФОРМЕ, НИКАКОЙ ДЕРЖАТЕЛЬ
    АВТОРСКИХ ПРАВ ИЛИ НИКАКОЕ ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ
    ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК
    БЫЛО РАЗРЕШЕНО ВЫШЕ, НЕ ОТВЕТСТВЕННЫ ПЕРЕД ВАМИ ЗА УБЫТ-
    КИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, СПЕЦИАЛЬНЫЕ, СЛУЧАЙНЫЕ ИЛИ
    ПОСЛЕДОВАВШИЕ УБЫТКИ, ПРОИСТЕКАЮЩИЕ ИЗ ИСПОЛЬЗОВАНИЯ ИЛИ
    НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ (ВКЛЮЧАЯ, НО НЕ
    ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ
    НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, ПОНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ
    ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С
    ЛЮБЫМИ ДРУГИМИ ПРОГРАММАМИ), ДАЖЕ ЕСЛИ ТАКОЙ ДЕРЖАТЕЛЬ ИЛИ
    ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.

КОНЕЦ ОПРЕДЕЛЕНИЙ И УСЛОВИЙ

Как применять эти условия к вашим новым программам

Если вы разрабатываете новую программу и хотите, чтобы она
принесла максимально возможную пользу обществу, лучший способ
достичь этого - включить ее в свободное ПО, которое каждый
может повторно распространять и изменять согласно данным
условиям.

Чтобы сделать это, добавьте в программу следующие уведомле-
ния. Самое безопасное -- это добавить их в начало каждого
исходного файла, чтобы наиболее эффективно отобразить исклю-
чение гарантий; и каждый файл должен содержать по меньшей
мере строку, содержащую знак охраны авторского права и
указание на то, где находится полное уведомление.

одна строка, содержащая название программы и краткое
описание того, что она делает.
(C) наименование (имя) автора 19гг

Это свободная программа; вы можете повторно распространять
ее и/или модифицировать ее в соответствии с Универсальной
Общественной Лицензией GNU, опубликованной Фондом Свободного
ПО; либо версии 2, либо (по вашему выбору) любой более
поздней версии.

Эта программа распространяется в надежде, что она будет
полезной, но БЕЗ КАКИХ-ЛИБО ГАРАНТИЙ; даже без подразумевае-
мых гарантий КОММЕРЧЕСКОЙ ЦЕННОСТИ или ПРИГОДНОСТИ ДЛЯ
КОНКРЕТНОЙ ЦЕЛИ.  Для получения подробных сведений смотрите
Универсальную Общественную Лицензию GNU.

Вы должны были получить копию Универсальной Общественной
Лицензии GNU вместе с этой программой; если нет, напишите
по адресу: Free Software Foundation, Inc., 51 Franklin Street,
Fifth Floor, Boston, MA 02110-1301 USA

Добавьте также сведения о том, как связаться с вами по
электронной и обычной почте.

Если программа интерактивная, сделайте так, чтобы при запуске
в интерактивном режиме она выдавала краткое уведомление типа
следующего:

Gnomovision, версия 69, (C) имя автора 19гг
Gnomovision поставляется АБСОЛЮТНО БЕЗ КАКИХ-ЛИБО ГАРАНТИЙ;
для получения подробностей напечатайте 'show w'.  Это свобод-
ная программа, и вы приглашаетесь повторно распространять ее
при определенных условиях; для получения подробностей введите
'show c'.

Гипотетические команды `show w' и `show c' должны показывать
соответствующие части Универсальной Общественной Лицензии.
Конечно, используемые вами команды могут называться как-ни-
будь иначе, нежели `show w' и `show c'; они даже могут выби-
раться с помощью мыши или быть пунктами меню -- все, что
подходит для вашей программы.

Вы также должны добиться того, чтобы ваш работодатель (если
вы работаете программистом) или ваше учебное заведение, если
таковое имеется, подписали в случае необходимости "отказ от
имущественных прав" на эту программу. Вот образец; замените
фамилии:

Компания ``Братья Ёёдины'' настоящим отказывается от всех
имущественных прав на программу 'Gnomovision' (которая делает
пассы в сторону компиляторов), написанную Абстрактным К.И.

подпись Мага Ната, 1 апреля 1989 г
Маг Нат, Президент фирмы Вице.

Данная Универсальная Общественная Лицензия не позволяет вам
включать вашу программу в программы, являющиеся частной соб-
ственностью. Если ваша программа -- это библиотека процедур,
вам стоит подумать, не будет ли лучше разрешить программам,
являющимся частной собственностью, связываться с вашей
библиотекой. Если это то, чего вы хотите, используйте вместо
этой Лицензии Универсальную Общественную Лицензию GNU для
библиотек.

[QueryBox]
Диалоговые окна запросов

В окнах запросов для выбора какого-либо варианта ответа (которые обычно задаются в виде экранных кнопок) Вы можете использовать либо клавиши со стрелками, либо выбрать ответ путем нажатия клавиши с выделенной в названии кнопки буквой, либо щелкнув по нужной кнопке мышкой.


[How to use help]
Как пользоваться помощью

При работе с программой Midnight Commander практически в любой момент можно обратиться к интерактивной подсказке, вызов которой осуществляется нажатием клавиши F1. Для перемещения в окне просмотра подсказки Вы можете использовать клавиши перемещения курсора (стрелки) или мышь. Стрелка вниз вызывает переход к следующей ссылке (выделены голубым фоном) или сдвиг текста на одну строку вверх. Стрелка вверх вызывает переход к предыдущей ссылке или сдвиг текста на одну строку вверх. Стрелка вправо вызывает переход по ссылке, которая в данный момент выделена синим фоном (текущая ссылка). По стрелке влево происходит переход к ранее просмотренным разделам подсказки.

Если Ваш терминал не поддерживает клавиши-стрелки, Вы можете использовать клавишу пробела для перехода к следующей странице подсказки и клавишу 'b' для перехода к предыдущей странице. Клавиша TAB вызывает переход к следующей ссылке, а нажатие ENTER - переход по текущей ссылке. При просмотре подсказки программа запоминает последовательность переходов по ссылкам и позволяет вернуться к ранее просмотренным разделам, воспользовавшись клавишей 'l' (last). Нажатие на ESC вызывает выход из окна подсказки.

По щелчку левой клавиши мыши происходит переход по ссылке или перемещение по тексту подсказки. Щелчок правой кнопкой мыши используется для переход к ранее просмотренным разделам.

Полный список управляющих комбинаций для окна просмотра подсказки:

Работают все клавиши управления перемещениемGeneral Movement Keys.

tab           Переход на следующую ссылку.
M-tab         Переход на предыдущую ссылку.
down          Переход на следующую ссылку или смещение
              текста на одну строку вверх.
up            Переход на следующую ссылку или смещение
              текста на одну строку вниз.
right, enter  Переход по текущей ссылке.
left, l       Переход к ранее просмотренным разделам.
F1            Помощь по использованию самой подсказки.
n             Переход к следующему разделу помощи.
p             Переход к предыдущему разделу помощи.
c             Переход к оглавлению подсказки.
F10, esc      Выход из окна просмотра подсказки.



Local variables:
fill-column: 58
end:
