/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmi;

import gnu.classpath.tools.rmi.Persistent;
import gnu.classpath.tools.rmi.rmid.ActivationSystemImpl;
import gnu.java.rmi.activation.BidiTable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;

public class PersistentBidiHashTable
extends BidiTable
implements Persistent {
    File database;
    WriteToDiskTask sheduled;
    long lastUpdated;

    private /* synthetic */ void finit$() {
        this.sheduled = null;
    }

    public PersistentBidiHashTable() {
        super(0);
        this.finit$();
    }

    public void init(File file, boolean bl) {
        try {
            this.database = file;
            if (this.database.exists()) {
                if (bl) {
                    this.k2v = new Hashtable();
                    this.v2k = new Hashtable();
                    this.database.delete();
                } else {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    AdaptedReader adaptedReader = new AdaptedReader(this, bufferedInputStream);
                    this.k2v = (Map)adaptedReader.readObject();
                    adaptedReader.close();
                    this.v2k = new Hashtable(this.k2v.size());
                    Iterator iterator = this.k2v.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        this.v2k.put(this.k2v.get(k), k);
                    }
                }
            } else {
                this.k2v = new Hashtable();
                this.v2k = new Hashtable();
            }
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to intialize with file " + file);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public synchronized void writeContent() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.database);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(this.k2v);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to write database to disk: " + this.database);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void markDirty() {
        if (System.currentTimeMillis() - this.lastUpdated > 300000L) {
            this.writeContent();
            this.lastUpdated = System.currentTimeMillis();
            if (this.sheduled != null) {
                this.sheduled.cancel();
                this.sheduled = null;
            }
        } else {
            if (this.sheduled != null) {
                this.sheduled.cancel();
            }
            this.sheduled = new WriteToDiskTask(this);
            Persistent.timer.schedule((TimerTask)this.sheduled, 5000);
        }
    }

    public void shutdown() {
        if (this.sheduled != null) {
            this.writeContent();
            this.sheduled = null;
        }
    }

    public void put(Object object, Object object2) {
        super.put(object, object2);
        this.markDirty();
    }

    public void removeKey(Object object) {
        super.removeKey(object);
        this.markDirty();
    }

    class AdaptedReader
    extends ObjectInputStream {
        private /* synthetic */ PersistentBidiHashTable this$0;

        AdaptedReader(PersistentBidiHashTable persistentBidiHashTable, InputStream inputStream) throws IOException {
            this.this$0 = persistentBidiHashTable;
            super(inputStream);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof ActivationSystemImpl) {
                return ActivationSystemImpl.singleton2;
            }
            return object;
        }
    }

    class WriteToDiskTask
    extends TimerTask {
        private /* synthetic */ PersistentBidiHashTable this$0;

        public void run() {
            this.this$0.writeContent();
            this.this$0.sheduled = null;
        }

        WriteToDiskTask(PersistentBidiHashTable persistentBidiHashTable) {
            this.this$0 = persistentBidiHashTable;
        }
    }
}

