/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    private byte[][] data;

    public ByteLookupTable(int n, byte[][] byArray) throws IllegalArgumentException {
        super(n, byArray.length);
        this.data = new byte[byArray.length][];
        for (int i = 0; i < byArray.length; ++i) {
            this.data[i] = byArray[i];
        }
    }

    public ByteLookupTable(int n, byte[] byArray) throws IllegalArgumentException {
        super(n, 1);
        if (byArray == null) {
            throw new NullPointerException("Null 'data' argument.");
        }
        this.data = new byte[][]{byArray};
    }

    public final byte[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) throws ArrayIndexOutOfBoundsException {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.data[0][nArray[i] - this.offset];
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.data[i][nArray[i] - this.offset];
            }
        }
        return nArray2;
    }

    public byte[] lookupPixel(byte[] byArray, byte[] byArray2) throws ArrayIndexOutOfBoundsException {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = this.data[0][byArray[i] - this.offset];
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = this.data[i][byArray[i] - this.offset];
            }
        }
        return byArray2;
    }
}

