/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EncodedKeyFactory
extends KeyFactorySpi {
    private static final Logger log;
    static /* synthetic */ Class class$gnu$java$security$jce$sig$EncodedKeyFactory;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    private static final Object invokeConstructor(String string, Object[] objectArray) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(string);
        try {
            Constructor constructor = EncodedKeyFactory.getConcreteCtor(clazz);
            Object object = constructor.newInstance(objectArray);
            return object;
        }
        catch (InstantiationException instantiationException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(instantiationException);
            throw invalidKeySpecException;
        }
        catch (IllegalAccessException illegalAccessException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(invalidKeySpecException);
            throw invalidKeySpecException;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(invocationTargetException);
            throw invalidKeySpecException;
        }
    }

    private static final Class getConcreteClass(String string) throws InvalidKeySpecException {
        try {
            Class clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(classNotFoundException);
            throw invalidKeySpecException;
        }
    }

    private static final Constructor getConcreteCtor(Class clazz) throws InvalidKeySpecException {
        try {
            Class clazz2;
            Class clazz3;
            Class clazz4;
            Class[] classArray = new Class[5];
            classArray[0] = Integer.TYPE;
            Class clazz5 = class$java$math$BigInteger;
            if (clazz5 == null) {
                clazz5 = classArray[1] = (class$java$math$BigInteger = EncodedKeyFactory.class("[Ljava.math.BigInteger;", false));
            }
            if ((clazz4 = class$java$math$BigInteger) == null) {
                clazz4 = classArray[2] = (class$java$math$BigInteger = EncodedKeyFactory.class("[Ljava.math.BigInteger;", false));
            }
            if ((clazz3 = class$java$math$BigInteger) == null) {
                clazz3 = classArray[3] = (class$java$math$BigInteger = EncodedKeyFactory.class("[Ljava.math.BigInteger;", false));
            }
            if ((clazz2 = class$java$math$BigInteger) == null) {
                clazz2 = class$java$math$BigInteger = EncodedKeyFactory.class("[Ljava.math.BigInteger;", false);
            }
            classArray[4] = clazz2;
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchMethodException);
            throw invalidKeySpecException;
        }
    }

    private static final Object invokeValueOf(String string, byte[] byArray) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(string);
        try {
            Method method = EncodedKeyFactory.getValueOfMethod(clazz);
            Object object = method.invoke(null, new Object[]{byArray});
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(illegalAccessException);
            throw invalidKeySpecException;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(invocationTargetException);
            throw invalidKeySpecException;
        }
    }

    private static final Method getValueOfMethod(Class clazz) throws InvalidKeySpecException {
        try {
            Class[] classArray = new Class[1];
            Class clazz2 = array$B;
            if (clazz2 == null) {
                clazz2 = array$B = EncodedKeyFactory.class("[B", true);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("valueOf", classArray);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchMethodException);
            throw invalidKeySpecException;
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        log.entering(this.getClass().getName(), "engineGeneratePublic()", keySpec);
        PublicKey publicKey = null;
        if (keySpec instanceof DSAPublicKeySpec) {
            publicKey = this.decodeDSSPublicKey((DSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof RSAPublicKeySpec) {
            publicKey = this.decodeRSAPublicKey((RSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof DHPublicKeySpec) {
            publicKey = this.decodeDHPublicKey((DHPublicKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof X509EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            boolean bl = false;
            try {
                publicKey = DSSPublicKey.valueOf(byArray);
                bl = true;
            }
            catch (InvalidParameterException invalidParameterException) {
                log.log(Level.FINE, "Exception in DSSPublicKey.valueOf(). Ignore", invalidParameterException);
            }
            if (!bl) {
                try {
                    publicKey = GnuRSAPublicKey.valueOf(byArray);
                    bl = true;
                }
                catch (InvalidParameterException invalidParameterException) {
                    log.log(Level.FINE, "Exception in GnuRSAPublicKey.valueOf(). Ignore", invalidParameterException);
                }
            }
            if (!bl) {
                publicKey = this.decodeDHPublicKey(byArray);
            }
        }
        log.exiting(this.getClass().getName(), "engineGeneratePublic()", publicKey);
        return publicKey;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        log.entering(this.getClass().getName(), "engineGeneratePrivate()", keySpec);
        PrivateKey privateKey = null;
        if (keySpec instanceof DSAPrivateKeySpec) {
            privateKey = this.decodeDSSPrivateKey((DSAPrivateKeySpec)keySpec);
        } else if (keySpec instanceof RSAPrivateCrtKeySpec) {
            privateKey = this.decodeRSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
        } else if (keySpec instanceof DHPrivateKeySpec) {
            privateKey = this.decodeDHPrivateKey((DHPrivateKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            boolean bl = false;
            try {
                privateKey = DSSPrivateKey.valueOf(byArray);
                bl = true;
            }
            catch (InvalidParameterException invalidParameterException) {
                log.log(Level.FINE, "Exception in DSSPrivateKey.valueOf(). Ignore", invalidParameterException);
            }
            if (!bl) {
                try {
                    privateKey = GnuRSAPrivateKey.valueOf(byArray);
                    bl = true;
                }
                catch (InvalidParameterException invalidParameterException) {
                    log.log(Level.FINE, "Exception in GnuRSAPrivateKey.valueOf(). Ignore", invalidParameterException);
                }
            }
            if (!bl) {
                privateKey = this.decodeDHPrivateKey(byArray);
            }
        }
        log.exiting(this.getClass().getName(), "engineGeneratePrivate()", privateKey);
        return privateKey;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof PublicKey && "X.509".equalsIgnoreCase(key.getFormat())) {
            Class clazz2 = class$java$security$spec$X509EncodedKeySpec;
            if (clazz2 == null) {
                clazz2 = class$java$security$spec$X509EncodedKeySpec = EncodedKeyFactory.class("[Ljava.security.spec.X509EncodedKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
        }
        if (key instanceof PrivateKey && "PKCS#8".equalsIgnoreCase(key.getFormat())) {
            Class clazz3 = class$java$security$spec$PKCS8EncodedKeySpec;
            if (clazz3 == null) {
                clazz3 = class$java$security$spec$PKCS8EncodedKeySpec = EncodedKeyFactory.class("[Ljava.security.spec.PKCS8EncodedKeySpec;", false);
            }
            if (clazz.isAssignableFrom(clazz3)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
        }
        throw new InvalidKeySpecException("Unsupported format or invalid key spec class");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Key translation not supported");
    }

    private final DSSPublicKey decodeDSSPublicKey(DSAPublicKeySpec dSAPublicKeySpec) {
        BigInteger bigInteger = dSAPublicKeySpec.getP();
        BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
        BigInteger bigInteger3 = dSAPublicKeySpec.getG();
        BigInteger bigInteger4 = dSAPublicKeySpec.getY();
        return new DSSPublicKey(2, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    private final GnuRSAPublicKey decodeRSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        BigInteger bigInteger = rSAPublicKeySpec.getModulus();
        BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
        return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
    }

    private final DHPublicKey decodeDHPublicKey(DHPublicKeySpec dHPublicKeySpec) throws InvalidKeySpecException {
        BigInteger bigInteger = dHPublicKeySpec.getP();
        BigInteger bigInteger2 = dHPublicKeySpec.getG();
        BigInteger bigInteger3 = dHPublicKeySpec.getY();
        Object[] objectArray = new Object[5];
        objectArray[0] = new Integer(2);
        objectArray[2] = bigInteger;
        objectArray[3] = bigInteger2;
        objectArray[4] = bigInteger3;
        Object[] objectArray2 = objectArray;
        Object object = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPublicKey", objectArray2);
        return (DHPublicKey)object;
    }

    private final DHPublicKey decodeDHPublicKey(byte[] byArray) throws InvalidKeySpecException {
        Object object = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPublicKey", byArray);
        return (DHPublicKey)object;
    }

    private final PrivateKey decodeDSSPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        BigInteger bigInteger = dSAPrivateKeySpec.getP();
        BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
        BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
        BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
        return new DSSPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    private final PrivateKey decodeRSAPrivateKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        BigInteger bigInteger = rSAPrivateCrtKeySpec.getModulus();
        BigInteger bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
        BigInteger bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
        BigInteger bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
        BigInteger bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
        BigInteger bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
        BigInteger bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
        BigInteger bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
        return new GnuRSAPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    private final DHPrivateKey decodeDHPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) throws InvalidKeySpecException {
        BigInteger bigInteger = dHPrivateKeySpec.getP();
        BigInteger bigInteger2 = dHPrivateKeySpec.getG();
        BigInteger bigInteger3 = dHPrivateKeySpec.getX();
        Object[] objectArray = new Object[5];
        objectArray[0] = new Integer(3);
        objectArray[2] = bigInteger;
        objectArray[3] = bigInteger2;
        objectArray[4] = bigInteger3;
        Object[] objectArray2 = objectArray;
        Object object = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPrivateKey", objectArray2);
        return (DHPrivateKey)object;
    }

    private final DHPrivateKey decodeDHPrivateKey(byte[] byArray) throws InvalidKeySpecException {
        Object object = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPrivateKey", byArray);
        return (DHPrivateKey)object;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$gnu$java$security$jce$sig$EncodedKeyFactory;
        if (clazz == null) {
            clazz = class$gnu$java$security$jce$sig$EncodedKeyFactory = EncodedKeyFactory.class("[Lgnu.java.security.jce.sig.EncodedKeyFactory;", false);
        }
        log = Logger.getLogger(clazz.getName());
    }
}

