/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    private static final long serialVersionUID = 940485415728614849L;
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer;
    private StyleChangeListener styleChangeListener;
    Vector edits;

    Edit getEditForParagraphAndIndex(AbstractDocument.BranchElement branchElement, int n) {
        Edit edit;
        int n2 = this.edits.size();
        int n3 = 0;
        while (n3 < n2) {
            edit = (Edit)this.edits.elementAt(n3);
            if (edit.e.equals(branchElement)) {
                return edit;
            }
            ++n3;
        }
        edit = new Edit(branchElement, n, null, null);
        this.edits.add(edit);
        return edit;
    }

    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        Style style2 = styleContext.addStyle(string, style);
        if (this.styleChangeListener == null) {
            this.styleChangeListener = new StyleChangeListener();
        }
        style2.addChangeListener(this.styleChangeListener);
        return style2;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        SectionElement sectionElement = new SectionElement();
        AbstractDocument.BranchElement branchElement = new AbstractDocument.BranchElement(sectionElement, null);
        Element[] elementArray = new Element[]{branchElement};
        sectionElement.replace(0, 0, elementArray);
        AbstractDocument.LeafElement leafElement = new AbstractDocument.LeafElement(branchElement, null, 0, 1);
        elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        return sectionElement;
    }

    public Element getCharacterElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    public Style getLogicalStyle(int n) {
        Element element = this.getParagraphElement(n);
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = attributeSet.getResolveParent();
        if (attributeSet2 instanceof Style) {
            return (Style)attributeSet2;
        }
        return null;
    }

    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n));
        }
        if (element != null) {
            return element.getParentElement();
        }
        return element;
    }

    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (n2 == 0) {
            return;
        }
        try {
            Element element;
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n, n2, defaultDocumentEvent);
            Element element2 = this.getDefaultRootElement();
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3 && n4 != (element = this.getCharacterElement(n4)).getEndOffset()) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n4 = element.getEndOffset();
            }
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var6_13 = null;
        }
        this.writeUnlock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (element == null) {
            return;
        }
        try {
            this.writeLock();
            if (!(element instanceof AbstractDocument.AbstractElement)) throw new AssertionError((Object)"paragraph elements are expected to beinstances of AbstractDocument.AbstractElement");
            AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)element;
            abstractElement.setResolveParent(style);
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE);
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        this.writeUnlock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n + n2 - 1);
            if (n4 < n3) {
                n4 = n3;
            }
            int n5 = n3;
            while (true) {
                block6: {
                    if (n5 <= n4) break block6;
                    this.fireChangedUpdate(defaultDocumentEvent);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    break;
                }
                Element element2 = element.getElement(n5);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                ++n5;
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var6_14 = null;
        }
        this.writeUnlock();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        ElementSpec elementSpec;
        int n;
        super.insertUpdate(defaultDocumentEvent, attributeSet);
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        int n2 = defaultDocumentEvent.getOffset();
        int n3 = defaultDocumentEvent.getLength();
        int n4 = n2 + n3;
        AttributeSet attributeSet2 = this.getParagraphElement(n4).getAttributes();
        Segment segment = new Segment();
        try {
            this.getText(n2, n3, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        int n5 = 0;
        Vector vector = new Vector();
        ElementSpec elementSpec2 = null;
        short s = 6;
        boolean bl = false;
        Element element = this.getCharacterElement(n2);
        Element element2 = this.getCharacterElement(n4);
        Element element3 = this.getParagraphElement(n2);
        Element element4 = this.getParagraphElement(n4);
        int n6 = segment.offset + segment.count;
        if (n2 > 0) {
            try {
                String string = this.getText(n2 - 1, 1);
                if (string.equals("\n")) {
                    s = this.handleInsertAfterNewline(vector, n2, n4, element3, element4, attributeSet2);
                    bl = true;
                    n = 0;
                    while (n < vector.size()) {
                        if (((ElementSpec)vector.get(n)).getType() == 1) {
                            elementSpec2 = (ElementSpec)vector.get(n);
                        }
                        ++n;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError();
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }
        int n7 = segment.offset;
        while (n7 < n6) {
            ++n5;
            if (segment.array[n7] == '\n') {
                vector.add(new ElementSpec(attributeSet, 3, n5));
                vector.add(new ElementSpec(null, 2));
                elementSpec2 = new ElementSpec(attributeSet2, 1);
                vector.add(elementSpec2);
                n5 = 0;
            }
            ++n7;
        }
        if (n5 > 0) {
            vector.add(new ElementSpec(attributeSet, 3, n5));
        }
        if (elementSpec2 != null) {
            if (bl) {
                elementSpec2.setDirection(s);
            } else if (element3.getEndOffset() != n4) {
                elementSpec2.setDirection((short)7);
            } else {
                Element element5 = element3.getParentElement();
                n = element5.getElementIndex(n2);
                if (n + 1 < element5.getElementCount() && !element5.getElement(n + 1).isLeaf()) {
                    elementSpec2.setDirection((short)5);
                }
            }
        }
        if ((elementSpec = (ElementSpec)vector.lastElement()).getType() == 3) {
            Element element6 = element3.getElement(element3.getElementIndex(n2));
            if (element6.getEndOffset() == n4) {
                if (n4 < this.getLength() && element2.getAttributes().isEqual(attributeSet) && elementSpec.getType() == 3) {
                    elementSpec.setDirection((short)5);
                }
            } else if (elementSpec2 != null && elementSpec2.getDirection() == 7 && element6.getAttributes().isEqual(attributeSet)) {
                elementSpec.setDirection((short)5);
            }
        }
        ElementSpec elementSpec3 = (ElementSpec)vector.firstElement();
        if (element.getAttributes().isEqual(attributeSet) && elementSpec3.getType() == 3) {
            elementSpec3.setDirection((short)4);
        }
        ElementSpec[] elementSpecArray = (ElementSpec[])vector.toArray(new ElementSpec[vector.size()]);
        this.buffer.insert(n2, n3, elementSpecArray, defaultDocumentEvent);
    }

    short handleInsertAfterNewline(Vector vector, int n, int n2, Element element, Element element2, AttributeSet attributeSet) {
        if (element.getParentElement() == element2.getParentElement()) {
            vector.add(new ElementSpec(attributeSet, 2));
            vector.add(new ElementSpec(attributeSet, 1));
            if (element2.getStartOffset() != n2) {
                return 7;
            }
            Element element3 = element2.getParentElement();
            if (element3.getElementCount() > element3.getElementIndex(n) + 1) {
                return 5;
            }
        }
        return 6;
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    public Enumeration getStyleNames() {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyleNames();
    }

    protected void styleChanged(Style style) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        block8: {
            block7: {
                if (elementSpecArray == null) return;
                if (elementSpecArray.length == 0) {
                    return;
                }
                try {
                    Object object;
                    this.writeLock();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= elementSpecArray.length) {
                            n2 = stringBuffer.length();
                            if (n2 != 0) break;
                            Object var4_6 = null;
                            break block7;
                        }
                        object = elementSpecArray[n2];
                        if (((ElementSpec)object).getArray() != null && ((ElementSpec)object).getLength() > 0) {
                            stringBuffer.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                        }
                        ++n2;
                    }
                    object = this.content.insertString(n, stringBuffer.toString());
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.INSERT);
                    defaultDocumentEvent.addEdit((UndoableEdit)object);
                    this.buffer.insert(n, n2, elementSpecArray, defaultDocumentEvent);
                    this.fireInsertUpdate(defaultDocumentEvent);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            this.writeUnlock();
            return;
        }
        Object var4_8 = null;
        this.writeUnlock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(ElementSpec[] elementSpecArray) {
        this.writeLock();
        try {
            try {
                Object object;
                int n = this.getLength();
                if (n > 0) {
                    this.remove(0, n);
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                while (true) {
                    if (n2 >= elementSpecArray.length) break;
                    object = elementSpecArray[n2];
                    if (((ElementSpec)object).getArray() != null && ((ElementSpec)object).getLength() > 0) {
                        stringBuilder.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                    }
                    ++n2;
                }
                AbstractDocument.Content content = this.getContent();
                object = content.insertString(0, stringBuilder.toString());
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(0, stringBuilder.length(), DocumentEvent.EventType.INSERT);
                defaultDocumentEvent.addEdit((UndoableEdit)object);
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
                Element element = this.createLeafElement(branchElement, null, 0, 1);
                branchElement.replace(0, 0, new Element[]{element});
                ElementBuffer elementBuffer = new ElementBuffer(branchElement);
                elementBuffer.insert(0, stringBuilder.length(), elementSpecArray, new AbstractDocument.DefaultDocumentEvent(0, stringBuilder.length(), DocumentEvent.EventType.INSERT));
                Element element2 = branchElement.getElement(0);
                AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)this.getDefaultRootElement();
                Element[] elementArray = new Element[element2.getElementCount()];
                int n3 = 0;
                while (true) {
                    if (n3 >= elementArray.length) break;
                    elementArray[n3] = element2.getElement(n3);
                    ((AbstractDocument.AbstractElement)elementArray[n3]).element_parent = branchElement2;
                    ++n3;
                }
                Element[] elementArray2 = new Element[branchElement2.getElementCount()];
                int n4 = 0;
                while (true) {
                    block10: {
                        if (n4 < elementArray2.length) break block10;
                        branchElement2.replace(0, elementArray2.length, elementArray);
                        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement2, 0, elementArray2, elementArray));
                        this.fireInsertUpdate(defaultDocumentEvent);
                        this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                        break;
                    }
                    elementArray2[n4] = branchElement2.getElement(n4);
                    ++n4;
                }
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }
        catch (Throwable throwable) {
            Object var3_20 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var3_21 = null;
        }
        this.writeUnlock();
    }

    private final /* synthetic */ void this() {
        this.edits = new Vector();
    }

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.this();
        this.buffer = new ElementBuffer(this.createDefaultRoot());
        this.setLogicalStyle(0, styleContext.getStyle("default"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Edit {
        Element e;
        int index;
        Vector removed;
        Vector added;

        public Element[] getRemovedElements() {
            int n = this.removed.size();
            Element[] elementArray = new Element[n];
            int n2 = 0;
            while (n2 < n) {
                elementArray[n2] = (Element)this.removed.elementAt(n2);
                ++n2;
            }
            return elementArray;
        }

        public Element[] getAddedElements() {
            int n = this.added.size();
            Element[] elementArray = new Element[n];
            int n2 = 0;
            while (n2 < n) {
                elementArray[n2] = (Element)this.added.elementAt(n2);
                ++n2;
            }
            return elementArray;
        }

        private final boolean contains(Vector vector, Element element) {
            if (element == null) {
                return false;
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)vector.get(n2);
                if (element2 != null && element2.getAttributes().isEqual(element.getAttributes()) && element2.getName().equals(element.getName()) && element2.getStartOffset() == element.getStartOffset() && element2.getEndOffset() == element.getEndOffset() && element2.getParentElement().equals(element.getParentElement()) && element2.getElementCount() == element.getElementCount()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void addRemovedElement(Element element) {
            if (!this.contains(this.removed, element)) {
                this.removed.add(element);
            }
        }

        public void addRemovedElements(Element[] elementArray) {
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < elementArray.length) {
                if (!this.contains(this.removed, elementArray[n])) {
                    this.removed.add(elementArray[n]);
                }
                ++n;
            }
        }

        public void addAddedElement(Element element) {
            if (!this.contains(this.added, element)) {
                this.added.add(element);
            }
        }

        public void addAddedElements(Element[] elementArray) {
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < elementArray.length) {
                if (!this.contains(this.added, elementArray[n])) {
                    this.added.add(elementArray[n]);
                }
                ++n;
            }
        }

        private final /* synthetic */ void this() {
            this.removed = new Vector();
            this.added = new Vector();
        }

        public Edit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.this();
            this.e = element;
            this.index = n;
            this.addRemovedElements(elementArray);
            this.addAddedElements(elementArray2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StyleChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Style style = (Style)changeEvent.getSource();
            DefaultStyledDocument.this.styleChanged(style);
        }

        private StyleChangeListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public String getName() {
            return "section";
        }

        public SectionElement() {
            super(null, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ElementBuffer
    implements Serializable {
        private static final long serialVersionUID = 1688745877691146623L;
        private Element root;
        private int offset;
        private int endOffset;
        private int length;
        private int pos;
        private Element lastFractured;
        private boolean fracNotCreated;
        private Stack elementStack;
        AbstractDocument.DefaultDocumentEvent documentEvent;

        public Element getRootElement() {
            return this.root;
        }

        public void remove(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n2 == 0) {
                return;
            }
            this.offset = n;
            this.length = n2;
            this.pos = this.offset;
            this.documentEvent = defaultDocumentEvent;
            this.removeUpdate();
        }

        protected void removeUpdate() {
            int n;
            Element[] elementArray;
            int n2 = this.root.getElementIndex(this.offset);
            int n3 = this.root.getElementIndex(this.offset + this.length);
            Element[] elementArray2 = new Element[]{};
            int n4 = -1;
            int n5 = -1;
            int n6 = n2;
            while (n6 < n3) {
                elementArray = (Element[])this.root.getElement(n6);
                n = elementArray.getElementIndex(this.offset);
                int n7 = elementArray.getElementIndex(this.offset + this.length);
                if (n == elementArray.getStartOffset() && n7 == elementArray.getEndOffset()) {
                    if (n4 == -1) {
                        n4 = n6;
                        n5 = n6;
                    } else {
                        n5 = n6;
                    }
                } else {
                    int n8 = n7 - n;
                    Element[] elementArray3 = new Element[n8];
                    int n9 = n;
                    while (n9 < n7) {
                        elementArray3[n9] = elementArray.getElement(n9);
                        ++n9;
                    }
                    Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex((AbstractDocument.BranchElement)elementArray, n);
                    edit.addRemovedElements(elementArray3);
                }
                ++n6;
            }
            if (n4 != -1) {
                n6 = n5 - n4;
                elementArray = new Element[n6];
                n = n4;
                while (n < n5) {
                    elementArray[n] = this.root.getElement(n);
                    ++n;
                }
                Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex((AbstractDocument.BranchElement)this.root, n4);
                edit.addRemovedElements(elementArray);
            }
        }

        protected void changeUpdate() {
            Element[] elementArray;
            Element element = DefaultStyledDocument.this.getCharacterElement(this.offset);
            Element[] elementArray2 = this.split(element, this.offset, 0, element.getElementIndex(this.offset));
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
            int n = branchElement.getElementIndex(this.offset);
            Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n);
            if (elementArray2[1] != null) {
                Element[] elementArray3;
                if (elementArray2[0] == null) {
                    elementArray3 = new Element[]{};
                    elementArray = new Element[]{elementArray2[1]};
                    ++n;
                } else {
                    elementArray3 = new Element[]{element};
                    elementArray = new Element[]{elementArray2[0], elementArray2[1]};
                }
                edit.addRemovedElements(elementArray3);
                edit.addAddedElements(elementArray);
            }
            int n2 = this.offset + this.length;
            element = DefaultStyledDocument.this.getCharacterElement(n2);
            elementArray2 = this.split(element, n2, 0, element.getElementIndex(n2));
            branchElement = (AbstractDocument.BranchElement)element.getParentElement();
            if (elementArray2[0] != null) {
                Element[] elementArray4;
                if (elementArray2[1] == null) {
                    elementArray = new Element[]{};
                    elementArray4 = new Element[]{elementArray2[1]};
                } else {
                    elementArray = new Element[]{element};
                    elementArray4 = new Element[]{elementArray2[0], elementArray2[1]};
                }
                edit.addRemovedElements(elementArray);
                edit.addAddedElements(elementArray4);
            }
        }

        public void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n2 == 0) {
                return;
            }
            this.offset = n;
            this.pos = n;
            this.length = n2;
            this.documentEvent = defaultDocumentEvent;
            this.changeUpdate();
        }

        public Element clone(Element element, Element element2) {
            Element element3 = element2;
            if (element2 instanceof AbstractDocument.BranchElement) {
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element2;
                AbstractDocument.BranchElement branchElement2 = new AbstractDocument.BranchElement(element, branchElement.getAttributes());
                int n = branchElement2.getElementCount();
                Element[] elementArray = new Element[n];
                int n2 = 0;
                while (n2 < n) {
                    elementArray[n2] = this.clone(branchElement2, branchElement2.getElement(n2));
                    ++n2;
                }
                branchElement2.replace(0, 0, elementArray);
                element3 = branchElement2;
            } else if (element2 instanceof AbstractDocument.LeafElement) {
                element3 = new AbstractDocument.LeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            return element3;
        }

        public void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n2 == 0) {
                return;
            }
            this.offset = n;
            this.pos = n;
            this.endOffset = n + n2;
            this.length = n2;
            this.documentEvent = defaultDocumentEvent;
            DefaultStyledDocument.this.edits.removeAllElements();
            this.elementStack.removeAllElements();
            this.lastFractured = null;
            this.fracNotCreated = false;
            this.insertUpdate(elementSpecArray);
            int n3 = DefaultStyledDocument.this.edits.size();
            int n4 = 0;
            while (n4 < n3) {
                Edit edit = (Edit)DefaultStyledDocument.this.edits.get(n4);
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)edit.e;
                Element[] elementArray = edit.getRemovedElements();
                Element[] elementArray2 = edit.getAddedElements();
                if (elementArray.length > 0 || elementArray2.length > 0) {
                    if (edit.index + elementArray.length <= branchElement.getElementCount()) {
                        branchElement.replace(edit.index, elementArray.length, elementArray2);
                        AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, edit.index, elementArray, elementArray2);
                        defaultDocumentEvent.addEdit(elementEdit);
                    } else {
                        System.err.println("WARNING: Tried to replace elements ");
                        System.err.print("beyond boundaries: elementCount: ");
                        System.err.println(branchElement.getElementCount());
                        System.err.print("index: " + edit.index);
                        System.err.println(", removed.length: " + elementArray.length);
                    }
                }
                ++n4;
            }
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            Element element = this.root;
            while (!element.isLeaf()) {
                int n = element.getElementIndex(this.offset);
                this.elementStack.push(element);
                element = element.getElement(n);
            }
            int n = 0;
            short s = elementSpecArray[0].getType();
            if (s == 3) {
                this.insertFirstContentTag(elementSpecArray);
                this.pos += elementSpecArray[0].length;
                n = 1;
            } else {
                this.createFracture(elementSpecArray);
                n = 0;
            }
            while (n < elementSpecArray.length) {
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.elementStack.peek();
                block0 : switch (elementSpecArray[n].getType()) {
                    case 1: {
                        switch (elementSpecArray[n].getDirection()) {
                            case 7: {
                                this.fracNotCreated = false;
                                this.insertFracture(elementSpecArray[n]);
                                if (!this.fracNotCreated) break block0;
                                if (this.lastFractured != null) {
                                    this.elementStack.push(this.lastFractured.getParentElement());
                                    break;
                                }
                                this.elementStack.push(branchElement.getElement(0));
                                break;
                            }
                            case 5: {
                                int n2 = branchElement.getElementIndex(this.pos) + 1;
                                this.elementStack.push(branchElement.getElement(n2));
                                break;
                            }
                            default: {
                                Element element2 = null;
                                if (elementSpecArray.length > n + 1) {
                                    int n3 = 0;
                                    if (branchElement.getElementCount() > 0) {
                                        n3 = branchElement.getElementIndex(this.pos) + 1;
                                    }
                                    Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n3);
                                    element2 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(branchElement, elementSpecArray[n].getAttributes());
                                    edit.added.add(element2);
                                    this.elementStack.push(element2);
                                    break;
                                }
                                element2 = this.insertParagraph(branchElement, this.pos);
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.elementStack.pop();
                        break;
                    }
                    case 3: {
                        this.insertContentTag(elementSpecArray[n]);
                        this.offset = this.pos;
                        break;
                    }
                }
                ++n;
            }
        }

        private final Element insertParagraph(AbstractDocument.BranchElement branchElement, int n) {
            Element element;
            int n2 = branchElement.getElementIndex(n);
            Element element2 = branchElement.getElement(n2);
            Element[] elementArray = this.split(element2, n, 0, 0);
            Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n2 + 1);
            if (elementArray[1] != null) {
                Element[] elementArray2;
                Element[] elementArray3;
                if (elementArray[0] == null) {
                    elementArray3 = new Element[]{};
                    if (elementArray[1] instanceof AbstractDocument.BranchElement) {
                        elementArray2 = new Element[]{elementArray[1]};
                        element = elementArray[1];
                    } else {
                        element = DefaultStyledDocument.this.createBranchElement(branchElement, null);
                        elementArray2 = new Element[]{element, elementArray[1]};
                    }
                    ++n2;
                } else {
                    elementArray3 = new Element[]{element2};
                    if (elementArray[1] instanceof AbstractDocument.BranchElement) {
                        element = elementArray[1];
                        elementArray2 = new Element[]{elementArray[0], elementArray[1]};
                    } else {
                        element = DefaultStyledDocument.this.createBranchElement(branchElement, null);
                        elementArray2 = new Element[]{elementArray[0], element, elementArray[1]};
                    }
                }
                edit.addAddedElements(elementArray2);
                edit.addRemovedElements(elementArray3);
            } else {
                element = DefaultStyledDocument.this.createBranchElement(branchElement, null);
                edit.addAddedElement(element);
            }
            return element;
        }

        private final void insertFirstContentTag(ElementSpec[] elementSpecArray) {
            ElementSpec elementSpec = elementSpecArray[0];
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.elementStack.peek();
            int n = branchElement.getElementIndex(this.pos);
            Element element = branchElement.getElement(n);
            int n2 = this.pos + elementSpec.length;
            boolean bl = false;
            if (elementSpecArray.length == 1) {
                bl = true;
            }
            boolean bl2 = bl;
            Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n);
            switch (elementSpec.getDirection()) {
                case 4: {
                    if (element.getEndOffset() == n2 || bl2) break;
                    Element element2 = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), element.getStartOffset(), n2);
                    edit.addAddedElement(element2);
                    edit.addRemovedElement(element);
                    this.offset = n2;
                    break;
                }
                case 5: {
                    if (this.pos == 0) break;
                    Element element3 = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), element.getStartOffset(), this.pos);
                    edit.addAddedElement(element3);
                    Element element4 = branchElement.getElement(n + 1);
                    if (bl2) {
                        element3 = DefaultStyledDocument.this.createLeafElement(branchElement, element4.getAttributes(), this.pos, element4.getEndOffset());
                    } else {
                        element3 = DefaultStyledDocument.this.createLeafElement(branchElement, element4.getAttributes(), this.pos, n2);
                        this.pos = n2;
                    }
                    edit.addAddedElement(element3);
                    edit.addRemovedElement(element);
                    edit.addRemovedElement(element4);
                    break;
                }
                default: {
                    Element element5;
                    if (element.getStartOffset() != this.pos) {
                        element5 = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), element.getStartOffset(), this.pos);
                        edit.addAddedElement(element5);
                    }
                    edit.addRemovedElement(element);
                    element5 = DefaultStyledDocument.this.createLeafElement(branchElement, elementSpec.getAttributes(), this.pos, n2);
                    edit.addAddedElement(element5);
                    if (element.getEndOffset() != this.endOffset) {
                        this.recreateLeaves(n2, branchElement, bl2);
                        break;
                    }
                    this.offset = n2;
                }
            }
        }

        private final void insertContentTag(ElementSpec elementSpec) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.elementStack.peek();
            int n = elementSpec.getLength();
            short s = elementSpec.getDirection();
            AttributeSet attributeSet = elementSpec.getAttributes();
            if (s == 5) {
                int n2 = branchElement.getElementIndex(this.pos);
                Element element = branchElement.getElement(n2);
                Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n2);
                if (branchElement.getStartOffset() > this.pos) {
                    Element element2 = branchElement.getElement(0);
                    Element element3 = DefaultStyledDocument.this.createLeafElement(branchElement, element2.getAttributes(), this.pos, element2.getEndOffset());
                    edit.addAddedElement(element3);
                    edit.addRemovedElement(element2);
                } else if (branchElement.getElementCount() > n2 + 1 && this.pos == element.getStartOffset() && !element.equals(this.lastFractured)) {
                    Element element4 = branchElement.getElement(n2 + 1);
                    Element element5 = DefaultStyledDocument.this.createLeafElement(branchElement, element4.getAttributes(), this.pos, element4.getEndOffset());
                    edit.addAddedElement(element5);
                    edit.addRemovedElement(element4);
                    edit.addRemovedElement(element);
                } else {
                    AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)branchElement.getParentElement();
                    int n3 = branchElement2.getElementIndex(this.pos);
                    AbstractDocument.BranchElement branchElement3 = (AbstractDocument.BranchElement)branchElement2.getElement(n3 + 1);
                    AttributeSet attributeSet2 = elementSpec.getAttributes();
                    if (branchElement3 != null) {
                        Element element6 = branchElement3.getElement(0);
                        Edit edit2 = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement3, 0);
                        Element element7 = DefaultStyledDocument.this.createLeafElement(branchElement3, attributeSet2, this.pos, element6.getEndOffset());
                        edit2.addAddedElement(element7);
                        edit2.addRemovedElement(element6);
                    }
                }
            } else {
                int n4 = this.pos + n;
                Element element = DefaultStyledDocument.this.createLeafElement(branchElement, elementSpec.getAttributes(), this.pos, n4);
                if (branchElement.getElementCount() > 0) {
                    int n5 = branchElement.getElementIndex(this.pos);
                    Element element8 = branchElement.getElement(n5);
                    boolean bl = element8.isLeaf();
                    AbstractDocument.BranchElement branchElement4 = branchElement;
                    if (!bl) {
                        branchElement4 = (AbstractDocument.BranchElement)element8;
                    }
                    if (this.pos > element8.getStartOffset()) {
                        ++n5;
                    }
                    Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n5);
                    edit.addAddedElement(element);
                    if (n4 != branchElement4.getEndOffset()) {
                        this.recreateLeaves(n4, branchElement4, bl);
                        if (bl) {
                            edit.addRemovedElement(element8);
                        }
                    }
                } else {
                    branchElement.replace(0, 0, new Element[]{element});
                }
            }
            this.pos += n;
        }

        private final void createFracture(ElementSpec[] elementSpecArray) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.elementStack.peek();
            int n = branchElement.getElementIndex(this.offset);
            Element element = branchElement.getElement(n);
            Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n);
            AttributeSet attributeSet = element.getAttributes();
            if (this.offset != 0) {
                Element element2 = DefaultStyledDocument.this.createLeafElement(branchElement, attributeSet, element.getStartOffset(), this.offset);
                edit.addAddedElement(element2);
                edit.addRemovedElement(element);
            }
        }

        private final void recreateLeaves(int n, AbstractDocument.BranchElement branchElement, boolean bl) {
            int n2 = branchElement.getElementIndex(n);
            Element element = branchElement.getElement(n2);
            AttributeSet attributeSet = element.getAttributes();
            if (!bl) {
                AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(branchElement, attributeSet);
                Element element2 = DefaultStyledDocument.this.createLeafElement(branchElement2, attributeSet, n, element.getEndOffset());
                branchElement2.replace(0, 0, new Element[]{element2});
                AbstractDocument.BranchElement branchElement3 = (AbstractDocument.BranchElement)branchElement.getParentElement();
                int n3 = branchElement3.getElementCount();
                Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement3, n3);
                edit.addAddedElement(branchElement2);
                int n4 = branchElement.getElementCount();
                Element[] elementArray = new Element[n4 - (n2 + 1)];
                int n5 = 0;
                int n6 = n2 + 1;
                while (n6 < n4) {
                    elementArray[n5++] = branchElement.getElement(n6);
                    ++n6;
                }
                edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n2);
                edit.addRemovedElements(elementArray);
                Element[] elementArray2 = this.recreateAfterFracture(elementArray, branchElement2, 0, element.getEndOffset());
                branchElement2.replace(1, 0, elementArray2);
                this.lastFractured = element2;
                this.pos = branchElement2.getEndOffset();
            } else {
                Element element3 = DefaultStyledDocument.this.createLeafElement(branchElement, attributeSet, n, element.getEndOffset());
                Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n2);
                edit.addAddedElement(element3);
            }
        }

        private final Element[] split(Element element, int n, int n2, int n3) {
            if ((n == element.getStartOffset() || n == element.getEndOffset()) && n2 == 0 && element.isLeaf()) {
                return new Element[2];
            }
            Element[] elementArray = new Element[2];
            if (element instanceof AbstractDocument.BranchElement) {
                int n4 = element.getElementIndex(n);
                Element element2 = element.getElement(n4);
                Element[] elementArray2 = this.split(element2, n, n2, n3);
                int n5 = element.getElementCount();
                if (elementArray2[1] != null) {
                    Element element3;
                    Element[] elementArray3;
                    Element[] elementArray4;
                    Element[] elementArray5;
                    if (elementArray2[0] == null) {
                        elementArray5 = new Element[n5 - n4 - 1];
                        elementArray4 = new Element[n5 - n4 - 1];
                        elementArray3 = new Element[]{};
                    } else {
                        elementArray5 = new Element[n5 - n4];
                        elementArray4 = new Element[n5 - n4];
                        elementArray3 = new Element[]{elementArray2[0]};
                    }
                    elementArray4[0] = elementArray2[1];
                    int n6 = n4;
                    while (n6 < n5) {
                        element3 = element.getElement(n6);
                        int n7 = n6 - n5 + elementArray5.length;
                        elementArray5[n7] = element3;
                        if (n7 != 0) {
                            elementArray4[n7] = element3;
                        }
                        ++n6;
                    }
                    Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex((AbstractDocument.BranchElement)element, n3);
                    edit.addRemovedElements(elementArray5);
                    edit.addAddedElements(elementArray3);
                    element3 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(element.getParentElement(), element.getAttributes());
                    ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray4);
                    Element[] elementArray6 = new Element[2];
                    elementArray6[1] = element3;
                    elementArray = elementArray6;
                } else {
                    Element[] elementArray7 = new Element[n5 - n4];
                    int n8 = n4;
                    while (n8 < n5) {
                        elementArray7[n8 - n4] = element.getElement(n8);
                        ++n8;
                    }
                    Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex((AbstractDocument.BranchElement)element, n3);
                    edit.addRemovedElements(elementArray7);
                    AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(element.getParentElement(), element.getAttributes());
                    branchElement.replace(0, 0, elementArray7);
                    Element[] elementArray8 = new Element[2];
                    elementArray8[1] = branchElement;
                    elementArray = elementArray8;
                }
            } else if (element instanceof AbstractDocument.LeafElement) {
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
                Element element4 = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), element.getStartOffset(), n);
                Element element5 = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), n + n2, element.getEndOffset());
                elementArray = new Element[]{element4, element5};
            }
            return elementArray;
        }

        private final void insertFracture(ElementSpec elementSpec) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.elementStack.peek();
            int n = branchElement.getElementIndex(this.pos);
            AttributeSet attributeSet = branchElement.getAttributes();
            Element element = branchElement.getElement(n);
            int n2 = branchElement.getElementCount();
            Edit edit = DefaultStyledDocument.this.getEditForParagraphAndIndex(branchElement, n);
            Element element2 = element;
            int n3 = 0;
            int n4 = element.getElementIndex(this.pos);
            int n5 = element.getElementCount();
            element2 = element.getElement(n4);
            while (!element2.isLeaf()) {
                element2 = element2.getElement(element2.getElementIndex(this.pos));
            }
            AttributeSet attributeSet2 = element2.getAttributes();
            int n6 = element2.getStartOffset();
            int n7 = element2.getEndOffset();
            if (this.pos >= n6 && this.pos < n7) {
                Object object;
                AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(branchElement, attributeSet);
                AbstractDocument.BranchElement branchElement3 = null;
                Element[] elementArray = null;
                if (edit.added.size() > 0 || edit.removed.size() > 0) {
                    elementArray = new Element[]{branchElement2};
                    ++n;
                } else {
                    branchElement3 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(branchElement, attributeSet);
                    elementArray = new Element[]{branchElement3, branchElement2};
                    if (n6 != this.pos) {
                        object = DefaultStyledDocument.this.createLeafElement(branchElement3, attributeSet2, n6, this.pos);
                        branchElement3.replace(n3, 0, new Element[]{object});
                    }
                }
                if (!element.isLeaf()) {
                    int n8;
                    if (n4 > 0 && branchElement3 != null) {
                        object = new Element[n4];
                        int n9 = 0;
                        while (n9 < n4) {
                            object[n9] = element.getElement(n9);
                            ++n9;
                        }
                        n3 = ((Element[])object).length;
                        branchElement3.replace(0, 0, (Element[])object);
                    }
                    if ((n8 = n5 - n4 - 1) > 0) {
                        Element[] elementArray2 = new Element[n8];
                        int n10 = 0;
                        int n11 = n4 + 1;
                        while (n10 < n8) {
                            elementArray2[n10++] = element.getElement(n11++);
                        }
                        branchElement2.replace(0, 0, elementArray2);
                    }
                }
                int n12 = 0;
                int n13 = n7;
                Element element3 = branchElement2.getElement(0);
                if (element3 != null && element3.isLeaf() && element3.getAttributes().isEqual(attributeSet2)) {
                    n13 = element3.getEndOffset();
                    n12 = 1;
                }
                Element element4 = DefaultStyledDocument.this.createLeafElement(branchElement2, attributeSet2, this.pos, n13);
                branchElement2.replace(0, n12, new Element[]{element4});
                int n14 = n2 - n;
                Element[] elementArray3 = new Element[]{};
                Element[] elementArray4 = new Element[]{};
                if (n14 > 0) {
                    elementArray3 = new Element[n14];
                    int n15 = 0;
                    int n16 = n;
                    while (n16 < n2) {
                        elementArray3[n15++] = branchElement.getElement(n16);
                        ++n16;
                    }
                    edit.addRemovedElements(elementArray3);
                    elementArray4 = this.recreateAfterFracture(elementArray3, branchElement, 1, branchElement2.getEndOffset());
                }
                edit.addAddedElements(elementArray);
                edit.addAddedElements(elementArray4);
                this.elementStack.push(branchElement2);
                this.lastFractured = element4;
            } else {
                this.fracNotCreated = true;
            }
        }

        private final Element[] recreateAfterFracture(Element[] elementArray, AbstractDocument.BranchElement branchElement, int n, int n2) {
            Element[] elementArray2 = new Element[elementArray.length - n];
            int n3 = 0;
            int n4 = n;
            while (n4 < elementArray.length) {
                Element element = elementArray[n4];
                int n5 = element.getEndOffset() - element.getStartOffset();
                if (element instanceof AbstractDocument.LeafElement) {
                    elementArray2[n3] = DefaultStyledDocument.this.createLeafElement(branchElement, element.getAttributes(), n2, n2 + n5);
                } else {
                    AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(branchElement, element.getAttributes());
                    int n6 = element.getElementCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        Element element2 = element.getElement(n7);
                        Element[] elementArray3 = this.recreateAfterFracture(new Element[]{element2}, branchElement2, 0, n2);
                        branchElement2.replace(0, 0, elementArray3);
                        ++n7;
                    }
                    elementArray2[n3] = branchElement2;
                }
                n2 += n5;
                ++n3;
                ++n4;
            }
            return elementArray2;
        }

        public ElementBuffer(Element element) {
            this.root = element;
            this.elementStack = new Stack();
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet copy;
        protected AttributeSet newAttributes;
        protected boolean isReplacing;
        protected Element element;

        public void undo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                mutableAttributeSet.removeAttributes(attributeSet);
                mutableAttributeSet.addAttributes(this.copy);
            }
        }

        public void redo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                if (this.isReplacing) {
                    mutableAttributeSet.removeAttributes(attributeSet);
                }
                mutableAttributeSet.addAttributes(this.newAttributes);
            }
        }

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        short type;
        short direction;
        int offset;
        int length;
        char[] content;
        AttributeSet attributes;

        public void setType(short s) {
            this.type = s;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public char[] getArray() {
            return this.content;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            switch (this.type) {
                case 1: {
                    stringBuilder.append("StartTag");
                    break;
                }
                case 2: {
                    stringBuilder.append("EndTag");
                    break;
                }
                case 3: {
                    stringBuilder.append("Content");
                    break;
                }
                default: {
                    stringBuilder.append("??");
                }
            }
            stringBuilder.append(':');
            switch (this.direction) {
                case 4: {
                    stringBuilder.append("JoinPrevious");
                    break;
                }
                case 5: {
                    stringBuilder.append("JoinNext");
                    break;
                }
                case 6: {
                    stringBuilder.append("Originate");
                    break;
                }
                case 7: {
                    stringBuilder.append("Fracture");
                    break;
                }
                default: {
                    stringBuilder.append("??");
                }
            }
            stringBuilder.append(':');
            stringBuilder.append(this.length);
            return stringBuilder.toString();
        }

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attributes = attributeSet;
            this.type = s;
            this.offset = n;
            this.length = n2;
            this.content = cArray;
            this.direction = (short)6;
        }
    }
}

