##############################################################################
#
# Copyright (c) 2004, 2005 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Unit tests for the i18n framework

$Id: test_i18n.py 68331 2006-05-29 09:47:23Z philikon $
"""
import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

def test_zpt_i18n():
    """
    Test i18n functionality in ZPTs

      >>> configure_zcml = '''
      ... <configure 
      ...     xmlns="http://namespaces.zope.org/zope"
      ...     xmlns:browser="http://namespaces.zope.org/browser"
      ...     xmlns:i18n="http://namespaces.zope.org/i18n">
      ...   <configure package="Products.Five.tests">
      ...     <i18n:registerTranslations directory="locales" />
      ...   </configure>
      ...   <configure package="Products.Five.browser.tests">
      ...     <browser:page
      ...         for="OFS.interfaces.IFolder"
      ...         class=".i18n.I18nView"
      ...         template="i18n.pt"
      ...         name="i18n.html"
      ...         permission="zope2.View"
      ...         />
      ...   </configure>
      ... </configure>'''

      >>> import Products.Five
      >>> from Products.Five import zcml
      >>> zcml.load_config("configure.zcml", Products.Five)
      >>> zcml.load_string(configure_zcml)

    In order to be able to traverse to the PageTemplate view, we need
    a traversable object:

      >>> from Products.Five.tests.testing import manage_addFiveTraversableFolder
      >>> manage_addFiveTraversableFolder(self.folder, 'testoid', 'Testoid')

    We tell Zope to translate the messages by passing the
    ``Accept-Language`` header which is processed by the
    ``IUserPreferredLangauges`` adapter:

      >>> print http(r'''
      ... GET /test_folder_1_/testoid/@@i18n.html HTTP/1.1
      ... Accept-Language: de
      ... ''')
      HTTP/1.1 200 OK
      ...
      <html>
      <body>
      <p>Dies ist eine Nachricht</p>
      <p>Dies ist eine explizite Nachricht</p>
      <p>Dies sind 4 Nachrichten</p>
      <p>Dies sind 4 explizite Nachrichten</p>
      <table summary="Dies ist ein Attribut">
      </table>
      <table summary="Explizite Zusammenfassung"
             title="Expliziter Titel">
      </table>
      <p>Dies ist eine Nachricht</p>
      <p>Dies ist eine Nachricht</p>
      </body>
      </html>
      ...


    Clean up:

      >>> from zope.app.testing.placelesssetup import tearDown
      >>> tearDown()
    """

def test_suite():
    from Testing.ZopeTestCase import FunctionalDocTestSuite
    from zope.testing.doctest import ELLIPSIS
    return FunctionalDocTestSuite(optionflags=ELLIPSIS)

if __name__ == '__main__':
    framework()
