/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT = 1000L;
    private long writeLockTimeout = WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = 10;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = 1000;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private boolean inTransaction = false;
    private boolean commitPending;
    private HashSet protectedSegments;
    private SegmentInfos rollbackSegmentInfos;
    SegmentInfos segmentInfos = new SegmentInfos();
    SegmentInfos ramSegmentInfos = new SegmentInfos();
    private final RAMDirectory ramDirectory = new RAMDirectory();
    private IndexFileDeleter deleter;
    private Lock writeLock;
    private int termIndexInterval = 128;
    private int maxBufferedDeleteTerms = 1000;
    private HashMap bufferedDeleteTerms = new HashMap();
    private int numBufferedDeleteTerms = 0;
    private boolean useCompoundFile = true;
    private boolean closeDir;
    private int maxFieldLength = 10000;
    private int mergeFactor = 10;
    private int minMergeDocs = 10;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private PrintStream infoStream = null;

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean value) {
        this.useCompoundFile = value;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws IOException {
        this.init(path, a, create);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws IOException {
        this.init(path, a, create);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws IOException {
        this.init(d, a, create, false);
    }

    public IndexWriter(String path, Analyzer a) throws IOException {
        if (IndexReader.indexExists(path)) {
            this.init(path, a, false);
        } else {
            this.init(path, a, true);
        }
    }

    public IndexWriter(File path, Analyzer a) throws IOException {
        if (IndexReader.indexExists(path)) {
            this.init(path, a, false);
        } else {
            this.init(path, a, true);
        }
    }

    public IndexWriter(Directory d, Analyzer a) throws IOException {
        if (IndexReader.indexExists(d)) {
            this.init(d, a, false, false);
        } else {
            this.init(d, a, true, false);
        }
    }

    private IndexWriter(Directory d, Analyzer a, boolean create, boolean closeDir) throws IOException {
        this.init(d, a, create, closeDir);
    }

    private void init(String path, Analyzer a, boolean create) throws IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true);
    }

    private void init(File path, Analyzer a, boolean create) throws IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true);
    }

    private void init(Directory d, Analyzer a, boolean create, boolean closeDir) throws IOException {
        Lock writeLock;
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        if (create) {
            this.directory.clearLock(WRITE_LOCK_NAME);
        }
        if (!(writeLock = this.directory.makeLock(WRITE_LOCK_NAME)).obtain(this.writeLockTimeout)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.segmentInfos.write(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
            }
            this.deleter = new IndexFileDeleter(this.segmentInfos, this.directory);
            this.deleter.setInfoStream(this.infoStream);
            this.deleter.findDeletableFiles();
            this.deleter.deleteFiles();
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        if (maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2");
        }
        this.minMergeDocs = maxBufferedDocs;
    }

    public int getMaxBufferedDocs() {
        return this.minMergeDocs;
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        if (maxBufferedDeleteTerms < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1");
        }
        this.maxBufferedDeleteTerms = maxBufferedDeleteTerms;
    }

    public int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
        if (this.closeDir) {
            this.directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int count = this.ramSegmentInfos.size();
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
        }
        return count;
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws IOException {
        SegmentInfo newSegmentInfo = this.buildSingleDocSegment(doc, analyzer);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ramSegmentInfos.addElement(newSegmentInfo);
            this.maybeFlushRamSegments();
        }
    }

    SegmentInfo buildSingleDocSegment(Document doc, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, analyzer, this);
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newRamSegmentName();
        dw.addDocument(segmentName, doc);
        return new SegmentInfo(segmentName, 1, this.ramDirectory, false, false);
    }

    public synchronized void deleteDocuments(Term term) throws IOException {
        this.bufferDeleteTerm(term);
        this.maybeFlushRamSegments();
    }

    public synchronized void deleteDocuments(Term[] terms) throws IOException {
        for (int i = 0; i < terms.length; ++i) {
            this.bufferDeleteTerm(terms[i]);
        }
        this.maybeFlushRamSegments();
    }

    public void updateDocument(Term term, Document doc) throws IOException {
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws IOException {
        SegmentInfo newSegmentInfo = this.buildSingleDocSegment(doc, analyzer);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.bufferDeleteTerm(term);
            this.ramSegmentInfos.addElement(newSegmentInfo);
            this.maybeFlushRamSegments();
        }
    }

    final synchronized String newRamSegmentName() {
        return "_ram_" + Integer.toString(this.ramSegmentInfos.counter++, 36);
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getRamSegmentCount() {
        return this.ramSegmentInfos.size();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || SegmentReader.hasSeparateNorms(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory || this.useCompoundFile && !SegmentReader.usesCompoundFile(this.segmentInfos.info(0)))) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(this.segmentInfos, minSegment < 0 ? 0 : minSegment, this.segmentInfos.size());
        }
    }

    private void startTransaction() throws IOException {
        if (this.inTransaction) {
            throw new IOException("transaction is already in process");
        }
        this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        this.protectedSegments = new HashSet();
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = (SegmentInfo)this.segmentInfos.elementAt(i);
            this.protectedSegments.add(si.name);
        }
        this.inTransaction = true;
    }

    private void rollbackTransaction() throws IOException {
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.rollbackSegmentInfos);
        this.deleter.clearPendingFiles();
        this.deleter.findDeletableFiles();
        this.deleter.deleteFiles();
        this.clearTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransaction() throws IOException {
        if (this.commitPending) {
            boolean success = false;
            try {
                this.segmentInfos.write(this.directory);
                success = true;
            }
            finally {
                if (!success) {
                    this.rollbackTransaction();
                }
            }
            this.deleter.commitPendingFiles();
            this.commitPending = false;
        }
        this.clearTransaction();
    }

    private void clearTransaction() {
        this.protectedSegments = null;
        this.rollbackSegmentInfos = null;
        this.inTransaction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexes(Directory[] dirs) throws IOException {
        this.optimize();
        int start = this.segmentInfos.size();
        boolean success = false;
        this.startTransaction();
        try {
            for (int i = 0; i < dirs.length; ++i) {
                SegmentInfos sis = new SegmentInfos();
                sis.read(dirs[i]);
                for (int j = 0; j < sis.size(); ++j) {
                    this.segmentInfos.addElement(sis.info(j));
                }
            }
            while (this.segmentInfos.size() > start + this.mergeFactor) {
                for (int base = start; base < this.segmentInfos.size(); ++base) {
                    int end = Math.min(this.segmentInfos.size(), base + this.mergeFactor);
                    if (end - base <= 1) continue;
                    this.mergeSegments(this.segmentInfos, base, end);
                }
            }
            success = true;
        }
        finally {
            if (success) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
        this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexesNoOptimize(Directory[] dirs) throws IOException {
        this.flushRamSegments();
        int start = this.segmentInfos.size();
        int startUpperBound = this.minMergeDocs;
        boolean success = false;
        this.startTransaction();
        try {
            int numTailSegments;
            try {
                for (int i = 0; i < dirs.length; ++i) {
                    if (this.directory == dirs[i]) {
                        throw new IllegalArgumentException("Cannot add this index to itself");
                    }
                    SegmentInfos sis = new SegmentInfos();
                    sis.read(dirs[i]);
                    for (int j = 0; j < sis.size(); ++j) {
                        SegmentInfo info = sis.info(j);
                        this.segmentInfos.addElement(info);
                        while (startUpperBound < info.docCount) {
                            if ((startUpperBound *= this.mergeFactor) <= this.maxMergeDocs) continue;
                            throw new IllegalArgumentException("Upper bound cannot exceed maxMergeDocs");
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                for (int i = this.segmentInfos.size() - 1; i >= start; --i) {
                    this.segmentInfos.remove(i);
                }
                throw e;
            }
            this.maybeMergeSegments(startUpperBound);
            int segmentCount = this.segmentInfos.size();
            for (numTailSegments = 0; numTailSegments < segmentCount && startUpperBound >= this.segmentInfos.info((int)(segmentCount - 1 - numTailSegments)).docCount; ++numTailSegments) {
            }
            if (numTailSegments == 0) {
                success = true;
                return;
            }
            if (this.checkNonDecreasingLevels(segmentCount - numTailSegments)) {
                int numSegmentsToCopy;
                for (numSegmentsToCopy = 0; numSegmentsToCopy < segmentCount && this.directory != this.segmentInfos.info((int)(segmentCount - 1 - numSegmentsToCopy)).dir; ++numSegmentsToCopy) {
                }
                if (numSegmentsToCopy == 0) {
                    success = true;
                    return;
                }
                for (int i = segmentCount - numSegmentsToCopy; i < segmentCount; ++i) {
                    this.mergeSegments(this.segmentInfos, i, i + 1);
                }
                if (this.checkNonDecreasingLevels(segmentCount - numSegmentsToCopy)) {
                    success = true;
                    return;
                }
            }
            this.mergeSegments(this.segmentInfos, segmentCount - numTailSegments, segmentCount);
            if (this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).docCount > startUpperBound) {
                this.maybeMergeSegments(startUpperBound * this.mergeFactor);
            }
            success = true;
        }
        finally {
            if (success) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void addIndexes(IndexReader[] readers) throws IOException {
        this.optimize();
        String mergedName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        SegmentReader sReader = null;
        if (this.segmentInfos.size() == 1) {
            sReader = SegmentReader.get(this.segmentInfos.info(0));
            merger.add(sReader);
            segmentsToDelete.addElement(sReader);
        }
        for (int i = 0; i < readers.length; ++i) {
            merger.add(readers[i]);
        }
        String segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
        boolean success = false;
        this.startTransaction();
        try {
            int docCount = merger.merge();
            this.segmentInfos.setSize(0);
            SegmentInfo info = new SegmentInfo(mergedName, docCount, this.directory, false, true);
            this.segmentInfos.addElement(info);
            this.commitPending = true;
            if (sReader != null) {
                sReader.close();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            } else {
                this.commitTransaction();
            }
        }
        this.deleter.deleteFile(segmentsInfosFileName);
        this.deleter.deleteSegments(segmentsToDelete);
        if (this.useCompoundFile) {
            void var9_11;
            success = false;
            segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
            this.startTransaction();
            try {
                void var6_7;
                Vector filesToDelete = merger.createCompoundFile(mergedName + ".cfs");
                var6_7.setUseCompoundFile(true);
                this.commitPending = true;
                success = true;
            }
            finally {
                if (!success) {
                    this.rollbackTransaction();
                } else {
                    this.commitTransaction();
                }
            }
            this.deleter.deleteFile(segmentsInfosFileName);
            this.deleter.deleteFiles((Vector)var9_11);
        }
    }

    void doAfterFlush() throws IOException {
    }

    protected final void maybeFlushRamSegments() throws IOException {
        if (this.ramSegmentInfos.size() >= this.minMergeDocs || this.numBufferedDeleteTerms >= this.maxBufferedDeleteTerms) {
            this.flushRamSegments();
        }
    }

    private final synchronized void flushRamSegments() throws IOException {
        if (this.ramSegmentInfos.size() > 0 || this.bufferedDeleteTerms.size() > 0) {
            this.mergeSegments(this.ramSegmentInfos, 0, this.ramSegmentInfos.size());
            this.maybeMergeSegments(this.minMergeDocs);
        }
    }

    public final synchronized void flush() throws IOException {
        this.flushRamSegments();
    }

    public final long ramSizeInBytes() {
        return this.ramDirectory.sizeInBytes();
    }

    public final synchronized int numRamDocs() {
        return this.ramSegmentInfos.size();
    }

    private final void maybeMergeSegments(int startUpperBound) throws IOException {
        long lowerBound = -1L;
        for (long upperBound = (long)startUpperBound; upperBound < (long)this.maxMergeDocs; upperBound *= (long)this.mergeFactor) {
            int numSegments;
            int minSegment = this.segmentInfos.size();
            int maxSegment = -1;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if (maxSegment == -1 && (long)si.docCount > lowerBound && (long)si.docCount <= upperBound) {
                    maxSegment = minSegment;
                    continue;
                }
                if ((long)si.docCount <= upperBound) continue;
                break;
            }
            if ((numSegments = ++maxSegment - ++minSegment) < this.mergeFactor) break;
            boolean exceedsUpperLimit = false;
            while (numSegments >= this.mergeFactor) {
                int docCount = this.mergeSegments(this.segmentInfos, minSegment, minSegment + this.mergeFactor);
                numSegments -= this.mergeFactor;
                if ((long)docCount > upperBound) {
                    ++minSegment;
                    exceedsUpperLimit = true;
                    continue;
                }
                ++numSegments;
            }
            if (!exceedsUpperLimit) break;
            lowerBound = upperBound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int mergeSegments(SegmentInfos sourceSegments, int minSegment, int end) throws IOException {
        Vector filesToDelete;
        int mergedDocCount;
        String segmentsInfosFileName;
        block37: {
            boolean success;
            SegmentInfo newSegment;
            String nextSegmentsFileName;
            Vector<SegmentReader> segmentsToDelete;
            SegmentMerger merger;
            String mergedName;
            boolean doMerge;
            block36: {
                doMerge = end > 0;
                mergedName = this.newSegmentName();
                merger = null;
                segmentsToDelete = new Vector<SegmentReader>();
                segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
                nextSegmentsFileName = this.segmentInfos.getNextSegmentFileName();
                newSegment = null;
                mergedDocCount = 0;
                try {
                    SegmentInfos rollback;
                    block35: {
                        if (doMerge) {
                            if (this.infoStream != null) {
                                this.infoStream.print("merging segments");
                            }
                            merger = new SegmentMerger(this, mergedName);
                            for (int i = minSegment; i < end; ++i) {
                                SegmentInfo si = sourceSegments.info(i);
                                if (this.infoStream != null) {
                                    this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
                                }
                                SegmentReader reader = SegmentReader.get(si);
                                merger.add(reader);
                                if (reader.directory() != this.directory && reader.directory() != this.ramDirectory) continue;
                                segmentsToDelete.addElement(reader);
                            }
                        }
                        rollback = null;
                        success = false;
                        try {
                            if (doMerge) {
                                mergedDocCount = merger.merge();
                                if (this.infoStream != null) {
                                    this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
                                }
                                newSegment = new SegmentInfo(mergedName, mergedDocCount, this.directory, false, true);
                            }
                            if (!(this.inTransaction || sourceSegments == this.ramSegmentInfos && this.bufferedDeleteTerms.size() <= 0)) {
                                rollback = (SegmentInfos)this.segmentInfos.clone();
                            }
                            if (doMerge) {
                                if (sourceSegments == this.ramSegmentInfos) {
                                    this.segmentInfos.addElement(newSegment);
                                } else {
                                    for (int i = end - 1; i > minSegment; --i) {
                                        sourceSegments.remove(i);
                                    }
                                    this.segmentInfos.set(minSegment, newSegment);
                                }
                            }
                            if (sourceSegments == this.ramSegmentInfos) {
                                this.deleter.clearPendingFiles();
                                this.maybeApplyDeletes(doMerge);
                                this.doAfterFlush();
                            }
                            if (!this.inTransaction) {
                                this.segmentInfos.write(this.directory);
                            } else {
                                this.commitPending = true;
                            }
                            success = true;
                            Object var16_18 = null;
                            if (!success) break block35;
                            if (sourceSegments != this.ramSegmentInfos) break block36;
                        }
                        catch (Throwable throwable) {
                            Object var16_19 = null;
                            if (success) {
                                if (sourceSegments != this.ramSegmentInfos) throw throwable;
                                this.ramSegmentInfos.removeAllElements();
                                throw throwable;
                            }
                            if (this.inTransaction) throw throwable;
                            if (sourceSegments == this.ramSegmentInfos && 0 == this.bufferedDeleteTerms.size()) {
                                if (newSegment != null && this.segmentInfos.size() > 0 && this.segmentInfos.info(this.segmentInfos.size() - 1) == newSegment) {
                                    this.segmentInfos.remove(this.segmentInfos.size() - 1);
                                }
                            } else if (rollback != null) {
                                this.segmentInfos.clear();
                                this.segmentInfos.addAll(rollback);
                            }
                            this.deleter.clearPendingFiles();
                            this.deleter.deleteFile(nextSegmentsFileName);
                            this.deleter.findDeletableFiles();
                            this.deleter.deleteFiles();
                            throw throwable;
                        }
                        this.ramSegmentInfos.removeAllElements();
                        break block36;
                    }
                    if (this.inTransaction) break block36;
                    if (sourceSegments == this.ramSegmentInfos && 0 == this.bufferedDeleteTerms.size()) {
                        if (newSegment != null && this.segmentInfos.size() > 0 && this.segmentInfos.info(this.segmentInfos.size() - 1) == newSegment) {
                            this.segmentInfos.remove(this.segmentInfos.size() - 1);
                        }
                    } else if (rollback != null) {
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                    }
                    this.deleter.clearPendingFiles();
                    this.deleter.deleteFile(nextSegmentsFileName);
                    this.deleter.findDeletableFiles();
                    this.deleter.deleteFiles();
                }
                finally {
                    if (doMerge) {
                        merger.closeReaders();
                    }
                }
            }
            if (!this.inTransaction) {
                this.deleter.deleteFile(segmentsInfosFileName);
                this.deleter.deleteSegments(segmentsToDelete);
                this.deleter.commitPendingFiles();
            } else {
                this.deleter.addPendingFile(segmentsInfosFileName);
                this.deleter.deleteSegments(segmentsToDelete, this.protectedSegments);
            }
            if (!this.useCompoundFile) return mergedDocCount;
            if (!doMerge) return mergedDocCount;
            segmentsInfosFileName = nextSegmentsFileName;
            nextSegmentsFileName = this.segmentInfos.getNextSegmentFileName();
            success = false;
            try {
                filesToDelete = merger.createCompoundFile(mergedName + ".cfs");
                newSegment.setUseCompoundFile(true);
                if (!this.inTransaction) {
                    this.segmentInfos.write(this.directory);
                }
                success = true;
                Object var19_22 = null;
                if (success || this.inTransaction) break block37;
                newSegment.setUseCompoundFile(false);
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                if (success) throw throwable;
                if (this.inTransaction) throw throwable;
                newSegment.setUseCompoundFile(false);
                this.deleter.deleteFile(mergedName + ".cfs");
                this.deleter.deleteFile(nextSegmentsFileName);
                throw throwable;
            }
            this.deleter.deleteFile(mergedName + ".cfs");
            this.deleter.deleteFile(nextSegmentsFileName);
        }
        if (!this.inTransaction) {
            this.deleter.deleteFile(segmentsInfosFileName);
        }
        this.deleter.deleteFiles(filesToDelete);
        return mergedDocCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeApplyDeletes(boolean doMerge) throws IOException {
        if (this.bufferedDeleteTerms.size() > 0) {
            if (this.infoStream != null) {
                this.infoStream.println("flush " + this.numBufferedDeleteTerms + " buffered deleted terms on " + this.segmentInfos.size() + " segments.");
            }
            if (doMerge) {
                IndexReader reader = null;
                try {
                    reader = SegmentReader.get(this.segmentInfos.info(this.segmentInfos.size() - 1));
                    reader.setDeleter(this.deleter);
                    this.applyDeletesSelectively(this.bufferedDeleteTerms, reader);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            int infosEnd = this.segmentInfos.size();
            if (doMerge) {
                --infosEnd;
            }
            for (int i = 0; i < infosEnd; ++i) {
                SegmentReader reader = null;
                try {
                    reader = SegmentReader.get(this.segmentInfos.info(i));
                    reader.setDeleter(this.deleter);
                    this.applyDeletes(this.bufferedDeleteTerms, reader);
                    continue;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            this.bufferedDeleteTerms.clear();
            this.numBufferedDeleteTerms = 0;
        }
    }

    private final boolean checkNonDecreasingLevels(int start) {
        int lowerBound = -1;
        int upperBound = this.minMergeDocs;
        for (int i = this.segmentInfos.size() - 1; i >= start; --i) {
            int docCount = this.segmentInfos.info((int)i).docCount;
            if (docCount <= lowerBound) {
                return false;
            }
            while (docCount > upperBound) {
                lowerBound = upperBound;
                upperBound *= this.mergeFactor;
            }
        }
        return true;
    }

    final synchronized int getBufferedDeleteTermsSize() {
        return this.bufferedDeleteTerms.size();
    }

    final synchronized int getNumBufferedDeleteTerms() {
        return this.numBufferedDeleteTerms;
    }

    private void bufferDeleteTerm(Term term) {
        Num num = (Num)this.bufferedDeleteTerms.get(term);
        if (num == null) {
            this.bufferedDeleteTerms.put(term, new Num(this.ramSegmentInfos.size()));
        } else {
            num.setNum(this.ramSegmentInfos.size());
        }
        ++this.numBufferedDeleteTerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyDeletesSelectively(HashMap deleteTerms, IndexReader reader) throws IOException {
        Iterator iter = deleteTerms.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Term term = (Term)entry.getKey();
            TermDocs docs = reader.termDocs(term);
            if (docs == null) continue;
            int num = ((Num)entry.getValue()).getNum();
            try {
                int doc;
                while (docs.next() && (doc = docs.doc()) < num) {
                    reader.deleteDocument(doc);
                }
            }
            finally {
                docs.close();
            }
        }
    }

    private final void applyDeletes(HashMap deleteTerms, IndexReader reader) throws IOException {
        Iterator iter = deleteTerms.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            reader.deleteDocuments((Term)entry.getKey());
        }
    }

    private class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            this.num = num;
        }
    }
}

