/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import msfgui.InteractWindow;
import msfgui.MainFrame;
import msfgui.MsfException;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.RpcConnection;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ModulePopup
extends MsfFrame
implements TreeSelectionListener {
    private JMenu recentMenu;
    private String moduleType;
    private String fullName;
    private RpcConnection rpcConn;
    private String payload;
    private String target;
    private ArrayList requiredOpts;
    private ArrayList optionalOpts;
    private ArrayList advancedOpts;
    private Map options;
    private MainFrame parentFrame;
    private JLabel advancedLabel;
    private JLabel authorsLabel;
    private ButtonGroup buttonGroup;
    private JButton consoleRunButton;
    private JButton consoleRunButton1;
    private JEditorPane descriptionBox;
    private JScrollPane descriptionPane;
    private JButton exploitButton;
    private JButton exploitButton1;
    private JLabel licenseLabel;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JLabel optionalLabel;
    private JScrollPane payloadScrollPane;
    private JTree payloadTree;
    private JLabel requiredLabel;
    private JLabel targetsLabel;
    private JLabel titleLabel;
    private JLabel versionLabel;

    public ModulePopup(RpcConnection rpcConn, Object[] args, MainFrame parentFrame) {
        this(args[1].toString(), rpcConn, args[0].toString(), parentFrame);
        Map opts = (Map)args[2];
        if (args[0].toString().equals("exploit")) {
            this.target = opts.get("TARGET").toString();
            for (Component comp : this.mainPanel.getComponents()) {
                JRadioButton but;
                if (!(comp instanceof JRadioButton) || !(but = (JRadioButton)comp).getName().equals("targetsButton" + this.target)) continue;
                but.setSelected(true);
                break;
            }
            this.showPayloads(rpcConn, this.fullName, this.target, opts.get("PAYLOAD").toString());
        }
        for (Component comp : this.mainPanel.getComponents()) {
            JTextField optionField;
            Object optionVal;
            if (!(comp instanceof JTextField) || (optionVal = opts.get((optionField = (JTextField)comp).getName().substring("field".length()))) == null) continue;
            optionField.setText(optionVal.toString());
        }
    }

    public ModulePopup(String fullName, RpcConnection rpcConn, String moduleType, MainFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.recentMenu = parentFrame.recentMenu;
        this.initComponents();
        this.exploitButton.setText("Run " + moduleType);
        this.exploitButton1.setText("Run " + moduleType);
        this.moduleType = moduleType;
        this.requiredOpts = new ArrayList();
        this.optionalOpts = new ArrayList();
        this.advancedOpts = new ArrayList();
        this.fullName = fullName;
        this.setTitle(fullName);
        this.payload = "";
        this.rpcConn = rpcConn;
        this.showModuleInfo(rpcConn, fullName);
        if (moduleType.equals("exploit")) {
            this.payloadTree.getSelectionModel().setSelectionMode(1);
            this.payloadTree.addTreeSelectionListener(this);
            this.payloadTree.setToggleClickCount(1);
        } else {
            this.mainPanel.remove(this.payloadScrollPane);
            this.mainPanel.remove(this.targetsLabel);
        }
        this.descriptionBox.setFont(this.authorsLabel.getFont());
        this.descriptionBox.setBackground(this.authorsLabel.getBackground());
        this.mainScrollPane.getVerticalScrollBar().setUnitIncrement(40);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.payloadTree.getLastSelectedPathComponent();
        if (node == null || !node.isLeaf()) {
            return;
        }
        this.payload = node.getUserObject().toString();
        while (node.getParent() != node.getRoot()) {
            node = (DefaultMutableTreeNode)node.getParent();
            this.payload = node.getUserObject() + "/" + this.payload;
        }
        this.showOptions();
    }

    private void showModuleInfo(final RpcConnection rpcConn, final String fullName) throws HeadlessException {
        try {
            Map info = (Map)rpcConn.execute("module.info", this.moduleType, fullName);
            this.setTitle(info.get("name") + " " + fullName);
            this.titleLabel.setText("<html><h2>" + info.get("name") + "</h2></html>");
            Object references = info.get("references");
            StringBuilder referenceString = new StringBuilder();
            if (references != null) {
                List refList = (List)references;
                referenceString.append("<br>References:<br>");
                for (Object refo : refList) {
                    List ref = (List)refo;
                    referenceString.append(ref.get(0)).append(": ").append(ref.get(1)).append("<br> ");
                }
                referenceString.append("<br>");
            }
            this.descriptionBox.setText("<html><b>Description</b> " + info.get("description").toString().replaceAll("\\s+", " ") + referenceString + "</html>");
            if (info.get("license") instanceof String) {
                this.licenseLabel.setText("<html><b>License:</b> " + info.get("license") + "</html>");
            } else {
                List license = (List)info.get("license");
                StringBuilder licenseString = new StringBuilder();
                for (Object lic : license) {
                    licenseString.append(lic).append(" ");
                }
                this.licenseLabel.setText("<html><b>License:</b> " + licenseString + "</html>");
            }
            this.versionLabel.setText("<html><b>Version:</b> " + info.get("version") + "</html>");
            List authors = (List)info.get("authors");
            StringBuilder authorLine = new StringBuilder();
            if (authors.size() > 0) {
                authorLine.append(authors.get(0).toString());
            }
            for (int i = 1; i < authors.size(); ++i) {
                authorLine.append(", ").append(authors.get(i));
            }
            this.authorsLabel.setText("<html><b>Authors:</b> " + authorLine.toString() + "</html>");
            if (this.moduleType.equals("exploit")) {
                Map targetsMap = (Map)info.get("targets");
                if (targetsMap == null) {
                    JOptionPane.showMessageDialog(this, "No Targets. ??");
                } else {
                    String defaultTarget = "";
                    if (info.get("default_target") != null) {
                        defaultTarget = info.get("default_target").toString();
                    }
                    for (Object targetName : targetsMap.keySet()) {
                        JRadioButton radio = new JRadioButton();
                        this.buttonGroup.add(radio);
                        radio.setText(targetsMap.get(targetName).toString());
                        radio.setName("targetButton" + targetName);
                        radio.setActionCommand(targetName.toString());
                        radio.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                ModulePopup.this.target = ModulePopup.this.buttonGroup.getSelection().getActionCommand();
                                ModulePopup.this.showPayloads(rpcConn, fullName, ModulePopup.this.target);
                            }
                        });
                        this.mainPanel.add(radio);
                        if (!targetName.equals(defaultTarget)) continue;
                        radio.setSelected(true);
                        this.showPayloads(rpcConn, fullName, targetName.toString());
                    }
                }
            } else {
                this.showOptions();
            }
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
        this.reGroup();
    }

    private void showPayloads(RpcConnection rpcConn, String modName, String target) throws HeadlessException {
        this.showPayloads(rpcConn, modName, target, null);
    }

    private void showPayloads(RpcConnection rpcConn, String modName, String target, String defaultPayload) throws HeadlessException {
        try {
            List mlist;
            try {
                mlist = (List)((Map)rpcConn.execute("module.compatible_payloads", modName, target)).get("payloads");
            }
            catch (MsfException ex) {
                mlist = (List)((Map)rpcConn.execute("module.compatible_payloads", modName)).get("payloads");
            }
            DefaultTreeModel payloadModel = (DefaultTreeModel)this.payloadTree.getModel();
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)payloadModel.getRoot();
            int count = top.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                payloadModel.removeNodeFromParent((DefaultMutableTreeNode)top.getChildAt(i));
            }
            top.removeAllChildren();
            DefaultMutableTreeNode defaultPayloadNode = null;
            for (Object payloadFullName : mlist) {
                String[] names = payloadFullName.toString().split("/");
                DefaultMutableTreeNode currentNode = top;
                for (int i = 0; i < names.length; ++i) {
                    boolean found = false;
                    for (int j = 0; j < currentNode.getChildCount(); ++j) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentNode.getChildAt(j);
                        if (!node.getUserObject().toString().equals(names[i])) continue;
                        if (i < names.length - 1) {
                            currentNode = node;
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DefaultMutableTreeNode nod = new DefaultMutableTreeNode(names[i]);
                    payloadModel.insertNodeInto(nod, currentNode, 0);
                    if (i < names.length - 1) {
                        this.payloadTree.scrollPathToVisible(new TreePath(nod.getPath()));
                        currentNode = nod;
                    }
                    if (!payloadFullName.equals(defaultPayload)) continue;
                    defaultPayloadNode = nod;
                }
            }
            if (defaultPayloadNode != null) {
                this.payloadTree.scrollPathToVisible(new TreePath(defaultPayloadNode.getPath()));
                this.payloadTree.setSelectionPath(new TreePath(defaultPayloadNode.getPath()));
            }
            this.payloadTree.setRootVisible(false);
            this.payloadTree.revalidate();
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
    }

    private void showOptions() {
        for (Object o : this.requiredOpts) {
            this.mainPanel.remove((Component)o);
        }
        this.requiredOpts.clear();
        for (Object o : this.optionalOpts) {
            this.mainPanel.remove((Component)o);
        }
        this.optionalOpts.clear();
        for (Object o : this.advancedOpts) {
            this.mainPanel.remove((Component)o);
        }
        this.advancedOpts.clear();
        try {
            this.options = (Map)this.rpcConn.execute("module.options", this.moduleType, this.fullName);
            if (this.moduleType.equals("exploit")) {
                if (this.payload.length() <= 0) {
                    JOptionPane.showMessageDialog(this, "You must select a payload.");
                    return;
                }
                this.options.putAll((Map)this.rpcConn.execute("module.options", "payload", this.payload.toString()));
                HashMap<String, Object> encodingOpt = new HashMap<String, Object>();
                encodingOpt.put("desc", "Preferred encoding or encodings for the payload.");
                encodingOpt.put("required", Boolean.FALSE);
                encodingOpt.put("advanced", Boolean.TRUE);
                encodingOpt.put("evasion", Boolean.TRUE);
                this.options.put("Encoder", encodingOpt);
            }
            for (Object optionName : this.options.keySet()) {
                Map option = (Map)this.options.get(optionName);
                JScrollPane containerPane = new JScrollPane();
                containerPane.setHorizontalScrollBarPolicy(31);
                JEditorPane tempText = new JEditorPane();
                tempText.setContentType("text/html");
                tempText.setEditable(false);
                tempText.setText("<html><b>" + optionName.toString() + "</b> " + option.get("desc") + "</html>");
                containerPane.setViewportView(tempText);
                containerPane.setViewportBorder(null);
                containerPane.setBorder(null);
                tempText.setBorder(null);
                this.mainPanel.add(containerPane);
                tempText.setBackground(this.authorsLabel.getBackground());
                tempText.setFont(this.authorsLabel.getFont());
                JTextField optionField = new JTextField();
                if (option.get("default") != null) {
                    optionField.setText(option.get("default").toString());
                } else if (optionName.equals("LHOST")) {
                    optionField.setText(MsfguiApp.getLocalIp());
                } else if (optionName.equals("WORKSPACE")) {
                    optionField.setText(MsfguiApp.workspace);
                }
                optionField.setName("field" + optionName);
                this.mainPanel.add(optionField);
                if (option.get("required").equals(Boolean.TRUE)) {
                    this.requiredOpts.add(containerPane);
                    this.requiredOpts.add(optionField);
                    continue;
                }
                if (option.get("advanced").equals(Boolean.FALSE) && option.get("evasion").equals(Boolean.FALSE)) {
                    this.optionalOpts.add(containerPane);
                    this.optionalOpts.add(optionField);
                    continue;
                }
                this.advancedOpts.add(containerPane);
                this.advancedOpts.add(optionField);
            }
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
        this.reGroup();
    }

    private void runModule(boolean console) {
        try {
            HashMap<String, String> hash = new HashMap<String, String>();
            if (this.moduleType.equals("exploit")) {
                if (this.payload.length() <= 0) {
                    JOptionPane.showMessageDialog(this.rootPane, "You must select a payload");
                    return;
                }
                hash.put("PAYLOAD", this.payload.toString());
                this.target = this.buttonGroup.getSelection().getActionCommand();
                hash.put("TARGET", this.target);
            }
            for (Component comp : this.mainPanel.getComponents()) {
                if (!(comp instanceof JTextField)) continue;
                JTextField optionField = (JTextField)comp;
                String optName = optionField.getName().substring("field".length());
                String optVal = optionField.getText();
                Object defaultVal = ((Map)this.options.get(optName)).get("default");
                if ((defaultVal != null || optVal.length() <= 0 || optName.equals("WORKSPACE") && optVal.equals("default")) && (defaultVal == null || optVal.equals(defaultVal.toString()))) continue;
                hash.put(optName, optVal);
            }
            if (console) {
                Map res = (Map)this.rpcConn.execute("console.create", new Object[0]);
                ArrayList<String> autoCommands = new ArrayList<String>();
                autoCommands.add("use " + this.moduleType + "/" + this.fullName);
                if (hash.containsKey("TARGET")) {
                    autoCommands.add("set TARGET " + hash.get("TARGET"));
                }
                if (hash.containsKey("PAYLOAD")) {
                    autoCommands.add("set PAYLOAD " + hash.get("PAYLOAD"));
                }
                for (Map.Entry entObj : hash.entrySet()) {
                    Map.Entry ent = entObj;
                    if (ent.getKey().toString().equals("TARGET") || ent.getKey().toString().equals("PAYLOAD")) continue;
                    autoCommands.add("set " + ent.getKey() + " " + ent.getValue());
                }
                autoCommands.add("exploit");
                InteractWindow iw = new InteractWindow(this.rpcConn, res, autoCommands);
                this.parentFrame.registerConsole(res, true, iw);
            } else {
                Map info = (Map)this.rpcConn.execute("module.execute", this.moduleType, this.fullName, hash);
                if (!info.get("result").equals("success")) {
                    JOptionPane.showMessageDialog(this.rootPane, info);
                }
            }
            MsfguiApp.addRecentModule(Arrays.asList(this.moduleType, this.fullName, hash), this.rpcConn, this.parentFrame);
            this.setVisible(false);
            this.dispose();
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
    }

    private void reGroup() {
        GroupLayout mainPanelLayout = (GroupLayout)this.mainPanel.getLayout();
        GroupLayout.ParallelGroup horizGroup = mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel).addComponent(this.descriptionPane, -1, 526, Short.MAX_VALUE).addComponent(this.authorsLabel).addComponent(this.licenseLabel).addComponent(this.versionLabel);
        if (this.moduleType.equals("exploit")) {
            horizGroup.addComponent(this.targetsLabel, -2, 431, -2).addComponent(this.payloadScrollPane, -1, 529, Short.MAX_VALUE);
        }
        horizGroup.addComponent(this.requiredLabel, -2, -1, -2).addComponent(this.optionalLabel, -2, -1, -2);
        Enumeration<AbstractButton> targets = this.buttonGroup.getElements();
        while (targets.hasMoreElements()) {
            horizGroup = horizGroup.addComponent((JRadioButton)targets.nextElement());
        }
        for (Object obj : this.requiredOpts) {
            horizGroup = horizGroup.addComponent((Component)obj, -1, -1, Short.MAX_VALUE);
        }
        for (Object obj : this.optionalOpts) {
            horizGroup = horizGroup.addComponent((Component)obj, -1, -1, Short.MAX_VALUE);
        }
        for (Object obj : this.advancedOpts) {
            horizGroup = horizGroup.addComponent((Component)obj, -1, -1, Short.MAX_VALUE);
        }
        horizGroup = horizGroup.addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.exploitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consoleRunButton)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.exploitButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consoleRunButton1));
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(horizGroup).addContainerGap());
        GroupLayout.SequentialGroup vGroup = mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPane, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        if (this.moduleType.equals("exploit")) {
            vGroup.addComponent(this.targetsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            targets = this.buttonGroup.getElements();
            while (targets.hasMoreElements()) {
                vGroup.addComponent((JRadioButton)targets.nextElement()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            vGroup = vGroup.addComponent(this.payloadScrollPane, -2, 296, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        boolean odd = false;
        odd = this.addObjectsToVgroup(vGroup, odd, this.requiredLabel, this.requiredOpts);
        vGroup.addGroup(mainPanelLayout.createParallelGroup().addComponent(this.exploitButton1).addComponent(this.consoleRunButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        odd = this.addObjectsToVgroup(vGroup, odd, this.optionalLabel, this.optionalOpts);
        odd = this.addObjectsToVgroup(vGroup, odd, this.advancedLabel, this.advancedOpts);
        vGroup = vGroup.addGroup(mainPanelLayout.createParallelGroup().addComponent(this.exploitButton).addComponent(this.consoleRunButton1)).addContainerGap();
        mainPanelLayout.setVerticalGroup(vGroup);
    }

    private boolean addObjectsToVgroup(GroupLayout.SequentialGroup vGroup, boolean odd, Component label, ArrayList opts) {
        vGroup = vGroup.addComponent(label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        for (Object obj : opts) {
            vGroup.addComponent((Component)obj, -2, -1, -2);
            if (odd) {
                vGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            odd = !odd;
        }
        return odd;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.authorsLabel = new JLabel();
        this.licenseLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.targetsLabel = new JLabel();
        this.payloadScrollPane = new JScrollPane();
        this.payloadTree = new JTree();
        this.exploitButton = new JButton();
        this.requiredLabel = new JLabel();
        this.optionalLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.descriptionBox = new JEditorPane();
        this.advancedLabel = new JLabel();
        this.exploitButton1 = new JButton();
        this.consoleRunButton = new JButton();
        this.consoleRunButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setName("mainScrollPane");
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(ModulePopup.class);
        this.titleLabel.setText(resourceMap.getString("titleLabel.text", new Object[0]));
        this.titleLabel.setName("titleLabel");
        this.authorsLabel.setText(resourceMap.getString("authorsLabel.text", new Object[0]));
        this.authorsLabel.setName("authorsLabel");
        this.licenseLabel.setText(resourceMap.getString("licenseLabel.text", new Object[0]));
        this.licenseLabel.setName("licenseLabel");
        this.versionLabel.setText(resourceMap.getString("versionLabel.text", new Object[0]));
        this.versionLabel.setName("versionLabel");
        this.targetsLabel.setText(resourceMap.getString("targetsLabel.text", new Object[0]));
        this.targetsLabel.setName("targetsLabel");
        this.payloadScrollPane.setName("payloadScrollPane");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Payloads");
        this.payloadTree.setModel(new DefaultTreeModel(treeNode1));
        this.payloadTree.setName("payloadTree");
        this.payloadScrollPane.setViewportView(this.payloadTree);
        this.exploitButton.setText(resourceMap.getString("exploitButton.text", new Object[0]));
        this.exploitButton.setName("exploitButton");
        this.exploitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModulePopup.this.exploitButtonActionPerformed(evt);
            }
        });
        this.requiredLabel.setText(resourceMap.getString("requiredLabel.text", new Object[0]));
        this.requiredLabel.setName("requiredLabel");
        this.optionalLabel.setText(resourceMap.getString("optionalLabel.text", new Object[0]));
        this.optionalLabel.setName("optionalLabel");
        this.descriptionPane.setHorizontalScrollBarPolicy(31);
        this.descriptionPane.setName("descriptionPane");
        this.descriptionBox.setContentType("text/html");
        this.descriptionBox.setEditable(false);
        this.descriptionBox.setName("descriptionBox");
        this.descriptionPane.setViewportView(this.descriptionBox);
        this.advancedLabel.setText(resourceMap.getString("advancedLabel.text", new Object[0]));
        this.advancedLabel.setName("advancedLabel");
        ResourceBundle bundle = ResourceBundle.getBundle("msfgui/resources/ModulePopup");
        this.exploitButton1.setText(bundle.getString("exploitButton.text"));
        this.exploitButton1.setName("exploitButton1");
        this.exploitButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModulePopup.this.exploitButton1ActionPerformed(evt);
            }
        });
        this.consoleRunButton.setText(resourceMap.getString("consoleRunButton.text", new Object[0]));
        this.consoleRunButton.setName("consoleRunButton");
        this.consoleRunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModulePopup.this.consoleRunButtonActionPerformed(evt);
            }
        });
        this.consoleRunButton1.setText(resourceMap.getString("consoleRunButton1.text", new Object[0]));
        this.consoleRunButton1.setName("consoleRunButton1");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionPane, -1, 906, Short.MAX_VALUE).addComponent(this.authorsLabel).addComponent(this.licenseLabel).addComponent(this.versionLabel).addComponent(this.targetsLabel, -2, 431, -2).addComponent(this.payloadScrollPane, -1, 906, Short.MAX_VALUE).addComponent(this.titleLabel).addComponent(this.requiredLabel, -2, -1, -2).addComponent(this.optionalLabel, -2, -1, -2).addComponent(this.advancedLabel, -2, -1, -2).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.exploitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consoleRunButton)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.exploitButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consoleRunButton1))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPane, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.payloadScrollPane, -2, 296, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.requiredLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.optionalLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.advancedLabel, -2, -1, -2).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exploitButton).addComponent(this.consoleRunButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exploitButton1).addComponent(this.consoleRunButton1)).addContainerGap(95, Short.MAX_VALUE)));
        this.mainScrollPane.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainScrollPane, -1, 919, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainScrollPane, -1, 884, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void exploitButtonActionPerformed(ActionEvent evt) {
        this.runModule(false);
    }

    private void exploitButton1ActionPerformed(ActionEvent evt) {
        this.exploitButtonActionPerformed(evt);
    }

    private void consoleRunButtonActionPerformed(ActionEvent evt) {
        this.runModule(true);
    }
}

