<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2011 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: set_admin_permissions.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

require_once(Environment::getBasePath() .'classes/modules/core/Misc.class.php');

if ( $argc < 2 OR in_array ($argv[1], array('--help', '-help', '-h', '-?') ) ) {
	$help_output = "Usage: generate_class_list.php [modules_directory]\n";
	echo $help_output;
} else {
	//Handle command line arguments
	$last_arg = count($argv)-1;

	$base_dir = $argv[$last_arg];

	if ( isset($argv[$last_arg]) AND $argv[$last_arg] != '' ) {
		//Get all files in the base_dir
		$file_list = Misc::getFileList( $base_dir, '\.php$', TRUE );

		if ( is_array($file_list) AND count($file_list) > 0 ) {
			//Start PHP Code here:


			foreach( $file_list as $file ) {
				$class_name = str_replace('.class.php', '', basename($file) );
				$dir_name =  preg_replace('/^\//','', str_replace( $base_dir, '', dirname($file) ) );
				//echo "File: $file - Base: ". basename($file) ." Class: ". $class_name ." Dir: ". $dir_name ."\n";

				//$class_list[$class_name] = 'classes/modules/'. $dir_name .'/'. basename($file);
				$class_list[$class_name] = $dir_name .'/'. basename($file);
			}
			unset($class_name,$dir_name);

			if ( is_array($class_list) ) {
				$output .= "<?php\n";
				$output .= "\$global_class_map = array(\n";

				foreach( $class_list as $class_name => $file ) {
					$output .= "\t'$class_name' => '$file',\n";
				}

				$output .= ");\n";
				$output .= "?>\n";

				//echo $output;
			}
			file_put_contents( Environment::getBasePath() .'/includes/classlist.inc.php', $output );
		}
	}
}

//Debug::Display();
?>
