/*
 *  Copyright (C) 2006  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: RIBExporter.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef RIBEXPORTER_H
#define RIBEXPORTER_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif
#include <iostream>
#include <fstream>
#include <iostream>
#include <list>
#include "Mesh.h"
#include "Matrix.h"
#include "util.h"

using std::string;
using std::list;
using std::ostringstream;
using std::ifstream;

namespace Animorph {

typedef std::pair <string, string> StringPair;

class RIBExporter
{
protected:
  Mesh &mesh;
  Matrix tm;

  void createObjectStream (ostringstream &outStream, 
                           const string& basename);

  void replaceRIBTags (ifstream                &in_stream, 
                       ostringstream           &outStream, 
                       const list <StringPair> &replaceList);

public:
  /*!
   * \param _mesh construct RIBExporter from a Mesh object
   */
  RIBExporter (Animorph::Mesh &_mesh) : mesh (_mesh)
  {
    tm.identity ();
  }

  /*!
   * \param tm the Matrix which transformates the Mesh before exporting
   */
  void setTransformationMatrix (const Matrix &tm) {this->tm = tm;}

  /// 
  /*!
  
  */
  bool exportFile (const string &outFile);

  bool exportFile (const string            &templateDirectory, 
                   const string            &templateFile, 
                   const string            &outFile, 
                   const list <StringPair> &replaceList);
};

}

#endif	// OBJEXPORTER_H
