/*
 * Decompiled with CFR 0.152.
 */
package java.applet;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Panel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Applet
extends Panel {
    private static final long serialVersionUID = -5836846270535785031L;
    private transient AppletStub stub;
    private transient int width;
    private transient int height;
    private AccessibleContext accessibleContext;

    public Applet() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public final void setStub(AppletStub appletStub) {
        this.stub = appletStub;
        if (this.width != 0 && this.height != 0) {
            appletStub.appletResize(this.width, this.height);
        }
    }

    public boolean isActive() {
        return this.stub.isActive();
    }

    public URL getDocumentBase() {
        return this.stub.getDocumentBase();
    }

    public URL getCodeBase() {
        return this.stub.getCodeBase();
    }

    public String getParameter(String string) {
        return this.stub.getParameter(string);
    }

    public AppletContext getAppletContext() {
        return this.stub.getAppletContext();
    }

    public void resize(int n, int n2) {
        if (this.stub == null) {
            this.width = n;
            this.height = n2;
        } else {
            this.stub.appletResize(n, n2);
        }
    }

    public void resize(Dimension dimension) {
        this.resize(dimension.width, dimension.height);
    }

    public void showStatus(String string) {
        this.getAppletContext().showStatus(string);
    }

    public Image getImage(URL uRL) {
        return this.getAppletContext().getImage(uRL);
    }

    public Image getImage(URL uRL, String string) {
        try {
            return this.getImage(new URL(uRL, string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static final AudioClip newAudioClip(URL uRL) {
        return new URLAudioClip(uRL);
    }

    public AudioClip getAudioClip(URL uRL) {
        return this.getAppletContext().getAudioClip(uRL);
    }

    public AudioClip getAudioClip(URL uRL, String string) {
        try {
            return this.getAudioClip(new URL(uRL, string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getAppletInfo() {
        return null;
    }

    public Locale getLocale() {
        return super.getLocale();
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public void play(URL uRL) {
        AudioClip audioClip = this.getAudioClip(uRL);
        try {
            audioClip.play();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void play(URL uRL, String string) {
        try {
            this.getAudioClip(uRL, string).play();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleApplet(this);
        }
        return this.accessibleContext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        objectInputStream.defaultReadObject();
    }

    private static class URLAudioClip
    implements AudioClip {
        private URL url;
        private Clip clip;

        public URLAudioClip(URL uRL) {
            this.url = uRL;
        }

        private synchronized Clip getClip() {
            if (this.url == null) {
                return this.clip;
            }
            try {
                this.clip = AudioSystem.getClip();
                this.clip.open(AudioSystem.getAudioInputStream(this.url));
            }
            catch (LineUnavailableException lineUnavailableException) {
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                // empty catch block
            }
            this.url = null;
            return this.clip;
        }

        public void loop() {
            Clip clip = this.getClip();
            if (clip != null) {
                clip.loop(-1);
            }
        }

        public void play() {
            Clip clip = this.getClip();
            if (clip != null) {
                clip.start();
            }
        }

        public void stop() {
            Clip clip = this.getClip();
            if (clip != null) {
                clip.stop();
                clip.setFramePosition(0);
            }
        }
    }

    protected class AccessibleApplet
    extends Panel.AccessibleAWTPanel {
        private /* synthetic */ Applet this$0;
        private static final long serialVersionUID = 8127374778187708896L;

        protected AccessibleApplet(Applet applet) {
            this.this$0 = applet;
            super(applet);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

