/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    ArrayList marks;
    WeakHashMap positions;
    ReferenceQueue queueOfDeath;
    private static final /* synthetic */ boolean $assertionsDisabled;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        n = Math.max(n, 2);
        this.buffer = (char[])this.allocateArray(n);
        this.gapStart = 1;
        this.gapEnd = n;
        this.buffer[0] = 10;
        this.positions = new WeakHashMap();
        this.marks = new ArrayList();
        this.queueOfDeath = new ReferenceQueue();
    }

    protected Object allocateArray(int n) {
        return new char[n];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        int n2 = this.length();
        int n3 = string.length();
        if (n < 0) {
            throw new BadLocationException("The where argument cannot be smaller than the zero", n);
        }
        if (n > n2) {
            throw new BadLocationException("The where argument cannot be greater than the content length", n);
        }
        this.replace(n, 0, string.toCharArray(), n3);
        return new InsertUndo(this, n, n3);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n + n2 >= n3) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", n + n2);
        }
        String string = this.getString(n, n2);
        this.replace(n, n2, null, 0);
        return new UndoRemove(this, n, string);
    }

    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        try {
            this.getChars(n, n2, segment);
            return new String(segment.array, segment.offset, segment.count);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            int n3 = 0;
            n3 = segment.offset < 0 || segment.offset >= segment.array.length ? segment.offset : segment.offset + segment.count;
            throw new BadLocationException("Illegal location: array.length = " + segment.array.length + ", offset = " + segment.offset + ", count = " + segment.count, n3);
        }
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = this.length();
        if (n < 0) {
            throw new BadLocationException("the where argument may not be below zero", n);
        }
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("len plus where cannot be greater than the content length", n2 + n);
        }
        if (n2 < 0) {
            throw new BadLocationException("negative length not allowed: ", n2);
        }
        if (n < this.gapStart && this.gapStart - n < n2) {
            char[] cArray = new char[n2];
            int n4 = this.gapStart - n;
            System.arraycopy(this.buffer, n, cArray, 0, n4);
            System.arraycopy(this.buffer, this.gapEnd, cArray, n4, n2 - n4);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        } else {
            segment.array = this.buffer;
            segment.offset = n < this.gapStart ? n : n + (this.gapEnd - this.gapStart);
            segment.count = n2;
        }
    }

    public Position createPosition(int n) throws BadLocationException {
        GapContentPosition gapContentPosition = null;
        Set set = this.positions.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            GapContentPosition gapContentPosition2 = (GapContentPosition)iterator.next();
            if (gapContentPosition2.getOffset() != n) continue;
            gapContentPosition = gapContentPosition2;
            break;
        }
        if (gapContentPosition == null) {
            gapContentPosition = new GapContentPosition(this, n);
            this.positions.put(gapContentPosition, null);
        }
        return gapContentPosition;
    }

    protected void shiftEnd(int n) {
        if (!$assertionsDisabled && this.gapEnd - this.gapStart >= n) {
            throw new AssertionError((Object)"The new gap size must be greater than the old gap size");
        }
        int n2 = n - this.gapEnd + this.gapStart;
        this.adjustPositionsInRange(this.gapEnd, -1, n2);
        char[] cArray = (char[])this.allocateArray(this.length() + n);
        System.arraycopy(this.buffer, 0, cArray, 0, this.gapStart);
        System.arraycopy(this.buffer, this.gapEnd, cArray, this.gapStart + n, this.buffer.length - this.gapEnd);
        this.gapEnd = this.gapStart + n;
        this.buffer = cArray;
    }

    protected void shiftGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        int n2 = n + this.gapEnd - this.gapStart;
        if (n < this.gapStart) {
            this.adjustPositionsInRange(n, this.gapStart, this.gapEnd - this.gapStart);
            System.arraycopy(this.buffer, n, this.buffer, n2, this.gapStart - n);
            this.gapStart = n;
            this.gapEnd = n2;
        } else {
            this.adjustPositionsInRange(this.gapEnd, n2, this.gapStart - this.gapEnd);
            System.arraycopy(this.buffer, this.gapEnd, this.buffer, this.gapStart, n - this.gapStart);
            this.gapStart = n;
            this.gapEnd = n2;
        }
        this.resetMarksAtZero();
    }

    protected void shiftGapStartDown(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (!$assertionsDisabled && this.gapStart <= n) {
            throw new AssertionError((Object)"The new gap start must be less than the old gap start.");
        }
        this.setPositionsInRange(n, this.gapStart, false);
        this.gapStart = n;
        this.resetMarksAtZero();
    }

    protected void shiftGapEndUp(int n) {
        if (n == this.gapEnd) {
            return;
        }
        if (!$assertionsDisabled && this.gapEnd >= n) {
            throw new AssertionError((Object)"The new gap end must be greater than the old gap end.");
        }
        this.setPositionsInRange(this.gapEnd, n, false);
        this.gapEnd = n;
        this.resetMarksAtZero();
    }

    protected final Object getArray() {
        return this.buffer;
    }

    protected void replace(int n, int n2, Object object, int n3) {
        if (this.gapStart != n) {
            this.shiftGap(n);
        }
        if (n2 > 0) {
            this.shiftGapEndUp(this.gapEnd + n2);
        }
        if (this.gapEnd - this.gapStart <= n3) {
            this.shiftEnd((n3 - this.gapEnd + this.gapStart + 1) * 2 + this.gapEnd + 10);
        }
        if (object != null) {
            System.arraycopy(object, 0, this.buffer, this.gapStart, n3);
            this.gapStart += n3;
        }
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector();
        } else {
            vector2.clear();
        }
        int n3 = n + n2;
        Set set = this.positions.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            GapContentPosition gapContentPosition = (GapContentPosition)iterator.next();
            int n4 = gapContentPosition.getOffset();
            if (n4 < n || n4 >= n3) continue;
            vector2.add(gapContentPosition);
        }
        return vector2;
    }

    private void setPositionsInRange(int n, int n2, boolean bl) {
        GapContent gapContent = this;
        synchronized (gapContent) {
            try {
                Mark mark = new Mark(this, 0);
                mark.mark = n;
                int n3 = this.search(this.marks, mark);
                if (n3 < 0) {
                    n3 = -n3 - 1;
                }
                mark.mark = n2;
                int n4 = this.search(this.marks, mark);
                if (n4 < 0) {
                    n4 = -n4 - 2;
                }
                for (int i = n3; i <= n4; ++i) {
                    ((Mark)this.marks.get((int)i)).mark = bl ? n : n2;
                }
                mark = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    private void adjustPositionsInRange(int n, int n2, int n3) {
        GapContent gapContent = this;
        synchronized (gapContent) {
            try {
                int n4;
                Mark mark = new Mark(this, 0);
                mark.mark = n;
                int n5 = this.search(this.marks, mark);
                if (n5 < 0) {
                    n5 = -n5 - 1;
                }
                mark.mark = n2;
                if (n2 == -1) {
                    n4 = this.marks.size() - 1;
                } else {
                    n4 = this.search(this.marks, mark);
                    if (n4 < 0) {
                        n4 = -n4 - 2;
                    }
                }
                for (int i = n5; i <= n4; ++i) {
                    Object object = this.marks.get(i);
                    ((Mark)object).mark += n3;
                }
                mark = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        for (int i = 0; i < this.marks.size(); ++i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.mark > this.gapEnd) continue;
            mark.mark = 0;
        }
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
    }

    private void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        for (int i = 0; i < this.buffer.length; ++i) {
            if (i == this.gapStart) {
                System.err.print('<');
            }
            if (i == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[i])) {
                System.err.print(this.buffer[i]);
                continue;
            }
            System.err.print('.');
        }
        System.err.println();
    }

    private void dumpMarks() {
        System.out.print("positionMarks: ");
        for (int i = 0; i < this.marks.size(); ++i) {
            System.out.print(((Mark)this.marks.get((int)i)).mark + ", ");
        }
        System.out.println();
    }

    void garbageCollect() {
        Reference reference = this.queueOfDeath.poll();
        while (reference != null) {
            if (reference != null) {
                GapContentPosition gapContentPosition = (GapContentPosition)reference.get();
                Mark mark = gapContentPosition.mark;
                --mark.refCount;
                if (mark.refCount == 0) {
                    this.marks.remove(mark);
                }
            }
            reference = this.queueOfDeath.poll();
        }
    }

    private int search(List list2, Object object) {
        Object object2;
        int n;
        for (n = Collections.binarySearch(list2, object); n > 0 && (object2 = list2.get(n - 1)).equals(object); --n) {
        }
        return n;
    }

    static {
        $assertionsDisabled = GapContent.class$("javax.swing.text.GapContent").desiredAssertionStatus() ^ true;
    }

    private class UndoRemove
    extends AbstractUndoableEdit {
        private /* synthetic */ GapContent this$0;
        public int where;
        String text;

        public UndoRemove(GapContent gapContent, int n, String string) {
            this.this$0 = gapContent;
            this.where = n;
            this.text = string;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.this$0.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.this$0.remove(this.where, this.text.length());
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        private /* synthetic */ GapContent this$0;
        public int where;
        public int length;
        String text;

        public InsertUndo(GapContent gapContent, int n, int n2) {
            this.this$0 = gapContent;
            this.where = n;
            this.length = n2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.text = this.this$0.getString(this.where, this.length);
                this.this$0.remove(this.where, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.this$0.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class Mark
    implements Comparable {
        private /* synthetic */ GapContent this$0;
        int mark;
        int refCount;
        private static final /* synthetic */ boolean $assertionsDisabled;

        Mark(GapContent gapContent, int n) {
            this.this$0 = gapContent;
            this.mark = n;
            if (this.mark >= gapContent.gapStart && this.mark != 0) {
                this.mark += gapContent.gapEnd - gapContent.gapStart;
            }
        }

        int getOffset() {
            if (!$assertionsDisabled && this.mark != 0 && this.mark >= this.this$0.gapStart && this.mark < this.this$0.gapEnd) {
                throw new AssertionError((Object)("Invalid mark: " + this.mark + ", gapStart: " + this.this$0.gapStart + ", gapEnd: " + this.this$0.gapEnd));
            }
            int n = this.mark;
            if (this.mark >= this.this$0.gapEnd) {
                n -= this.this$0.gapEnd - this.this$0.gapStart;
            }
            return n;
        }

        public int compareTo(Object object) {
            Mark mark = (Mark)object;
            return this.mark - mark.mark;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Mark)) {
                return false;
            }
            return ((Mark)object).mark == this.mark;
        }

        static {
            $assertionsDisabled = GapContent.class$("javax.swing.text.GapContent$Mark").desiredAssertionStatus() ^ true;
        }
    }

    private class GapContentPosition
    implements Position {
        private /* synthetic */ GapContent this$0;
        Mark mark;

        GapContentPosition(GapContent gapContent, int n) {
            this.this$0 = gapContent;
            GapContent gapContent2 = gapContent;
            synchronized (gapContent2) {
                Mark mark;
                try {
                    gapContent.garbageCollect();
                    mark = new Mark(gapContent, n);
                    int n2 = gapContent.search(gapContent.marks, mark);
                    if (n2 >= 0) {
                        mark = (Mark)gapContent.marks.get(n2);
                    } else {
                        n2 = -n2 - 1;
                        gapContent.marks.add(n2, mark);
                    }
                    ++mark.refCount;
                    this.mark = mark;
                }
                finally {
                    mark = null;
                }
                new WeakReference(this, gapContent.queueOfDeath);
                return;
            }
        }

        public int getOffset() {
            return this.mark.getOffset();
        }
    }
}

