/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : AbstractListener.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */
 
#ifndef ABSTRACTLISTENER
#define ABSTRACTLISTENER 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

namespace mhgui {

class Point;
class Component;

class AbstractListener {
public:

           AbstractListener() {}
  virtual ~AbstractListener() {}

  virtual bool mouseOver     (const Point& inMousePos,               Component *source ) = 0;
  virtual bool mouseOut      (const Point& inMousePos,               Component *source ) = 0;
  virtual bool mousePressed  (const Point& inMousePos, int inButton, Component *source ) = 0;
  virtual bool mouseReleased (const Point& inMousePos, int inButton, Component *source ) = 0;
  virtual bool mouseDragged  (const Point& inMousePos,               Component *source ) = 0;
  virtual bool keyType       (unsigned char inKey,                   Component *source ) = 0;
};

} // namespace mhgui

#endif
