# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import unittest
import random

from elisa.plugins.pigment.widgets.size_enforcer import RatioConstrainer
from elisa.plugins.pigment.graph.group import Group


class TestRatioConstrainer(unittest.TestCase):
    """
    Tests of a Square object in the case it belongs to a parent Group.
    """

    def setUp(self):
        self.parent = Group()
        self.parent.size = (3.0, 2.0)
        self.parent.visible = True
        # add self.parent to an imaginary canvas to make sure self.constrainer
        # is considered as mapped
        self.parent.canvas = "FakeCanvas"

        self.constrainer = RatioConstrainer()
        # FIXME: add tests with set aspect ratios rather than a random one
        # between 0.0 and 2.0
        self.constrainer.aspect_ratio = random.random()*2.0
        self.constrainer.visible = True

        self.parent.add(self.constrainer)

    def tearDown(self):
        self.parent.empty()
        self.parent = None
        self.constrainer = None

    def test_size_set(self):
        self.constrainer.size = (1.0, 1.0)
        self.assertAspectRatioIsRespected(self.constrainer)

        self.constrainer.size = (0.5, 0.5)
        self.assertAspectRatioIsRespected(self.constrainer)

        # pass a non self.constrainer size changing only one attribute
        self.constrainer.size = (0.2, 0.5)
        self.assertAspectRatioIsRespected(self.constrainer)

        # pass a non self.constrainer size changing both attributes
        self.constrainer.size = (0.7, 0.3)
        self.assertAspectRatioIsRespected(self.constrainer)

        self.constrainer.size = (0.1, 0.1)
        self.assertAspectRatioIsRespected(self.constrainer)

    def test_width_set(self):
        self.constrainer.width = 0.2
        self.assertAspectRatioIsRespected(self.constrainer)

        self.constrainer.width = 0.1
        self.assertAspectRatioIsRespected(self.constrainer)

        # test width set to 0
        self.constrainer.width = 0.0
        self.assertAspectRatioIsRespected(self.constrainer)

    def test_height_set(self):
        self.constrainer.height = 0.2
        self.assertAspectRatioIsRespected(self.constrainer)

        self.constrainer.height = 0.1
        self.assertAspectRatioIsRespected(self.constrainer)

        # test height set to 0
        self.constrainer.height = 0.0
        self.assertAspectRatioIsRespected(self.constrainer)

    def assertAspectRatioIsRespected(self, widget):
        expected_width = widget.aspect_ratio*widget.absolute_height
        self.assertAlmostEqual(widget.absolute_width, expected_width)
