/*
 * Decompiled with CFR 0.152.
 */
package pax;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ListIterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.pdfbox.pdmodel.interactive.action.type.PDActionRemoteGoTo;
import org.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitHeightDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitRectangleDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import pax.Constants;
import pax.Entry;
import pax.EntryWriteException;
import pax.StringVisitor;

public class PDFAnnotExtractor
implements Constants {
    protected File inputFile;
    protected File outputFile;
    protected PDDocument doc;
    protected PDDocumentCatalog catalog;
    protected Entry entry;
    protected int destCount;
    protected static final String USAGE = "Syntax: java PDFAnnotExtractor <pdffiles[.pdf]>";
    protected static final String EXT_PDF = ".pdf";
    protected static final String EXT_PAX = ".pax";

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println(USAGE);
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            PDFAnnotExtractor.processFile(stringArray[i]);
        }
    }

    public static void processFile(String string) {
        Object object;
        File file = new File(string);
        if (file.isFile()) {
            string = PDFAnnotExtractor.stripFromEnd(string, EXT_PDF);
        } else {
            object = new File(string + EXT_PDF);
            if (((File)object).isFile()) {
                file = object;
            } else {
                System.err.println(USAGE);
                PDFAnnotExtractor.error("PDF file not found: " + string, null);
            }
        }
        System.out.println("* Processing file `" + file.toString() + "' ...");
        object = new PDFAnnotExtractor(file, new File(string + EXT_PAX));
        ((PDFAnnotExtractor)object).parse();
        ((PDFAnnotExtractor)object).close();
    }

    public PDFAnnotExtractor(File file, File file2) {
        this.inputFile = file;
        this.outputFile = file2;
        this.destCount = 0;
        try {
            this.doc = PDDocument.load((File)file);
            this.catalog = this.doc.getDocumentCatalog();
        }
        catch (IOException iOException) {
            PDFAnnotExtractor.error("Loading failed: " + file, iOException);
        }
        try {
            this.entry = new Entry(new BufferedWriter(new FileWriter(file2)));
        }
        catch (IOException iOException) {
            PDFAnnotExtractor.error("Cannot open output: " + file2, iOException);
        }
    }

    public void close() {
        try {
            this.doc.close();
        }
        catch (IOException iOException) {
            PDFAnnotExtractor.error("Closing failed: " + this.inputFile, iOException);
        }
        try {
            this.entry.close();
        }
        catch (EntryWriteException entryWriteException) {
            PDFAnnotExtractor.error("Closing failed: " + this.outputFile, entryWriteException);
        }
    }

    public void parse() {
        this.cmd_pax();
        this.cmd_file();
        this.cmd_pagenum();
        this.cmd_baseurl();
        this.parse_pages();
    }

    public void cmd_pax() {
        try {
            this.entry.setCmd("pax");
            this.entry.addArg("0.01");
            this.entry.write();
        }
        catch (Exception exception) {
            this.handleCmdException(exception);
        }
    }

    public void cmd_file() {
        try {
            long l;
            this.entry.setCmd("file");
            this.entry.addArg(this.formatString(this.inputFile.toString()));
            long l2 = this.inputFile.length();
            if (l2 > 0L) {
                this.entry.putKV("Size", "" + l2);
            }
            if ((l = this.inputFile.lastModified()) != 0L) {
                Date date = new Date(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                String string = "D:" + simpleDateFormat.format(date);
                simpleDateFormat = new SimpleDateFormat("Z");
                String string2 = simpleDateFormat.format(date);
                string2 = string2.equals("+0000") ? "Z" : string2.substring(0, 3) + "'" + string2.substring(3, 5) + "'";
                this.entry.putKV("Date", string + string2);
            }
            this.entry.write();
        }
        catch (Exception exception) {
            this.handleCmdException(exception);
        }
    }

    public void cmd_pagenum() {
        try {
            int n = this.doc.getNumberOfPages();
            this.entry.setCmd("pagenum");
            this.entry.addArg("" + n);
            this.entry.write();
        }
        catch (Exception exception) {
            this.handleCmdException(exception);
        }
    }

    public void cmd_info() {
        try {
            this.entry.setCmd("info");
            PDDocumentInformation pDDocumentInformation = this.doc.getDocumentInformation();
            this.entry.putKV("Author", this.formatString(pDDocumentInformation.getAuthor()));
            this.entry.putKV("Creator", this.formatString(pDDocumentInformation.getCreator()));
            this.entry.putKV("Keywords", this.formatString(pDDocumentInformation.getKeywords()));
            this.entry.putKV("Producer", this.formatString(pDDocumentInformation.getProducer()));
            this.entry.putKV("Subject", this.formatString(pDDocumentInformation.getSubject()));
            this.entry.putKV("Title", this.formatString(pDDocumentInformation.getTitle()));
            if (!this.entry.isEmptyKV()) {
                this.entry.write();
            }
        }
        catch (Exception exception) {
            this.handleCmdException(exception);
        }
    }

    public void cmd_baseurl() {
        try {
            this.entry.setCmd("baseurl");
            COSDictionary cOSDictionary = this.catalog.getCOSDictionary();
            cOSDictionary = (COSDictionary)cOSDictionary.getItem(COSName.getPDFName((String)"URI"));
            String string = cOSDictionary.getString("Base");
            if (string.length() > 0) {
                this.entry.addArg(this.formatString(string));
                this.entry.write();
            }
        }
        catch (EntryWriteException entryWriteException) {
            this.handleCmdException(entryWriteException);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parse_pages() {
        ListIterator listIterator = this.catalog.getAllPages().listIterator();
        while (listIterator.hasNext()) {
            PDPage pDPage = (PDPage)listIterator.next();
            int n = listIterator.nextIndex();
            this.parse_page(n, pDPage);
        }
        try {
            this.entry.flushDelayed();
        }
        catch (EntryWriteException entryWriteException) {
            System.err.println("Write error: " + this.outputFile);
            System.err.println(entryWriteException.getCause().toString());
        }
    }

    public void parse_page(int n, PDPage pDPage) {
        this.cmd_page(n, pDPage);
        this.parse_annots(n, pDPage);
    }

    public void cmd_page(int n, PDPage pDPage) {
        try {
            this.entry.setCmd("page");
            this.entry.addArg("" + n);
            this.entry.withKV();
            int n2 = pDPage.findRotation();
            if (n2 != 0) {
                this.entry.putKV("Rotate", "" + n2);
            }
            PDRectangle pDRectangle = pDPage.findMediaBox();
            PDRectangle pDRectangle2 = pDPage.findCropBox();
            PDRectangle pDRectangle3 = pDPage.getBleedBox();
            PDRectangle pDRectangle4 = pDPage.getTrimBox();
            PDRectangle pDRectangle5 = pDPage.getArtBox();
            this.entry.addArg(this.formatBox(pDRectangle));
            if (!this.equals(pDRectangle2, pDRectangle)) {
                this.entry.putKV("CropBox", this.formatBox(pDRectangle2));
            }
            if (!this.equals(pDRectangle3, pDRectangle2)) {
                this.entry.putKV("BleedBox", this.formatBox(pDRectangle3));
            }
            if (!this.equals(pDRectangle4, pDRectangle2)) {
                this.entry.putKV("TrimBox", this.formatBox(pDRectangle4));
            }
            if (!this.equals(pDRectangle5, pDRectangle2)) {
                this.entry.putKV("ArtBox", this.formatBox(pDRectangle5));
            }
            this.entry.write();
        }
        catch (Exception exception) {
            this.handleCmdException(exception);
        }
    }

    public void parse_annots(int n, PDPage pDPage) {
        COSArray cOSArray = null;
        try {
            COSDictionary cOSDictionary = pDPage.getCOSDictionary();
            cOSArray = (COSArray)cOSDictionary.getDictionaryObject(COSName.ANNOTS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cOSArray == null) {
            return;
        }
        for (int i = 0; i < cOSArray.size(); ++i) {
            try {
                COSDictionary cOSDictionary = (COSDictionary)cOSArray.getObject(i);
                this.cmd_annot(n, cOSDictionary);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cmd_annot(int n, COSDictionary cOSDictionary) {
        try {
            this.entry.setCmd("annot");
            this.entry.addArg("" + n);
            String string = cOSDictionary.getNameAsString(COSName.TYPE, "Annot");
            if (!string.equals("Annot")) {
                throw new Exception("Wrong annotation type: " + string);
            }
            String string2 = cOSDictionary.getNameAsString(COSName.SUBTYPE);
            if (string2 == null) {
                throw new Exception("Missing annotation subtype.");
            }
            if (!string2.equals("Link")) {
                throw new Exception("Unsupported annotation subtype: " + string2);
            }
            this.entry.addArg(string2);
            this.entry.withKV();
            COSArray cOSArray = (COSArray)cOSDictionary.getDictionaryObject("Rect");
            PDRectangle pDRectangle = new PDRectangle(cOSArray);
            this.entry.addArg(this.formatBox(pDRectangle));
            COSDictionary cOSDictionary2 = (COSDictionary)cOSDictionary.getDictionaryObject("A");
            if (cOSDictionary2 == null) {
                COSBase cOSBase = cOSDictionary.getDictionaryObject("Dest");
                if (cOSBase == null) {
                    throw new Exception("Unsupported link annotation without action.");
                }
                this.entry.addArg("GoTo");
                ++this.destCount;
                this.entry.putKV("DestLabel", "" + this.destCount);
                this.annot_attrs(cOSDictionary);
                this.entry.write();
                this.add_dest(PDDestination.create((COSBase)cOSBase));
                this.entry.writeDelayed();
                return;
            }
            PDAction pDAction = PDActionFactory.createAction((COSDictionary)cOSDictionary2);
            if (pDAction == null) {
                if (!cOSDictionary2.getNameAsString("S").equals("Named")) throw new Exception("Unsupported link annotation.");
                this.entry.addArg("Named");
                String string3 = cOSDictionary2.getNameAsString("N");
                if (string3 == null) throw new Exception("Unsupported link annotation.");
                this.entry.putKV("Name", string3);
                this.annot_attrs(cOSDictionary);
                this.entry.write();
                return;
            }
            String string4 = pDAction.getSubType();
            this.entry.addArg(string4);
            if (pDAction instanceof PDActionURI) {
                PDActionURI pDActionURI = (PDActionURI)pDAction;
                this.entry.putKV("URI", this.formatString(pDActionURI.getURI()));
                if (pDActionURI.shouldTrackMousePosition()) {
                    this.entry.putKV("IsMap", null);
                }
            } else {
                if (pDAction instanceof PDActionGoTo) {
                    ++this.destCount;
                    this.entry.putKV("DestLabel", "" + this.destCount);
                    this.annot_attrs(cOSDictionary);
                    this.entry.write();
                    this.add_dest(((PDActionGoTo)pDAction).getDestination());
                    this.entry.writeDelayed();
                    return;
                }
                if (!(pDAction instanceof PDActionRemoteGoTo)) throw new Exception("Unsupported link annotation type: " + string4);
                PDActionRemoteGoTo pDActionRemoteGoTo = (PDActionRemoteGoTo)pDAction;
                String string5 = pDActionRemoteGoTo.getFile().getFile();
                if (string5 == null || string5.length() == 0) {
                    throw new Exception("GoToR: missing file");
                }
                this.entry.putKV("File", this.formatString(pDActionRemoteGoTo.getFile().getFile()));
                COSBase cOSBase = pDActionRemoteGoTo.getD();
                if (cOSBase instanceof COSString) {
                    this.entry.putKV("DestName", this.formatString(((COSString)cOSBase).getString()));
                } else if (cOSBase instanceof COSName) {
                    this.entry.putKV("DestName", this.formatString(((COSName)cOSBase).getName()));
                } else {
                    if (!(cOSBase instanceof COSArray)) throw new Exception("GoToR: unknown dest type");
                    COSArray cOSArray2 = (COSArray)cOSBase;
                    int n2 = cOSArray2.getInt(0);
                    this.entry.putKV("DestPage", "" + n2);
                    String string6 = cOSArray2.getName(1);
                    int n3 = cOSArray2.size();
                    if (!string6.equals("Fit") && !string6.equals("FitB")) {
                        if (string6.equals("FitH") || string6.equals("FitBH") || string6.equals("FitV") || string6.equals("FitBV")) {
                            if (n3 >= 3) {
                                try {
                                    String string7 = this.formatNumber(((COSNumber)cOSArray2.getObject(2)).floatValue());
                                    string6 = string6 + " " + string7;
                                }
                                catch (Exception exception) {
                                    n3 = 0;
                                }
                            }
                            if (n3 < 3) {
                                string6 = string6.equals("FitH") || string6.equals("FitV") ? "Fit" : "FitB";
                            }
                        } else if (string6.equals("XYZ")) {
                            COSBase cOSBase2;
                            string6 = string6 + " ";
                            string6 = n3 >= 3 ? ((cOSBase2 = cOSArray2.getObject(2)) instanceof COSNumber ? string6 + this.formatNumber(((COSNumber)cOSBase2).floatValue()) : string6 + "null") : string6 + "null";
                            string6 = string6 + " ";
                            string6 = n3 >= 4 ? ((cOSBase2 = cOSArray2.getObject(3)) instanceof COSNumber ? string6 + this.formatNumber(((COSNumber)cOSBase2).floatValue()) : string6 + "null") : string6 + "null";
                            string6 = string6 + " ";
                            string6 = n3 >= 5 ? ((cOSBase2 = cOSArray2.getObject(4)) instanceof COSNumber ? string6 + this.formatNumber(((COSNumber)cOSBase2).floatValue()) : string6 + "null") : string6 + "null";
                        } else {
                            if (!string6.equals("FitR")) throw new Exception("Unknown destination view type");
                            string6 = string6 + " " + this.formatNumber(((COSNumber)cOSArray2.getObject(2)).floatValue()) + " " + this.formatNumber(((COSNumber)cOSArray2.getObject(3)).floatValue()) + " " + this.formatNumber(((COSNumber)cOSArray2.getObject(4)).floatValue()) + " " + this.formatNumber(((COSNumber)cOSArray2.getObject(5)).floatValue());
                        }
                    }
                    this.entry.putKV("DestView", "/" + string6);
                }
            }
            this.annot_attrs(cOSDictionary);
            this.entry.write();
            return;
        }
        catch (EntryWriteException entryWriteException) {
            this.handleCmdException(entryWriteException);
            return;
        }
        catch (Exception exception) {
            System.err.println("!!! Warning: Annotation on page " + n + " not recognized!");
            System.err.println("    " + exception.toString());
            String string = exception.getMessage();
            Throwable throwable = exception.getCause();
            if (throwable != null) {
                System.err.println("    " + throwable.toString());
            }
            if (!(exception instanceof ClassCastException)) return;
            exception.printStackTrace();
        }
    }

    private void add_dest(PDDestination pDDestination) throws Exception {
        Object object;
        String string;
        this.entry.setCmd("dest");
        this.entry.withKV();
        if (pDDestination instanceof PDNamedDestination) {
            string = ((PDNamedDestination)pDDestination).getNamedDestination();
            object = this.catalog.getNames().getDests().getValue(string);
            if (object instanceof PDDestination) {
                pDDestination = (PDDestination)object;
            }
        }
        if (pDDestination instanceof PDPageDestination) {
            string = (PDPageDestination)pDDestination;
            object = string.getPage();
            int n = this.catalog.getAllPages().indexOf(object);
            if (n < 0) {
                throw new Exception("Link to unknown page");
            }
            this.entry.addArg("" + (n + 1));
            this.entry.addArg("" + this.destCount);
            if (string instanceof PDPageFitDestination) {
                PDPageFitDestination pDPageFitDestination = (PDPageFitDestination)string;
                this.entry.addArg(pDPageFitDestination.fitBoundingBox() ? "FitB" : "Fit");
                return;
            }
            if (string instanceof PDPageFitHeightDestination) {
                COSNumber cOSNumber;
                PDPageFitHeightDestination pDPageFitHeightDestination = (PDPageFitHeightDestination)string;
                this.entry.addArg(pDPageFitHeightDestination.fitBoundingBox() ? "FitBV" : "FitV");
                COSArray cOSArray = pDPageFitHeightDestination.getCOSArray();
                if (cOSArray.size() > 2 && (cOSNumber = (COSNumber)cOSArray.getObject(2)) != null) {
                    this.entry.putKV("DestX", this.formatNumber(cOSNumber));
                }
                return;
            }
            if (string instanceof PDPageFitWidthDestination) {
                COSNumber cOSNumber;
                PDPageFitWidthDestination pDPageFitWidthDestination = (PDPageFitWidthDestination)string;
                this.entry.addArg(pDPageFitWidthDestination.fitBoundingBox() ? "FitBH" : "FitH");
                COSArray cOSArray = pDPageFitWidthDestination.getCOSArray();
                if (cOSArray.size() > 2 && (cOSNumber = (COSNumber)cOSArray.getObject(2)) != null) {
                    this.entry.putKV("DestY", this.formatNumber(cOSNumber));
                }
                return;
            }
            if (string instanceof PDPageFitRectangleDestination) {
                PDPageFitRectangleDestination pDPageFitRectangleDestination = (PDPageFitRectangleDestination)string;
                this.entry.addArg("FitR");
                COSArray cOSArray = pDPageFitRectangleDestination.getCOSArray();
                int n2 = cOSArray.size();
                if (n2 != 6) {
                    throw new Exception("Rectangle destination without correct number of parameters");
                }
                this.entry.putKV("Rect", this.formatNumber((COSNumber)cOSArray.getObject(2)) + " " + this.formatNumber((COSNumber)cOSArray.getObject(3)) + " " + this.formatNumber((COSNumber)cOSArray.getObject(4)) + " " + this.formatNumber((COSNumber)cOSArray.getObject(5)));
                return;
            }
            if (string instanceof PDPageXYZDestination) {
                COSNumber cOSNumber;
                PDPageXYZDestination pDPageXYZDestination = (PDPageXYZDestination)string;
                this.entry.addArg("XYZ");
                COSArray cOSArray = pDPageXYZDestination.getCOSArray();
                int n3 = cOSArray.size();
                if (n3 > 2 && (cOSNumber = (COSNumber)cOSArray.getObject(2)) != null) {
                    this.entry.putKV("DestX", this.formatNumber(cOSNumber));
                }
                if (n3 > 3 && (cOSNumber = (COSNumber)cOSArray.getObject(3)) != null) {
                    this.entry.putKV("DestY", this.formatNumber(cOSNumber));
                }
                if (n3 > 4 && (cOSNumber = (COSNumber)cOSArray.getObject(4)) != null) {
                    this.entry.putKV("DestZoom", this.formatNumber(cOSNumber));
                }
                return;
            }
        }
        throw new Exception("Unknown destination type");
    }

    protected void annot_attrs(COSDictionary cOSDictionary) {
        this.put_attr(cOSDictionary, "C", "C");
        this.put_attr(cOSDictionary, "Border", "Border");
        this.put_attr(cOSDictionary, "BS", "BS");
        this.put_attr(cOSDictionary, "H", "H");
    }

    protected void put_attr(COSDictionary cOSDictionary, String string, String string2) {
        try {
            COSBase cOSBase = cOSDictionary.getDictionaryObject(string);
            if (cOSBase == null) {
                return;
            }
            String string3 = cOSBase.accept((ICOSVisitor)new StringVisitor()).toString();
            if (string3 == null || string3.length() == 0) {
                return;
            }
            this.entry.putKV(string2, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean equals(PDRectangle pDRectangle, PDRectangle pDRectangle2) {
        return pDRectangle.getLowerLeftX() == pDRectangle2.getLowerLeftX() && pDRectangle.getLowerLeftY() == pDRectangle2.getLowerLeftY() && pDRectangle.getUpperRightX() == pDRectangle2.getUpperRightX() && pDRectangle.getUpperRightY() == pDRectangle2.getUpperRightY();
    }

    protected String formatBox(PDRectangle pDRectangle) {
        return this.formatNumber(pDRectangle.getLowerLeftX()) + ' ' + this.formatNumber(pDRectangle.getLowerLeftY()) + ' ' + this.formatNumber(pDRectangle.getUpperRightX()) + ' ' + this.formatNumber(pDRectangle.getUpperRightY());
    }

    protected String formatString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return "\\<" + new COSString(string).getHexString() + "\\>";
    }

    protected String formatNumber(float f) {
        String string = "" + f;
        return PDFAnnotExtractor.stripFromEnd(string, ".0");
    }

    protected String formatNumber(COSNumber cOSNumber) {
        return this.formatNumber(cOSNumber.floatValue());
    }

    protected static String stripFromEnd(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    protected static void error(String string, Exception exception, boolean bl) {
        System.err.println("!!! Error: " + string);
        if (exception != null) {
            if (bl) {
                exception.printStackTrace();
            } else {
                System.err.println(exception.toString());
            }
        }
        System.exit(1);
    }

    protected static void error(String string, Exception exception) {
        PDFAnnotExtractor.error(string, exception, false);
    }

    protected void handleCmdException(Exception exception) {
        System.err.println("!!! Error during write of entry `" + this.entry.getCmd() + "'!\n");
        if (exception instanceof EntryWriteException) {
            System.err.println("Write error: " + this.outputFile);
            System.err.println(((EntryWriteException)exception).getCause().toString());
        } else {
            exception.printStackTrace();
        }
    }
}

