/*	$OpenBSD: pow2_x.c,v 1.1 2009/04/09 01:24:43 martynas Exp $	*/

/*
 * Copyright (c) 2009 Gaston H. Gonnet <gonnet@inf.ethz.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* This program was generated automatically by a program written
   by Gaston H. Gonnet on enigma on 2002-09-01 17:40:39.
   Do not edit, rerun the original maple program.       */
#include "header.h"
#define DBL_MAX_EXP 1024
#define N 1467
#define F pow2_x
#define Fs "pow2_x"
#define Fn fpaccuracy_pow2_x

static struct input_point { double arg_m, val, eps;
	int arg_e, val_e; } input_points[N] = {
 -8978350369394041.,5467256732866502.,.498257556096271592293,-43,1073,
 -8978350369394000.,5467256732884166.,.494851169252276389381,-43,1073,
 -8978350369393959.,5467256732901830.,.491444839478360552504,-43,1073,
 -8978350369393479.,5467256733108629.,-.499649410318153210411,-43,1073,
 -8978350369392595.,5467256733489482.,-.499894185599401408611,-43,1073,
 -8978350369388778.,5467256735133957.,-.499515277245534750993,-43,1073,
 -8978350369384961.,5467256736778432.,-.498641733618678966706,-43,1073,
 -8978350369318907.,5467256765236423.,-.404394717203865548794,-43,1073,
 -8978265489008005.,5503948253274504.,-.490667823494606041800,-43,1073,
 -8978265488988249.,5503948261843087.,-.499749658968435295126,-43,1073,
 -8978265488986399.,5503948262645470.,-.499815804570816768269,-43,1073,
 -8978265488984642.,5503948263407516.,.489959405982984026495,-43,1073,
 -8978265488984635.,5503948263410553.,-.466256418020247464542,-43,1073,
 -8978265488984617.,5503948263418360.,-.496525672052810567593,-43,1073,
 -8978265488984549.,5503948263447853.,-.499764976239586580115,-43,1073,
 -8978265488979296.,5503948265726187.,-.499523567497142480725,-43,1073,
 -8977997097604419.,5621594827356193.,.499024322765455004029,-43,1073,
 -8977997097604304.,5621594827407137.,.497504827994062075149,-43,1073,
 -8977997097604303.,5621594827407580.,.488795964846828278682,-43,1073,
 -8977997097603845.,5621594827610471.,-.499859687321880072964,-43,1073,
 -8977997097601204.,5621594828780411.,-.499803247332236162564,-43,1073,
 -8977997097591329.,5621594833154950.,-.497056302316688033740,-43,1073,
 -8977997097544595.,5621594853857705.,-.437778647053901554503,-43,1073,
 -8976930418185147.,6114552367698786.,.499959005521648955935,-43,1073,
 -8976930418185104.,6114552367719505.,.499076524284384896880,-43,1073,
 -8976930418184932.,6114552367802381.,.495547301393138650036,-43,1073,
 -8976930418184901.,6114552367817318.,.448399712087558391964,-43,1073,
 -8976930418184889.,6114552367823100.,.494665171184779586859,-43,1073,
 -8976930418164743.,6114552377530193.,-.492296796599885326793,-43,1073,
 -8976930418154541.,6114552382445896.,-.482496838703195565032,-43,1073,
 -8974759521484945.,7255370393439719.,-.499406088117639858669,-43,1073,
 -8974759521481212.,7255370395574008.,-.499868748172038012218,-43,1073,
 -8974759521480066.,7255370396229216.,.499311531115235955275,-43,1073,
 -8974759521479858.,7255370396348138.,-.495595302527205974378,-43,1073,
 -8974759521479839.,7255370396359000.,.480831574250392222858,-43,1073,
 -8974759521479824.,7255370396367577.,-.485147195752272990610,-43,1073,
 -8974759521479684.,7255370396447619.,.499051439722636958040,-43,1073,
 -8974759521473364.,7255370400060989.,-.499061878308459821850,-43,1073,
 -8968146807763509.,6108540743684044.,-.498777239600158890158,-43,1072,
 -8968146807755654.,6108540747465154.,-.499510541476030013447,-43,1072,
 -8968146807755599.,6108540747491628.,.490944516664924668745,-43,1072,
 -8968146807755434.,6108540747571053.,.462310379558389378799,-43,1072,
 -8968146807755423.,6108540747576348.,.460401473803052395077,-43,1072,
 -8968146807754603.,6108540747971066.,.499932332307042512924,-43,1072,
 -8968146807753032.,6108540748727289.,-.499870842157659791559,-43,1072,
 -8968146807703789.,6108540772431070.,-.449426334037213538606,-43,1072,
 -8967157225741524.,6603954725247649.,-.498256753782224736106,-43,1072,
 -8967157225733885.,6603954729223007.,-.499990624499175388204,-43,1072,
 -8967157225732453.,6603954729968223.,.499034339764812835035,-43,1072,
 -8967157225732386.,6603954730003090.,.495499159274760528488,-43,1072,
 -8967157225732329.,6603954730032753.,.462641016319702826493,-43,1072,
 -8967157225732319.,6603954730037957.,.491964162872499884255,-43,1072,
 -8967157225731907.,6603954730252364.,-.499918634189039005443,-43,1072,
 -8967157225699373.,6603954747183153.,-.477734261224996617317,-43,1072,
 -8965181920559350.,7716231510506501.,-.488970022208407832755,-43,1072,
 -8965181920542526.,7716231520736372.,-.499545655166909272557,-43,1072,
 -8965181920537894.,7716231523552870.,-.492943656595374215627,-43,1072,
 -8965181920537875.,7716231523564422.,.499745299470173429902,-43,1072,
 -8965181920536918.,7716231524146328.,.499942990208944112676,-43,1072,
 -8965165582422571.,7726172349174687.,-.497564052659583007636,-43,1072,
 -8965165582419852.,7726172350830111.,-.498662528488139321580,-43,1072,
 -8965165582412577.,7726172355259389.,.499774716411709654246,-43,1072,
 -8965165582412504.,7726172355303834.,.498672246404754022225,-43,1072,
 -8965165582412492.,7726172355311141.,-.474111696799205813089,-43,1072,
 -8965165582411695.,7726172355796383.,-.499829790699195956611,-43,1072,
 -8964955899162533.,7854895526357707.,.499944218966081691550,-43,1072,
 -8964955899162389.,7854895526446841.,-.494180101709591994296,-43,1072,
 -8964955899162387.,7854895526448078.,.464234845402410262819,-43,1072,
 -8964955899135985.,7854895542790368.,-.483046788978838812345,-43,1072,
 -8964955899069615.,7854895583872018.,-.290122387335894958199,-43,1072,
 -8963452997644447.,8842487093398705.,-.485723184131789952927,-43,1072,
 -8963452997632501.,8842487101722715.,-.496874800905984538959,-43,1072,
 -8963452997622546.,8842487108659389.,.499817967775707915263,-43,1072,
 -8963452997621647.,8842487109285815.,.499284938913075841702,-43,1072,
 -8963452997621642.,8842487109289300.,-.485145042825452986858,-43,1072,
 -8963452997621454.,8842487109420299.,-.499711360030022045820,-43,1072,
 -8963452997589598.,8842487131617659.,-.471816694337822352051,-43,1072,
 -8961486688192218.,5162234617648831.,.497997621264105668592,-43,1071,
 -8961486688192160.,5162234617672425.,.487394050857734416815,-43,1071,
 -8961486688192049.,5162234617717580.,-.498415929768170104150,-43,1071,
 -8961486688191851.,5162234617798124.,.499869950280320674644,-43,1071,
 -8961486688191286.,5162234618027963.,-.499963936965048748132,-43,1071,
 -8961486688178460.,5162234623245489.,-.496979998774885031230,-43,1071,
 -8961486688165634.,5162234628463015.,-.488722650984788618578,-43,1071,
 -8958235190127275.,6669821928022105.,-.499758077324172558261,-43,1071,
 -8958235190126852.,6669821928244431.,-.499922583306765681743,-43,1071,
 -8958235190124314.,6669821929578386.,.499246008019139550512,-43,1071,
 -8958235190123923.,6669821929783894.,-.489038029871434233811,-43,1071,
 -8958235190123918.,6669821929786521.,.477863749777947459895,-43,1071,
 -8958235190123891.,6669821929800712.,.499133377777036723653,-43,1071,
 -8958235190072408.,6669821956859837.,-.445050645203228607452,-43,1071,
 -8949718684248528.,6524479740906490.,.498711854741917532895,-43,1070,
 -8949718684248478.,6524479740932198.,-.492928748075165802411,-43,1070,
 -8949718684248157.,6524479741097237.,-.499259005667471925574,-43,1070,
 -8949718684245289.,6524479742571791.,-.499557151922209091181,-43,1070,
 -8949718684243855.,6524479743309068.,-.499581254769327261112,-43,1070,
 -8949718684232012.,6524479749398030.,-.494502973935788658747,-43,1070,
 -8947891199738794.,7535085078250550.,-.475490545703853216707,-43,1070,
 -8947891199738785.,7535085078255894.,-.477118000608834467757,-43,1070,
 -8947891199738686.,7535085078314678.,-.495019754420596211600,-43,1070,
 -8947891199738659.,7535085078330710.,-.499901971323748317643,-43,1070,
 -8947891199734972.,7535085080519968.,-.499608781627636697969,-43,1070,
 -8947891199731285.,7535085082709226.,-.498679520733652217200,-43,1070,
 -8946116222148642.,8666295263641493.,-.465084729903933050730,-43,1070,
 -8946116222126411.,8666295278823463.,-.494894250181113909947,-43,1070,
 -8946116222112811.,8666295288111159.,.499666762146384562981,-43,1070,
 -8946116222112774.,8666295288136427.,.498856718106263101072,-43,1070,
 -8946116222112626.,8666295288237499.,.495617278675558364591,-43,1070,
 -8946116222112614.,8666295288245695.,-.477618299885982350320,-43,1070,
 -8946116222111578.,8666295288953198.,.499739298623567077835,-43,1070,
 -8946116222104180.,8666295294005433.,-.498107375440140847894,-43,1070,
 -8945448348632486.,4567307165303174.,.499994436680491437937,-43,1069,
 -8945448348631875.,4567307165523080.,.499478499139882751069,-43,1069,
 -8945448348631660.,4567307165600461.,.497662807085175396413,-43,1069,
 -8945448348631626.,4567307165612698.,.492724631652324755785,-43,1069,
 -8945448348631615.,4567307165616658.,-.479461241615265250791,-43,1069,
 -8945448348631479.,4567307165665606.,-.499213573056946679997,-43,1069,
 -8945448348608793.,4567307173830561.,-.492617116568191930953,-43,1069,
 -8943444842034329.,5348432554474611.,-.499977687708116060071,-43,1069,
 -8943444842033034.,5348432555020408.,.499498894306934712598,-43,1069,
 -8943444842032976.,5348432555044854.,-.493573438254430010272,-43,1069,
 -8943444842032452.,5348432555265702.,-.499945999132866134583,-43,1069,
 -8942866848298541.,5597669961514147.,-.499855385971036355243,-43,1069,
 -8942866848297522.,5597669961963633.,.484375477134837638596,-43,1069,
 -8942866848297503.,5597669961972014.,.497820752580390453888,-43,1069,
 -8942866848297352.,5597669962038621.,.499412598317378247094,-43,1069,
 -8942866848294153.,5597669963449720.,-.499789792425086706348,-43,1069,
 -8942866848275931.,5597669971487553.,-.491901083899341353089,-43,1069,
 -8942525049648792.,5750488175455277.,-.424539776123799537670,-43,1069,
 -8942525049594271.,5750488200161376.,-.498048446427998859590,-43,1069,
 -8942525049585337.,5750488204209803.,-.499990372035499835888,-43,1069,
 -8942525049584420.,5750488204625340.,-.499916476801236896706,-43,1069,
 -8942525049583793.,5750488204909463.,.490336720958349370123,-43,1069,
 -8942525049583786.,5750488204912636.,-.471494503815938907344,-43,1069,
 -8942525049583739.,5750488204933933.,.499067318014100175719,-43,1069,
 -8942525049583503.,5750488205040877.,-.499812554377577411353,-43,1069,
 -8941143777139872.,6411744510254083.,-.499831718295150788418,-43,1069,
 -8941143777139018.,6411744510685571.,.498335370322820891733,-43,1069,
 -8941143777139014.,6411744510687593.,-.475912022297757187845,-43,1069,
 -8941143777138979.,6411744510705276.,.499423319445971144669,-43,1069,
 -8941143777138940.,6411744510724982.,-.499488670872154338044,-43,1069,
 -8941143777131601.,6411744514433059.,-.498797835844431803744,-43,1069,
 -8941143777112302.,6411744524184003.,-.485793172531141698334,-43,1069,
 -8937480868180381.,8557215813025705.,-.485561789464899332505,-43,1069,
 -8937480868158565.,8557215827736740.,.499985793781749176511,-43,1069,
 -8937480868157309.,8557215828583691.,-.499342934772660232533,-43,1069,
 -8937480868157077.,8557215828740133.,.494420803304375013178,-43,1069,
 -8937480868157071.,8557215828744179.,.433914731022637001036,-43,1069,
 -8937480868156780.,8557215828940407.,.499372521629779067258,-43,1069,
 -8937480868122800.,8557215851853912.,-.468808440437864191542,-43,1069,
 -8932498220540170.,6336134363987827.,-.491027529105314344089,-43,1068,
 -8932498220518814.,6336134374650840.,-.498822453898262945659,-43,1068,
 -8932498220518757.,6336134374679300.,-.499708927141562745962,-43,1068,
 -8932498220517627.,6336134375243507.,-.499712623443719104586,-43,1068,
 -8932498220509717.,6336134379192956.,-.498331768066954672923,-43,1068,
 -8932498220508587.,6336134379757163.,-.497933541657097649449,-43,1068,
 -8928162550622381.,8916710216211244.,.499978105923508028654,-43,1068,
 -8928162550622335.,8916710216243566.,.492982227771090423091,-43,1068,
 -8928162550622243.,8916710216308210.,.478990822956167890882,-43,1068,
 -8928162550603512.,8916710229469586.,-.490302531382178271026,-43,1068,
 -8928162550584643.,8916710242727927.,-.460869215663977068186,-43,1068,
 -8925223742344723.,5620176161303510.,.492523331197610507256,-43,1067,
 -8925223742344715.,5620176161307054.,-.471494103811558482696,-43,1067,
 -8925223742344665.,5620176161329198.,-.496603022014354465428,-43,1067,
 -8925223742344499.,5620176161402716.,-.499964004766493023929,-43,1067,
 -8925223742334383.,5620176165882885.,-.498147202440345952099,-43,1067,
 -8925223742315346.,5620176174313982.,-.484944956731696570856,-43,1067,
 -8924736878827604.,5839987678726389.,-.499833209895087804952,-43,1067,
 -8924736878827211.,5839987678907248.,-.498381585275549308164,-43,1067,
 -8924736878827181.,5839987678921054.,-.467736192991787597309,-43,1067,
 -8924736878827151.,5839987678934860.,-.437090768069860763274,-43,1067,
 -8924736878827017.,5839987678996526.,.499792528390477290224,-43,1067,
 -8924736878819381.,5839987682510622.,-.498826786270887261872,-43,1067,
 -8924736878811158.,5839987686294855.,-.495368230862561251900,-43,1067,
 -8924689182264072.,5861978988043487.,-.213180400561091527668,-43,1067,
 -8924689182253848.,5861978992766300.,-.258031266656107822919,-43,1067,
 -8924689182150472.,5861979040519187.,-.497784435897343085439,-43,1067,
 -8924689182139112.,5861979045766756.,.499591733548276498524,-43,1067,
 -8924689182138536.,5861979046032830.,.471414811726767240659,-43,1067,
 -8924689182138521.,5861979046039759.,.481097865735930887763,-43,1067,
 -8924689182138491.,5861979046053618.,-.499536001674939972345,-43,1067,
 -8924652163763887.,5879104056762749.,-.499939556608492019704,-43,1067,
 -8924652163763760.,5879104056821585.,.499355894152055307787,-43,1067,
 -8924652163763693.,5879104056852625.,.491110424335406665765,-43,1067,
 -8924652163763672.,5879104056862354.,.443749937678070848288,-43,1067,
 -8924652163763633.,5879104056880422.,.498651933742542141240,-43,1067,
 -8924652163758186.,5879104059403928.,-.499490485840733468985,-43,1067,
 -8924652163599066.,5879104133121592.,-.005420965280295248337,-43,1067,
 -8920967501964396.,7859806858126174.,-.498569013619348614091,-43,1067,
 -8920967501964265.,7859806858207310.,.477405946391634573819,-43,1067,
 -8920967501964254.,7859806858214124.,-.494077034115037755621,-43,1067,
 -8920967501964011.,7859806858364629.,.499527720928596611027,-43,1067,
 -8920967501963555.,7859806858647060.,.499880224930680855861,-43,1067,
 -8920967501960434.,7859806860580103.,-.499627678132284730273,-43,1067,
 -8920967501898997.,7859806898632106.,-.396033809451118540236,-43,1067,
 -8919575179764656.,8771250679305382.,-.499956404817024586862,-43,1067,
 -8919575179764292.,8771250679556975.,-.499591134371777116172,-43,1067,
 -8919575179764176.,8771250679637152.,.489537775865433994692,-43,1067,
 -8919575179764139.,8771250679662727.,-.496688193424769280597,-43,1067,
 -8919575179751225.,8771250688588749.,-.495435240627552755645,-43,1067,
 -8916171883705449.,5734598716069026.,-.474252311529484469328,-43,1066,
 -8916171883668130.,5734598732933339.,.499370268719994019654,-43,1066,
 -8916171883667552.,5734598733194535.,.498494271957738870474,-43,1066,
 -8916171883667446.,5734598733242436.,.494874705360746682949,-43,1066,
 -8916171883667427.,5734598733251023.,-.477472155798779614276,-43,1066,
 -8916171883667417.,5734598733255541.,.484450554017579290189,-43,1066,
 -8916171883666213.,5734598733799624.,.499970840833439303814,-43,1066,
 -8916171883645492.,5734598743163366.,-.491445259763374452908,-43,1066,
 -8912951695636517.,7391081766857324.,.499884483054192599152,-43,1066,
 -8912951695636510.,7391081766861402.,-.490888197056794183922,-43,1066,
 -8912951695636489.,7391081766873633.,-.463206223896191806622,-43,1066,
 -8912951695635975.,7391081767173002.,-.499936379810811477795,-43,1066,
 -8912951695618852.,7391081777145949.,-.492870758036638252194,-43,1066,
 -8912951695607256.,7391081783899806.,-.480385044077839907394,-43,1066,
 -8911079808990999.,8565838087909053.,-.499152018281912475606,-43,1066,
 -8911079808986922.,8565838090661039.,-.499929058827113841722,-43,1066,
 -8911079808985439.,8565838091662068.,-.498766019524237768480,-43,1066,
 -8911079808985428.,8565838091669493.,-.469087367054727639838,-43,1066,
 -8911079808985350.,8565838091722143.,-.258638555825509928864,-43,1066,
 -8911079808985069.,8565838091911818.,.499519459882143044165,-43,1066,
 -8908737612404941.,5151067090740494.,-.495890131854248834667,-43,1065,
 -8908737612404918.,5151067090749830.,-.499180951523386791061,-43,1065,
 -8908737612404608.,5151067090875662.,.499944434360804066067,-43,1065,
 -8908737612390934.,5151067096426116.,-.496866637461083298465,-43,1065,
 -5629499534408815.,9007199252570665.,.000266619289039501697,-49,63,
 -5629499534257246.,9007199254251619.,.000183083792268700606,-49,63,
 -5629499534215909.,9007199254710061.,.000214746109515744973,-49,63,
 -5629499534214924.,9007199254720985.,-.000219660041404196147,-49,63,
 -5629499534213286.,9007199254739151.,.001088432973400855521,-49,63,
 -5629499534213264.,9007199254739395.,-.011104009972414788825,-49,63,
 -5629499534213132.,9007199254740859.,-.084258667508516226800,-49,63,
 -5629499534213121.,9007199254740981.,-.090354888959118123028,-49,63,
 -5629499534213119.,4503599627370502.,-.454822555520434110838,-49,62,
 -5611213340421876.,4606149963635716.,-.499991772326404210871,-49,62,
 -5611213340408204.,4606149963713255.,.499982027090009309064,-49,62,
 -5611213340370606.,4606149963926490.,.499916705987580539779,-49,62,
 -5611213340369909.,4606149963930443.,.497282469463048443860,-49,62,
 -5611213340369903.,4606149963930478.,-.474045802285706501225,-49,62,
 -5611213340369769.,4606149963931237.,.499622795390934711355,-49,62,
 -5589917886980197.,4728523302577820.,-.499982670355103249907,-49,62,
 -5589917886911881.,4728523302975564.,-.499977812267795725780,-49,62,
 -5589917886911004.,4728523302980669.,.499905364727248172878,-49,62,
 -5589917886910959.,4728523302980931.,.495338367116300273659,-49,62,
 -5589917886910914.,4728523302981193.,.490771369519868874099,-49,62,
 -5584028471488697.,4762936814610892.,-.499912333745481317281,-49,62,
 -5584028471357626.,4762936815379557.,-.499886168986474610260,-49,62,
 -5584028471357043.,4762936815382975.,.499702234059890896990,-49,62,
 -5584028471356615.,4762936815385486.,-.497169399877266277054,-49,62,
 -5584028471356593.,4762936815385615.,-.478317007193433195207,-49,62,
 -5584028471356578.,4762936815385702.,.489082351456638591070,-49,62,
 -5584028471356460.,4762936815386394.,.499290639560531705091,-49,62,
 -5584028471355080.,4762936815394488.,-.499968356506631920397,-49,62,
 -5555479367779159.,4933340294014915.,.499974687637111990965,-49,62,
 -5555479367778365.,4933340294019738.,.499835400783778627216,-49,62,
 -5555479367778325.,4933340294019981.,.472120575374357934645,-49,62,
 -5555479367778311.,4933340294020067.,-.487579613516112187902,-49,62,
 -5555479367765015.,4933340294100831.,-.499986915130634239559,-49,62,
 -5555479367743402.,4933340294232115.,-.499996052884626922987,-49,62,
 -5545533983873938.,4994123008801254.,.499993380696976826860,-49,62,
 -5545533983829130.,4994123009076785.,.499924523658797617718,-49,62,
 -5545533983828426.,4994123009081114.,.499745023560261028819,-49,62,
 -5545533983828359.,4994123009081526.,.492625667922574999944,-49,62,
 -5545533983828346.,4994123009081606.,.431542807877408817765,-49,62,
 -5545533983828312.,4994123009081816.,-.497443133773130188226,-49,62,
 -5545533983823793.,4994123009109603.,.499984287681792389831,-49,62,
 -5544198963911455.,5002338994210823.,.499997527432371705215,-49,62,
 -5544198963890270.,5002338994341307.,.499866215206740299888,-49,62,
 -5544198963889347.,5002338994346993.,-.499809006033577888000,-49,62,
 -5544198963889077.,5002338994348656.,-.498630575489191897285,-49,62,
 -5544198963889008.,5002338994349080.,.490559467960847030968,-49,62,
 -5544198963888995.,5002338994349161.,-.439013422399596245331,-49,62,
 -5544198963888964.,5002338994349351.,.498158915976826526455,-49,62,
 -5544198963886848.,5002338994362384.,.499986933349032755637,-49,62,
 -5539725571706545.,5029967815792997.,-.499808899525845744498,-49,62,
 -5539725571705950.,5029967815796682.,-.496811317586051844905,-49,62,
 -5539725571705800.,5029967815797610.,.495541014421491686747,-49,62,
 -5539725571705769.,5029967815797802.,.487293829724444428846,-49,62,
 -5539725571701573.,5029967815823790.,-.499970199062699808143,-49,62,
 -5539725571688235.,5029967815906396.,-.499999721082238318540,-49,62,
 -5537279579435519.,5045139371119434.,-.499960168735062967241,-49,62,
 -5537279579434599.,5045139371125149.,-.494246743336202906405,-49,62,
 -5537279579434566.,5045139371125354.,-.499476587739668326412,-49,62,
 -5537279579429400.,5045139371157444.,.499996963813440388342,-49,62,
 -5537279579406646.,5045139371298792.,-.499996504411863300367,-49,62,
 -5522619698209655.,5137032867772541.,-.499992574287038177310,-49,62,
 -5522619698197739.,5137032867847910.,.499525209616703695107,-49,62,
 -5522619698197699.,5137032867848164.,-.496112526742242010919,-49,62,
 -5522619698197690.,5137032867848220.,.429868982578712450324,-49,62,
 -5522619698195672.,5137032867860984.,.499945199583216004846,-49,62,
 -5522619698159681.,5137032868088632.,-.499993414945458448444,-49,62,
 -5522215089901295.,5139592697029149.,-.499995272470046865640,-49,62,
 -5522215089853586.,5139592697331063.,.499993353568232820353,-49,62,
 -5522215089853199.,5139592697333513.,-.463032510358659468737,-49,62,
 -5522215089853193.,5139592697333551.,-.493467019867719280941,-49,62,
 -5522215089853126.,5139592697333975.,-.499985709366498904759,-49,62,
 -5512667243258521.,5200370515052777.,.469764377272265010211,-49,62,
 -5512667243258511.,5200370515052842.,-.499283342352916907296,-49,62,
 -5512667243258382.,5200370515053668.,-.499998925447079800854,-49,62,
 -5486380295690163.,5371441901051536.,-.497877443403507247659,-49,62,
 -5486380295689464.,5371441901056159.,-.499596949831703468419,-49,62,
 -5486380295689231.,5371441901057699.,.499829882243084673449,-49,62,
 -5486380295687556.,5371441901068778.,-.499998672446978576725,-49,62,
 -5482520377150936.,5397031125536727.,-.499990224253695854930,-49,62,
 -5482520377149256.,5397031125547891.,-.498701385249506394127,-49,62,
 -5482520377149163.,5397031125548509.,-.491487180987203024899,-49,62,
 -5482520377149070.,5397031125549127.,-.484272976654132430519,-49,62,
 -5482520377148447.,5397031125553266.,.499538307961114934735,-49,62,
 -5482520377148027.,5397031125556057.,.499860524100604206906,-49,62,
 -5482520377110599.,5397031125804776.,-.499991048055859959852,-49,62,
 -5468820810006754.,5488840160161980.,-.499990961034309801743,-49,62,
 -5468820810001169.,5488840160199725.,-.499540297723746847306,-49,62,
 -5468820809999237.,5488840160212781.,.499720403974957084447,-49,62,
 -5468820809995886.,5488840160235428.,.499990980423531966165,-49,62,
 -5468088758172730.,5493789802668338.,.499999731438511635614,-49,62,
 -5468088758158661.,5493789802763506.,.499901203004023745409,-49,62,
 -5468088758157235.,5493789802773152.,.499464838872169360258,-49,62,
 -5468088758157112.,5493789802773985.,-.482339979961479669941,-49,62,
 -5468088758157095.,5493789802774100.,-.487955280115568648671,-49,62,
 -5468088758157061.,5493789802774330.,-.499185880416525520694,-49,62,
 -5468088758154209.,5493789802793621.,.499941446262281273845,-49,62,
 -5465050034960486.,5514383369215978.,-.499997109816913112905,-49,62,
 -5465050034927880.,5514383369437363.,.499963416689054273034,-49,62,
 -5465050034922991.,5514383369470558.,.499467556985473864757,-49,62,
 -5465050034922972.,5514383369470688.,-.495625390330676555287,-49,62,
 -5465050034922582.,5514383369473335.,.499835165425622363704,-49,62,
 -5465050034914226.,5514383369530071.,-.499989134477519804487,-49,62,
 -5418613610006378.,5838862067506944.,-.499996007758853011882,-49,62,
 -5418613610005559.,5838862067512831.,.499867016145151686993,-49,62,
 -5418613610005205.,5838862067515376.,.496144808534919101722,-49,62,
 -5418613610005189.,5838862067515492.,-.475774839240471522659,-49,62,
 -5418613610005168.,5838862067515642.,.498580623057767270253,-49,62,
 -5418613610005131.,5838862067515909.,-.498983562407266224622,-49,62,
 -5418613609969840.,5838862067769625.,-.499996132012095302030,-49,62,
 -5413189176026263.,5877990229377965.,-.499944178164345138276,-49,62,
 -5413189175930539.,5877990230070760.,.499964141511256555710,-49,62,
 -5413189175914585.,5877990230186226.,.499956800121293235067,-49,62,
 -5413189175912736.,5877990230199609.,-.487131781692805435708,-49,62,
 -5413189175912715.,5877990230199760.,.498953204843392000943,-49,62,
 -5413189175912357.,5877990230202351.,.499830594969784325765,-49,62,
 -5398648100196943.,5984178047331884.,.469080090281899765329,-49,62,
 -5398648100196932.,5984178047331966.,-.480948630836148037806,-49,62,
 -5398648100196875.,5984178047332386.,-.494733822066631872098,-49,62,
 -5398648100196856.,5984178047332526.,-.499328885803576306295,-49,62,
 -5398648100196636.,5984178047334147.,-.499903307782317733470,-49,62,
 -5398648100179226.,5984178047462427.,-.499905036604970668123,-49,62,
 -5398648099787501.,5984178050348727.,-.499216936169586998841,-49,62,
 -5358514779804355.,6287315668269162.,-.499975112074386671678,-49,62,
 -5358514779770767.,6287315668529180.,.499969579091866066390,-49,62,
 -5358514779729715.,6287315668846981.,.499916582758657268263,-49,62,
 -5358514779729599.,6287315668847880.,-.494724487426670872734,-49,62,
 -5357868470838364.,6292321012309275.,-.499995792637746937418,-49,62,
 -5357868470804257.,6292321012573521.,.499989142978805698687,-49,62,
 -5357868470803635.,6292321012578341.,-.499981709219036075238,-49,62,
 -5357868470794927.,6292321012645807.,-.499573252470458507368,-49,62,
 -5357868470793061.,6292321012660264.,-.499485631912732444563,-49,62,
 -5357868470792958.,6292321012661062.,-.497873077399074530362,-49,62,
 -5357868470792954.,6292321012661092.,.492480808215147796553,-49,62,
 -5357868470792942.,6292321012661185.,.463542465058730562141,-49,62,
 -5340868642028359.,6425416777215903.,-.499998993486152830896,-49,62,
 -5340868642025332.,6425416777239851.,-.491842383509212095642,-49,62,
 -5340868642025321.,6425416777239938.,-.465714295236189839261,-49,62,
 -5340868642025298.,6425416777240119.,.498008071156665507673,-49,62,
 -5340868642025106.,6425416777241638.,.499516521245907729282,-49,62,
 -5340868642023728.,6425416777252540.,.499926137111259473168,-49,62,
 -5334469363672613.,6476244431329665.,-.499995935321730859346,-49,62,
 -5334469363655234.,6476244431468245.,.499276443211663847006,-49,62,
 -5334469363655195.,6476244431468556.,.487191264589072356256,-49,62,
 -5334469363655157.,6476244431468860.,-.498943012003191134071,-49,62,
 -5334469363654656.,6476244431472854.,.499655079513939032023,-49,62,
 -5334469363654078.,6476244431477464.,-.499966280903661829168,-49,62,
 -5334469363646217.,6476244431540147.,.499993362682147579964,-49,62,
 -5325827369889416.,6545524051723201.,-.499990280793474807589,-49,62,
 -5325827369852871.,6545524052017729.,.499948195996102648987,-49,62,
 -5325827369851085.,6545524052032124.,-.498303205487227852434,-49,62,
 -5325827369851068.,6545524052032261.,-.489327994710969616190,-49,62,
 -5325827369850866.,6545524052033888.,.499671568849945074475,-49,62,
 -5325827369849417.,6545524052045566.,.499970430223474857394,-49,62,
 -5325827369845963.,6545524052073403.,.499992782836871481829,-49,62,
 -5317788020390738.,6610637732577304.,.499765424369390740140,-49,62,
 -5317788020390265.,6610637732581154.,.494826948247288445221,-49,62,
 -5317788020389749.,6610637732585354.,.489439522307684948525,-49,62,
 -5317788020389720.,6610637732585591.,-.464351631396543468830,-49,62,
 -5317788020389713.,6610637732585648.,-.487680530565266865644,-49,62,
 -5317788020388552.,6610637732595098.,-.499802228754086066151,-49,62,
 -5317788020379636.,6610637732667670.,-.499868153254167390013,-49,62,
 -5317788020361804.,6610637732812814.,-.499997612154287881949,-49,62,
 -5307605800716371.,6694037865264005.,-.499993368592104512614,-49,62,
 -5307605800692549.,6694037865460351.,-.499855076320245027263,-49,62,
 -5307605800692260.,6694037865462732.,.499726856714551943556,-49,62,
 -5307605800692194.,6694037865463276.,.485790550882910183685,-49,62,
 -5307605800692186.,6694037865463342.,.423495241088139364697,-49,62,
 -5307605800692132.,6694037865463788.,-.496998100009575166179,-49,62,
 -5307605800687669.,6694037865500573.,-.499993948070141864362,-49,62,
 -5299460840249897.,6761508119000738.,.499986730586718923312,-49,62,
 -5299460840243558.,6761508119053512.,.498335337170221762052,-49,62,
 -5299460840243309.,6761508119055585.,.494957652414863344231,-49,62,
 -5299460840242771.,6761508119060064.,.499707877884641623040,-49,62,
 -5299460840241901.,6761508119067307.,.499954531298153873329,-49,62,
 -5299460840221476.,6761508119237352.,-.499999680834426579416,-49,62,
 -5266341419814166.,7042936020215739.,.499991093211369154262,-49,62,
 -5266341419812219.,7042936020232624.,-.499047898548833286046,-49,62,
 -5266341419812088.,7042936020233760.,-.492819909381413245873,-49,62,
 -5266341419812076.,7042936020233864.,-.431180704257679217478,-49,62,
 -5266341419812024.,7042936020234315.,-.497410815370397918118,-49,62,
 -5266341419811765.,7042936020236560.,.499635362402048927790,-49,62,
 -5266341419811116.,7042936020242188.,.499955710622685951672,-49,62,
 -5266341419757968.,7042936020703078.,-.499989167907690033667,-49,62,
 -5242088987167799.,7256419951881689.,.499455552637424890315,-49,62,
 -5242088987167661.,7256419951882922.,.482682578821542043903,-49,62,
 -5242088987167646.,7256419951883057.,-.497401440058865006523,-49,62,
 -5242088987167447.,7256419951884835.,-.499849423638020057652,-49,62,
 -5242088987158861.,7256419951961548.,-.499941405783048958923,-49,62,
 -5242088987153137.,7256419952012689.,.499997723336957658807,-49,62,
 -5208774931130610.,7560258704526730.,-.499999950326645250666,-49,62,
 -5208774931127828.,7560258704552626.,.499955902195756158228,-49,62,
 -5208774931125046.,7560258704578523.,.499911843426048781462,-49,62,
 -5208774931124761.,7560258704581176.,.499547881235715654745,-49,62,
 -5208774931124748.,7560258704581298.,-.486433632806905297965,-49,62,
 -5208774931124735.,7560258704581419.,-.472415146847589227982,-49,62,
 -5161411928745807.,8014259341233911.,-.499984901564640583957,-49,62,
 -5161411928695765.,8014259341727714.,-.499869289329642967539,-49,62,
 -5161411928695402.,8014259341731296.,-.498969094900795501915,-49,62,
 -5161411928695334.,8014259341731967.,-.490536000449577504776,-49,62,
 -5161411928689125.,8014259341793236.,-.499931595336773147514,-49,62,
 -5161411928682485.,8014259341858758.,-.499993365657161387133,-49,62,
 -5120907462136524.,8424082600055129.,.499969614622434485761,-49,62,
 -5120907462135952.,8424082600061062.,.499566891454412983280,-49,62,
 -5120907462135404.,8424082600066747.,-.437881867381718032087,-49,62,
 -5120907462135380.,8424082600066995.,.499164172464945501751,-49,62,
 -5120907462126612.,8424082600157940.,.499984555370016136562,-49,62,
 -5120907462116700.,8424082600260752.,-.499999249134291836442,-49,62,
 -5119822908942615.,8435339509051847.,-.499996707063361083854,-49,62,
 -5119822908933082.,8435339509150859.,-.499925169907471116410,-49,62,
 -5119822908932370.,8435339509158254.,-.498975691349634234282,-49,62,
 -5119822908932326.,8435339509158710.,.495465006976186060282,-49,62,
 -5119822908932313.,8435339509158846.,-.483450241240992593738,-49,62,
 -5119822908932181.,8435339509160216.,.499871853906962336668,-49,62,
 -5119822908927865.,8435339509205044.,-.499990427442313907372,-49,62,
 -5095830265894774.,8688250089639967.,-.499997087255609230089,-49,62,
 -5095830265877103.,8688250089829005.,-.499979217621152448760,-49,62,
 -5095830265873035.,8688250089872523.,-.499634982118530826457,-49,62,
 -5095830265869645.,8688250089908788.,-.499347952691434957045,-49,62,
 -5095830265869602.,8688250089909247.,.499180762813321813822,-49,62,
 -5095830265869473.,8688250089910627.,.494766909473719581938,-49,62,
 -5095830265869450.,8688250089910874.,-.459508428695588370327,-49,62,
 -5095830265869440.,8688250089910981.,-.483106401810505444698,-49,62,
 -5095830265860110.,8688250090010789.,.499985255879740230770,-49,62,
 -5066549580987503.,9007199252570665.,.000266619289039501697,-49,62,
 -5066549580835934.,9007199254251619.,.000183083792268700606,-49,62,
 -5066549580794597.,9007199254710061.,.000214746109515744973,-49,62,
 -5066549580793612.,9007199254720985.,-.000219660041404196147,-49,62,
 -5066549580791974.,9007199254739151.,.001088432973400855521,-49,62,
 -5066549580791952.,9007199254739395.,-.011104009972414788825,-49,62,
 -5066549580791820.,9007199254740859.,-.084258667508516226800,-49,62,
 -5066549580791809.,9007199254740981.,-.090354888959118123028,-49,62,
 -5066549580791807.,4503599627370502.,-.454822555520434110838,-49,61,
 -4503599627566191.,9007199252570665.,.000266619289039501697,-49,61,
 -4503599627414622.,9007199254251619.,.000183083792268700606,-49,61,
 -4503599627373285.,9007199254710061.,.000214746109515744973,-49,61,
 -4503599627372300.,9007199254720985.,-.000219660041404196147,-49,61,
 -4503599627370662.,9007199254739151.,.001088432973400855521,-49,61,
 -4503599627370640.,9007199254739395.,-.011104009972414788825,-49,61,
 -4503599627370508.,9007199254740859.,-.084258667508516226800,-49,61,
 -4503599627370497.,9007199254740981.,-.090354888959118123028,-49,61,
 -9007199254740990.,4503599627370502.,-.454822555520434110838,-50,60,
 -7881299347902961.,9007199254715523.,-.000002458622032915512,-50,60,
 -7881299347898369.,9007199254740986.,.454822555520439231574,-50,60,
 -7881299347898367.,4503599627370499.,-.227411277760217908875,-50,59,
 -7881299347898366.,4503599627370502.,-.454822555520434110838,-50,59,
 -7881299347898357.,4503599627370526.,.498475944637696882534,-50,59,
 -7881299347898036.,4503599627371416.,.499455783701442239929,-50,59,
 -7881299347895745.,4503599627377769.,-.499781559181926237259,-50,59,
 -7881299347893775.,4503599627383231.,-.499998734680567230945,-50,59,
 -6755399441060337.,9007199254715523.,-.000002458622032915512,-50,59,
 -6755399441058367.,9007199254726447.,-.000436858148598096929,-50,59,
 -6755399441055755.,9007199254740931.,.003048110725019307635,-50,59,
 -6755399441055746.,9007199254740981.,-.090354888959118123028,-50,59,
 -6755399441055745.,9007199254740986.,.454822555520439231574,-50,59,
 -6755399441055743.,4503599627370499.,-.227411277760217908875,-50,58,
 -6755399441055412.,4503599627371416.,.499455783701442239929,-50,58,
 -5629499534217713.,9007199254715523.,-.000002458622032915512,-50,58,
 -5629499534215743.,9007199254726447.,-.000436858148598096929,-50,58,
 -5629499534213452.,9007199254739151.,.001088432973400855521,-50,58,
 -5629499534213131.,9007199254740931.,.003048110725019307635,-50,58,
 -5629499534213122.,9007199254740981.,-.090354888959118123028,-50,58,
 -5629499534213121.,9007199254740986.,.454822555520439231574,-50,58,
 -5629499534213119.,4503599627370499.,-.227411277760217908875,-50,57,
 -5629499534213109.,4503599627370526.,.498475944637696882534,-50,57,
 -4503599627375089.,9007199254715523.,-.000002458622032915512,-50,57,
 -4503599627370497.,9007199254740986.,.454822555520439231574,-50,57,
 -9007199254740990.,4503599627370499.,-.227411277760217908875,-51,56,
 -9007199254740988.,4503599627370502.,-.454822555520434110838,-51,56,
 -9007199254740970.,4503599627370526.,.498475944637696882534,-51,56,
 -9007199254740328.,4503599627371416.,.499455783701442239929,-51,56,
 -9007199254735746.,4503599627377769.,-.499781559181926237259,-51,56,
 -9007199254731806.,4503599627383231.,-.499998734680567230945,-51,56,
 -6755399441055745.,9007199254740989.,.227411277760219189059,-51,56,
 -6755399441055743.,4503599627370497.,.386294361119890832198,-51,55,
 -6755399441055740.,4503599627370502.,-.454822555520434110838,-51,55,
 -6755399441055722.,4503599627370526.,.498475944637696882534,-51,55,
 -6755399441055080.,4503599627371416.,.499455783701442239929,-51,55,
 -6755399441054759.,4503599627371861.,.499945703299270638189,-51,55,
 -6755399441046558.,4503599627383231.,-.499998734680567230945,-51,55,
 -4503599627370497.,9007199254740989.,.227411277760219189059,-51,55,
 -9007199254740990.,4503599627370497.,.386294361119890832198,-52,54,
 -9007199254740984.,4503599627370502.,-.454822555520434110838,-52,54,
 -9007199254740948.,4503599627370526.,.498475944637696882534,-52,54,
 -9007199254739664.,4503599627371416.,.499455783701442239929,-52,54,
 -9007199254739022.,4503599627371861.,.499945703299270638189,-52,54,
 -9007199254722620.,4503599627383231.,-.499998734680567230945,-52,54,
 -4503599627388868.,9007199254715523.,-.000002458622032915512,-52,54,
 -4503599627372466.,9007199254738261.,.000108594229503068588,-52,54,
 -4503599627370817.,9007199254740547.,-.000489919473896025936,-52,54,
 -4503599627370540.,9007199254740931.,.003048110725019307635,-52,54,
 -4503599627370514.,9007199254740967.,.046701499842003425948,-52,54,
 -4503599627370497.,9007199254740991.,-.386294361119890512152,-52,54,
 -9007199254740990.,4503599627370497.,-.306852819440054637242,-53,53,
 -9007199254740982.,4503599627370499.,.465735902799727880611,-53,53,
 -9007199254740904.,4503599627370526.,.498475944637696882534,-53,53,
 -9007199254737052.,4503599627371861.,.499945703299270638189,-53,53,
 -4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,52,
 0.,4503599627370496.,0.000000000000000000000,0,52,
 4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,52,
 8703077354446111.,4527225890137045.,-.499940051979896991006,-60,52,
 8703077354446125.,4527225890137045.,-.461834704924138873146,-60,52,
 8703077354446223.,4527225890137045.,-.195097275533832039147,-60,52,
 8703077354447948.,4527225890137050.,-.499974156163632643264,-60,52,
 8703077354449785.,4527225890137054.,.499991739652637226548,-60,52,
 8703077354508202.,4527225890137213.,.499995950814492086307,-60,52,
 7188956797837108.,4662041946773222.,.499998807267276815650,-57,52,
 7188956797842192.,4662041946773336.,.498049936007053510250,-57,52,
 7188956797842237.,4662041946773338.,-.492919320327849474467,-57,52,
 7188956797842238.,4662041946773338.,-.470496414913069538313,-57,52,
 7188956797843084.,4662041946773356.,.499281565990795086997,-57,52,
 7188956797843530.,4662041946773366.,.499897380982698054076,-57,52,
 9006440473863973.,4702973853929170.,.499462962432673560262,-57,52,
 9006440473864194.,4702973853929175.,.498433143490128084608,-57,52,
 9006440473864238.,4702973853929176.,.493703224786635502003,-57,52,
 9006440473864241.,4702973853929177.,-.438437451488602620959,-57,52,
 9006440473864813.,4702973853929190.,-.499926394633986841280,-57,52,
 9006440473869676.,4702973853929300.,-.499962636793394325500,-57,52,
 9006440473874539.,4702973853929410.,-.499998878950228971255,-57,52,
 7591484324372716.,4844781445711790.,.499790933726418537698,-56,52,
 7591484324373124.,4844781445711810.,-.485921524495133466676,-56,52,
 7591484324373188.,4844781445711812.,.496711815391688676262,-56,52,
 7591484324373231.,4844781445711815.,-.499331409371851665146,-56,52,
 7591484324373982.,4844781445711850.,-.499993311637271411391,-56,52,
 8003388474978634.,4864015761325463.,-.499999234446632507624,-56,52,
 8003388475029672.,4864015761327851.,-.499985335143109562644,-56,52,
 8003388475031852.,4864015761327952.,.499309901774758955888,-56,52,
 8003388475031873.,4864015761327953.,.481871920112051577056,-56,52,
 8003388475032023.,4864015761327961.,-.499827948907281070942,-56,52,
 8715649185231383.,4897455917443630.,.499957912989740487089,-56,52,
 8715649185231850.,4897455917443653.,-.499513265636524911676,-56,52,
 8715649185231935.,4897455917443657.,-.495134358105963014539,-56,52,
 8715649185231956.,4897455917443657.,.494182783754529252662,-56,52,
 8715649185237093.,4897455917443899.,.499999818872379511501,-56,52,
 4823460372458353.,4941525535432862.,.499995829569183548194,-55,52,
 4823460372560290.,4941525535442553.,.499952715687048661279,-55,52,
 4823460372575174.,4941525535443968.,.499838512356244360833,-55,52,
 4823460372578824.,4941525535444315.,.499944878841286137509,-55,52,
 7429938090806177.,5195637528189570.,-.499995803056228552311,-55,52,
 7429938090843653.,5195637528193316.,-.499980085955423443372,-55,52,
 7429938090848335.,5195637528193784.,-.499871387199459300056,-55,52,
 7429938090848375.,5195637528193787.,.498420869945156008873,-55,52,
 7429938090848865.,5195637528193836.,.477501019966943251113,-55,52,
 7429938090848965.,5195637528193846.,.473231662828589214155,-55,52,
 8992428863865199.,5354191040255252.,-.499999987241966212069,-55,52,
 8992428863870286.,5354191040255776.,-.499984122439403833217,-55,52,
 8992428863890634.,5354191040257872.,-.499920662716329850845,-55,52,
 8992428863894391.,5354191040258258.,.499894474889603115822,-55,52,
 8992428863894857.,5354191040258307.,-.498531435642286502440,-55,52,
 8992428863894925.,5354191040258314.,-.494009894689822397712,-55,52,
 8992428863894944.,5354191040258315.,.463135829988073622394,-55,52,
 8992428863894954.,5354191040258316.,.493212527186966551907,-55,52,
 4684840655107187.,5393192297008990.,.447759095589102187187,-54,52,
 4684840655107192.,5393192297008991.,.485339127173763146298,-54,52,
 4684840655107221.,5393192297008998.,-.496696689635199354414,-54,52,
 4684840655107327.,5393192297009019.,.499999979959684497480,-54,52,
 5261029272893198.,5514095936971714.,.499994288752848279160,-54,52,
 5261029272899528.,5514095936973058.,-.476161937693097033615,-54,52,
 5261029272899542.,5514095936973060.,.494190955329343976846,-54,52,
 5261029272899674.,5514095936973089.,-.499624624744704973627,-54,52,
 5261029272900315.,5514095936973225.,-.499895737071965612724,-54,52,
 5261029272904194.,5514095936974048.,-.499976305982370377670,-54,52,
 5261029272930065.,5514095936979537.,-.499998060582698988656,-54,52,
 5357701474445815.,5534644885011323.,-.499998369106116903158,-54,52,
 5357701474447698.,5534644885011724.,-.498702550707324434277,-54,52,
 5357701474447712.,5534644885011726.,.482719723035526326591,-54,52,
 5357701474447806.,5534644885011747.,-.499159296119576971481,-54,52,
 5357701474448022.,5534644885011792.,.499927213056204681986,-54,52,
 6544763739207500.,5793302292861274.,.496516400693664187354,-54,52,
 6544763739207509.,5793302292861277.,-.497282818590200689143,-54,52,
 6544763739207666.,5793302292861311.,.499775245013601566086,-54,52,
 6544763739207989.,5793302292861384.,-.499907847061987500539,-54,52,
 6544763739211053.,5793302292862067.,-.499997612093658381443,-54,52,
 6750030179316033.,5839239651458275.,-.499997531419140782843,-54,52,
 6750030179323270.,5839239651459901.,-.499899083302559855435,-54,52,
 6750030179323813.,5839239651460023.,-.499338981401294685059,-54,52,
 6750030179323844.,5839239651460029.,.465702203053550591459,-54,52,
 6750030179323853.,5839239651460031.,.487810934024313679461,-54,52,
 6750030179328562.,5839239651461090.,-.499965272399276763376,-54,52,
 6750030179346383.,5839239651465094.,-.499999200303761050216,-54,52,
 7262316160940686.,5955481305381648.,-.499999961171879633317,-54,52,
 7262316160955340.,5955481305385005.,.484971200913631926255,-54,52,
 7262316160955349.,5955481305385008.,-.452665980711364995902,-54,52,
 7262316160955375.,5955481305385014.,-.494728949850240981439,-54,52,
 7262316160955615.,5955481305385069.,-.498387126516507096801,-54,52,
 7262316160955711.,5955481305385091.,-.499850397182871339942,-54,52,
 7262316160957090.,5955481305385406.,.499963662733217778096,-54,52,
 7667186625394737.,6048984370271638.,-.499990292200953479912,-54,52,
 7667186625699679.,6048984370342613.,-.499876979329302749143,-54,52,
 7667186625743503.,6048984370352813.,-.499860626404752319481,-54,52,
 7667186625744474.,6048984370353038.,.499592090992681814503,-54,52,
 7667186625744706.,6048984370353092.,.497401597107427654332,-54,52,
 7667186625744852.,6048984370353126.,.478781717335057932507,-54,52,
 7667186625744865.,6048984370353130.,-.495478956891239704937,-54,52,
 7667186625745329.,6048984370353238.,-.499859944659641242340,-54,52,
 7756304500063635.,6069762085709031.,-.499995130179589279925,-54,52,
 7756304500083451.,6069762085713659.,-.499920408128700752512,-54,52,
 7756304500086718.,6069762085714422.,-.496476518158237349240,-54,52,
 7756304500086731.,6069762085714425.,-.460344050888496931408,-54,52,
 7756304500086855.,6069762085714453.,.499688713838334153306,-54,52,
 7756304500087630.,6069762085714634.,.499893493384158938167,-54,52,
 4889567999025855.,6561063454364383.,-.499998785136737502100,-53,52,
 4889567999035845.,6561063454369427.,-.496059554984035707301,-53,52,
 4889567999035847.,6561063454369428.,-.486248956539172453923,-53,52,
 4889567999035881.,6561063454369445.,-.319468782976473367309,-53,52,
 4889567999035946.,6561063454369477.,.499375666481752843278,-53,52,
 4889567999036150.,6561063454369581.,-.499943292140594180103,-53,52,
 4889567999040533.,6561063454371793.,.499983200202211637651,-53,52,
 4930099044602323.,6581559742000859.,-.496149587143097688233,-53,52,
 4930099044602331.,6581559742000863.,-.444288892307457055497,-53,52,
 4930099044602554.,6581559742000976.,-.498672023762970525807,-53,52,
 4930099044602708.,6581559742001053.,.499646351824936367160,-53,52,
 4930099044603865.,6581559742001639.,.499999342472732045051,-53,52,
 5026050879177168.,6630337540270521.,.474354489574068028536,-53,52,
 5026050879177170.,6630337540270522.,.494827034306604964671,-53,52,
 5026050879177317.,6630337540270597.,.499559072148499782646,-53,52,
 5026050879179222.,6630337540271569.,.499657929972248927450,-53,52,
 5026050879185572.,6630337540274809.,.499987457080537029601,-53,52,
 5026050879246434.,6630337540305863.,.499996305715756458630,-53,52,
 5035712052426564.,6635268854219734.,.499996002303389742038,-53,52,
 5035712052438847.,6635268854226006.,.393383760946608721892,-53,52,
 5035712052438857.,6635268854226011.,.499541367200463514038,-53,52,
 5035712052440741.,6635268854226973.,.499634385496813257563,-53,52,
 5035712052447335.,6635268854230340.,.499959950632391182401,-53,52,
 5035712052448277.,6635268854230822.,-.499993539923052755637,-53,52,
 5388947655825165.,6818110368144556.,.499986645391770865986,-53,52,
 5388947655826360.,6818110368145184.,-.499894394583714840165,-53,52,
 5388947655827555.,6818110368145811.,-.499775434501541000203,-53,52,
 5388947655827879.,6818110368145980.,.498583178953268833760,-53,52,
 5388947655827999.,6818110368146043.,.460938220974644418915,-53,52,
 5388947655828001.,6818110368146045.,-.489689194991661061989,-53,52,
 5388947655828041.,6818110368146065.,.497762485682263236704,-53,52,
 5388947655833692.,6818110368149030.,.499998673540179519255,-53,52,
 5828367993123534.,7052610723955642.,-.499999735246719701334,-53,52,
 5828367993162872.,7052610723976992.,-.499966951604823835339,-53,52,
 5828367993164475.,7052610723977861.,.499780178551544381919,-53,52,
 5828367993164908.,7052610723978097.,-.497168974669155004100,-53,52,
 5828367993164943.,7052610723978115.,.498458691929975791420,-53,52,
 5828367993174994.,7052610723983570.,.499992322271644369360,-53,52,
 5842346135983921.,7060201194194451.,-.499856024382647990212,-53,52,
 5842346135984672.,7060201194194859.,-.469283083081269581420,-53,52,
 5842346135984683.,7060201194194865.,-.492803319626613443581,-53,52,
 5842346135984729.,7060201194194889.,.499748418456548855885,-53,52,
 5842346135989023.,7060201194197223.,-.499878465303882573066,-53,52,
 5842346136014533.,7060201194211083.,-.499990653584775943083,-53,52,
 5842346136017084.,7060201194212468.,.499998129083618678139,-53,52,
 6083309738847399.,7192342035029183.,.499997932274913878903,-53,52,
 6083309738851746.,7192342035031590.,-.499778666276599574701,-53,52,
 6083309738851961.,7192342035031708.,.499542251920369954081,-53,52,
 6083309738852017.,7192342035031739.,.494714212009206145901,-53,52,
 6083309738852055.,7192342035031761.,-.472847672216150366513,-53,52,
 6083309738852064.,7192342035031766.,-.491480750058988953067,-53,52,
 6466710109370302.,7407710009701898.,.499849810758719796603,-53,52,
 6466710109370823.,7407710009702196.,-.499509077910733002408,-53,52,
 6466710109371030.,7407710009702314.,-.497334970334638192156,-53,52,
 6466710109371037.,7407710009702317.,.493076714462653910336,-53,52,
 6466710109371044.,7407710009702321.,.483488399259948162397,-53,52,
 6466710109371137.,7407710009702374.,.498957925852775786657,-53,52,
 6466710109373535.,7407710009703741.,.499989375119289790322,-53,52,
 6466710109409412.,7407710009724193.,.499991617639209510776,-53,52,
 6683043781636026.,7532065180902585.,.499999665921501415798,-53,52,
 6683043781680608.,7532065180928426.,.499522581789826627117,-53,52,
 6683043781680765.,7532065180928518.,-.498796804851076115012,-53,52,
 6683043781680784.,7532065180928529.,-.485854565017734987994,-53,52,
 6683043781680796.,7532065180928535.,.469687902245436125637,-53,52,
 6683043781681845.,7532065180929144.,-.499974751140866478271,-53,52,
 6683043781693744.,7532065180936041.,-.499989917050420728493,-53,52,
 7533119765574791.,8041267246475283.,-.482528706935127870229,-53,52,
 7533119765574799.,8041267246475287.,.467983932908682407347,-53,52,
 7533119765574854.,8041267246475322.,-.497241668165039431440,-53,52,
 7533119765574875.,8041267246475334.,.497854011425032049623,-53,52,
 7533119765575683.,8041267246475834.,.499630635668493211526,-53,52,
 7533119765575885.,8041267246475960.,-.499925208265783709245,-53,52,
 7533119765578128.,8041267246477348.,-.499943811821259619901,-53,52,
 7533119765584857.,8041267246481512.,-.499999621050194561762,-53,52,
 7593583889890302.,8078770481630060.,.499999433455757599458,-53,52,
 7593583889909242.,8078770481641836.,-.499466602436435764654,-53,52,
 7593583889909279.,8078770481641859.,-.496561652225764568084,-53,52,
 7593583889909316.,8078770481641882.,-.493656702015027874711,-53,52,
 7593583889909332.,8078770481641891.,.453545438616662332098,-53,52,
 7593583889909583.,8078770481642048.,-.499720980222094407895,-53,52,
 7593583889909924.,8078770481642260.,-.499975358002189841704,-53,52,
 7593583889917841.,8078770481647181.,.499983855042650508670,-53,52,
 7618936725665402.,8094547728899355.,.499962454331181297495,-53,52,
 7618936725667200.,8094547728900475.,.499817455706088381872,-53,52,
 7618936725668998.,8094547728901595.,.499672457235963936040,-53,52,
 7618936725669059.,8094547728901633.,.497442843831186017485,-53,52,
 7618936725669067.,8094547728901638.,.480756992892867717585,-53,52,
 7618936725678407.,8094547728907457.,-.499973975501083170062,-53,52,
 7618936725720119.,8094547728933439.,.499999292492698262252,-53,52,
 8259236168414635.,8503389324638753.,-.499998623676889750241,-53,52,
 8259236168421741.,8503389324643403.,-.499948655290719713200,-53,52,
 8259236168422175.,8503389324643686.,.499491492030570482142,-53,52,
 8259236168422826.,8503389324644112.,.498651713030290378209,-53,52,
 8259236168422907.,8503389324644166.,-.496844480668712406942,-53,52,
 8259236168422933.,8503389324644183.,-.483053135436223500688,-53,52,
 8259236168422936.,8503389324644184.,.480076635167527409812,-53,52,
 8460168363171364.,8635896467805670.,-.499939841868421864547,-53,52,
 8460168363172956.,8635896467806728.,-.498688464442073657156,-53,52,
 8460168363172968.,8635896467806735.,.476195339910878445811,-53,52,
 8460168363173010.,8635896467806763.,.388288655146268801369,-53,52,
 8460168363173275.,8635896467806940.,-.499693998723592668867,-53,52,
 8460168363174390.,8635896467807680.,.499926155787845833054,-53,52,
 8460168363187290.,8635896467816254.,-.499984159591263182031,-53,52,
 8460168363195253.,8635896467821545.,.499993686411651414381,-53,52,
 8791115980768813.,8858660167162050.,-.499913991316333017964,-53,52,
 8791115980769080.,8858660167162232.,-.481639092850316880656,-53,52,
 8791115980769168.,8858660167162292.,-.490597178748338557726,-53,52,
 8791115980769256.,8858660167162352.,-.499555264645953974138,-53,52,
 8791115980771493.,8858660167163876.,.499998847388589608838,-53,52,
 8837821264155853.,8890557211901519.,.499999789028371787214,-53,52,
 8837821264157186.,8890557211902431.,.499964058742212310738,-53,52,
 8837821264166517.,8890557211908815.,.499713949358597725422,-53,52,
 8837821264166536.,8890557211908828.,.498963252537822804771,-53,52,
 8837821264166916.,8890557211909088.,.483949316126315806512,-53,52,
 8837821264166992.,8890557211909140.,.480946528844926730235,-53,52,
 9007199254704248.,9007199254715523.,-.000002458622032915512,-53,52,
 9007199254737052.,9007199254738261.,.000108594229503068588,-53,52,
 9007199254740350.,9007199254740547.,-.000489919473896025936,-53,52,
 9007199254740904.,9007199254740931.,.003048110725019307635,-53,52,
 9007199254740956.,9007199254740967.,.046701499842003425948,-53,52,
 9007199254740991.,9007199254740991.,.306852819440054717253,-53,52,
 4503599627370497.,4503599627370497.,-.306852819440054637242,-52,51,
 4503599627370501.,4503599627370499.,.465735902799727880611,-52,51,
 4503599627370540.,4503599627370526.,.498475944637696882534,-52,51,
 4503599627372466.,4503599627371861.,.499945703299270638189,-52,51,
 9007199254740991.,9007199254740991.,-.386294361119890512152,-52,51,
 4503599627370497.,4503599627370497.,.386294361119890832198,-51,50,
 4503599627370500.,4503599627370502.,-.454822555520434110838,-51,50,
 4503599627370518.,4503599627370526.,.498475944637696882534,-51,50,
 4503599627371160.,4503599627371416.,.499455783701442239929,-51,50,
 4503599627371481.,4503599627371861.,.499945703299270638189,-51,50,
 4503599627379682.,4503599627383231.,-.499998734680567230945,-51,50,
 6755399441055743.,9007199254740989.,.227411277760219189059,-51,50,
 6755399441055745.,4503599627370497.,.386294361119890832198,-51,49,
 6755399441055748.,4503599627370502.,-.454822555520434110838,-51,49,
 6755399441055766.,4503599627370526.,.498475944637696882534,-51,49,
 6755399441056408.,4503599627371416.,.499455783701442239929,-51,49,
 6755399441056729.,4503599627371861.,.499945703299270638189,-51,49,
 6755399441064930.,4503599627383231.,-.499998734680567230945,-51,49,
 9007199254731806.,9007199254715523.,-.000002458622032915512,-51,49,
 9007199254735746.,9007199254726447.,-.000436858148598096929,-51,49,
 9007199254740328.,9007199254739151.,.001088432973400855521,-51,49,
 9007199254740970.,9007199254740931.,.003048110725019307635,-51,49,
 9007199254740988.,9007199254740981.,-.090354888959118123028,-51,49,
 9007199254740991.,9007199254740989.,.227411277760219189059,-51,49,
 4503599627370497.,4503599627370499.,-.227411277760217908875,-50,48,
 4503599627370507.,4503599627370526.,.498475944637696882534,-50,48,
 5629499534208527.,9007199254715523.,-.000002458622032915512,-50,48,
 5629499534210497.,9007199254726447.,-.000436858148598096929,-50,48,
 5629499534212788.,9007199254739151.,.001088432973400855521,-50,48,
 5629499534213109.,9007199254740931.,.003048110725019307635,-50,48,
 5629499534213118.,9007199254740981.,-.090354888959118123028,-50,48,
 5629499534213119.,9007199254740986.,.454822555520439231574,-50,48,
 5629499534213121.,4503599627370499.,-.227411277760217908875,-50,47,
 5629499534213131.,4503599627370526.,.498475944637696882534,-50,47,
 5868404969502442.,5217176454040533.,.499999946279241622341,-50,47,
 5868404969519913.,5217176454096648.,.499984457539526224675,-50,47,
 5868404969532797.,5217176454138031.,-.457785149320526437878,-50,47,
 5868404969532811.,5217176454138076.,-.491269220431662803275,-50,47,
 5868404969532844.,5217176454138182.,-.498767388049236503589,-50,47,
 5868404969533382.,5217176454139910.,-.499798120419898546642,-50,47,
 5868404969537384.,5217176454152763.,.499969572362533115803,-50,47,
 5888592265882432.,5282420499191297.,.499998815567891947896,-50,47,
 5888592265910092.,5282420499281249.,.499855082508731476801,-50,47,
 5888592265916158.,5282420499300977.,-.499742394717522499096,-50,47,
 5888592265916392.,5282420499301737.,.482468980040293805412,-50,47,
 5888592265916400.,5282420499301763.,.498954839008311021682,-50,47,
 5888592265917007.,5282420499303737.,.499819388580313037093,-50,47,
 5943141639571899.,5462830750683704.,.499999134231711975984,-50,47,
 5943141639584239.,5462830750725206.,-.497950972199586321706,-50,47,
 5943141639584250.,5462830750725242.,.496459283113610877893,-50,47,
 5943141639584294.,5462830750725390.,.474100304368904945908,-50,47,
 5943141639584305.,5462830750725427.,.468510559683354780316,-50,47,
 5943141639584776.,5462830750727012.,-.498104871617453831135,-50,47,
 5943141639590683.,5462830750746878.,-.499797725808064028235,-50,47,
 5943141639591399.,5462830750749285.,.499997084653745843654,-50,47,
 6303973650795881.,6821702937224042.,.499995401555320400524,-50,47,
 6303973650797894.,6821702937232497.,-.499758825934414440462,-50,47,
 6303973650801249.,6821702937246587.,-.499349181802030932589,-50,47,
 6303973650801264.,6821702937246649.,.496181710860034587140,-50,47,
 6303973650801369.,6821702937247090.,.464897959510781860877,-50,47,
 6303973650801379.,6821702937247132.,.461918554621863500517,-50,47,
 6421931254341636.,7335520459500137.,.499977745483205527648,-50,47,
 6421931254443646.,7335520459960817.,.499958549616371716786,-50,47,
 6421931254449386.,7335520459986739.,.499762270042759648993,-50,47,
 6421931254449698.,7335520459988149.,-.499551532075756433257,-50,47,
 6421931254449727.,7335520459988279.,.465255838894923263505,-50,47,
 6421931254449729.,7335520459988288.,.497311519651608050722,-50,47,
 6421931254450977.,7335520459993925.,-.499943686008497520464,-50,47,
 6619016067711014.,8281808293214681.,-.499995872424830048630,-50,47,
 6619016067722434.,8281808293272906.,.499866733769412778066,-50,47,
 6619016067722860.,8281808293275079.,-.496986019235341565312,-50,47,
 6619016067723053.,8281808293276063.,-.467391139540608784489,-50,47,
 6619016067723073.,8281808293276165.,-.495412395524106073652,-50,47,
 6619016067724361.,8281808293282732.,-.499981278217278593271,-50,47,
 6755399441051151.,9007199254715523.,-.000002458622032915512,-50,47,
 6755399441055743.,9007199254740986.,.454822555520439231574,-50,47,
 6755399441055745.,4503599627370499.,-.227411277760217908875,-50,46,
 6755399441055746.,4503599627370502.,-.454822555520434110838,-50,46,
 6755399441055755.,4503599627370526.,.498475944637696882534,-50,46,
 6755399441056076.,4503599627371416.,.499455783701442239929,-50,46,
 6755399441058367.,4503599627377769.,-.499781559181926237259,-50,46,
 6755399441060337.,4503599627383231.,-.499998734680567230945,-50,46,
 6787616684046200.,4593816523061540.,.499998602615888325829,-50,46,
 6787616684056161.,4593816523089711.,.499986402461617908571,-50,46,
 6787616684082745.,4593816523164895.,-.499944920132527471556,-50,46,
 6787616684082809.,4593816523165076.,-.499643820417536482971,-50,46,
 6787616684083833.,4593816523167972.,-.494826224007787592771,-50,46,
 6787616684084077.,4593816523168662.,-.431178280843935112075,-50,46,
 6787616684084089.,4593816523168696.,-.493621824620087701737,-50,46,
 6787616684086044.,4593816523174224.,.499950838529416443057,-50,46,
 6792176747028827.,4606731092011600.,.432635072134825283885,-50,46,
 6792176747028851.,4606731092011668.,.498564882473464862073,-50,46,
 6792176747028912.,4606731092011841.,.499469817088700294742,-50,46,
 6792176747028973.,4606731092012015.,-.499625248289567406913,-50,46,
 6792176747030065.,4606731092015112.,-.499818876584956904091,-50,46,
 6792176747031157.,4606731092018208.,.499987497201695638757,-50,46,
 6792176747077570.,4606731092149840.,-.499998465730385465948,-50,46,
 6935652144114442.,5032150734044894.,-.499998633804924916552,-50,46,
 6935652144165858.,5032150734204179.,.499985939918855751954,-50,46,
 6935652144171318.,5032150734221094.,.498428662006390430030,-50,46,
 6935652144171420.,5032150734221410.,.492905065047937870012,-50,46,
 6935652144171471.,5032150734221568.,.490143266576152680879,-50,46,
 6935652144172012.,5032150734223245.,-.499937771809327570662,-50,46,
 7272069881149969.,6190148894558330.,-.499998149253967947334,-50,46,
 7272069881160471.,6190148894598351.,.499965298257546842575,-50,46,
 7272069881162729.,6190148894606956.,.496719994451848308315,-50,46,
 7272069881162745.,6190148894607017.,.471010550357730570018,-50,46,
 7272069881162766.,6190148894607097.,.499766904985112510802,-50,46,
 7272069881163427.,6190148894609617.,-.499854503595616368198,-50,46,
 7274706301332422.,6200204168254250.,-.499756223539923270134,-50,46,
 7274706301332433.,6200204168254291.,.488163068422539533875,-50,46,
 7274706301332455.,6200204168254375.,.464001652348318171236,-50,46,
 7274706301333581.,6200204168258674.,-.499896277931641493224,-50,46,
 7274706301334740.,6200204168263097.,.499963670833274199229,-50,46,
 7274706301348812.,6200204168316811.,.499989115952893822371,-50,46,
 7274706301355848.,6200204168343669.,-.499997986985353339462,-50,46,
 7641538687453691.,7771151201542685.,-.499884679351986500835,-50,46,
 7641538687453705.,7771151201542751.,.479179065523183090778,-50,46,
 7641538687454312.,7771151201545656.,-.499985709691129442148,-50,46,
 7641538687484069.,7771151201688020.,-.499994619682019688422,-50,46,
 7642555474142749.,7776017254425356.,-.499983921081378867187,-50,46,
 7642555474143844.,7776017254430597.,.499967791292715099750,-50,46,
 7642555474148224.,7776017254451565.,.499774676126671369771,-50,46,
 7642555474148774.,7776017254454198.,.467786960181386662570,-50,46,
 7642555474148788.,7776017254454265.,.488790909241687660561,-50,46,
 7642555474148802.,7776017254454333.,-.490205141697433691627,-50,46,
 7642555474149178.,7776017254456133.,-.497527652417747533926,-50,46,
 7642555474149319.,7776017254456807.,.499726406169555537856,-50,46,
 7642555474225781.,7776017254822848.,-.499982496679512645324,-50,46,
 7661357941778388.,7866551682051031.,.499997563781503834994,-50,46,
 7661357941794453.,7866551682128834.,-.491624878094722540229,-50,46,
 7661357941794504.,7866551682129080.,.498877909029357025748,-50,46,
 7661357941794816.,7866551682130591.,.499600842192562883569,-50,46,
 7661357941795128.,7866551682132103.,-.499676224353999492906,-50,46,
 7661357941806080.,7866551682185143.,-.499940248199562687355,-50,46,
 7661357941808818.,7866551682198402.,.499993801717277966002,-50,46,
 7881299347893775.,9007199254715523.,-.000002458622032915512,-50,46,
 7881299347898367.,9007199254740986.,.454822555520439231574,-50,46,
 7881299347898369.,4503599627370499.,-.227411277760217908875,-50,45,
 7881299347898370.,4503599627370502.,-.454822555520434110838,-50,45,
 7881299347898379.,4503599627370526.,.498475944637696882534,-50,45,
 7881299347898700.,4503599627371416.,.499455783701442239929,-50,45,
 7881299347900991.,4503599627377769.,-.499781559181926237259,-50,45,
 7881299347902961.,4503599627383231.,-.499998734680567230945,-50,45,
 7952142228756981.,4704364005498082.,-.499993418724064884396,-50,45,
 7952142228792622.,4704364005601305.,-.499972393432776076546,-50,45,
 7952142228792988.,4704364005602365.,-.495539069059371876339,-50,45,
 7952142228792998.,4704364005602393.,.466330693905002143530,-50,45,
 7952142228793094.,4704364005602672.,-.499719581627935342287,-50,45,
 7952142228808410.,4704364005647030.,-.499990413506139474766,-50,45,
 7975281835700737.,4771860255602282.,-.499970819696538951623,-50,45,
 7975281835704640.,4771860255613748.,-.499745957771214512586,-50,45,
 7975281835705427.,4771860255616060.,-.498163334311682359375,-50,45,
 7975281835705475.,4771860255616201.,-.486630976046648540790,-50,45,
 7975281835705941.,4771860255617570.,-.499670997673678721470,-50,45,
 7975281835714004.,4771860255641257.,-.499975000676509413468,-50,45,
 7975281835780339.,4771860255836132.,-.499991130549820740382,-50,45,
 8134778399524007.,5264195980835611.,-.497113944315334961366,-50,45,
 8134778399524061.,5264195980835786.,-.491698887264717215394,-50,45,
 8134778399524065.,5264195980835798.,.471665191035559985151,-50,45,
 8134778399524144.,5264195980836054.,.498105737472575913470,-50,45,
 8134778399524717.,5264195980837912.,-.499990045592573812792,-50,45,
 8134778399551494.,5264195980924691.,.499991866260007806822,-50,45,
 8395085770606831.,6179167963701071.,-.499993876848480499466,-50,45,
 8395085770623720.,6179167963765319.,-.499827672569974821635,-50,45,
 8395085770624011.,6179167963766426.,-.497160346836265401751,-50,45,
 8395085770624190.,6179167963767106.,.442624709297761552714,-50,45,
 8395085770624205.,6179167963767164.,-.495382129570281135924,-50,45,
 8395085770624833.,6179167963769553.,-.499935116372819908827,-50,45,
 8395085770625946.,6179167963773786.,.499957442725495029940,-50,45,
 8395085770634947.,6179167963808027.,.499987131038057415837,-50,45,
 8472742745230410.,6481761058822439.,-.499996073685695086290,-50,45,
 8472742745233333.,6481761058834102.,.499991960404652698284,-50,45,
 8472742745245025.,6481761058880758.,.499944306661000602882,-50,45,
 8472742745247934.,6481761058892367.,-.365958705205296498827,-50,45,
 8472742745247948.,6481761058892422.,.499932445698826770797,-50,45,
 8714420965793256.,7521598086853414.,.499804511831178873372,-50,45,
 8714420965793367.,7521598086853928.,.494669226697232379173,-50,45,
 8714420965793375.,7521598086853966.,-.460655838896650043466,-50,45,
 8714420965793413.,7521598086854142.,-.498449900465099982042,-50,45,
 8714420965794420.,7521598086858805.,-.499992530529071758387,-50,45,
 8743627225390060.,7658063315506043.,.499996242201832796696,-50,45,
 8743627225396889.,7658063315538239.,.486988829789208052695,-50,45,
 8743627225396896.,7658063315538272.,.489172011600212724448,-50,45,
 8743627225396924.,7658063315538404.,.497904738845653630175,-50,45,
 8743627225396931.,7658063315538438.,-.499912079342630588715,-50,45,
 8743627225400137.,7658063315553552.,.499985205372280266830,-50,45,
 8897696383646856.,8420001496409038.,-.499939029968981568172,-50,45,
 8897696383647003.,8420001496409800.,-.499570679919212378526,-50,45,
 8897696383647934.,8420001496414626.,-.497237794669266262971,-50,45,
 8897696383647983.,8420001496414880.,-.497115011158436184426,-50,45,
 8897696383647999.,8420001496414962.,.441700591622269832137,-50,45,
 8897696383654979.,8420001496451145.,-.499992617376558994582,-50,45,
 8897696383711987.,8420001496746656.,-.499993452735654413087,-50,45,
 8979216647919140.,8853359649423372.,-.499997203377398641159,-50,45,
 8979216647922239.,8853359649440262.,.499966071320188807240,-50,45,
 8979216647925338.,8853359649457153.,.499929378243495198156,-50,45,
 8979216647925873.,8853359649460070.,-.499754268315866044764,-50,45,
 8979216647926035.,8853359649460952.,.476042459457470739479,-50,45,
 8979216647926075.,8853359649461170.,.494757700896542284125,-50,45,
 9007199254349602.,9007199252570665.,.000266619289039501697,-50,45,
 9007199254652740.,9007199254251619.,.000183083792268700606,-50,45,
 9007199254735414.,9007199254710061.,.000214746109515744973,-50,45,
 9007199254737384.,9007199254720985.,-.000219660041404196147,-50,45,
 9007199254740660.,9007199254739151.,.001088432973400855521,-50,45,
 9007199254740704.,9007199254739395.,-.011104009972414788825,-50,45,
 9007199254740968.,9007199254740859.,-.084258667508516226800,-50,45,
 9007199254740991.,9007199254740986.,.454822555520439231574,-50,45,
 4503599627370497.,4503599627370502.,-.454822555520434110838,-49,44,
 4523144813466884.,4613295806809459.,-.499297145969298596199,-49,44,
 4523144813467056.,4613295806810436.,-.497363867501431514515,-49,44,
 4523144813467078.,4613295806810560.,.467999691387290531440,-49,44,
 4523144813467081.,4613295806810578.,-.491268914218530552728,-49,44,
 4523144813467375.,4613295806812248.,-.499592263283647849228,-49,44,
 4523144813467866.,4613295806815037.,-.499887378911888151178,-49,44,
 4523144813471475.,4613295806835536.,.499980142685226584162,-49,44,
 4523144813478202.,4613295806873748.,-.499989462386372314189,-49,44,
 4523144813508719.,4613295807047092.,-.499996256053235631482,-49,44,
 4612325947558647.,5148725368218194.,-.499983880353316917366,-49,44,
 4612325947558971.,5148725368220247.,.499882447404848613002,-49,44,
 4612325947563993.,5148725368252084.,.497810632438428268999,-49,44,
 4612325947564803.,5148725368257219.,.497476487170884917718,-49,44,
 4612325947564812.,5148725368257277.,-.446971669969986597270,-49,44,
 4612325947573660.,5148725368313368.,.499995926724060318887,-49,44,
 4802115455481652.,6504098966353419.,.499997370347200403149,-49,44,
 4802115455518545.,6504098966648871.,.399343761839865119389,-49,44,
 4802115455518557.,6504098966648967.,.499492631198561693995,-49,44,
 4802115455519276.,6504098966654726.,-.499920943801586059143,-49,44,
 4802115455522631.,6504098966681594.,-.499966139453300065962,-49,44,
 4802115455525986.,6504098966708461.,.499988775884905556727,-49,44,
 5059472696353164.,8929055048048181.,-.499985163239851381582,-49,44,
 5059472696383016.,8929055048376377.,.499993299907515147660,-49,44,
 5059472696385063.,8929055048398882.,.499958766456358382063,-49,44,
 5059472696394953.,8929055048507615.,-.477735371384427588764,-49,44,
 5059472696394957.,8929055048507658.,.498815612043058624765,-49,44,
 5059472696395298.,8929055048511407.,.499786950032528277075,-49,44,
 5066549580596113.,9007199252570665.,.000266619289039501697,-49,44,
 5066549580747682.,9007199254251619.,.000183083792268700606,-49,44,
 5066549580789019.,9007199254710061.,.000214746109515744973,-49,44,
 5066549580790004.,9007199254720985.,-.000219660041404196147,-49,44,
 5066549580791642.,9007199254739151.,.001088432973400855521,-49,44,
 5066549580791664.,9007199254739395.,-.011104009972414788825,-49,44,
 5066549580791796.,9007199254740859.,-.084258667508516226800,-49,44,
 5066549580791807.,9007199254740981.,-.090354888959118123028,-49,44,
 5066549580791809.,4503599627370502.,-.454822555520434110838,-49,43,
 5079689563129230.,4577055780623428.,-.499993783317175893324,-49,43,
 5079689563131560.,4577055780636558.,.499958280579085092849,-49,43,
 5079689563132172.,4577055780640008.,-.499195935017613917767,-49,43,
 5079689563132205.,4577055780640193.,.476339867156412497292,-49,43,
 5079689563132227.,4577055780640317.,.460030401943294875425,-49,43,
 5079689563132419.,4577055780641399.,.499511432953187027867,-49,43,
 5107897798880038.,4738819685345705.,.499960309286003717675,-49,43,
 5107897798881140.,4738819685352135.,.447829563087119790675,-49,43,
 5107897798881164.,4738819685352275.,.482991869982039845792,-49,43,
 5107897798881176.,4738819685352346.,-.499426976568948328314,-49,43,
 5107897798883337.,4738819685364954.,.499979090575359269657,-49,43,
 5107897798886636.,4738819685384203.,.499997950053805423428,-49,43,
 5222449517538544.,5456638600810190.,-.499986936282803115795,-49,43,
 5222449517592907.,5456638601175435.,-.499864570432382898064,-49,43,
 5222449517593170.,5456638601177202.,-.499606390922713589171,-49,43,
 5222449517593632.,5456638601180306.,-.491548294733219537012,-49,43,
 5222449517593639.,5456638601180353.,-.461123172050102447030,-49,43,
 5222449517593664.,5456638601180521.,-.495319162464232413192,-49,43,
 5222449517593696.,5456638601180736.,-.499090030186774254011,-49,43,
 5222449517596621.,5456638601200387.,.499979127824972921929,-49,43,
 5270585385640589.,5789821915182105.,-.499987594314045539610,-49,43,
 5270585385676446.,5789821915437725.,-.499982969006734537714,-49,43,
 5270585385682320.,5789821915479600.,-.499841692695157090577,-49,43,
 5270585385682436.,5789821915480426.,.449429060788843357148,-49,43,
 5270585385682452.,5789821915480541.,-.488602559410990867405,-49,43,
 5270585385682514.,5789821915480983.,-.498475087664124213267,-49,43,
 5270585385689614.,5789821915531597.,.499993674261712227704,-49,43,
 5489113122526546.,7577396357262741.,-.499993315357427284274,-49,43,
 5489113122559371.,7577396357568994.,-.456648627884208387956,-49,43,
 5489113122559383.,7577396357569106.,-.498186473716861026270,-49,43,
 5489113122559480.,7577396357570010.,.499382605863259630993,-49,43,
 5489113122559865.,7577396357573603.,-.499956613294090822100,-49,43,
 5489113122568917.,7577396357658056.,.499995534995302994208,-49,43,
 5503648895898286.,7714234138504659.,-.499974842901028731474,-49,43,
 5503648895950630.,7714234139001841.,-.499983456490458363557,-49,43,
 5503648895951543.,7714234139010512.,.499978468825273897489,-49,43,
 5503648895960673.,7714234139097232.,.499598258159877254695,-49,43,
 5503648895962150.,7714234139111262.,-.427078711691723606919,-49,43,
 5503648895962182.,7714234139111566.,-.479653974127875062969,-49,43,
 5503648895962194.,7714234139111680.,-.499369697538344350998,-49,43,
 5503648895962499.,7714234139114576.,.499522333010931907815,-49,43,
 5548511370782210.,8152342696180245.,-.499999611017932165074,-49,43,
 5548511370793033.,8152342696288884.,-.499946602784304043586,-49,43,
 5548511370793721.,8152342696295789.,.499502440858304209252,-49,43,
 5548511370794012.,8152342696298710.,.496362430554863175387,-49,43,
 5548511370794065.,8152342696299242.,.499226964873433020501,-49,43,
 5548511370800363.,8152342696362460.,.499997724095106597971,-49,43,
 5629499534017425.,9007199252570665.,.000266619289039501697,-49,43,
 5629499534168994.,9007199254251619.,.000183083792268700606,-49,43,
 5629499534210331.,9007199254710061.,.000214746109515744973,-49,43,
 5629499534211316.,9007199254720985.,-.000219660041404196147,-49,43,
 5629499534212954.,9007199254739151.,.001088432973400855521,-49,43,
 5629499534212976.,9007199254739395.,-.011104009972414788825,-49,43,
 5629499534213108.,9007199254740859.,-.084258667508516226800,-49,43,
 5629499534213119.,9007199254740981.,-.090354888959118123028,-49,43,
 5629499534213121.,4503599627370502.,-.454822555520434110838,-49,42,
 5426391276979760.,6171883528749693.,.499548756881675847362,-44,-256,
 5426391276979822.,6171883528764771.,-.495997908487646170693,-44,-256,
 5426391276979839.,6171883528768905.,-.478647794171130015118,-44,-256,
 5426391276979991.,6171883528805868.,-.499987825454056851255,-44,-256,
 5426391277018838.,6171883538252584.,-.492704910792221852041,-44,-256,
 5506672652879599.,4560457981990708.,-.490086818771931960945,-44,-261,
 5506672652929202.,4560457990903669.,.499978458046844147075,-44,-261,
 5506672652931294.,4560457991279572.,.499841486780678485041,-44,-261,
 5506672652932504.,4560457991496992.,.494996292062968998124,-44,-261,
 5506672652932520.,4560457991499867.,.470138904381217189690,-44,-261,
 5506672652932539.,4560457991503282.,-.496879241136836228496,-44,-261,
 5506672652932660.,4560457991525024.,-.497363160522913391772,-44,-261,
 5506672652933265.,4560457991633734.,-.499781202627411629592,-44,-261,
 5506672652937449.,4560457992385540.,-.499903807385714565251,-44,-261,
 5562950707703165.,5235095141729844.,.499241066940454628315,-44,-264,
 5562950707703180.,5235095141732939.,-.492349495526194357484,-44,-264,
 5562950707704950.,5235095142098031.,.499976972000520112259,-44,-264,
 5562950707709231.,5235095142981062.,-.499833240386563414593,-44,-264,
 5562950707725760.,5235095146390453.,-.497936324024171069552,-44,-264,
 5565768841137126.,5849884319338643.,-.499085983446758285100,-44,-264,
 5565768841151354.,5849884322618061.,-.420299534294856278803,-44,-264,
 5565768841151362.,5849884322619905.,-.496723652271072815473,-44,-264,
 5565768841151415.,5849884322632120.,.496966580816771001745,-44,-264,
 5565768841152828.,5849884322957803.,.498566540643742853991,-44,-264,
 5565768841154084.,5849884323247300.,-.499996051015771453538,-44,-264,
 5637442019523229.,6158404352799899.,-.499227792673740273634,-44,-268,
 5637442019535910.,6158404355876898.,-.498557196509076715628,-44,-268,
 5637442019535927.,6158404355881022.,.490246879316363825853,-44,-268,
 5637442019536091.,6158404355920816.,.499886340940724360453,-44,-268,
 5637442019536716.,6158404356072471.,-.499960914516512294320,-44,-268,
 5666178554258968.,4776783453951195.,-.499944886742069443450,-44,-270,
 5666178554261170.,4776783454365631.,.499131226849700209011,-44,-270,
 5666178554261256.,4776783454381818.,-.496362800262842078266,-44,-270,
 5666178554261619.,4776783454450137.,.499401387295407413673,-44,-270,
 5666178554262517.,4776783454619149.,.499946193169750142184,-44,-270,
 5666178554281160.,4776783458127937.,-.498528414959072663857,-44,-270,
 5835612929791082.,7398683857392519.,-.490285253920812893948,-44,-279,
 5835612929832190.,7398683869376096.,-.496572336568118316324,-44,-279,
 5835612929832223.,7398683869385715.,.481074667498134124754,-44,-279,
 5835612929832225.,7398683869386299.,-.489977028823116114361,-44,-279,
 5835612929832328.,7398683869416325.,-.499139327257392774788,-44,-279,
 5835612929832777.,7398683869547214.,.499756542754880209917,-44,-279,
 5835612929833537.,7398683869768766.,-.499879914884285857765,-44,-279,
 5835612929838995.,7398683871359852.,-.499705781991491611724,-44,-279,
 5835612929841724.,7398683872155395.,-.499490404481375943908,-44,-279,
 6029337333034302.,7460260725316394.,-.451090927571183074015,-44,-290,
 6029337333089910.,7460260741661846.,-.492417422190763112677,-44,-290,
 6029337333126190.,7460260752326013.,-.499643605168245523564,-44,-290,
 6029337333126207.,7460260752331009.,.491508731928824455600,-44,-290,
 6029337333126982.,7460260752558813.,.499927653955805057887,-44,-290,
 6157045845814039.,8929717502718032.,-.496946623810720595848,-44,-297,
 6157045845814361.,8929717502831324.,-.497006028996714789236,-44,-297,
 6157045845824182.,8929717506286730.,-.498127422971412660073,-44,-297,
 6157045845834808.,8929717510025366.,-.497834757146934675606,-44,-297,
 6157045845835000.,8929717510092918.,.495973747716591644679,-44,-297,
 6157045845835056.,8929717510112621.,.452501324564641402254,-44,-297,
 6157045845835062.,8929717510114732.,.483557853233973195418,-44,-297,
 6157045845835130.,8929717510138658.,-.497801453634950315596,-44,-297,
 6157045845873479.,8929717523631313.,-.489767129505768794243,-44,-297,
 6268442428701097.,5620806524057176.,-.499688905848665638948,-44,-304,
 6268442428702763.,5620806524426136.,-.499830586880144663139,-44,-304,
 6268442428709427.,5620806525901975.,.499844881072463453513,-44,-304,
 6268442428709554.,5620806525930102.,-.497756580498565295128,-44,-304,
 6268442428709582.,5620806525936303.,-.489353734193208104347,-44,-304,
 6268442428709597.,5620806525939624.,.479433507713048396242,-44,-304,
 6328789084985243.,7574167972273737.,-.499589622587651935271,-44,-307,
 6328789084993139.,7574167974630129.,.499673315980800645344,-44,-307,
 6328789084993146.,7574167974632219.,-.499440487378029376652,-44,-307,
 6328789084993307.,7574167974680266.,-.479057805611248401596,-44,-307,
 6328789084993573.,7574167974759648.,-.445381402750077488199,-44,-307,
 6328789084993580.,7574167974761737.,-.444495170387052322216,-44,-307,
 6328789084995397.,7574167975303981.,.499850629217549613490,-44,-307,
 6328789084997655.,7574167975977834.,-.499912106866014368019,-44,-307,
 6477002457216950.,5084275526228931.,-.495429788055383358801,-44,-316,
 6477002457239465.,5084275530739244.,-.499480540397444977191,-44,-316,
 6477002457250918.,5084275533033563.,.499505669695246360690,-44,-316,
 6477002457250958.,5084275533041576.,.491733053553383691255,-44,-316,
 6477002457250967.,5084275533043379.,.414984216661864194540,-44,-316,
 6477002457251817.,5084275533213655.,.499819169543913559376,-44,-316,
 6477002457258892.,5084275534630954.,-.499715681026167977380,-44,-316,
 6491364931154882.,8953516025250841.,-.496160975841784861898,-44,-316,
 6491364931154931.,8953516025268127.,-.462788343151553429849,-44,-316,
 6491364931154949.,8953516025274477.,-.491345326843020341870,-44,-316,
 6491364931155025.,8953516025301287.,.499191902776011912788,-44,-316,
 6491364931155445.,8953516025449453.,.499530672145932984521,-44,-316,
 6491364931156075.,8953516025671703.,-.499956576478787530298,-44,-316,
 6491364931167911.,8953516029847162.,-.498821738954047730017,-44,-316,
 6491364931209442.,8953516044498310.,-.479351727763725962689,-44,-316,
 6544022097449506.,8911496337897258.,-.499814084089566450928,-44,-319,
 6544022097452956.,8911496339108624.,-.499947532513560440712,-44,-319,
 6544022097454681.,8911496339714307.,-.499952507517149004084,-44,-319,
 6616319171067012.,4807478929483446.,-.494188221684716613397,-44,-324,
 6616319171103002.,4807478936300628.,-.499966191714694851605,-44,-324,
 6616319171105089.,4807478936695945.,-.499893564162874422129,-44,-324,
 6616319171106388.,4807478936941999.,.499209740896920105909,-44,-324,
 6616319171106474.,4807478936958290.,-.485452721298911693891,-44,-324,
 6616319171106486.,4807478936960563.,-.460056781402955225024,-44,-324,
 6616319171106505.,4807478936964161.,.496820125630239872745,-44,-324,
 6616319171106782.,4807478937016630.,.499710076235977284550,-44,-324,
 6702751591224365.,4526496367389519.,.499996213155903866478,-44,-329,
 6702751591224503.,4526496367414132.,-.499550847571858512992,-44,-329,
 6702751591225722.,4526496367631538.,-.495544071981264488286,-44,-329,
 6702751591225880.,4526496367659716.,.461497767540141465122,-44,-329,
 6702751591225883.,4526496367660252.,-.495014094569379838755,-44,-329,
 6702751591263985.,4526496374455661.,-.494902916653210793864,-44,-329,
 6740450947105953.,4998014454460926.,-.489717451131415057808,-44,-331,
 6740450947143341.,4998014461823597.,-.499220241568372733649,-44,-331,
 6740450947151684.,4998014463466551.,-.499833838557351414249,-44,-331,
 6740450947155700.,4998014464257405.,.499943493907124775265,-44,-331,
 6740450947156944.,4998014464502382.,-.499104078410965927008,-44,-331,
 6740450947157431.,4998014464598284.,.485194877132358293999,-44,-331,
 6740450947157512.,4998014464614235.,.494903916810582820756,-44,-331,
 6740450947157566.,4998014464624870.,-.498623361788846527887,-44,-331,
 6754791752059396.,8794097065749098.,-.499946508390329018864,-44,-331,
 6754791752060188.,8794097066023521.,.498785004193397922278,-44,-331,
 6754791752062069.,8794097066675278.,.495806667610091234946,-44,-331,
 6754791752062152.,8794097066704038.,-.423515559333023642710,-44,-331,
 6754791752062166.,8794097066708889.,-.494244600390935938072,-44,-331,
 6754791752062168.,8794097066709581.,.495651251104940320679,-44,-331,
 6794379564732387.,5230112843794016.,-.491487682723538734970,-44,-334,
 6794379564757711.,5230112849012556.,-.498277326147141166190,-44,-334,
 6794379564776704.,5230112852926461.,-.499952469722761614246,-44,-334,
 6794379564777409.,5230112853071740.,.499251963290619655540,-44,-334,
 6794379564778114.,5230112853217020.,.498460431834162961933,-44,-334,
 6794379564778156.,5230112853225675.,.477136808392557349293,-44,-334,
 6794379564778170.,5230112853228560.,.470028937094815412148,-44,-334,
 6990987887109262.,5908251725332788.,-.493051658133335059071,-44,-345,
 6990987887140197.,5908251732534152.,-.499700524288652717386,-44,-345,
 6990987887148175.,5908251734391351.,.499749890329375057068,-44,-345,
 6990987887148194.,5908251734395775.,-.486964183735217596806,-44,-345,
 6990987887148928.,5908251734566642.,.499978858181518751322,-44,-345,
 7138546116873513.,7729877522753201.,-.496544189384772327518,-44,-353,
 7138546116878318.,7729877524216630.,-.497774589177882037532,-44,-353,
 7138546116897515.,7729877530063341.,-.467043269303913860389,-44,-353,
 7138546116897522.,7729877530065472.,.479470800760170583617,-44,-353,
 7138546116897538.,7729877530070346.,-.499925608313908537376,-44,-353,
 7322656671992078.,5336592887257907.,.499999328545569420324,-44,-364,
 7322656671992859.,5336592887422126.,-.499936812322397084051,-44,-364,
 7322656671993058.,5336592887463968.,.498799857189924439286,-44,-364,
 7322656671993197.,5336592887493196.,-.481981872505308670243,-44,-364,
 7322656671993212.,5336592887496350.,-.487102193479162290525,-44,-364,
 7322656671993242.,5336592887502658.,-.497342829834715186119,-44,-364,
 7357968097663804.,5363374957105977.,.499984140124120317247,-44,-366,
 7357968097664342.,5363374957219669.,-.499783941152849068886,-44,-366,
 7357968097664370.,5363374957225586.,-.496054332937268169865,-44,-366,
 7357968097664398.,5363374957231503.,-.492324718193907017653,-44,-366,
 7357968097672384.,5363374958919117.,-.499747445410868455011,-44,-366,
 7357968097698124.,5363374964358534.,-.495264510568199188524,-44,-366,
 7461059150902210.,4867527186045587.,.492376753873787253054,-44,-372,
 7461059150902224.,4867527186048272.,.478672092386185542049,-44,-372,
 7461059150902275.,4867527186058054.,-.499823447650922128612,-44,-372,
 7461059150902786.,4867527186156055.,.499957618588801087314,-44,-372,
 7461059150911761.,4867527187877324.,-.499652084684765640294,-44,-372,
 7819356134935638.,6276736201578648.,-.499960271305822903730,-44,-392,
 7819356134935923.,6276736201649131.,-.498744243849929770514,-44,-392,
 7819356134936059.,6276736201682764.,.494818771015156736559,-44,-392,
 7819356134936072.,6276736201685980.,-.491090637244327163330,-44,-392,
 7819356134947135.,6276736204421957.,-.499400070583664619628,-44,-392,
 7880037969479055.,8570488960775738.,-.493096503149208498047,-44,-395,
 7880037969501214.,8570488968258491.,-.499334279743728793479,-44,-395,
 7880037969503389.,8570488968992955.,-.499639577559790876194,-44,-395,
 7880037969509914.,8570488971196346.,.499822176546702340593,-44,-395,
 7880037969511271.,8570488971654584.,.498861852302507008081,-44,-395,
 7880037969511680.,8570488971792697.,.499314135192767249735,-44,-395,
 7961347698810188.,6594670221502742.,.499369509627989069840,-44,-400,
 7961347698810231.,6594670221513915.,.432258376965258171127,-44,-400,
 7961347698810255.,6594670221520151.,.487824264640463809523,-44,-400,
 7961347698810261.,6594670221521711.,-.498284262519337564580,-44,-400,
 7961347698810620.,6594670221614991.,.499556199837459319320,-44,-400,
 7961347698811484.,6594670221839489.,.499935312084203079643,-44,-400,
 7961347698817027.,6594670223279759.,-.499765512925414122416,-44,-400,
 8016984453633574.,7381345780991594.,-.495905894320822144382,-44,-403,
 8016984453660065.,7381345788696006.,.499923160763013649072,-44,-403,
 8016984453660148.,7381345788720146.,-.498944810078943883314,-44,-403,
 8016984453660314.,7381345788768424.,-.496680514939632262884,-44,-403,
 8016984453660320.,7381345788770168.,.491353140195116406513,-44,-403,
 8016984453660326.,7381345788771913.,.479386795742389204266,-44,-403,
 8016984453678617.,7381345794091510.,-.498096773587908978120,-44,-403,
 8049376796641490.,6612406404265507.,-.499994054059168897341,-44,-405,
 8049376796642171.,6612406404442930.,.473637409077124662578,-44,-405,
 8049376796642186.,6612406404446838.,.490677803259607117700,-44,-405,
 8049376796642201.,6612406404450747.,-.492281800248222205694,-44,-405,
 8049376796642549.,6612406404541413.,-.496943953254184970047,-44,-405,
 8049376796642781.,6612406404601856.,.499948635389944491367,-44,-405,
 8198893031063934.,4672482745522309.,-.499915390548840137548,-44,-414,
 8198893031068322.,4672482746330138.,.499611518236732009635,-44,-414,
 8198893031068733.,4672482746405804.,-.475357271807470488922,-44,-414,
 8198893031068743.,4672482746407645.,-.477181314690379446654,-44,-414,
 8198893031068833.,4672482746424214.,-.493597667994953654318,-44,-414,
 8198893031068863.,4672482746429737.,-.499069772706502492085,-44,-414,
 8198893031069965.,4672482746632614.,.499926105248037062512,-44,-414,
 8466376832793595.,5384763999923516.,.499940227322585181902,-44,-429,
 8466376832794867.,5384764000193390.,-.499828221022357757671,-44,-429,
 8466376832794873.,5384764000194662.,.486021959856355297168,-44,-429,
 8466376832798330.,5384764000928115.,-.499915452535461715152,-44,-429,
 8466376832806528.,5384764002667438.,-.499433620829095090759,-44,-429,
 8627767282607862.,6074931139311478.,-.498082377548557337167,-44,-438,
 8627767282627737.,6074931144068708.,-.499846283966154143984,-44,-438,
 8627767282627944.,6074931144118254.,.499400229782509610865,-44,-438,
 8627767282627958.,6074931144121606.,-.495819798176303645521,-44,-438,
 8627767282628014.,6074931144135010.,-.476699891527012947024,-44,-438,
 8627767282628025.,6074931144137642.,.455627236468666278099,-44,-438,
 8627767282634431.,6074931145670967.,-.499853293378442802203,-44,-438,
 8627767282638406.,6074931146622413.,-.499508089567416365055,-44,-438,
 8666709478615150.,7044394057341837.,-.492217497388840429235,-44,-440,
 8666709478651848.,7044394067527555.,.499992428400354559326,-44,-440,
 8666709478652401.,7044394067681043.,.499524438528100029391,-44,-440,
 8666709478652864.,7044394067809552.,-.464698449176974145109,-44,-440,
 8666709478652882.,7044394067814548.,-.471946807836910858724,-44,-440,
 8666709478652945.,7044394067832034.,-.497316035243713776527,-44,-440,
 8666709478652954.,7044394067834531.,.499059792955692229487,-44,-440,
 8666709478662609.,7044394070514327.,-.499472096087458981444,-44,-440,
 8704521642362387.,7812846536877131.,-.499902121695399124500,-44,-442,
 8704521642365749.,7812846537912065.,-.499909478305566505638,-44,-442,
 8704521642366371.,7812846538103537.,-.474910683474141435667,-44,-442,
 8704521642366377.,7812846538105384.,-.477884948776088395943,-44,-442,
 8704521642366419.,7812846538118313.,-.498704793663808942124,-44,-442,
 8918028527502122.,8188167299261490.,-.488934713485145863072,-43,-961,
 8918028527521514.,8188167311774015.,-.499958460860216901232,-43,-961,
 8918028527522971.,8188167312714132.,-.496868816425169605972,-43,-961,
 8918028527522979.,8188167312719293.,.435886949725039659380,-43,-961,
 8918028527523120.,8188167312810273.,-.499292137764226819171,-43,-961,
 8918028527523596.,8188167313117407.,.499685217831620983562,-43,-961,
 8918028527524399.,8188167313635537.,-.499913006726693083640,-43,-961,
 8922371199869951.,5764698951501434.,-.499956207362952489585,-43,-962,
 8922371199871398.,5764698952158760.,-.499933089103210190758,-43,-962,
 8922371199871715.,5764698952302763.,-.499226930835093232537,-43,-962,
 8922371199871745.,5764698952316391.,-.454995877798081430530,-43,-962,
 8922371199871756.,5764698952321387.,.494555516387737142791,-43,-962,
 8922371199933481.,5764698980361089.,-.431802358721287102876,-43,-962,
 8923543109217644.,6322415876760098.,-.499892526430424868752,-43,-962,
 8923543109218505.,6322415877189062.,.499811550236301528849,-43,-962,
 8923543109218915.,6322415877393332.,-.452700088532725515784,-43,-962,
 8923543109218924.,6322415877397816.,-.497999050480282256253,-43,-962,
 8923543109221728.,6322415878794817.,-.499876358974185102858,-43,-962,
 8923543109229035.,6322415882435290.,-.497968675127896480674,-43,-962,
 8923543109303827.,6322415919697950.,-.358453517528640895644,-43,-962,
 8927612007905576.,8712315267700716.,-.475799758792600822854,-43,-962,
 8927612007920614.,8712315278024985.,-.494003129122600577569,-43,-962,
 8927612007935487.,8712315288235974.,-.483015881762023869646,-43,-962,
 8927612007935575.,8712315288296390.,-.492059345646423621334,-43,-962,
 8927612007935652.,8712315288349254.,-.499972032868998550456,-43,-962,
 8936637841673181.,8871479109224838.,-.498547551963505200859,-43,-963,
 8936637841679336.,8871479113527723.,-.499627314619079559977,-43,-963,
 8936637841680339.,8871479114228907.,.497145095950214270906,-43,-963,
 8936637841680362.,8871479114244987.,-.484982105054916685627,-43,-963,
 8936637841680453.,8871479114308603.,.498775776716509575668,-43,-963,
 8936637841680510.,8871479114348451.,.499591385577407420274,-43,-963,
 8936637841689127.,8871479120372491.,-.497856810930629963349,-43,-963,
 8936637841752911.,8871479164963103.,-.355015550891579893968,-43,-963,
 8938176088222735.,5007369944587362.,-.499987530382115908802,-43,-964,
 8938176088223278.,5007369944801624.,-.499542622793033346443,-43,-964,
 8938176088223709.,5007369944971691.,.497133802835681456998,-43,-964,
 8938176088223726.,5007369944978400.,-.484435686098963462817,-43,-964,
 8938176088223731.,5007369944980372.,.462161524748092922430,-43,-964,
 8938176088223765.,5007369944993788.,.499022579123606210928,-43,-964,
 8940110850503086.,5832078146551141.,-.499988904629820319574,-43,-964,
 8940110850503311.,5832078146654545.,.490798626171141406941,-43,-964,
 8940110850503337.,5832078146666495.,-.488043585431753975800,-43,-964,
 8940110850520999.,5832078154783557.,-.494353597900130185393,-43,-964,
 8940251230171576.,5896951675957387.,-.499924024676709366063,-43,-964,
 8940251230171705.,5896951676017331.,.494847493466482425990,-43,-964,
 8940251230171734.,5896951676030808.,-.498575879802467906245,-43,-964,
 8940251230189366.,5896951684224220.,-.494285371862360239505,-43,-964,
 8940944733884848.,6228184211671291.,-.441311013983338890729,-43,-964,
 8940944733884853.,6228184211673745.,-.483448455417900875013,-43,-964,
 8940944733884925.,6228184211709082.,-.490227504867895598084,-43,-964,
 8940944733885021.,6228184211756198.,-.499265925590949358950,-43,-964,
 8940944733885472.,6228184211977544.,.499943764250378426046,-43,-964,
 8940944733915564.,6228184226746445.,-.481799700412600322323,-43,-964,
 8940944733990794.,6228184263668695.,-.282939261196432463160,-43,-964,
 8942307480356773.,6934240877101175.,-.484129989632511678646,-43,-964,
 8942307480374006.,6934240886517804.,-.497876950574313144462,-43,-964,
 8942307480383784.,6934240891860796.,.499603144794157046261,-43,-964,
 8942307480383884.,6934240891915440.,-.495696920688932076744,-43,-964,
 8942307480383891.,6934240891919265.,-.485367909146919627785,-43,-964,
 8942307480383919.,6934240891934565.,-.444051841879654726644,-43,-964,
 8942307480385914.,6934240893024692.,.499804842755581538080,-43,-964,
 8942307480391239.,6934240895934433.,-.498836224581620605387,-43,-964,
 8942613188620169.,7103317436084606.,-.499048783764927276080,-43,-964,
 8942613188626747.,7103317439766664.,.472062588382727181577,-43,-964,
 8942613188626755.,7103317439771143.,-.499391267689653271510,-43,-964,
 8942613188627035.,7103317439927873.,.499725548273640808740,-43,-964,
 8942613188628086.,7103317440516175.,-.499987265523310416931,-43,-964,
 8945254115904634.,8746656457254135.,-.392885739710211433139,-43,-964,
 8945254115955533.,8746656492336347.,-.496137647801301657098,-43,-964,
 8945254115966881.,8746656500157973.,-.499935302065668030459,-43,-964,
 8945254115967048.,8746656500273078.,-.499762723547320724441,-43,-964,
 8945254115967382.,8746656500503288.,-.499413022204674044391,-43,-964,
 8945254115967398.,8746656500514316.,-.475444022156411361890,-43,-964,
 8945254115967438.,8746656500541886.,-.415521461203853590252,-43,-964,
 8946847078309036.,4958248189206604.,-.499809113646532770716,-43,-965,
 8946847078309139.,4958248189246847.,.499617994961276694796,-43,-965,
 8946847078309757.,4958248189488311.,.496187506121411215476,-43,-965,
 8946847078309931.,4958248189556297.,-.495067500299710753142,-43,-965,
 8946847078312577.,4958248190590138.,-.499899451583492102387,-43,-965,
 8946847078317837.,4958248192645317.,-.499038570410373356808,-43,-965,
 8948813482418940.,5789283286078991.,-.400832433136300407777,-43,-965,
 8948813482492293.,5789283319543028.,-.499964826131824750779,-43,-965,
 8948813482493140.,5789283319929434.,-.499693536690946044722,-43,-965,
 8948813482493213.,5789283319962736.,.496789139367907130226,-43,-965,
 8948813482493218.,5789283319965018.,-.476054505946624083144,-43,-965,
 8952183438217363.,7550145104069035.,-.489874231679965973414,-43,-965,
 8952183438234167.,7550145114066816.,-.499611013967647831715,-43,-965,
 8952183438237842.,7550145116253309.,.499964322674834268731,-43,-965,
 8952183438238151.,7550145116437153.,.485263597278827689751,-43,-965,
 8952183438238235.,7550145116487130.,.490976795313775106395,-43,-965,
 8952183438238375.,7550145116570426.,-.499500472816914189762,-43,-965,
 8954214000884692.,8860282019064038.,-.469660075825149941393,-43,-965,
 8954214000917820.,8860282042194185.,.499875744653180159932,-43,-965,
 8954214000917893.,8860282042245154.,.492992893998501309444,-43,-965,
 8954214000917903.,8860282042252137.,-.453155418874410794375,-43,-965,
 8954214000917932.,8860282042272385.,-.496985495092170868601,-43,-965,
 8954214000919417.,8860282043309220.,-.499946513274896668328,-43,-965,
 8955438287551924.,4878839080959657.,-.499947025655506350012,-43,-966,
 8955438287552039.,4878839081003869.,.499808406537911628121,-43,-966,
 8955438287552065.,4878839081013865.,.482361864131919485784,-43,-966,
 8955438287552078.,4878839081018863.,.473638600609003569189,-43,-966,
 8955438287556051.,4878839082546327.,-.499777352907449281148,-43,-966,
 8955438287613369.,4878839104582855.,-.443101502974948007261,-43,-966,
 8955628748487397.,4952616119299434.,-.485305079125907078340,-43,-966,
 8955628748509478.,4952616127917088.,-.498794817314556014188,-43,-966,
 8955628748511346.,4952616128646121.,-.499293381212892011906,-43,-966,
 8955628748516950.,4952616130833219.,.499854816019511470714,-43,-966,
 8955628748518290.,4952616131356187.,.497652893451510006598,-43,-966,
 8955628748518308.,4952616131363212.,.440907273355871279169,-43,-966,
 8955628748518483.,4952616131431511.,-.499674624877235907003,-43,-966,
 8959985196784881.,6981135103209888.,-.493747784486158302743,-43,-966,
 8959985196787433.,6981135104613808.,-.495547317926877080320,-43,-966,
 8959985196800831.,6981135111984387.,.499637125669789922322,-43,-966,
 8959985196801788.,6981135112510857.,.499590928408569557433,-43,-966,
 8959985196801796.,6981135112515259.,-.497274494203014242736,-43,-966,
 8959985196801860.,6981135112550467.,-.472197775215390390566,-43,-966,
 8959985196801868.,6981135112554868.,-.469063172856900627328,-43,-966,
 8962426859346884.,8462280614249243.,-.437474700357803561752,-43,-966,
 8962426859389487.,8462280642658721.,-.498982344711941694791,-43,-966,
 8962426859395412.,8462280646609761.,-.499277761791363496510,-43,-966,
 8962426859395545.,8462280646698451.,-.487448877650156124197,-43,-966,
 8962426859395659.,8462280646774471.,-.477309094272951141460,-43,-966,
 8962426859395672.,8462280646783139.,.471215661245181204642,-43,-966,
 8962426859395995.,8462280646998529.,.499948976753894358161,-43,-966,
 8966012136681064.,5612507118204378.,-.499073415351578362769,-43,-967,
 8966012136686995.,5612507120827511.,.499830214936367260632,-43,-967,
 8966012136688336.,5612507121420602.,.495199907753424920148,-43,-967,
 8966012136688347.,5612507121425468.,-.477992177142745521103,-43,-967,
 8966012136688376.,5612507121438294.,-.498225835291193659034,-43,-967,
 8966012136688823.,5612507121635991.,-.499754720361971226319,-43,-967,
 8969275689044218.,7258484290366882.,-.499867904092405396679,-43,-967,
 8969275689045848.,7258484291299211.,-.499815033706306207701,-43,-967,
 8969275689046425.,7258484291629244.,-.473387251231202209333,-43,-967,
 8969275689046426.,7258484291629816.,-.492405560939094030653,-43,-967,
 8969275689046479.,7258484291660130.,.499624089042216970722,-43,-967,
 8969275689056890.,7258484297615025.,-.497530463376002095639,-43,-967,
 8973743112284807.,5160659834998532.,.357591355992872660335,-43,-968,
 8973743112284861.,5160659835020492.,.474144632853348268907,-43,-968,
 8973743112284873.,5160659835025373.,-.499954626265140030622,-43,-968,
 8973743112294448.,5160659838919227.,-.498517615716866265899,-43,-968,
 8973743112330586.,5160659853615425.,-.466415385599738680579,-43,-968,
 8977737720437900.,7069900481835974.,-.499708206513041578724,-43,-968,
 8977737720441351.,7069900483758595.,.499886449073245633805,-43,-968,
 8977737720441509.,7069900483846621.,-.499829821114464068968,-43,-968,
 8977737720441559.,7069900483874477.,-.487081577060528482781,-43,-968,
 8977737720441567.,7069900483878933.,.474958152173372018515,-43,-968,
 8978413913667608.,7456838920238987.,-.499959468707162809898,-43,-968,
 8978413913668808.,7456838920944120.,.499053232228349751710,-43,-968,
 8978413913668826.,7456838920954698.,-.490961069664348520616,-43,-968,
 8978413913668911.,7456838921004645.,-.499361737013918924882,-43,-968,
 8978413913673917.,7456838923946229.,-.499403929539395298213,-43,-968,
 8979652206164545.,8221158654736991.,-.498509752988348213604,-43,-968,
 8979652206164564.,8221158654749299.,.487495010138994971399,-43,-968,
 8979652206164583.,8221158654761608.,.473499791695752163411,-43,-968,
 8979652206164690.,8221158654830927.,.499948116176547712117,-43,-968,
 8979652206165333.,8221158655247490.,-.499980951334568148369,-43,-968,
 8980869029263653.,4524249542216467.,-.499170425784297920192,-43,-969,
 8980869029270909.,4524249544803365.,.499951633614558753690,-43,-969,
 8980869029271312.,4524249544947042.,.497878975468072373418,-43,-969,
 8980869029271314.,4524249544947756.,-.464910455625936800871,-43,-969,
 8980869029271339.,4524249544956669.,-.499778334819233291783,-43,-969,
 8982476667097608.,5135290058826667.,.428075595980660428052,-43,-969,
 8982476667097629.,5135290058835165.,.490584670691631628559,-43,-969,
 8982476667097632.,5135290058836379.,.499514539655476427806,-43,-969,
 8982476667097744.,5135290058881702.,.499563186335321230518,-43,-969,
 8982476667098752.,5135290059289610.,-.499980993035111894745,-43,-969,
 8990158661607529.,4703671901737740.,-.498919348564301519459,-43,-970,
 8990158661607564.,4703671901750713.,-.490129428762040177996,-43,-970,
 8990158661607637.,4703671901777770.,.499632519108048699611,-43,-970,
 8990158661609003.,4703671902284088.,.499864250768466869691,-43,-970,
 8990158661610369.,4703671902790407.,-.499849515913109909243,-43,-970,
 8990158661620039.,4703671906374664.,-.497728846339486117690,-43,-970,
 8994909371864365.,6839451622330989.,-.457650865066260233554,-43,-970,
 8994909371897599.,6839451640242802.,-.497218880058206183049,-43,-970,
 8994909371908812.,6839451646286165.,.499803864638581488383,-43,-970,
 8994909371909015.,6839451646395574.,.479733181798881302743,-43,-970,
 8994909371909040.,6839451646409048.,.492039868994003149522,-43,-970,
 8994909371909065.,6839451646422523.,-.495653417266494397332,-43,-970,
 8994909371909217.,6839451646504444.,.499171973589693187749,-43,-970,
 8994909371910356.,6839451647118320.,.499901358429171528692,-43,-970,
 8994909371913444.,6839451648782631.,-.499599909487883532003,-43,-970,
 8995529652246672.,7182063315994533.,-.499005134170069313918,-43,-970,
 8995529652253335.,7182063319765517.,-.493558641838429570061,-43,-970,
 8995529652253359.,7182063319779100.,-.480478263461969684531,-43,-970,
 8995529652253554.,7182063319889462.,-.499199236863164234602,-43,-970,
 8995529652257299.,7182063322008978.,-.499434539853491084104,-43,-970,
 8995529652258904.,7182063322917342.,-.499343905787051022042,-43,-970,
 8997421512909510.,8336709289986388.,-.499891064422357859967,-43,-970,
 8997421512909642.,8336709290073104.,.498359456096568316440,-43,-970,
 8997421512910660.,8336709290741877.,-.499950923850713228925,-43,-970,
 8997421512922669.,8336709298631153.,-.495616048077816550061,-43,-970,
 8999158423446624.,4779772305988671.,-.499816935390269434721,-43,-971,
 8999158423446731.,4779772306028973.,-.496558076593852151391,-43,-971,
 8999158423446754.,4779772306037636.,-.449128557900034527407,-43,-971,
 8999158423446919.,4779772306099783.,.499822797429635945296,-43,-971,
 8999158423455205.,4779772309220741.,-.499071752815968489045,-43,-971,
 8999158423480063.,4779772318583612.,-.483528411993507582356,-43,-971,
 9000781172713929.,5431787826008698.,.499932794070619481143,-43,-971,
 9000781172714251.,5431787826146526.,-.495824777048767613882,-43,-971,
 9000781172714279.,5431787826158510.,.461066034216995088432,-43,-971,
 9000781172714280.,5431787826158938.,.495240706536997652445,-43,-971,
 9000781172714485.,5431787826246686.,-.498950755657214561378,-43,-971,
 9000781172745268.,5431787839422862.,-.483818282588662140967,-43,-971,
 9000781172763176.,5431787847088098.,-.459659759391467863297,-43,-971 };
#define pow2_x(x) pow(2.0,x)
#include "trailer.h"
