<?php
/**
 * CKEditor - The text editor for the Internet - http://ckeditor.com
 * Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * @file
 * CKEditor Module for Drupal 6.x
 *
 * This module allows Drupal to replace textarea fields with CKEditor.
 *
 * This HTML text editor brings to the web many of the powerful functionalities
 * of known desktop editors like Word. It's really  lightweight and doesn't
 * require any kind of installation on the client computer.
 */

/**
 * @file
 * Drush integration for the ckeditor module.
 */

/**
 * Implements hook_drush_command().
 */
function ckeditor_drush_command() {
  $items['ckeditor-download'] = array(
    'callback' => 'ckeditor_drush_download',
    'description' => dt('Downloads the required CKEditor library from svn.fckeditor.net.'),
    'arguments' => array(
      'path' => dt('Optional. A path to the download folder. If omitted Drush will use the default location (sites/all/libraries/ckeditor).'),
    ),
  );
  return $items;
}

/**
 * Downloads
 */
function ckeditor_drush_download() {
  $args = func_get_args();
  if ($args[0]) {
    $path = $args[0];
  }
  else {
    $path = drush_get_context('DRUSH_DRUPAL_ROOT') . '/sites/all/libraries/ckeditor';
  }

  if (drush_shell_exec('svn checkout http://svn.fckeditor.net/CKEditor/releases/stable/ ' . $path)) {
    drush_log(dt('CKEditor has been downloaded to @path.', array('@path' => $path)), 'success');
  }
  else {
    drush_log(dt('Drush was unable to download the CKEditor to @path.', array('@path' => $path)), 'error');
  }
}

/**
 * Implements drush_MODULE_post_COMMAND().
 */
function drush_ckeditor_post_enable() {
  $modules = func_get_args();
  if (in_array('ckeditor', $modules)) {
    ckeditor_drush_download();
  }
}
