#!/usr/bin/env python

# "Optional option arguments" with Optik, version 2:
# override OptionParser's argument-processing methods
# to completely replace Optik's core parsing logic.

import optik

class Option (optik.Option):

    # ??? what else is needed ???

    def requires_value (self):          # now all option args are optional 
        return 0                        # -- not right, but it'll do for now!


class OptionParser (optik.OptionParser):
    
    def _process_long_opt (self, rargs, values):

        # Value explicitly attached to arg?  Split it off and
        # keep it in waiting.
        if "=" in arg:
            (opt, next) = arg.split("=", 1)
            rargs.insert(0, next)
            had_explicit_value = 1
        else:
            opt = arg
            had_explicit_value = 0

        opt = self._match_long_opt(opt)
        option = self._long_opt[opt]

        # Three basic cases for the Option here:
        #   1) it requires a value
        #   2) it takes no value
        #   3) it takes an optional value
        if option.takes_value():
            nargs = option.nargs
            if len(rargs) < nargs:      # don't have enough arguments
                if option.requires_value():
                    if nargs == 1:
                        self.error("%s option requires a value" % opt)
                    else:
                        self.error("%s option requires %d values"
                                   % (opt, nargs))
                else:
                    value = None
            elif nargs == 1:            # need one argument and have it
                value = rargs.pop()
            else:                       # need multiple args (and have them)
                value = tuple(rargs[0:nargs])
                del rargs[0:nargs]

        elif had_explicit_value:
            self.error("%s option does not take a value" % opt)
        else:
            value = None
                
        option.process(opt, value, values, self)

    def _process_short_opts (self, rargs, values):


                
            
            
        
