/* telepathy-glib.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Tp", lower_case_cprefix = "tp_", gir_namespace = "TelepathyGLib", gir_version = "0.12")]
namespace TelepathyGLib {
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Account : TelepathyGLib.Proxy {
		public TelepathyGLib.AccountPrivate priv;
		[CCode (has_construct_function = false)]
		public Account (TelepathyGLib.DBusDaemon bus_daemon, string object_path) throws GLib.Error;
		public bool associated_with_uri_scheme (string scheme);
		public unowned GLib.Binding bind_connection_status_to_property (void* target, string target_property, bool invert);
		public unowned TelepathyGLib.Connection ensure_connection (string path);
		public TelepathyGLib.ConnectionPresenceType get_automatic_presence (out unowned string status, out string status_message);
		public async unowned GLib.Array<weak uint8> get_avatar_async () throws GLib.Error;
		public bool get_changing_presence ();
		public bool get_connect_automatically ();
		public unowned TelepathyGLib.Connection get_connection ();
		public unowned string get_connection_manager ();
		public TelepathyGLib.ConnectionStatus get_connection_status (out TelepathyGLib.ConnectionStatusReason reason);
		public TelepathyGLib.ConnectionPresenceType get_current_presence (out string status, out string status_message);
		public unowned string get_display_name ();
		public static GLib.Quark get_feature_quark_addressing ();
		public static GLib.Quark get_feature_quark_core ();
		public static GLib.Quark get_feature_quark_storage ();
		public bool get_has_been_online ();
		public unowned string get_icon_name ();
		public unowned string get_nickname ();
		public unowned string get_normalized_name ();
		public unowned GLib.HashTable<weak string,weak GLib.Value> get_parameters ();
		public unowned string get_path_suffix ();
		public unowned string get_protocol ();
		public TelepathyGLib.ConnectionPresenceType get_requested_presence (out unowned string status, out string status_message);
		public unowned string get_service ();
		public GLib.Value get_storage_identifier ();
		public unowned string get_storage_provider ();
		public TelepathyGLib.StorageRestrictionFlags get_storage_restrictions ();
		public async unowned GLib.HashTable<weak string,weak GLib.Value> get_storage_specific_information_async () throws GLib.Error;
		public unowned string[] get_uri_schemes ();
		public static void init_known_interfaces ();
		public bool is_enabled ();
		public bool is_valid ();
		public static bool parse_object_path (string object_path, out string cm, out string protocol, out string account_id) throws GLib.Error;
		public async bool reconnect_async () throws GLib.Error;
		public async bool remove_async () throws GLib.Error;
		public async bool request_presence_async (TelepathyGLib.ConnectionPresenceType type, string status, string message) throws GLib.Error;
		public async bool set_automatic_presence_async (TelepathyGLib.ConnectionPresenceType type, string status, string message) throws GLib.Error;
		public async bool set_avatar_async ([CCode (array_length_cname = "len", array_length_pos = 1.5)] uint8[]? avatar, string? mime_type) throws GLib.Error;
		public async bool set_connect_automatically_async (bool connect_automatically) throws GLib.Error;
		public async bool set_display_name_async (string display_name) throws GLib.Error;
		public async bool set_enabled_async (bool enabled) throws GLib.Error;
		public async bool set_icon_name_async (string icon_name) throws GLib.Error;
		public async bool set_nickname_async (string nickname) throws GLib.Error;
		public async bool set_service_async (string service) throws GLib.Error;
		public async bool set_uri_scheme_association_async (string scheme, bool associate) throws GLib.Error;
		public async bool update_parameters_async (GLib.HashTable<weak string,weak GLib.Value> parameters, string unset_parameters, [CCode (array_length = false)] out string[] reconnect_required) throws GLib.Error;
		[NoAccessorMethod]
		public uint automatic_presence_type { get; }
		[NoAccessorMethod]
		public string automatic_status { get; }
		[NoAccessorMethod]
		public string automatic_status_message { get; }
		public bool changing_presence { get; }
		public bool connect_automatically { get; }
		public TelepathyGLib.Connection connection { get; }
		[NoAccessorMethod]
		public string connection_error { get; }
		[NoAccessorMethod]
		public GLib.HashTable<weak void*,weak void*> connection_error_details { get; }
		public string connection_manager { get; }
		public uint connection_status { get; }
		[NoAccessorMethod]
		public uint connection_status_reason { get; }
		[NoAccessorMethod]
		public uint current_presence_type { get; }
		[NoAccessorMethod]
		public string current_status { get; }
		[NoAccessorMethod]
		public string current_status_message { get; }
		public string display_name { get; }
		[NoAccessorMethod]
		public bool enabled { get; }
		public bool has_been_online { get; }
		public string icon_name { get; }
		public string nickname { get; }
		public string normalized_name { get; }
		public string protocol { get; }
		[NoAccessorMethod]
		public uint requested_presence_type { get; }
		[NoAccessorMethod]
		public string requested_status { get; }
		[NoAccessorMethod]
		public string requested_status_message { get; }
		public string service { get; }
		public GLib.Value storage_identifier { get; }
		public string storage_provider { get; }
		public uint storage_restrictions { get; }
		[NoAccessorMethod]
		public bool valid { get; }
		public signal void presence_changed (uint presence, string status, string status_message);
		public signal void status_changed (uint old_status, uint new_status, uint reason, string? dbus_error_name, GLib.HashTable<weak string,weak GLib.Value> details);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class AccountChannelRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		public AccountChannelRequest (TelepathyGLib.Account account, GLib.HashTable<weak string,weak GLib.Value> request, int64 user_action_time);
		public async TelepathyGLib.Channel create_and_handle_channel_async (GLib.Cancellable? cancellable, out TelepathyGLib.HandleChannelsContext? context) throws GLib.Error;
		public async TelepathyGLib.Channel create_and_observe_channel_async (string preferred_handler, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool create_channel_async (string preferred_handler, GLib.Cancellable? cancellable) throws GLib.Error;
		public async TelepathyGLib.Channel ensure_and_handle_channel_async (GLib.Cancellable? cancellable, out TelepathyGLib.HandleChannelsContext? context) throws GLib.Error;
		public async TelepathyGLib.Channel ensure_and_observe_channel_async (string preferred_handler, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool ensure_channel_async (string preferred_handler, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned TelepathyGLib.Account get_account ();
		public unowned TelepathyGLib.ChannelRequest get_channel_request ();
		public unowned GLib.HashTable<weak void*,weak void*> get_request ();
		public int64 get_user_action_time ();
		public void set_channel_factory (TelepathyGLib.ClientChannelFactory factory);
		public void set_hints (GLib.HashTable<weak void*,weak void*> hints);
		public TelepathyGLib.Account account { get; construct; }
		public TelepathyGLib.ChannelRequest channel_request { get; }
		public int64 user_action_time { get; construct; }
		public signal void re_handled (TelepathyGLib.Channel channel, int64 user_action_time, TelepathyGLib.HandleChannelsContext context);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class AccountManager : TelepathyGLib.Proxy {
		public TelepathyGLib.AccountManagerPrivate priv;
		[CCode (has_construct_function = false)]
		public AccountManager (TelepathyGLib.DBusDaemon bus_daemon);
		public async unowned TelepathyGLib.Account create_account_async (string connection_manager, string protocol, string display_name, GLib.HashTable<weak string,weak GLib.Value> parameters, GLib.HashTable<weak string,weak GLib.Value> properties) throws GLib.Error;
		public static TelepathyGLib.AccountManager dup ();
		public void enable_restart ();
		public unowned TelepathyGLib.Account ensure_account (string path);
		public static GLib.Quark get_feature_quark_core ();
		public TelepathyGLib.ConnectionPresenceType get_most_available_presence (out string status, out string message);
		public GLib.List<weak TelepathyGLib.Account> get_valid_accounts ();
		public static void init_known_interfaces ();
		public void set_all_requested_presences (TelepathyGLib.ConnectionPresenceType type, string status, string message);
		public signal void account_disabled (TelepathyGLib.Account account);
		public signal void account_enabled (TelepathyGLib.Account account);
		public signal void account_removed (TelepathyGLib.Account account);
		public signal void account_validity_changed (TelepathyGLib.Account account, bool valid);
		public signal void most_available_presence_changed (uint presence, string status, string message);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class AddDispatchOperationContext : GLib.Object {
		public void accept ();
		public void delay ();
		public void fail (GLib.Error error);
		[NoAccessorMethod]
		public TelepathyGLib.Account account { get; construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<weak void*> channels { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.Connection connection { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.ChannelDispatchOperation dispatch_operation { get; construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class AutomaticProxyFactory : GLib.Object, TelepathyGLib.ClientChannelFactory {
		[CCode (has_construct_function = false)]
		public AutomaticProxyFactory ();
		public static TelepathyGLib.AutomaticProxyFactory dup ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_avatar_requirements_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class AvatarRequirements {
		public void* _1;
		public void* _2;
		public void* _3;
		public void* _4;
		public uint maximum_bytes;
		public uint maximum_height;
		public uint maximum_width;
		public uint minimum_height;
		public uint minimum_width;
		public uint recommended_height;
		public uint recommended_width;
		[CCode (array_length = false)]
		public weak string[] supported_mime_types;
		public TelepathyGLib.AvatarRequirements copy ();
		public void destroy ();
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class BaseClient : GLib.Object {
		public TelepathyGLib.BaseClientPrivate priv;
		public void add_account_features ([CCode (array_length_cname = "n")] GLib.Quark[] features);
		public void add_approver_filter (GLib.HashTable<weak string,weak GLib.Value> filter);
		public void add_channel_features ([CCode (array_length_cname = "n")] GLib.Quark[] features);
		public void add_connection_features ([CCode (array_length_cname = "n")] GLib.Quark[] features);
		public void add_handler_capabilities ([CCode (array_length = false)] string[] tokens);
		public void add_handler_capability (string token);
		public void add_handler_filter (GLib.HashTable<weak string,weak GLib.Value> filter);
		public void add_observer_filter (GLib.HashTable<weak string,weak GLib.Value> filter);
		public void be_a_handler ();
		public unowned string get_bus_name ();
		public GLib.List<weak TelepathyGLib.Channel> get_handled_channels ();
		public unowned string get_object_path ();
		public GLib.List<weak TelepathyGLib.ChannelRequest> get_pending_requests ();
		public bool is_handling_channel (TelepathyGLib.Channel channel);
		public bool register () throws GLib.Error;
		public void set_channel_factory (TelepathyGLib.ClientChannelFactory factory);
		public void set_handler_bypass_approval (bool bypass_approval);
		public void set_handler_request_notification ();
		public void set_observer_delay_approvers (bool delay);
		public void set_observer_recover (bool recover);
		public void unregister ();
		[NoAccessorMethod]
		public TelepathyGLib.AccountManager account_manager { get; construct; }
		[NoAccessorMethod]
		public GLib.Object channel_factory { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.DBusDaemon dbus_daemon { get; construct; }
		[NoAccessorMethod]
		public string name { get; construct; }
		[NoAccessorMethod]
		public bool uniquify_name { get; construct; }
		public signal void request_added (TelepathyGLib.Account account, TelepathyGLib.ChannelRequest request);
		public signal void request_removed (TelepathyGLib.ChannelRequest request, string error, string message);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class BaseConnection : GLib.Object {
		public void* _future1;
		public void* _future2;
		public void* _future3;
		public void* _future4;
		public weak string bus_name;
		public weak string object_path;
		public TelepathyGLib.BaseConnectionPrivate priv;
		public TelepathyGLib.Handle self_handle;
		public TelepathyGLib.ConnectionStatus status;
		public void add_client_interest (string unique_name, string token, bool only_if_uninterested);
		public void add_possible_client_interest (GLib.Quark token);
		public void change_status (TelepathyGLib.ConnectionStatus status, TelepathyGLib.ConnectionStatusReason reason);
		public unowned TelepathyGLib.HandleRepoIface get_handles (TelepathyGLib.HandleType handle_type);
		public bool register (string cm_name, out string bus_name, out string object_path) throws GLib.Error;
		public void set_self_handle (TelepathyGLib.Handle self_handle);
		[NoAccessorMethod]
		public bool has_immortal_handles { get; }
		public signal void clients_interested (string token);
		public signal void clients_uninterested (string token);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class BasicProxyFactory : GLib.Object, TelepathyGLib.ClientChannelFactory {
		[CCode (has_construct_function = false)]
		public BasicProxyFactory ();
		public static TelepathyGLib.BasicProxyFactory dup ();
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Capabilities : GLib.Object {
		public unowned GLib.GenericArray<weak void*> get_channel_classes ();
		public bool is_specific_to_contact ();
		public bool supports_contact_search (out bool with_limit, out bool with_server);
		public bool supports_dbus_tubes (TelepathyGLib.HandleType handle_type, string service_name);
		public bool supports_room_list (out bool with_server);
		public bool supports_stream_tubes (TelepathyGLib.HandleType handle_type, string service);
		public bool supports_text_chatrooms ();
		public bool supports_text_chats ();
		[NoAccessorMethod]
		public bool contact_specific { get; construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Channel : TelepathyGLib.Proxy {
		public TelepathyGLib.ChannelPrivate priv;
		[CCode (has_construct_function = false)]
		public Channel (TelepathyGLib.Connection conn, string object_path, string optional_channel_type, TelepathyGLib.HandleType optional_handle_type, TelepathyGLib.Handle optional_handle) throws GLib.Error;
		public unowned TelepathyGLib.Connection borrow_connection ();
		public unowned GLib.HashTable<weak string,weak GLib.Value> borrow_immutable_properties ();
		public async bool close_async () throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Channel.from_properties (TelepathyGLib.Connection conn, string object_path, GLib.HashTable<weak string,weak GLib.Value> immutable_properties) throws GLib.Error;
		public unowned string get_channel_type ();
		public GLib.Quark get_channel_type_id ();
		public TelepathyGLib.ChannelChatState get_chat_state (TelepathyGLib.Handle contact);
		public static GLib.Quark get_feature_quark_chat_states ();
		public static GLib.Quark get_feature_quark_core ();
		public static GLib.Quark get_feature_quark_group ();
		public TelepathyGLib.Handle get_handle (out TelepathyGLib.HandleType handle_type);
		public unowned string get_identifier ();
		public TelepathyGLib.ChannelGroupFlags group_get_flags ();
		public TelepathyGLib.Handle group_get_handle_owner (TelepathyGLib.Handle handle);
		public unowned TelepathyGLib.Intset group_get_local_pending ();
		public bool group_get_local_pending_info (TelepathyGLib.Handle local_pending, TelepathyGLib.Handle actor, TelepathyGLib.ChannelGroupChangeReason reason, string message);
		public unowned TelepathyGLib.Intset group_get_members ();
		public unowned TelepathyGLib.Intset group_get_remote_pending ();
		public TelepathyGLib.Handle group_get_self_handle ();
		public static void init_known_interfaces ();
		public async bool leave_async (TelepathyGLib.ChannelGroupChangeReason reason, string message) throws GLib.Error;
		[NoAccessorMethod]
		public bool channel_ready { get; }
		[NoAccessorMethod]
		public TelepathyGLib.Connection connection { get; construct; }
		[NoAccessorMethod]
		public uint group_flags { get; }
		[NoAccessorMethod]
		public uint group_self_handle { get; }
		public string identifier { get; }
		[NoAccessorMethod]
		public uint initiator_handle { get; }
		[NoAccessorMethod]
		public string initiator_identifier { get; }
		[NoAccessorMethod]
		public bool requested { get; }
		public signal void chat_state_changed (uint contact, uint state);
		public signal void group_flags_changed (uint added, uint removed);
		public signal void group_members_changed_detailed (GLib.Array<weak uint> added, GLib.Array<weak uint> removed, GLib.Array<weak uint> local_pending, GLib.Array<weak uint> remote_pending, GLib.HashTable<weak string,weak GLib.Value> details);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ChannelDispatchOperation : TelepathyGLib.Proxy {
		public TelepathyGLib.ChannelDispatchOperationPrivate priv;
		[CCode (has_construct_function = false)]
		public ChannelDispatchOperation (TelepathyGLib.DBusDaemon bus_daemon, string object_path, GLib.HashTable<weak void*,weak void*> immutable_properties) throws GLib.Error;
		public async bool claim_async () throws GLib.Error;
		public static GLib.Quark get_feature_quark_core ();
		public async bool handle_with_async (string? handler) throws GLib.Error;
		public async bool handle_with_time_async (string? handler, int64 user_action_time) throws GLib.Error;
		public static void init_known_interfaces ();
		[NoAccessorMethod]
		public TelepathyGLib.Account account { get; construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<weak void*> channels { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.Connection connection { get; construct; }
		[NoAccessorMethod]
		public string[] possible_handlers { get; }
		public signal void channel_lost (TelepathyGLib.Channel channel, uint domain, int code, string message);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ChannelRequest : TelepathyGLib.Proxy {
		public TelepathyGLib.ChannelRequestPrivate priv;
		[CCode (has_construct_function = false)]
		public ChannelRequest (TelepathyGLib.DBusDaemon bus_daemon, string object_path, GLib.HashTable<weak void*,weak void*> immutable_properties) throws GLib.Error;
		public unowned GLib.HashTable<weak void*,weak void*> get_hints ();
		public unowned GLib.HashTable<weak void*,weak void*> get_immutable_properties ();
		public static void init_known_interfaces ();
		public void set_channel_factory (TelepathyGLib.ClientChannelFactory factory);
		[NoAccessorMethod]
		public GLib.Object channel_factory { get; set construct; }
		public signal void succeeded ();
		public signal void succeeded_with_channel (TelepathyGLib.Connection connection, TelepathyGLib.Channel channel);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ClientMessage : TelepathyGLib.Message {
		[CCode (type = "TpMessage*", has_construct_function = false)]
		public ClientMessage ();
		[CCode (type = "TpMessage*", has_construct_function = false)]
		public ClientMessage.text (TelepathyGLib.ChannelTextMessageType type, string text);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Connection : TelepathyGLib.Proxy {
		public TelepathyGLib.ConnectionPrivate priv;
		[CCode (has_construct_function = false)]
		public Connection (TelepathyGLib.DBusDaemon dbus, string? bus_name, string? object_path) throws GLib.Error;
		public void add_client_interest (string interested_in);
		public unowned GLib.Binding bind_connection_status_to_property (void* target, string target_property, bool invert);
		public TelepathyGLib.Contact dup_contact_if_possible (TelepathyGLib.Handle handle, string identifier);
		public TelepathyGLib.AvatarRequirements get_avatar_requirements ();
		public unowned TelepathyGLib.Capabilities get_capabilities ();
		public unowned string get_connection_manager_name ();
		public void get_contact_attributes (int timeout_ms, [CCode (array_length_cname = "n_handles", array_length_pos = 1.5)] TelepathyGLib.Handle[] handles, string interfaces, bool hold, [CCode (delegate_target_pos = 5.33333)] owned GLib.Callback callback, GLib.Object weak_object);
		public TelepathyGLib.ContactInfoFlags get_contact_info_flags ();
		public GLib.List<weak TelepathyGLib.ContactInfoFieldSpec> get_contact_info_supported_fields ();
		public void get_contact_list_attributes (int timeout_ms, string interfaces, bool hold, [CCode (delegate_target_pos = 4.33333)] owned GLib.Callback callback, GLib.Object weak_object);
		public void get_contacts_by_handle ([CCode (array_length_cname = "n_handles", array_length_pos = 0.5)] uint[] handles, [CCode (array_length_cname = "n_features", array_length_pos = 1.5)] uint[]? features, [CCode (delegate_target_pos = 3.33333)] owned TelepathyGLib.ConnectionContactsByHandleCb callback, GLib.Object? weak_object);
		public void get_contacts_by_id ([CCode (array_length_cname = "n_ids", array_length_pos = 0.5)] string[] ids, [CCode (array_length_cname = "n_features", array_length_pos = 1.5)] TelepathyGLib.ContactFeature[]? features, [CCode (delegate_target_pos = 3.33333)] owned TelepathyGLib.ConnectionContactsByIdCb callback, GLib.Object? weak_object);
		public unowned string get_detailed_error (out unowned GLib.HashTable<weak string,weak GLib.Value>? details);
		public static GLib.Quark get_feature_quark_avatar_requirements ();
		public static GLib.Quark get_feature_quark_capabilities ();
		public static GLib.Quark get_feature_quark_connected ();
		public static GLib.Quark get_feature_quark_contact_info ();
		public static GLib.Quark get_feature_quark_core ();
		public unowned string get_protocol_name ();
		public unowned TelepathyGLib.Contact get_self_contact ();
		public TelepathyGLib.Handle get_self_handle ();
		public TelepathyGLib.ConnectionStatus get_status (out TelepathyGLib.ConnectionStatusReason reason);
		public bool has_immortal_handles ();
		public void hold_handles (int timeout_ms, TelepathyGLib.HandleType handle_type, [CCode (array_length_cname = "n_handles", array_length_pos = 2.5)] TelepathyGLib.Handle[] handles, [CCode (delegate_target_pos = 4.33333)] owned TelepathyGLib.ConnectionHoldHandlesCb callback, GLib.Object weak_object);
		public static void init_known_interfaces ();
		public bool parse_object_path (out string protocol, out string cm_name);
		public static int presence_type_cmp_availability (TelepathyGLib.ConnectionPresenceType p1, TelepathyGLib.ConnectionPresenceType p2);
		public void refresh_contact_info ([CCode (array_length_cname = "n_contacts", array_length_pos = 0.5)] TelepathyGLib.Contact[] contacts);
		public void request_handles (int timeout_ms, TelepathyGLib.HandleType handle_type, [CCode (array_length = false)] string[] ids, [CCode (delegate_target_pos = 4.33333)] owned TelepathyGLib.ConnectionRequestHandlesCb callback, GLib.Object weak_object);
		public async bool set_contact_info_async (GLib.List<weak TelepathyGLib.ContactInfoField> info) throws GLib.Error;
		public void unref_handles (TelepathyGLib.HandleType handle_type, [CCode (array_length_cname = "n_handles", array_length_pos = 1.5)] TelepathyGLib.Handle[] handles);
		public void upgrade_contacts ([CCode (array_length_cname = "n_contacts", array_length_pos = 0.5)] TelepathyGLib.Contact[] contacts, [CCode (array_length_cname = "n_features", array_length_pos = 1.5)] TelepathyGLib.ContactFeature[] features, [CCode (delegate_target_pos = 3.33333)] owned TelepathyGLib.ConnectionUpgradeContactsCb callback, GLib.Object? weak_object);
		public TelepathyGLib.Capabilities capabilities { get; }
		public string connection_manager_name { get; }
		[NoAccessorMethod]
		public bool connection_ready { get; }
		public string protocol_name { get; }
		public TelepathyGLib.Contact self_contact { get; }
		public uint self_handle { get; }
		public uint status { get; }
		[NoAccessorMethod]
		public uint status_reason { get; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ConnectionManager : TelepathyGLib.Proxy {
		public weak string name;
		public TelepathyGLib.ConnectionManagerPrivate priv;
		public weak TelepathyGLib.ConnectionManagerProtocol protocols;
		public uint reserved_flags;
		public uint running;
		[CCode (has_construct_function = false)]
		public ConnectionManager (TelepathyGLib.DBusDaemon dbus, string name, string? manager_filename) throws GLib.Error;
		public static bool check_valid_name (string name) throws GLib.Error;
		public static bool check_valid_protocol_name (string name) throws GLib.Error;
		public string[] dup_protocol_names ();
		public static GLib.Quark get_feature_quark_core ();
		public TelepathyGLib.CMInfoSource get_info_source ();
		public unowned string get_name ();
		public unowned TelepathyGLib.ConnectionManagerProtocol get_protocol (string protocol);
		public unowned TelepathyGLib.Protocol get_protocol_object (string protocol);
		public bool has_protocol (string protocol);
		public static void init_known_interfaces ();
		public bool is_running ();
		[NoAccessorMethod]
		public bool always_introspect { get; set; }
		[NoAccessorMethod]
		public string connection_manager { get; }
		public uint info_source { get; }
		[NoAccessorMethod]
		public string manager_file { get; set construct; }
		public signal void activated ();
		public signal void exited ();
		public signal void got_info (uint source);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_connection_manager_param_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ConnectionManagerParam {
		public weak string dbus_signature;
		public GLib.Value default_value;
		public uint flags;
		public weak string name;
		public void* priv;
		public TelepathyGLib.ConnectionManagerParam copy ();
		public void free ();
		public unowned string get_dbus_signature ();
		public bool get_default (GLib.Value value);
		public unowned string get_name ();
		public bool is_dbus_property ();
		public bool is_required ();
		public bool is_required_for_registration ();
		public bool is_secret ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_connection_manager_protocol_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ConnectionManagerProtocol {
		public weak string name;
		public weak TelepathyGLib.ConnectionManagerParam @params;
		public void* priv;
		public bool can_register ();
		public TelepathyGLib.ConnectionManagerProtocol copy ();
		public string[] dup_param_names ();
		public void free ();
		public unowned TelepathyGLib.ConnectionManagerParam get_param (string param);
		public bool has_param (string param);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Contact : GLib.Object {
		public unowned string get_alias ();
		public unowned GLib.File get_avatar_file ();
		public unowned string get_avatar_mime_type ();
		public unowned string get_avatar_token ();
		public unowned TelepathyGLib.Capabilities get_capabilities ();
		public unowned string[] get_client_types ();
		public unowned TelepathyGLib.Connection get_connection ();
		public unowned string[] get_contact_groups ();
		public GLib.List<weak TelepathyGLib.ContactInfoField> get_contact_info ();
		public TelepathyGLib.Handle get_handle ();
		public unowned string get_identifier ();
		public unowned GLib.HashTable<weak string,weak GLib.Value> get_location ();
		public unowned string get_presence_message ();
		public unowned string get_presence_status ();
		public TelepathyGLib.ConnectionPresenceType get_presence_type ();
		public unowned string get_publish_request ();
		public TelepathyGLib.SubscriptionState get_publish_state ();
		public TelepathyGLib.SubscriptionState get_subscribe_state ();
		public bool has_feature (TelepathyGLib.ContactFeature feature);
		public async bool request_contact_info_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool set_contact_groups_async ([CCode (array_length_cname = "n_groups", array_length_pos = 0.5)] string[]? groups) throws GLib.Error;
		public string alias { get; }
		public GLib.File avatar_file { get; }
		public string avatar_mime_type { get; }
		public string avatar_token { get; }
		public TelepathyGLib.Capabilities capabilities { get; }
		public string[] client_types { get; }
		public TelepathyGLib.Connection connection { get; }
		public string[] contact_groups { get; }
		public TelepathyGLib.ContactInfoList contact_info { get; }
		public uint handle { get; }
		public string identifier { get; }
		public string presence_message { get; }
		public string presence_status { get; }
		public uint presence_type { get; }
		public string publish_request { get; }
		public uint publish_state { get; }
		public uint subscribe_state { get; }
		public signal void contact_groups_changed (string[] added, string[] removed);
		public signal void presence_changed (uint type, string status, string message);
		public signal void subscription_states_changed (uint subscribe, uint publish, string publish_request);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_contact_info_field_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactInfoField {
		public weak string field_name;
		[CCode (array_length = false)]
		public weak string[] field_value;
		[CCode (array_length = false)]
		public weak string[] parameters;
		public void* priv;
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_contact_info_field_spec_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactInfoFieldSpec {
		public TelepathyGLib.ContactInfoFieldFlags flags;
		public uint max;
		public weak string name;
		[CCode (array_length = false)]
		public weak string[] parameters;
		public void* priv;
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_contact_info_list_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactInfoList {
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_contact_info_spec_list_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactInfoSpecList {
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactSearch : GLib.Object, GLib.AsyncInitable {
		public TelepathyGLib.ContactSearchPrivate priv;
		public unowned TelepathyGLib.Account get_account ();
		public uint get_limit ();
		public unowned string[] get_search_keys ();
		public unowned string get_server ();
		public static async void new_async (TelepathyGLib.Account account, string server, uint limit) throws GLib.Error;
		public async unowned string[] reset_async (string server, uint limit) throws GLib.Error;
		public void start (GLib.HashTable<weak string,weak string> criteria);
		public TelepathyGLib.Account account { get; construct; }
		public uint limit { get; set; }
		public string server { get; construct; }
		[NoAccessorMethod]
		public uint state { get; }
		public signal void search_results_received (GLib.List<weak TelepathyGLib.ContactSearchResult> results);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ContactSearchResult : GLib.Object {
		public TelepathyGLib.ContactSearchResultPrivate priv;
		public unowned TelepathyGLib.ContactInfoField get_field (string field);
		public GLib.List<weak TelepathyGLib.ContactInfoField> get_fields ();
		public unowned string get_identifier ();
		public string identifier { get; construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class DBusDaemon : TelepathyGLib.Proxy {
		public static TelepathyGLib.DBusDaemon dup () throws GLib.Error;
		public unowned string get_unique_name ();
		public static void init_known_interfaces ();
		public void list_activatable_names (int timeout_ms, [CCode (delegate_target_pos = 2.33333)] owned TelepathyGLib.DBusDaemonListNamesCb callback, GLib.Object weak_object);
		public void list_names (int timeout_ms, [CCode (delegate_target_pos = 2.33333)] owned TelepathyGLib.DBusDaemonListNamesCb callback, GLib.Object weak_object);
		public void register_object (string object_path, GLib.Object object);
		public bool release_name (string well_known_name) throws GLib.Error;
		public bool request_name (string well_known_name, bool idempotent) throws GLib.Error;
		public void unregister_object (GLib.Object object);
		public void watch_name_owner (string name, [CCode (delegate_target_pos = 2.1)] owned TelepathyGLib.DBusDaemonNameOwnerChangedCb callback);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class HandleChannelsContext : GLib.Object {
		public void accept ();
		public void delay ();
		public void fail (GLib.Error error);
		public unowned GLib.HashTable<weak string,weak GLib.Value> get_handler_info ();
		public GLib.List<TelepathyGLib.ChannelRequest> get_requests ();
		[NoAccessorMethod]
		public TelepathyGLib.Account account { get; construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<weak void*> channels { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.Connection connection { get; construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<weak void*> requests_satisfied { get; construct; }
		[NoAccessorMethod]
		public int64 user_action_time { get; construct; }
		public signal void done ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_handle_set_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class HandleSet {
		public string dump ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "tp_intset_get_type ()", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Intset {
		public void add (uint element);
		public void clear ();
		public TelepathyGLib.Intset copy ();
		public void destroy ();
		public TelepathyGLib.Intset difference (TelepathyGLib.Intset right);
		public void difference_update (TelepathyGLib.Intset other);
		public string dump ();
		public void @foreach (TelepathyGLib.IntFunc func);
		public static TelepathyGLib.Intset from_array (GLib.Array<weak uint> array);
		public TelepathyGLib.Intset intersection (TelepathyGLib.Intset right);
		public bool is_empty ();
		public bool is_equal (TelepathyGLib.Intset right);
		public bool is_member (uint element);
		public bool remove (uint element);
		public uint size ();
		public TelepathyGLib.Intset symmetric_difference (TelepathyGLib.Intset right);
		public GLib.Array<uint> to_array ();
		public TelepathyGLib.Intset union (TelepathyGLib.Intset right);
		public void union_update (TelepathyGLib.Intset other);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Message : GLib.Object {
		public uint append_part ();
		public uint count_parts ();
		public bool delete_key (uint part, string key);
		public void delete_part (uint part);
		public void destroy ();
		public TelepathyGLib.ChannelTextMessageType get_message_type ();
		public int64 get_received_timestamp ();
		public int64 get_sent_timestamp ();
		public unowned string get_specific_to_interface ();
		public unowned string get_supersedes ();
		public unowned string get_token ();
		public bool is_delivery_report ();
		public bool is_mutable ();
		public bool is_rescued ();
		public bool is_scrollback ();
		public unowned GLib.HashTable<weak string,weak GLib.Value> peek (uint part);
		public void ref_handle (TelepathyGLib.HandleType handle_type, TelepathyGLib.Handle handle);
		public void @set (uint part, string key, GLib.Value source);
		public void set_boolean (uint part, string key, bool b);
		public void set_bytes (uint part, string key, uint len, void* bytes);
		public void set_handle (uint part, string key, TelepathyGLib.HandleType handle_type, TelepathyGLib.Handle handle_or_0);
		public void set_int32 (uint part, string key, int32 i);
		public void set_int64 (uint part, string key, int64 i);
		public void set_string (uint part, string key, string s);
		public void set_uint32 (uint part, string key, uint32 u);
		public void set_uint64 (uint part, string key, uint64 u);
		public void take_message (uint part, string key, TelepathyGLib.Message message);
		public string to_text (out TelepathyGLib.ChannelTextMessageFlags out_flags);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class ObserveChannelsContext : GLib.Object {
		public void accept ();
		public void delay ();
		public void fail (GLib.Error error);
		public GLib.List<TelepathyGLib.ChannelRequest> get_requests ();
		public bool is_recovering ();
		[NoAccessorMethod]
		public TelepathyGLib.Account account { get; construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<weak void*> channels { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.Connection connection { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.ChannelDispatchOperation dispatch_operation { get; construct; }
		public GLib.GenericArray<weak void*> requests { get; construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Protocol : TelepathyGLib.Proxy {
		public TelepathyGLib.ProtocolPrivate priv;
		[CCode (has_construct_function = false)]
		public Protocol (TelepathyGLib.DBusDaemon dbus, string cm_name, string protocol_name, GLib.HashTable<weak void*,weak void*> immutable_properties) throws GLib.Error;
		public bool can_register ();
		public string[] dup_param_names ();
		public unowned string[] get_authentication_types ();
		public unowned TelepathyGLib.Capabilities get_capabilities ();
		public unowned string get_english_name ();
		public static GLib.Quark get_feature_quark_core ();
		public static GLib.Quark get_feature_quark_parameters ();
		public unowned string get_icon_name ();
		public unowned string get_name ();
		public unowned TelepathyGLib.ConnectionManagerParam get_param (string param);
		public unowned string get_vcard_field ();
		public bool has_param (string param);
		public static void init_known_interfaces ();
		public string[] authentication_types { get; }
		public TelepathyGLib.Capabilities capabilities { get; }
		public string english_name { get; }
		public string icon_name { get; }
		[NoAccessorMethod]
		public string[] param_names { get; }
		[NoAccessorMethod]
		public string protocol_name { get; construct; }
		public string vcard_field { get; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class Proxy : GLib.Object {
		public TelepathyGLib.ProxyPrivate priv;
		public void dbus_error_to_gerror (string dbus_error, string debug_message) throws GLib.Error;
		public unowned string get_bus_name ();
		public unowned TelepathyGLib.DBusDaemon get_dbus_daemon ();
		public unowned GLib.Error get_invalidated ();
		public unowned string get_object_path ();
		public bool has_interface (string iface);
		public bool has_interface_by_id (GLib.Quark iface);
		public bool is_prepared (GLib.Quark feature);
		public async bool prepare_async ([CCode (array_length = false)] GLib.Quark[]? features) throws GLib.Error;
		public string bus_name { get; construct; }
		public TelepathyGLib.DBusDaemon dbus_daemon { get; construct; }
		[NoAccessorMethod]
		public string[] interfaces { get; }
		public string object_path { get; construct; }
		public signal void invalidated (uint domain, int code, string message);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class SignalledMessage : TelepathyGLib.Message {
		public static unowned TelepathyGLib.Contact get_sender (TelepathyGLib.Message message);
		public TelepathyGLib.Contact sender { get; construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class SimpleApprover : TelepathyGLib.BaseClient {
		public TelepathyGLib.SimpleApproverPrivate priv;
		[CCode (has_construct_function = false)]
		public SimpleApprover (TelepathyGLib.DBusDaemon dbus, string name, bool uniquify, owned TelepathyGLib.SimpleApproverAddDispatchOperationImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[CCode (has_construct_function = false)]
		public SimpleApprover.with_am (TelepathyGLib.AccountManager account_manager, string name, bool uniquify, owned TelepathyGLib.SimpleApproverAddDispatchOperationImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public void* callback { construct; }
		[NoAccessorMethod]
		public void* destroy { construct; }
		[NoAccessorMethod]
		public void* user_data { construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class SimpleHandler : TelepathyGLib.BaseClient {
		public TelepathyGLib.SimpleHandlerPrivate priv;
		[CCode (has_construct_function = false)]
		public SimpleHandler (TelepathyGLib.DBusDaemon dbus, bool bypass_approval, bool requests, string name, bool uniquify, owned TelepathyGLib.SimpleHandlerHandleChannelsImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[CCode (has_construct_function = false)]
		public SimpleHandler.with_am (TelepathyGLib.AccountManager account_manager, bool bypass_approval, bool requests, string name, bool uniquify, owned TelepathyGLib.SimpleHandlerHandleChannelsImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public bool bypass_approval { construct; }
		[NoAccessorMethod]
		public void* callback { construct; }
		[NoAccessorMethod]
		public void* destroy { construct; }
		[NoAccessorMethod]
		public bool requests { construct; }
		[NoAccessorMethod]
		public void* user_data { construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class SimpleObserver : TelepathyGLib.BaseClient {
		public TelepathyGLib.SimpleObserverPrivate priv;
		[CCode (has_construct_function = false)]
		public SimpleObserver (TelepathyGLib.DBusDaemon dbus, bool recover, string name, bool uniquify, owned TelepathyGLib.SimpleObserverObserveChannelsImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[CCode (has_construct_function = false)]
		public SimpleObserver.with_am (TelepathyGLib.AccountManager account_manager, bool recover, string name, bool uniquify, owned TelepathyGLib.SimpleObserverObserveChannelsImpl callback, void* user_data, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public void* callback { construct; }
		[NoAccessorMethod]
		public void* destroy { construct; }
		[NoAccessorMethod]
		public bool recover { construct; }
		[NoAccessorMethod]
		public void* user_data { construct; }
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class StreamTubeChannel : TelepathyGLib.Channel {
		public TelepathyGLib.StreamTubeChannelPrivate priv;
		[CCode (has_construct_function = false)]
		public StreamTubeChannel (TelepathyGLib.Connection conn, string object_path, GLib.HashTable<weak string,weak GLib.Value> immutable_properties) throws GLib.Error;
		public async TelepathyGLib.StreamTubeConnection accept_async () throws GLib.Error;
		public async bool offer_async (GLib.HashTable<weak void*,weak void*>? @params) throws GLib.Error;
		[NoAccessorMethod]
		public string service { get; }
		public signal void incoming (TelepathyGLib.StreamTubeConnection tube_connection);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class StreamTubeConnection : GLib.Object {
		[NoAccessorMethod]
		public TelepathyGLib.StreamTubeChannel channel { get; construct; }
		[NoAccessorMethod]
		public TelepathyGLib.Contact contact { get; construct; }
		[NoAccessorMethod]
		public GLib.SocketConnection socket_connection { get; construct; }
		public signal void closed (void* error);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public class TextChannel : TelepathyGLib.Channel {
		public TelepathyGLib.TextChannelPrivate priv;
		[CCode (has_construct_function = false)]
		public TextChannel (TelepathyGLib.Connection conn, string object_path, GLib.HashTable<weak string,weak GLib.Value> immutable_properties) throws GLib.Error;
		public async bool ack_message_async (TelepathyGLib.Message message) throws GLib.Error;
		public async bool ack_messages_async (GLib.List<weak TelepathyGLib.SignalledMessage> messages) throws GLib.Error;
		public static GLib.Quark get_feature_quark_incoming_messages ();
		public GLib.List<weak TelepathyGLib.SignalledMessage> get_pending_messages ();
		public async bool send_message_async (TelepathyGLib.Message message, TelepathyGLib.MessageSendingFlags flags, out string token) throws GLib.Error;
		public async bool set_chat_state_async (TelepathyGLib.ChannelChatState state) throws GLib.Error;
		public bool supports_message_type (TelepathyGLib.ChannelTextMessageType message_type);
		[NoAccessorMethod]
		public uint delivery_reporting_support { get; }
		[NoAccessorMethod]
		public uint message_part_support_flags { get; }
		[NoAccessorMethod]
		public string[] supported_content_types { get; }
		public signal void message_received (TelepathyGLib.SignalledMessage message);
		public signal void message_sent (TelepathyGLib.SignalledMessage message, uint flags, string token);
		public signal void pending_message_removed (TelepathyGLib.SignalledMessage message);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", type_cname = "TpClientChannelFactoryInterface")]
	public interface ClientChannelFactory : GLib.Object {
		public TelepathyGLib.Channel create_channel (TelepathyGLib.Connection conn, string path, GLib.HashTable<weak string,weak GLib.Value> properties) throws GLib.Error;
		public GLib.Array<void*> dup_channel_features (TelepathyGLib.Channel channel);
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public interface HandleRepoIface : GLib.Object {
		[NoAccessorMethod]
		public uint handle_type { get; construct; }
	}
	[CCode (type_id = "TP_TYPE_ACCOUNT_CHANNEL_REQUEST_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AccountChannelRequestPrivate {
	}
	[CCode (type_id = "TP_TYPE_ACCOUNT_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AccountClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_ACCOUNT_MANAGER_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AccountManagerClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_ACCOUNT_MANAGER_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AccountManagerPrivate {
	}
	[CCode (type_id = "TP_TYPE_ACCOUNT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AccountPrivate {
	}
	[CCode (type_id = "TP_TYPE_ADD_DISPATCH_OPERATION_CONTEXT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct AddDispatchOperationContextPrivate {
	}
	[CCode (type_id = "TP_TYPE_BASE_CLIENT_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct BaseClientClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_BASE_CLIENT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct BaseClientPrivate {
	}
	[CCode (type_id = "TP_TYPE_BASE_CONNECTION_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct BaseConnectionPrivate {
	}
	[CCode (type_id = "TP_TYPE_CAPABILITIES_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct CapabilitiesPrivate {
	}
	[CCode (type_id = "TP_TYPE_CHANNEL_DISPATCH_OPERATION_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ChannelDispatchOperationClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_CHANNEL_DISPATCH_OPERATION_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ChannelDispatchOperationPrivate {
	}
	[CCode (type_id = "TP_TYPE_CHANNEL_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ChannelPrivate {
	}
	[CCode (type_id = "TP_TYPE_CHANNEL_REQUEST_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ChannelRequestClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_CHANNEL_REQUEST_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ChannelRequestPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONNECTION_MANAGER_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ConnectionManagerPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONNECTION_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ConnectionPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONTACT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONTACT_SEARCH_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactSearchPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONTACT_SEARCH_RESULT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactSearchResultPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONTACTS_MIXIN", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactsMixin {
	}
	[CCode (type_id = "TP_TYPE_CONTACTS_MIXIN_CLASS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactsMixinClass {
	}
	[CCode (type_id = "TP_TYPE_CONTACTS_MIXIN_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactsMixinClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_CONTACTS_MIXIN_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ContactsMixinPrivate {
	}
	[CCode (type_id = "TP_TYPE_DBUS_DAEMON_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct DBusDaemonPrivate {
	}
	[CCode (type_id = "TP_TYPE_DBUS_PROPERTIES_MIXIN_IFACE_IMPL", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct DBusPropertiesMixinIfaceImpl {
		public weak string name;
		public weak TelepathyGLib.DBusPropertiesMixinGetter getter;
		public weak TelepathyGLib.DBusPropertiesMixinSetter setter;
		public TelepathyGLib.DBusPropertiesMixinPropImpl props;
		public weak GLib.Callback _1;
		public weak GLib.Callback _2;
		public void* mixin_next;
		public void* mixin_priv;
	}
	[CCode (type_id = "TP_TYPE_DBUS_PROPERTIES_MIXIN_IFACE_INFO", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct DBusPropertiesMixinIfaceInfo {
		public GLib.Quark dbus_interface;
		public TelepathyGLib.DBusPropertiesMixinPropInfo props;
		public weak GLib.Callback _1;
		public weak GLib.Callback _2;
	}
	[CCode (type_id = "TP_TYPE_DBUS_PROPERTIES_MIXIN_PROP_IMPL", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct DBusPropertiesMixinPropImpl {
		public weak string name;
		public void* getter_data;
		public void* setter_data;
		public weak GLib.Callback _1;
		public weak GLib.Callback _2;
		public void* mixin_priv;
	}
	[CCode (type_id = "TP_TYPE_DBUS_PROPERTIES_MIXIN_PROP_INFO", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct DBusPropertiesMixinPropInfo {
		public GLib.Quark name;
		public TelepathyGLib.DBusPropertiesMixinFlags flags;
		public weak string dbus_signature;
		public GLib.Type type;
		public weak GLib.Callback _1;
		public weak GLib.Callback _2;
	}
	[CCode (type_id = "TP_TYPE_GROUP_MIXIN", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct GroupMixin {
		public weak TelepathyGLib.HandleRepoIface handle_repo;
		public TelepathyGLib.Handle self_handle;
		public TelepathyGLib.ChannelGroupFlags group_flags;
		public weak TelepathyGLib.HandleSet members;
		public weak TelepathyGLib.HandleSet local_pending;
		public weak TelepathyGLib.HandleSet remote_pending;
	}
	[CCode (type_id = "TP_TYPE_GROUP_MIXIN_CLASS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct GroupMixinClass {
		public weak TelepathyGLib.GroupMixinAddMemberFunc add_member;
		public weak TelepathyGLib.GroupMixinRemMemberFunc remove_member;
	}
	[CCode (type_id = "TP_TYPE_GROUP_MIXIN_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct GroupMixinClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_GROUP_MIXIN_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct GroupMixinPrivate {
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct Handle : uint {
		public static TelepathyGLib.Handle ensure (TelepathyGLib.HandleRepoIface self, string id, void* context) throws GLib.Error;
		public static bool type_is_valid (TelepathyGLib.HandleType type) throws GLib.Error;
		public static unowned string type_to_string (TelepathyGLib.HandleType type);
	}
	[CCode (type_id = "TP_TYPE_HANDLE_CHANNELS_CONTEXT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct HandleChannelsContextPrivate {
	}
	[CCode (type_id = "TP_TYPE_HANDLE_REPO_IFACE_CLASS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct HandleRepoIfaceClass {
	}
	[CCode (type_id = "TP_TYPE_INTSET_FAST_ITER", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct IntsetFastIter {
		[CCode (array_length = false)]
		public weak void*[] _dummy;
		public void init (TelepathyGLib.Intset @set);
		public bool next (uint output);
	}
	[CCode (type_id = "TP_TYPE_INTSET_ITER", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct IntsetIter {
		public weak TelepathyGLib.Intset @set;
		public uint element;
		public void init (TelepathyGLib.Intset @set);
		public bool next ();
		public void reset ();
	}
	[CCode (type_id = "TP_TYPE_OBSERVE_CHANNELS_CONTEXT_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ObserveChannelsContextPrivate {
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_MIXIN", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceMixin {
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_MIXIN_CLASS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceMixinClass {
		public weak TelepathyGLib.PresenceMixinStatusAvailableFunc status_available;
		public weak TelepathyGLib.PresenceMixinGetContactStatusesFunc get_contact_statuses;
		public weak TelepathyGLib.PresenceMixinSetOwnStatusFunc set_own_status;
		public TelepathyGLib.PresenceStatusSpec statuses;
		public weak TelepathyGLib.PresenceMixinGetMaximumStatusMessageLengthFunc get_maximum_status_message_length;
		public void* _future1;
		public void* _future2;
		public void* _future3;
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_MIXIN_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceMixinClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_MIXIN_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceMixinPrivate {
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_STATUS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceStatus {
		public uint index;
		public weak GLib.HashTable<weak void*,weak void*> optional_arguments;
		public void* _future1;
		public void* _future2;
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_STATUS_OPTIONAL_ARGUMENT_SPEC", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceStatusOptionalArgumentSpec {
		public weak string name;
		public weak string dtype;
		public void* _future1;
		public void* _future2;
	}
	[CCode (type_id = "TP_TYPE_PRESENCE_STATUS_SPEC", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct PresenceStatusSpec {
		public weak string name;
		public TelepathyGLib.ConnectionPresenceType presence_type;
		public bool self;
		public TelepathyGLib.PresenceStatusOptionalArgumentSpec optional_arguments;
		public void* _future1;
		public void* _future2;
	}
	[CCode (type_id = "TP_TYPE_PROTOCOL_CLASS_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProtocolClassPrivate {
	}
	[CCode (type_id = "TP_TYPE_PROTOCOL_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProtocolPrivate {
	}
	[CCode (type_id = "TP_TYPE_PROXY_FEATURE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProxyFeature {
	}
	[CCode (type_id = "TP_TYPE_PROXY_PENDING_CALL", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProxyPendingCall {
		public void cancel ();
	}
	[CCode (type_id = "TP_TYPE_PROXY_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProxyPrivate {
	}
	[CCode (type_id = "TP_TYPE_PROXY_SIGNAL_CONNECTION", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct ProxySignalConnection {
		public void disconnect ();
	}
	[CCode (type_id = "TP_TYPE_SIMPLE_APPROVER_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct SimpleApproverPrivate {
	}
	[CCode (type_id = "TP_TYPE_SIMPLE_HANDLER_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct SimpleHandlerPrivate {
	}
	[CCode (type_id = "TP_TYPE_SIMPLE_OBSERVER_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct SimpleObserverPrivate {
	}
	[CCode (type_id = "TP_TYPE_STREAM_TUBE_CHANNEL_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct StreamTubeChannelPrivate {
	}
	[CCode (type_id = "TP_TYPE_STREAM_TUBE_CONNECTION_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct StreamTubeConnectionPrivate {
	}
	[CCode (type_id = "TP_TYPE_TEXT_CHANNEL_PRIVATE", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct TextChannelPrivate {
	}
	[CCode (cname = "_TpDBusPropertiesMixinClass", type_id = "TP_TYPE__DBUSPROPERTIESMIXINCLASS", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public struct _DBusPropertiesMixinClass {
		public TelepathyGLib.DBusPropertiesMixinIfaceImpl interfaces;
		public void* _1;
		public void* _2;
		public void* _3;
		public void* _4;
		public void* _5;
		public void* _6;
		public void* _7;
	}
	[CCode (cprefix = "TP_ACCESS_CONTROL_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum AccessControlType {
		WHITELIST,
		PUBLISH_LIST,
		GROUP,
		OPEN,
		SUBSCRIBE_OR_PUBLISH_LIST,
		CLOSED,
		NOT_UNDERSTOOD
	}
	[CCode (cprefix = "TP_ANONYMITY_MODE_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum AnonymityModeFlags {
		[CCode (cname = "TP_ANONYMITY_MODE_CLIENT_INFO")]
		CLIENT_INFO,
		[CCode (cname = "TP_ANONYMITY_MODE_SHOW_CLIENT_INFO")]
		SHOW_CLIENT_INFO,
		[CCode (cname = "TP_ANONYMITY_MODE_NETWORK_INFO")]
		NETWORK_INFO
	}
	[CCode (cprefix = "TP_CM_INFO_SOURCE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum CMInfoSource {
		NONE,
		FILE,
		LIVE
	}
	[CCode (cprefix = "TP_CHANNEL_CALL_STATE_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelCallStateFlags {
		[CCode (cname = "TP_CHANNEL_CALL_STATE_RINGING")]
		RINGING,
		[CCode (cname = "TP_CHANNEL_CALL_STATE_QUEUED")]
		QUEUED,
		[CCode (cname = "TP_CHANNEL_CALL_STATE_HELD")]
		HELD,
		[CCode (cname = "TP_CHANNEL_CALL_STATE_FORWARDED")]
		FORWARDED,
		[CCode (cname = "TP_CHANNEL_CALL_STATE_IN_PROGRESS")]
		IN_PROGRESS,
		[CCode (cname = "TP_CHANNEL_CALL_STATE_CONFERENCE_HOST")]
		CONFERENCE_HOST
	}
	[CCode (cprefix = "TP_CHANNEL_CHAT_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelChatState {
		GONE,
		INACTIVE,
		ACTIVE,
		PAUSED,
		COMPOSING
	}
	[CCode (cprefix = "TP_CHANNEL_CONTACT_SEARCH_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelContactSearchState {
		NOT_STARTED,
		IN_PROGRESS,
		MORE_AVAILABLE,
		COMPLETED,
		FAILED
	}
	[CCode (cprefix = "TP_CHANNEL_GROUP_CHANGE_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelGroupChangeReason {
		NONE,
		OFFLINE,
		KICKED,
		BUSY,
		INVITED,
		BANNED,
		ERROR,
		INVALID_CONTACT,
		NO_ANSWER,
		RENAMED,
		PERMISSION_DENIED,
		SEPARATED
	}
	[CCode (cprefix = "TP_CHANNEL_GROUP_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelGroupFlags {
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_CAN_ADD")]
		CAN_ADD,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_CAN_REMOVE")]
		CAN_REMOVE,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_CAN_RESCIND")]
		CAN_RESCIND,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_ADD")]
		MESSAGE_ADD,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE")]
		MESSAGE_REMOVE,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT")]
		MESSAGE_ACCEPT,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_REJECT")]
		MESSAGE_REJECT,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND")]
		MESSAGE_RESCIND,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES")]
		CHANNEL_SPECIFIC_HANDLES,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_ONLY_ONE_GROUP")]
		ONLY_ONE_GROUP,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_HANDLE_OWNERS_NOT_AVAILABLE")]
		HANDLE_OWNERS_NOT_AVAILABLE,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_PROPERTIES")]
		PROPERTIES,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MEMBERS_CHANGED_DETAILED")]
		MEMBERS_CHANGED_DETAILED,
		[CCode (cname = "TP_CHANNEL_GROUP_FLAG_MESSAGE_DEPART")]
		MESSAGE_DEPART
	}
	[CCode (cprefix = "TP_CHANNEL_MEDIA_CAPABILITIES_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelMediaCapabilities {
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_AUDIO")]
		AUDIO,
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_VIDEO")]
		VIDEO,
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_STUN")]
		NAT_TRAVERSAL_STUN,
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_GTALK_P2P")]
		NAT_TRAVERSAL_GTALK_P2P,
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_ICE_UDP")]
		NAT_TRAVERSAL_ICE_UDP,
		[CCode (cname = "TP_CHANNEL_MEDIA_CAPABILITY_IMMUTABLE_STREAMS")]
		IMMUTABLE_STREAMS
	}
	[CCode (cprefix = "TP_CHANNEL_PASSWORD_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelPasswordFlags {
		[CCode (cname = "TP_CHANNEL_PASSWORD_FLAG_PROVIDE")]
		CHANNEL_PASSWORD_FLAG_PROVIDE
	}
	[CCode (cprefix = "TP_CHANNEL_TEXT_MESSAGE_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelTextMessageFlags {
		[CCode (cname = "TP_CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED")]
		TRUNCATED,
		[CCode (cname = "TP_CHANNEL_TEXT_MESSAGE_FLAG_NON_TEXT_CONTENT")]
		NON_TEXT_CONTENT,
		[CCode (cname = "TP_CHANNEL_TEXT_MESSAGE_FLAG_SCROLLBACK")]
		SCROLLBACK,
		[CCode (cname = "TP_CHANNEL_TEXT_MESSAGE_FLAG_RESCUED")]
		RESCUED
	}
	[CCode (cprefix = "TP_CHANNEL_TEXT_MESSAGE_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelTextMessageType {
		NORMAL,
		ACTION,
		NOTICE,
		AUTO_REPLY,
		DELIVERY_REPORT
	}
	[CCode (cprefix = "TP_CHANNEL_TEXT_SEND_ERROR_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ChannelTextSendError {
		UNKNOWN,
		OFFLINE,
		INVALID_CONTACT,
		PERMISSION_DENIED,
		TOO_LONG,
		NOT_IMPLEMENTED
	}
	[CCode (cprefix = "TP_CONN_MGR_PARAM_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnMgrParamFlags {
		[CCode (cname = "TP_CONN_MGR_PARAM_FLAG_REQUIRED")]
		REQUIRED,
		[CCode (cname = "TP_CONN_MGR_PARAM_FLAG_REGISTER")]
		REGISTER,
		[CCode (cname = "TP_CONN_MGR_PARAM_FLAG_HAS_DEFAULT")]
		HAS_DEFAULT,
		[CCode (cname = "TP_CONN_MGR_PARAM_FLAG_SECRET")]
		SECRET,
		[CCode (cname = "TP_CONN_MGR_PARAM_FLAG_DBUS_PROPERTY")]
		DBUS_PROPERTY
	}
	[CCode (cprefix = "TP_CONNECTION_ALIAS_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnectionAliasFlags {
		[CCode (cname = "TP_CONNECTION_ALIAS_FLAG_USER_SET")]
		CONNECTION_ALIAS_FLAG_USER_SET
	}
	[CCode (cprefix = "TP_CONNECTION_CAPABILITY_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnectionCapabilityFlags {
		[CCode (cname = "TP_CONNECTION_CAPABILITY_FLAG_CREATE")]
		CREATE,
		[CCode (cname = "TP_CONNECTION_CAPABILITY_FLAG_INVITE")]
		INVITE
	}
	[CCode (cprefix = "TP_CONNECTION_PRESENCE_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnectionPresenceType {
		UNSET,
		OFFLINE,
		AVAILABLE,
		AWAY,
		EXTENDED_AWAY,
		HIDDEN,
		BUSY,
		UNKNOWN,
		ERROR
	}
	[CCode (cprefix = "TP_CONNECTION_STATUS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnectionStatus {
		CONNECTED,
		CONNECTING,
		DISCONNECTED
	}
	[CCode (cprefix = "TP_CONNECTION_STATUS_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ConnectionStatusReason {
		NONE_SPECIFIED,
		REQUESTED,
		NETWORK_ERROR,
		AUTHENTICATION_FAILED,
		ENCRYPTION_ERROR,
		NAME_IN_USE,
		CERT_NOT_PROVIDED,
		CERT_UNTRUSTED,
		CERT_EXPIRED,
		CERT_NOT_ACTIVATED,
		CERT_HOSTNAME_MISMATCH,
		CERT_FINGERPRINT_MISMATCH,
		CERT_SELF_SIGNED,
		CERT_OTHER_ERROR,
		CERT_REVOKED,
		CERT_INSECURE,
		CERT_LIMIT_EXCEEDED
	}
	[CCode (cprefix = "TP_CONTACT_BLOCKING_CAPABILITIES_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactBlockingCapabilities {
		[CCode (cname = "TP_CONTACT_BLOCKING_CAPABILITY_CAN_REPORT_ABUSIVE")]
		CONTACT_BLOCKING_CAPABILITY_CAN_REPORT_ABUSIVE
	}
	[CCode (cprefix = "TP_CONTACT_FEATURE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactFeature {
		ALIAS,
		AVATAR_TOKEN,
		PRESENCE,
		LOCATION,
		CAPABILITIES,
		AVATAR_DATA,
		CONTACT_INFO,
		CLIENT_TYPES,
		SUBSCRIPTION_STATES,
		CONTACT_GROUPS
	}
	[CCode (cprefix = "TP_CONTACT_INFO_FIELD_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactInfoFieldFlags {
		[CCode (cname = "TP_CONTACT_INFO_FIELD_FLAG_PARAMETERS_EXACT")]
		PARAMETERS_EXACT,
		[CCode (cname = "TP_CONTACT_INFO_FIELD_FLAG_OVERWRITTEN_BY_NICKNAME")]
		OVERWRITTEN_BY_NICKNAME
	}
	[CCode (cprefix = "TP_CONTACT_INFO_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactInfoFlags {
		[CCode (cname = "TP_CONTACT_INFO_FLAG_CAN_SET")]
		CAN_SET,
		[CCode (cname = "TP_CONTACT_INFO_FLAG_PUSH")]
		PUSH
	}
	[CCode (cprefix = "TP_CONTACT_LIST_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactListState {
		NONE,
		WAITING,
		FAILURE,
		SUCCESS
	}
	[CCode (cprefix = "TP_CONTACT_METADATA_STORAGE_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ContactMetadataStorageType {
		NONE,
		SUBSCRIBED_OR_PENDING,
		SUBSCRIBED,
		ANYONE
	}
	[CCode (cprefix = "TP_DBUS_ERROR_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DBusError {
		UNKNOWN_REMOTE_ERROR,
		PROXY_UNREFERENCED,
		NO_INTERFACE,
		NAME_OWNER_LOST,
		INVALID_BUS_NAME,
		INVALID_INTERFACE_NAME,
		INVALID_OBJECT_PATH,
		INVALID_MEMBER_NAME,
		OBJECT_REMOVED,
		CANCELLED,
		INCONSISTENT
	}
	[CCode (cprefix = "TP_DBUS_NAME_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DBusNameType {
		UNIQUE,
		WELL_KNOWN,
		BUS_DAEMON,
		NOT_BUS_DAEMON,
		ANY
	}
	[CCode (cprefix = "TP_DBUS_PROPERTIES_MIXIN_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DBusPropertiesMixinFlags {
		[CCode (cname = "TP_DBUS_PROPERTIES_MIXIN_FLAG_READ")]
		READ,
		[CCode (cname = "TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE")]
		WRITE
	}
	[CCode (cprefix = "TP_DTMF_EVENT_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DTMFEvent {
		DIGIT_0,
		DIGIT_1,
		DIGIT_2,
		DIGIT_3,
		DIGIT_4,
		DIGIT_5,
		DIGIT_6,
		DIGIT_7,
		DIGIT_8,
		DIGIT_9,
		ASTERISK,
		HASH,
		LETTER_A,
		LETTER_B,
		LETTER_C,
		LETTER_D
	}
	[CCode (cprefix = "TP_DEBUG_LEVEL_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DebugLevel {
		ERROR,
		CRITICAL,
		WARNING,
		MESSAGE,
		INFO,
		DEBUG
	}
	[CCode (cprefix = "TP_DELIVERY_REPORTING_SUPPORT_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DeliveryReportingSupportFlags {
		[CCode (cname = "TP_DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_FAILURES")]
		FAILURES,
		[CCode (cname = "TP_DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_SUCCESSES")]
		SUCCESSES,
		[CCode (cname = "TP_DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_READ")]
		READ,
		[CCode (cname = "TP_DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_DELETED")]
		DELETED
	}
	[CCode (cprefix = "TP_DELIVERY_STATUS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum DeliveryStatus {
		UNKNOWN,
		DELIVERED,
		TEMPORARILY_FAILED,
		PERMANENTLY_FAILED,
		ACCEPTED,
		READ,
		DELETED
	}
	[CCode (cprefix = "TP_FILE_HASH_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum FileHashType {
		NONE,
		MD5,
		SHA1,
		SHA256
	}
	[CCode (cprefix = "TP_FILE_TRANSFER_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum FileTransferState {
		NONE,
		PENDING,
		ACCEPTED,
		OPEN,
		COMPLETED,
		CANCELLED
	}
	[CCode (cprefix = "TP_FILE_TRANSFER_STATE_CHANGE_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum FileTransferStateChangeReason {
		NONE,
		REQUESTED,
		LOCAL_STOPPED,
		REMOTE_STOPPED,
		LOCAL_ERROR,
		REMOTE_ERROR
	}
	[CCode (cprefix = "TP_HTTP_METHOD_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum HTTPMethod {
		GET,
		POST
	}
	[CCode (cprefix = "TP_HANDLE_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum HandleType {
		NONE,
		CONTACT,
		ROOM,
		LIST,
		GROUP
	}
	[CCode (cprefix = "TP_LOCAL_HOLD_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum LocalHoldState {
		UNHELD,
		HELD,
		PENDING_HOLD,
		PENDING_UNHOLD
	}
	[CCode (cprefix = "TP_LOCAL_HOLD_STATE_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum LocalHoldStateReason {
		NONE,
		REQUESTED,
		RESOURCE_NOT_AVAILABLE
	}
	[CCode (cprefix = "TP_LOCATION_FEATURES_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum LocationFeatures {
		[CCode (cname = "TP_LOCATION_FEATURE_CAN_SET")]
		LOCATION_FEATURE_CAN_SET
	}
	[CCode (cprefix = "TP_MAIL_NOTIFICATION_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MailNotificationFlags {
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAIL_COUNT")]
		SUPPORTS_UNREAD_MAIL_COUNT,
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAILS")]
		SUPPORTS_UNREAD_MAILS,
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_EMITS_MAILS_RECEIVED")]
		EMITS_MAILS_RECEIVED,
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_INBOX_URL")]
		SUPPORTS_REQUEST_INBOX_URL,
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_MAIL_URL")]
		SUPPORTS_REQUEST_MAIL_URL,
		[CCode (cname = "TP_MAIL_NOTIFICATION_FLAG_THREAD_BASED")]
		THREAD_BASED
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_BASE_PROTO_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamBaseProto {
		UDP,
		TCP
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_DIRECTION_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamDirection {
		NONE,
		SEND,
		RECEIVE,
		BIDIRECTIONAL
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_ERROR_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamError {
		UNKNOWN,
		EOS,
		CODEC_NEGOTIATION_FAILED,
		CONNECTION_FAILED,
		NETWORK_ERROR,
		NO_CODECS,
		INVALID_CM_BEHAVIOR,
		MEDIA_ERROR
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_PENDING_SEND_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamPendingSend {
		[CCode (cname = "TP_MEDIA_STREAM_PENDING_LOCAL_SEND")]
		LOCAL_SEND,
		[CCode (cname = "TP_MEDIA_STREAM_PENDING_REMOTE_SEND")]
		REMOTE_SEND
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamState {
		DISCONNECTED,
		CONNECTING,
		CONNECTED
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_TRANSPORT_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamTransportType {
		LOCAL,
		DERIVED,
		RELAY
	}
	[CCode (cprefix = "TP_MEDIA_STREAM_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MediaStreamType {
		AUDIO,
		VIDEO
	}
	[CCode (cprefix = "TP_MESSAGE_PART_SUPPORT_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MessagePartSupportFlags {
		[CCode (cname = "TP_MESSAGE_PART_SUPPORT_FLAG_ONE_ATTACHMENT")]
		ONE_ATTACHMENT,
		[CCode (cname = "TP_MESSAGE_PART_SUPPORT_FLAG_MULTIPLE_ATTACHMENTS")]
		MULTIPLE_ATTACHMENTS
	}
	[CCode (cprefix = "TP_MESSAGE_SENDING_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum MessageSendingFlags {
		[CCode (cname = "TP_MESSAGE_SENDING_FLAG_REPORT_DELIVERY")]
		DELIVERY,
		[CCode (cname = "TP_MESSAGE_SENDING_FLAG_REPORT_READ")]
		READ,
		[CCode (cname = "TP_MESSAGE_SENDING_FLAG_REPORT_DELETED")]
		DELETED
	}
	[CCode (cprefix = "TP_PROPERTY_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum PropertyFlags {
		[CCode (cname = "TP_PROPERTY_FLAG_READ")]
		READ,
		[CCode (cname = "TP_PROPERTY_FLAG_WRITE")]
		WRITE
	}
	[CCode (cprefix = "TP_RICH_PRESENCE_ACCESS_CONTROL_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum RichPresenceAccessControlType {
		WHITELIST,
		PUBLISH_LIST,
		GROUP,
		OPEN
	}
	[CCode (cprefix = "TP_SASL_ABORT_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum SASLAbortReason {
		INVALID_CHALLENGE,
		USER_ABORT
	}
	[CCode (cprefix = "TP_SASL_STATUS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum SASLStatus {
		NOT_STARTED,
		IN_PROGRESS,
		SERVER_SUCCEEDED,
		CLIENT_ACCEPTED,
		SUCCEEDED,
		SERVER_FAILED,
		CLIENT_FAILED
	}
	[CCode (cprefix = "TP_SERVICE_POINT_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum ServicePointType {
		NONE,
		EMERGENCY,
		COUNSELING
	}
	[CCode (cprefix = "TP_SOCKET_ACCESS_CONTROL_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum SocketAccessControl {
		LOCALHOST,
		PORT,
		NETMASK,
		CREDENTIALS
	}
	[CCode (cprefix = "TP_SOCKET_ADDRESS_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum SocketAddressType {
		UNIX,
		ABSTRACT_UNIX,
		IPV4,
		IPV6
	}
	[CCode (cprefix = "TP_STORAGE_RESTRICTION_FLAGS_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum StorageRestrictionFlags {
		[CCode (cname = "TP_STORAGE_RESTRICTION_FLAG_CANNOT_SET_PARAMETERS")]
		PARAMETERS,
		[CCode (cname = "TP_STORAGE_RESTRICTION_FLAG_CANNOT_SET_ENABLED")]
		ENABLED,
		[CCode (cname = "TP_STORAGE_RESTRICTION_FLAG_CANNOT_SET_PRESENCE")]
		PRESENCE,
		[CCode (cname = "TP_STORAGE_RESTRICTION_FLAG_CANNOT_SET_SERVICE")]
		SERVICE
	}
	[CCode (cprefix = "TP_SUBSCRIPTION_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum SubscriptionState {
		UNKNOWN,
		NO,
		REMOVED_REMOTELY,
		ASK,
		YES
	}
	[CCode (cprefix = "TP_TLS_CERTIFICATE_REJECT_REASON_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum TLSCertificateRejectReason {
		UNKNOWN,
		UNTRUSTED,
		EXPIRED,
		NOT_ACTIVATED,
		FINGERPRINT_MISMATCH,
		HOSTNAME_MISMATCH,
		SELF_SIGNED,
		REVOKED,
		INSECURE,
		LIMIT_EXCEEDED
	}
	[CCode (cprefix = "TP_TLS_CERTIFICATE_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum TLSCertificateState {
		PENDING,
		ACCEPTED,
		REJECTED
	}
	[CCode (cprefix = "TP_TUBE_CHANNEL_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum TubeChannelState {
		LOCAL_PENDING,
		REMOTE_PENDING,
		OPEN,
		NOT_OFFERED
	}
	[CCode (cprefix = "TP_TUBE_STATE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum TubeState {
		LOCAL_PENDING,
		REMOTE_PENDING,
		OPEN
	}
	[CCode (cprefix = "TP_TUBE_TYPE_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public enum TubeType {
		DBUS,
		STREAM
	}
	[CCode (cprefix = "ERROR_", cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public errordomain Error {
		NETWORK_ERROR,
		NOT_IMPLEMENTED,
		INVALID_ARGUMENT,
		NOT_AVAILABLE,
		PERMISSION_DENIED,
		DISCONNECTED,
		INVALID_HANDLE,
		CHANNEL_BANNED,
		CHANNEL_FULL,
		CHANNEL_INVITE_ONLY,
		NOT_YOURS,
		CANCELLED,
		AUTHENTICATION_FAILED,
		ENCRYPTION_NOT_AVAILABLE,
		ENCRYPTION_ERROR,
		CERT_NOT_PROVIDED,
		CERT_UNTRUSTED,
		CERT_EXPIRED,
		CERT_NOT_ACTIVATED,
		CERT_FINGERPRINT_MISMATCH,
		CERT_HOSTNAME_MISMATCH,
		CERT_SELF_SIGNED,
		CERT_INVALID,
		NOT_CAPABLE,
		OFFLINE,
		CHANNEL_KICKED,
		BUSY,
		NO_ANSWER,
		DOES_NOT_EXIST,
		TERMINATED,
		CONNECTION_REFUSED,
		CONNECTION_FAILED,
		CONNECTION_LOST,
		ALREADY_CONNECTED,
		CONNECTION_REPLACED,
		REGISTRATION_EXISTS,
		SERVICE_BUSY,
		RESOURCE_UNAVAILABLE,
		WOULD_BREAK_ANONYMITY,
		CERT_REVOKED,
		CERT_INSECURE,
		CERT_LIMIT_EXCEEDED,
		NOT_YET,
		REJECTED,
		PICKED_UP_ELSEWHERE,
		CONFUSED,
		SERVICE_CONFUSED,
		EMERGENCY_CALLS_NOT_SUPPORTED,
		SOFTWARE_UPGRADE_REQUIRED,
		INSUFFICIENT_BALANCE,
	}
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void BaseClientClassAddDispatchOperationImpl (TelepathyGLib.BaseClient client, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, TelepathyGLib.ChannelDispatchOperation dispatch_operation, TelepathyGLib.AddDispatchOperationContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void BaseClientClassHandleChannelsImpl (TelepathyGLib.BaseClient client, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, GLib.List<weak TelepathyGLib.ChannelRequest> requests_satisfied, int64 user_action_time, TelepathyGLib.HandleChannelsContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void BaseClientClassObserveChannelsImpl (TelepathyGLib.BaseClient client, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, TelepathyGLib.ChannelDispatchOperation? dispatch_operation, GLib.List<weak TelepathyGLib.ChannelRequest> requests, TelepathyGLib.ObserveChannelsContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate GLib.GenericArray<void*> BaseConnectionCreateChannelFactoriesImpl (TelepathyGLib.BaseConnection self);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate GLib.GenericArray<void*> BaseConnectionCreateChannelManagersImpl (TelepathyGLib.BaseConnection self);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate string BaseConnectionGetUniqueConnectionNameImpl (TelepathyGLib.BaseConnection self);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void BaseConnectionProc (TelepathyGLib.BaseConnection self);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool BaseConnectionStartConnectingImpl (TelepathyGLib.BaseConnection self) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 2.9)]
	public delegate void ChannelWhenReadyCb (TelepathyGLib.Channel channel, GLib.Error error);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 4.9)]
	public delegate void ConnectionContactsByHandleCb (TelepathyGLib.Connection connection, [CCode (array_length_cname = "n_contacts", array_length_pos = 1.5)] TelepathyGLib.Contact[] contacts, [CCode (array_length_cname = "n_failed", array_length_pos = 2.5)] TelepathyGLib.Handle[] failed, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 5.9)]
	public delegate void ConnectionContactsByIdCb (TelepathyGLib.Connection connection, [CCode (array_length_cname = "n_contacts", array_length_pos = 1.5)] TelepathyGLib.Contact[] contacts, [CCode (array_length_cname = "n_contacts", array_length_pos = 1.5)] string[] requested_ids, GLib.HashTable<weak string,weak GLib.Error> failed_id_errors, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 5.9)]
	public delegate void ConnectionHoldHandlesCb (TelepathyGLib.Connection connection, TelepathyGLib.HandleType handle_type, uint n_handles, TelepathyGLib.Handle handles, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 3.9)]
	public delegate void ConnectionManagerListCb ([CCode (array_length = false)] TelepathyGLib.ConnectionManager[] cms, size_t n_cms, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 2.9)]
	public delegate void ConnectionManagerWhenReadyCb (TelepathyGLib.ConnectionManager cm, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 5.9)]
	public delegate void ConnectionNameListCb ([CCode (array_length = false)] string[] names, size_t n, [CCode (array_length = false)] string[] cms, [CCode (array_length = false)] string[] protocols, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 5.9)]
	public delegate void ConnectionRequestHandlesCb (TelepathyGLib.Connection connection, TelepathyGLib.HandleType handle_type, [CCode (array_length_cname = "n_handles", array_length_pos = 2.5)] uint[] handles, [CCode (array_length_cname = "n_handles", array_length_pos = 2.5)] string[] ids, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 4.9)]
	public delegate void ConnectionUpgradeContactsCb (TelepathyGLib.Connection connection, uint n_contacts, TelepathyGLib.Contact contacts, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 2.9)]
	public delegate void ConnectionWhenReadyCb (TelepathyGLib.Connection connection, GLib.Error error);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void ContactsMixinFillContactAttributesFunc (GLib.Object obj, GLib.Array<weak void*> contacts, GLib.HashTable<weak void*,weak void*> attributes_hash);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 3.9)]
	public delegate void DBusDaemonListNamesCb (TelepathyGLib.DBusDaemon bus_daemon, string names, GLib.Error error, GLib.Object weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 3.9)]
	public delegate void DBusDaemonNameOwnerChangedCb (TelepathyGLib.DBusDaemon bus_daemon, string name, string new_owner);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void DBusPropertiesMixinGetter (GLib.Object object, GLib.Quark iface, GLib.Quark name, GLib.Value value, void* getter_data);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool DBusPropertiesMixinSetter (GLib.Object object, GLib.Quark iface, GLib.Quark name, GLib.Value value, void* setter_data) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool GroupMixinAddMemberFunc (GLib.Object obj, TelepathyGLib.Handle handle, string message) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool GroupMixinRemMemberFunc (GLib.Object obj, TelepathyGLib.Handle handle, string message) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool GroupMixinRemMemberWithReasonFunc (GLib.Object obj, TelepathyGLib.Handle handle, string message, uint reason) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate void IntFunc (uint i, void* userdata);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate GLib.HashTable<void*,void*> PresenceMixinGetContactStatusesFunc (GLib.Object obj, GLib.Array<weak void*> contacts) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate uint PresenceMixinGetMaximumStatusMessageLengthFunc (GLib.Object obj);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool PresenceMixinSetOwnStatusFunc (GLib.Object obj, TelepathyGLib.PresenceStatus status) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", has_target = false)]
	public delegate bool PresenceMixinStatusAvailableFunc (GLib.Object obj, uint which);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 6.9)]
	public delegate void SimpleApproverAddDispatchOperationImpl (TelepathyGLib.SimpleApprover approver, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, TelepathyGLib.ChannelDispatchOperation? dispatch_operation, TelepathyGLib.AddDispatchOperationContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 7.9)]
	public delegate void SimpleHandlerHandleChannelsImpl (TelepathyGLib.SimpleHandler handler, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, GLib.List<weak TelepathyGLib.ChannelRequest> requests_satisfied, int64 user_action_time, TelepathyGLib.HandleChannelsContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h", instance_pos = 7.9)]
	public delegate void SimpleObserverObserveChannelsImpl (TelepathyGLib.SimpleObserver observer, TelepathyGLib.Account account, TelepathyGLib.Connection connection, GLib.List<weak TelepathyGLib.Channel> channels, TelepathyGLib.ChannelDispatchOperation? dispatch_operation, GLib.List<weak TelepathyGLib.ChannelRequest> requests, TelepathyGLib.ObserveChannelsContext context);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string ACCOUNT_MANAGER_BUS_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string ACCOUNT_MANAGER_OBJECT_PATH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string ACCOUNT_OBJECT_PATH_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CHANNEL_DISPATCHER_BUS_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CHANNEL_DISPATCHER_OBJECT_PATH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CLIENT_BUS_NAME_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CLIENT_OBJECT_PATH_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CM_BUS_NAME_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CM_OBJECT_PATH_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CONN_BUS_NAME_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string CONN_OBJECT_PATH_BASE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string ERROR_PREFIX;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_ACCOUNT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_ACCOUNT_INTERFACE_ADDRESSING;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_ACCOUNT_INTERFACE_AVATAR;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_ACCOUNT_INTERFACE_STORAGE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_ACCOUNT_MANAGER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_AUTHENTICATION_TLS_CERTIFICATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_DISPATCHER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_DISPATCHER_INTERFACE_OPERATION_LIST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_DISPATCH_OPERATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_ANONYMITY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_CALL_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_CHAT_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_CONFERENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_DESTROYABLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_DTMF;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_GROUP;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_HOLD;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_MEDIA_SIGNALLING;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_MESSAGES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_PASSWORD;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_SASL_AUTHENTICATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_SECURABLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_SERVICE_POINT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_SMS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_INTERFACE_TUBE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_REQUEST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_CONTACT_LIST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_CONTACT_SEARCH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_DBUS_TUBE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_FILE_TRANSFER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_ROOM_LIST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_SERVER_AUTHENTICATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_SERVER_TLS_CONNECTION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_STREAMED_MEDIA;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_STREAM_TUBE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_TEXT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CHANNEL_TYPE_TUBES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CLIENT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CLIENT_APPROVER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CLIENT_HANDLER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CLIENT_INTERFACE_REQUESTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CLIENT_OBSERVER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_ALIASING;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_ANONYMITY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_AVATARS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_BALANCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CAPABILITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CELLULAR;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CLIENT_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACT_BLOCKING;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACT_CAPABILITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACT_GROUPS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACT_INFO;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_CONTACT_LIST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_LOCATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_MAIL_NOTIFICATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_POWER_SAVING;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_REQUESTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_SERVICE_POINT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_INTERFACE_SIMPLE_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_CONNECTION_MANAGER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_DBUS_DAEMON;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_DBUS_INTROSPECTABLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_DBUS_PEER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_DBUS_PROPERTIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_DEBUG;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_MEDIA_SESSION_HANDLER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_MEDIA_STREAM_HANDLER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_PROPERTIES_INTERFACE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_PROTOCOL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_PROTOCOL_INTERFACE_AVATARS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string IFACE_PROTOCOL_INTERFACE_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_AUTOMATIC_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CHANGING_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECTION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECTION_ERROR;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECTION_ERROR_DETAILS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECTION_STATUS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECTION_STATUS_REASON;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CONNECT_AUTOMATICALLY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_CURRENT_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_DISPLAY_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_ENABLED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_HAS_BEEN_ONLINE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_ICON;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_ADDRESSING_URI_SCHEMES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_AVATAR_AVATAR;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_STORAGE_STORAGE_IDENTIFIER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_STORAGE_STORAGE_PROVIDER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_STORAGE_STORAGE_RESTRICTIONS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_INTERFACE_STORAGE_STORAGE_SPECIFIC_INFORMATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_MANAGER_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_MANAGER_INVALID_ACCOUNTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_MANAGER_SUPPORTED_ACCOUNT_PROPERTIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_MANAGER_VALID_ACCOUNTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_NICKNAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_NORMALIZED_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_PARAMETERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_REQUESTED_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_SERVICE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_ACCOUNT_VALID;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_AUTHENTICATION_TLS_CERTIFICATE_CERTIFICATE_CHAIN_DATA;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_AUTHENTICATION_TLS_CERTIFICATE_CERTIFICATE_TYPE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_AUTHENTICATION_TLS_CERTIFICATE_REJECTIONS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_AUTHENTICATION_TLS_CERTIFICATE_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_CHANNEL_TYPE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCHER_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCHER_INTERFACE_OPERATION_LIST_DISPATCH_OPERATIONS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCHER_SUPPORTS_REQUEST_HINTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCH_OPERATION_ACCOUNT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCH_OPERATION_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCH_OPERATION_CONNECTION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCH_OPERATION_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_DISPATCH_OPERATION_POSSIBLE_HANDLERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INITIATOR_HANDLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INITIATOR_ID;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_ANONYMITY_ANONYMITY_MANDATORY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_ANONYMITY_ANONYMITY_MODES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_ANONYMITY_ANONYMOUS_ID;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CHAT_STATE_CHAT_STATES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_INITIAL_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_INITIAL_INVITEE_HANDLES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_INITIAL_INVITEE_IDS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_INVITATION_MESSAGE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_CONFERENCE_ORIGINAL_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_DTMF_CURRENTLY_SENDING_TONES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_DTMF_DEFERRED_TONES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_DTMF_INITIAL_TONES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_GROUP_FLAGS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_HANDLE_OWNERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_LOCAL_PENDING_MEMBERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_MEMBERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_REMOTE_PENDING_MEMBERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_GROUP_SELF_HANDLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_MESSAGES_DELIVERY_REPORTING_SUPPORT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_MESSAGES_MESSAGE_PART_SUPPORT_FLAGS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_MESSAGES_MESSAGE_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_MESSAGES_PENDING_MESSAGES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_MESSAGES_SUPPORTED_CONTENT_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_AUTHORIZATION_IDENTITY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_AVAILABLE_MECHANISMS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_CAN_TRY_AGAIN;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_DEFAULT_REALM;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_DEFAULT_USERNAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_HAS_INITIAL_DATA;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_MAY_SAVE_RESPONSE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_SASL_ERROR;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_SASL_ERROR_DETAILS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SASL_AUTHENTICATION_SASL_STATUS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SECURABLE_ENCRYPTED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SECURABLE_VERIFIED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SERVICE_POINT_CURRENT_SERVICE_POINT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SERVICE_POINT_INITIAL_SERVICE_POINT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SMS_FLASH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_SMS_SMS_CHANNEL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_TUBE_PARAMETERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_INTERFACE_TUBE_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUESTED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_ACCOUNT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_HINTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_PREFERRED_HANDLER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_REQUESTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_REQUEST_USER_ACTION_TIME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TARGET_HANDLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TARGET_HANDLE_TYPE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TARGET_ID;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_CONTACT_SEARCH_AVAILABLE_SEARCH_KEYS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_CONTACT_SEARCH_LIMIT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_CONTACT_SEARCH_SEARCH_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_CONTACT_SEARCH_SERVER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_DBUS_TUBE_DBUS_NAMES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_DBUS_TUBE_SERVICE_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_DBUS_TUBE_SUPPORTED_ACCESS_CONTROLS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_AVAILABLE_SOCKET_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_CONTENT_HASH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_CONTENT_HASH_TYPE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_CONTENT_TYPE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_DATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_DESCRIPTION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_FILENAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_INITIAL_OFFSET;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_SIZE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_TRANSFERRED_BYTES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_FILE_TRANSFER_URI;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_ROOM_LIST_SERVER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_SERVER_AUTHENTICATION_AUTHENTICATION_METHOD;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_SERVER_TLS_CONNECTION_HOSTNAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_SERVER_TLS_CONNECTION_REFERENCE_IDENTITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_SERVER_TLS_CONNECTION_SERVER_CERTIFICATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_STREAMED_MEDIA_IMMUTABLE_STREAMS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_STREAMED_MEDIA_INITIAL_AUDIO;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_STREAMED_MEDIA_INITIAL_VIDEO;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_STREAM_TUBE_SERVICE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CHANNEL_TYPE_STREAM_TUBE_SUPPORTED_SOCKET_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_APPROVER_APPROVER_CHANNEL_FILTER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_HANDLER_BYPASS_APPROVAL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_HANDLER_CAPABILITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_HANDLER_HANDLED_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_HANDLER_HANDLER_CHANNEL_FILTER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_OBSERVER_DELAY_APPROVERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_OBSERVER_OBSERVER_CHANNEL_FILTER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CLIENT_OBSERVER_RECOVER;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_HAS_IMMORTAL_HANDLES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_ANONYMITY_ANONYMITY_MANDATORY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_ANONYMITY_ANONYMITY_MODES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_ANONYMITY_SUPPORTED_ANONYMITY_MODES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_MAXIMUM_AVATAR_BYTES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_MAXIMUM_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_MAXIMUM_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_MINIMUM_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_MINIMUM_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_RECOMMENDED_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_RECOMMENDED_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_AVATARS_SUPPORTED_AVATAR_MIME_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_BALANCE_ACCOUNT_BALANCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_BALANCE_MANAGE_CREDIT_URI;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_IMSI;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_MESSAGE_NATIONAL_CHARACTER_SET;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_MESSAGE_REDUCED_CHARACTER_SET;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_MESSAGE_SERVICE_CENTRE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_MESSAGE_VALIDITY_PERIOD;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CELLULAR_OVERRIDE_MESSAGE_SERVICE_CENTRE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACTS_CONTACT_ATTRIBUTE_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_BLOCKING_CONTACT_BLOCKING_CAPABILITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_GROUPS_DISJOINT_GROUPS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_GROUPS_GROUPS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_GROUPS_GROUP_STORAGE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_INFO_CONTACT_INFO_FLAGS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_INFO_SUPPORTED_FIELDS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_LIST_CAN_CHANGE_CONTACT_LIST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_LIST_CONTACT_LIST_PERSISTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_LIST_CONTACT_LIST_STATE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_CONTACT_LIST_REQUEST_USES_MESSAGE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_LOCATION_LOCATION_ACCESS_CONTROL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_LOCATION_LOCATION_ACCESS_CONTROL_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_LOCATION_SUPPORTED_LOCATION_FEATURES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MAIL_ADDRESS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MAIL_NOTIFICATION_FLAGS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UNREAD_MAILS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UNREAD_MAIL_COUNT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_POWER_SAVING_POWER_SAVING_ACTIVE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_REQUESTS_CHANNELS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_REQUESTS_REQUESTABLE_CHANNEL_CLASSES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_SERVICE_POINT_KNOWN_SERVICE_POINTS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_SIMPLE_PRESENCE_MAXIMUM_STATUS_MESSAGE_LENGTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_INTERFACE_SIMPLE_PRESENCE_STATUSES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_MANAGER_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_MANAGER_PROTOCOLS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_SELF_HANDLE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_CONNECTION_STATUS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_DEBUG_ENABLED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_MEDIA_STREAM_HANDLER_CREATED_LOCALLY;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_MEDIA_STREAM_HANDLER_NAT_TRAVERSAL;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_MEDIA_STREAM_HANDLER_RELAY_INFO;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_MEDIA_STREAM_HANDLER_STUN_SERVERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_AUTHENTICATION_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_CONNECTION_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_ENGLISH_NAME;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_ICON;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_MAXIMUM_AVATAR_BYTES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_MAXIMUM_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_MAXIMUM_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_MINIMUM_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_MINIMUM_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_RECOMMENDED_AVATAR_HEIGHT;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_RECOMMENDED_AVATAR_WIDTH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_AVATARS_SUPPORTED_AVATAR_MIME_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_INTERFACE_PRESENCE_STATUSES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_PARAMETERS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_REQUESTABLE_CHANNEL_CLASSES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string PROP_PROTOCOL_VCARD_FIELD;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CHANNEL_INTERFACE_MEDIA_SIGNALLING_GTALK_P2P;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CHANNEL_INTERFACE_MEDIA_SIGNALLING_ICE_UDP;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CHANNEL_INTERFACE_MEDIA_SIGNALLING_WLM_2009;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CHANNEL_INTERFACE_MEDIA_SIGNALLING_WLM_8_5;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_CONTACT_ID;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_ALIASING_ALIAS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_AVATARS_TOKEN;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CAPABILITIES_CAPS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CLIENT_TYPES_CLIENT_TYPES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_BLOCKING_BLOCKED;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_CAPABILITIES_CAPABILITIES;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_GROUPS_GROUPS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_INFO_INFO;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_LIST_PUBLISH;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_LIST_PUBLISH_REQUEST;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_CONTACT_LIST_SUBSCRIBE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_LOCATION_LOCATION;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const string TOKEN_CONNECTION_INTERFACE_SIMPLE_PRESENCE_PRESENCE;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public const int UNKNOWN_CONNECTION_STATUS;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool asv_get_boolean (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void* asv_get_boxed (GLib.HashTable<weak string,weak GLib.Value> asv, string key, GLib.Type type);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static unowned GLib.Array<weak void*> asv_get_bytes (GLib.HashTable<weak string,weak GLib.Value> asv, string key);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static double asv_get_double (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static int32 asv_get_int32 (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static int64 asv_get_int64 (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static unowned string asv_get_object_path (GLib.HashTable<weak string,weak GLib.Value> asv, string key);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static unowned string asv_get_string (GLib.HashTable<weak string,weak GLib.Value> asv, string key);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static unowned string[] asv_get_strv (GLib.HashTable<weak string,weak GLib.Value> asv, string key);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static uint32 asv_get_uint32 (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static uint64 asv_get_uint64 (GLib.HashTable<weak string,weak GLib.Value> asv, string key, out bool valid);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_check_valid_bus_name (string name, TelepathyGLib.DBusNameType allow_types) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_check_valid_interface_name (string name) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_check_valid_member_name (string name) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_check_valid_object_path (string path) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark dbus_errors_quark ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void dbus_properties_mixin_class_init (GLib.ObjectClass cls, size_t offset);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_properties_mixin_get (GLib.Object self, string interface_name, string property_name, GLib.Value value) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void dbus_properties_mixin_getter_gobject_properties (GLib.Object object, GLib.Quark iface, GLib.Quark name, GLib.Value value, void* getter_data);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void dbus_properties_mixin_iface_init (void* g_iface, void* iface_data);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static bool dbus_properties_mixin_setter_gobject_properties (GLib.Object object, GLib.Quark iface, GLib.Quark name, GLib.Value value, void* setter_data) throws GLib.Error;
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void debug_divert_messages (string filename);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void debug_set_flags (string flags_string);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void debug_set_persistent (bool persistent);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void debug_timestamped_log_handler (string log_domain, GLib.LogLevelFlags log_level, string message, void* ignored);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static unowned string error_get_dbus_name (TelepathyGLib.Error error);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark errors_disconnected_quark ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark errors_removed_from_group_quark ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_account ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_account_interface_addressing ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_account_interface_avatar ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_account_interface_storage ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_account_manager ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_authentication_tls_certificate ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_dispatch_operation ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_dispatcher ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_dispatcher_interface_operation_list ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_anonymity ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_call_state ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_chat_state ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_conference ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_destroyable ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_dtmf ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_group ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_hold ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_media_signalling ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_messages ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_password ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_sasl_authentication ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_securable ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_service_point ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_sms ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_interface_tube ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_request ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_contact_list ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_contact_search ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_dbus_tube ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_file_transfer ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_room_list ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_server_authentication ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_server_tls_connection ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_stream_tube ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_streamed_media ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_text ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_channel_type_tubes ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_client ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_client_approver ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_client_handler ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_client_interface_requests ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_client_observer ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_aliasing ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_anonymity ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_avatars ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_balance ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_capabilities ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_cellular ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_client_types ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contact_blocking ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contact_capabilities ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contact_groups ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contact_info ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contact_list ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_contacts ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_location ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_mail_notification ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_power_saving ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_presence ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_requests ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_service_point ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_interface_simple_presence ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_connection_manager ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_dbus_daemon ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_dbus_introspectable ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_dbus_peer ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_dbus_properties ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_debug ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_media_session_handler ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_media_stream_handler ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_properties_interface ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_protocol ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_protocol_interface_avatars ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static GLib.Quark iface_quark_protocol_interface_presence ();
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void list_connection_managers (TelepathyGLib.DBusDaemon bus_daemon, [CCode (delegate_target_pos = 2.33333)] owned TelepathyGLib.ConnectionManagerListCb callback, GLib.Object? weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void list_connection_names (TelepathyGLib.DBusDaemon bus_daemon, [CCode (delegate_target_pos = 2.33333)] owned TelepathyGLib.ConnectionNameListCb callback, GLib.Object? weak_object);
	[CCode (cheader_filename = "telepathy-glib/telepathy-glib.h")]
	public static void svc_interface_set_dbus_properties_info (GLib.Type g_interface, TelepathyGLib.DBusPropertiesMixinIfaceInfo info);
}
