package Bric::Util::Language::pt_pt;

=encoding utf8

=head1 NAME

Bric::Util::Language::pt_pt - Bricolage Portuguese translation

=head1 VERSION

$LastChangedRevision$

=cut

require Bric; our $VERSION = Bric->VERSION;

=head1 DATE

$LastChangedDate: 2007-07-11 12:35:23 +0200 (Wed, 11 Jul 2007) $

=head1 SYNOPSIS

In F<bricolage.conf>:

  LANGUAGE = pt_pt

=head1 DESCRIPTION

Translation to Portuguese using Lang::Maketext.

=cut

use strict;
use utf8;
use base qw(Bric::Util::Language);

use constant key => 'pt_pt';

our %Lexicon = (

# Date
   'Jan' => 'Jan',
   'Feb' => 'Fev',
   'Mar' => 'Mar',
   'Apr' => 'Abr',
   'May' => 'Mai',
   'Jun' => 'Jun',
   'Jul' => 'Jul',
   'Aug' => 'Ago',
   'Sep' => 'Set',
   'Oct' => 'Out',
   'Nov' => 'Nov',
   'Dec' => 'Dez',
   'Day' => 'Dia',
   'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec' =>
   'Jan Fev Mar Abr Mai Jun Jul Ago Set Out Nov Dez',
   'Month' => 'Mês',

# Time
   'Date'=>'Data',
   'Hour'=> 'Hora',
   'Minute'=>'Minuto',
   'Second'=>'Segundo',

#Expiries
   '1 Day' => '1 Dia',
   '3 Days' => '3 Dias',
   '5 Days' => '5 Dias',
   '10 Days' => '10 Dias',
   '15 Days' => '15 Dias',
   '20 Days' => '20 Dias',
   '30 Days' => '30 Dias',
   '45 Days' => '45 Dias',
   '90 Days' => '90 Dias',
   '180 Days' => '180 Dias',
   '1 Year' => '1 Ano',



# Priotity
   'High'=> 'Alta',
   'Low'     => 'Baixa',
   'Medium High' => 'Média Alta',
   'Medium Low' => 'Média Baixa',
   'Normal'  => 'Normal',

# Areas
   'Alert Type Manager' => 'Gestão de Tipos de Alerta',
   'Category Manager' => 'Gestão de Categorias',
   'Contributor Type Manager ' => 'Gestão de Tipos de Colaborador',
   'Current Output Channels' => 'Canais de Distribuição Correntes',
   'Destination Manager' => 'Gestão de Destinos',
   'Element Manager' => 'Gestão de Elementos',
   'Element Type Manager' => 'Gestão de Tipos de Elementos',
   'Group Manager' => 'Gestão de Grupos',
   'Job Manager' => 'Gestão de Tarefas',
   'Manager' => 'Gestão',
   'Media Gallery' => 'Arquivo Multimedia',
   'Media Type Manager' => 'Gestão de Tipos de Multimedia',
   'Preference Manager ' => 'Gestão das Preferências',
   'Source Manager' => 'Gestão de Fontes',
   'User Manager' => 'Gestão de Utilizadores',
   'Workflow Manager' => 'Gestão de Workflows',
   'Workspace for [_1]' => 'Área de trabalho de [_1]',

# Interface Objects
   'Checkbox'  => 'Checkbox',
   'Columns' => 'Colunas',
   'Custom Fields' => 'Campos Personalizados',
   'Page' => 'Página',
   'Pulldown'  => 'Selecção',
   'Radio Buttons' => 'Botões tipo Rádio',
   'Rows'      => 'Linhas',
   'Size'      => 'Tamanho',
   'Template'  => 'Template',
   'Text Area' => 'Área de Texto',
   'Workflows' => 'Workflows',
   'Workflow'  => 'Workflow',
   '[_1] Field Text' => '[_1] Campo de Texto',

# General Information
  '&quot;Story&quot;' => '&quot;Artigo&quot;',
  '&quot;Template&quot;' => '&quot;Template&quot;',
  'ADMIN' => 'ADMINISTRAÇÃO',
  'ADVANCED SEARCH' => 'PESQUISA AVANÇADA',
  'Actions' => 'Acções',
  'Active' => 'Activo',
  'Active Media' => 'Multimedia Activos',
  'Active Stories' => 'Artigos Activos',
  'Active Templates' => 'Templates Activos',
  'Ad String' => 'Keyword para Publicidade',
  'Ad String 2' => 'Keyword para Publicidade 2',
  'Ad Strings' => 'Keywords de Publicidade',
  'Admin' => 'Administração',
  'Advanced Search' => 'Pesquisa Avançada',
  'Alert Types' => 'Tipos de Alerta',
  'All' => 'Tudo',
  'All Contributors' => 'Todos os Colaboradores',
  'All Elements' => 'Todos os Elementos',
  'All Groups' => 'Todos os Grupos',
  'All Categories' => 'Todas as Categorias',
  'Asset Type' => 'Tipo de Material',
  'Available Groups' => 'Grupos Disponíveis',
  'Available Output Channels' => 'Canais de Distribuição Disponíveis',
  'Bricolage' => 'Bricolage',
  'By Last' => 'Por Apelido',
  'By Source name' => 'Por Fonte',
  'CONTACTS' => 'CONTACTOS',
  'Caption' => 'Designação',
  'Categories' => 'Categorias',
  'Category' => 'Categoria',
  'Category Assets' => 'Materiais da Categoria',
  'Category Profile' => 'Informações de Categoria',
  'Category tree' => 'Árvore de Categorias',
  'Characters' => 'Caracteres',
  'Choose Site' => 'Escolher Site',
  'Contacts' => 'Contactos',
  'Content' => 'Conteúdo',
  'Content Type' => 'Tipo de Conteúdo',
  'Contributor Roles' => 'Papéis do Colaborador',
  'Contributor Type' => 'Tipo de Colaborador',
  'Contributor Type Profile' => 'Gestão de Tipos de Colaborador',
  'Contributor Types' => 'Tipos de Colaborador',
  'Contributors' => 'Colaboradores',
  'Cookie' => 'Cookie',
  'Copy' => 'Copiar',
  'Cover Date' => 'Data de início',
  'Current Groups' => 'Grupos Actuais',
  'Current Note' => 'Notas actuais',
  'Current Version' => 'Versão Actual',
  'Currently Related Story' => 'Artigos relacionados actualmente',
  'DISTRIBUTION' => 'DISTRIBUIÇÃO',
  'Field Elements' => 'Elementos de Dados',
  'Default Value' => 'Valor por defeito',
  'Deployed Date' => 'Data de Entrega',
  'Description' => 'Descrição',
  'Desk Permissions' => 'Permissões para as Áreas',
  'Desks' => 'Áreas',
  'Destinations' => 'Destinos',
  'Directory' => 'Directoria',
  'Display Name' => 'Designação',
  'Domain Name' => 'Nome do Domínio',
  'Element' => 'Elemento',
  'Element Profile' => 'Características do Elemento',
  'Element Type' => 'Elemento',
  'Element Type Profile' => 'Características do Tipo de Elemento',
  'Element Types' => 'Tipos de Elemento',
  'Elements' => 'Elementos',
  'Error' => 'Erro',
  'Event Type' => 'Tipo de evento',
  'Events' => 'Eventos',
  'Existing %n' => '%n existentes',
  'EXISTING CATEGORIES' => 'CATEGORIAS EXISTENTES',
  'EXISTING DESTINATIONS' => 'DESTINOS EXISTENTES',
  'EXISTING ELEMENT TYPES' => 'TIPOS DE ELEMENTO EXISTENTES',
  'EXISTING ELEMENTS' => 'ELEMENTOS EXISTENTES',
  'EXISTING MEDIA TYPES' => 'TIPOS DE MEDIA EXISTENTES',
  'EXISTING OUTPUT CHANNELS' => 'CANAIS DE DISTRIBUIÇÃO EXISTENTES',
  'EXISTING SOURCES' => 'FONTES EXISTENTES',
  'EXISTING USERS' => 'UTILIZADORES EXISTENTES',
  'Expiration' => 'Expiração',
  'Expire Date' => 'Data de Fim',
  'Extension' => 'Extensão',
  'Extensions' => 'Extensões',
  'Fields' => 'Campos',
  'File Name' => 'Nome do Ficheiro',
  'File Path' => 'Caminho para o Ficheiro (PATH)',
  'First' => 'Nome',
  'First Name' => 'Primeiro Nome',
  'Fixed' => 'URL Fixo',
  'Generic' => 'Genérico',
  'Group Type' => 'Tipo de Grupo',
  'Groups' => 'Grupos',
  'HTML::Template' => 'HTML::Template',
  'ID' => 'ID',
  'Information' => 'Informação Geral',
  'Jobs' => 'Tarefas',
  'Key Name' => 'Nome-chave',
  'Label' => 'Etiqueta',
  'Last' => 'Apelido',
  'Last Name' => 'Apelido',
  'Legal' => 'Legal',
  'Log' => 'Histórico',
  'Login ' => 'Login de utilizador',
  'Login and Password' => 'Login e Password',
  'MIME Type' => 'Tipo MIME',
  'Mason' => 'Mason',
  'Max size' => 'Tamanho máx.',
  'Maximum size' => 'Tamanho máximo',
  'Media' => 'Multimedia',
  'Media Profile' => 'Característicad Multimedia',
  'Media Type' => 'Tipo de Multimedia',
  'Media Type Element' => 'Tipo de Multimedia',
  'Media Type Profile' => 'Características do Tipo de Multimedia',
  'Media Types' => 'Tipos de Multimedia',
  'Member Type  ' => 'Tipo de Membro',
  'Members' => 'Membros',
  'My Alerts' => 'Os meus Alertas',
  'My Workspace' => 'Área Pessoal',
  'NAME' => 'NOME',
  'Name' => 'Nome',
  'Never' => 'Nunca',
  'New' => 'Novo',
  'New Role Name' => 'Designação da Nova Função',
  'New password' => 'Nova password',
  'No' => 'Não',
  'No custom fields defined.' => 'Não foram definidos campos personalizados',
  'Normal' => 'Normal',
  'Note' => 'Nota',
  'Note saved.' => 'Nota guardada.',
  'Notes' => 'Notas',
  'OS' => 'Sis. Operativo',
  'Old password' => 'Password antiga',
  'Option, Label' => 'Opção, Etiqueta',
  'Options, Label' => 'Opções, Etiquetas',
  'Order' => 'Ordenação',
  'Organization' => 'Organização',
  'Output Channel' => 'Canal de Distribuição',
  'Output Channels' => 'Canais de Distribuição ',
  'Owner' => 'Responsável',
  'PREFERENCES' => 'PREFERÊNCIAS',
  'PROPERTIES' => 'INFORMAÇÃO GERAL',
  'PUBLISHING' => 'PUBLICAÇÃO',
  'Parent Category' => 'Categoria-mãe',
  'Password' => 'Password',
  'Pending ' => 'Pendentes',
  'Pending %n' => '%n Pendentes',
  'Position' => 'Posição',
  'URI Suffix' => 'Pós URI',
  'URI Prefix' => 'Pré URI',
  'Preferences' => 'Preferências',
  'Prefix' => 'Título',
  'Previews' => 'Previsualizações',
  'Primary Category' => 'Categoria Principal',
  'Primary Output Channel' => 'Canal de Distribuição Principal',
  'Priority' => 'Prioridade',
  'Profile' => 'Características',
  'Properties' => 'Propriedades',
  'Publish Date' => 'Data de Publicação',
  'Publish Desk' => 'Área de Publicação',
  'Publishes' => 'Publicar',
  'Recipients' => 'Destinatários',
  'Related Media' => 'Ficheiro Multimedia Associado',
  'Related Story' => 'Artigo Relacionado',
  'Repeatable' => 'Repetível',
  'Required' => 'Obrigatório',
  'Resources' => 'Recursos',
  'Role' => 'Função',
  'Roles' => 'Funções',
  'STORIES' => 'ARTIGOS',
  'SYSTEM' => 'SISTEMA',
  'Separator String' => 'String de Separador',
  'Simple Search' => 'Pesquisa Simples',
  'Site Profile' => 'Características do Site',
  'Sites' => 'Sites', 
  'Site'  => 'Site',
  'Slug' => 'Identificador',
  'Source' => 'Fonte',
  'Source Profile' => 'Características da Fonte',
  'Source name' => 'Nome da fonte',
  'Sources' => 'Fontes',
  'Start Desk' => 'Área Inicial',
  'Statistics' => 'Estatísticas',
  'Story' => 'Artigo',
  'Story Type' => 'Tipo de Artigo',
  'Story Type Element' => 'Tipo de Elemento de Artigo',
  'Subelements' => 'Subelementos',
  'Subelement' => 'Subelemento',
  'Teaser' => 'Descrição',
  'Template Name' => 'Nome do Template',
  'Text box' => 'Caixa de texto',
  'Title' => 'Título',
  'Trail' => 'Histórico',
  'Type' => 'Tipo',
  'URI' => 'Endereço URI',
  'URL' => 'Endereço URL',
  'Username' => 'Nome de Utilizador (username)',
  'Users' => 'Utilizadores',
  'Value Name' => 'Preferência',
  'Version' => 'Versão',
  'Welcome to Bricolage.' => 'Bem-vindo ao Bricolage',
  'Welcome to [_1].' => 'Bem-vindo ao [_1]',
  'Words' => 'Palavras',
  'Workflow Permissions' => 'Permissões do Workflow',
  'Year' => 'Ano',
  'Yes' => 'Sim',
  '_AUTO' => 1,
  'all' => 'todos',
  'one per line' => 'uma por linha',
  'to' => 'para',

# Action Commands

   'Associate' => 'Associar',
   'Add New Field' => 'Adicionar Novo Campo',
   'Add a New Alert Type' => 'Criar Novo Tipo de Alerta',
   'Add a New Category' => 'Criar Nova Categoria',
   'Add a New Contributor Type' => 'Criar Novo Tipo de Colaborador',
   'Add a New Desk' => 'Criar Nova Área',
   'Add a New Destination' => 'Criar Novo Destino',
   'Add a New Element Type' => 'Criar Novo Tipo de Elemento',
   'Add a New Element' => 'Adicionar Novo Elemento',
   'Add a New Group' => 'Criar Novo Grupo',
   'Add a New Media Type' => 'Criar Novo Tipo de Media',
   'Add a New Output Channel' => 'Criar Novo Canal de Distribuição',
   'Add a New Source' => 'Criar Nova Fonte',
   'Add a New Workflow' => 'Criar Novo Workflow',
   'Add a New Keyword' => 'Adicionar Palavra-chave',
   'Add a New User' => 'Criar Novo Utilizador',
   'Add to Element' => 'Adicionar ao Elemento',
   'Add to Include' => 'Adicionar para Incluir',
   'Add' => 'Adicionar',
   'Allow multiple' => 'Permitir múltiplos',
   'Burner' => 'Sistema de Publicação',
   'Check In Assets' => 'Libertar Materiais',
   'Check In to Edit' => 'Libertar para Edição',
   'Check In to Publish' => 'Libertar para Publicação',
   'Check In to' => 'Libertar para',
   'Check In' => 'Libertar',
   'Checkin' => 'Libertar',
   'Check Out' => 'Reservar',
   'Checkout' => 'Reservar',
   'Choose Contributors' => 'Escolher Colaboradores',
   'Choose Related Media' => 'Escolher Media Relacionados',
   'Choose Subelements' => 'Escolher subelementos',
   'Create a New Category' => 'Criar Nova Categoria',
   'Create a New Media' => 'Criar Novo Multimedia',
   'Create a New Story' => 'Criar Novo Artigo',
   'Create a New Template' => 'Criar Novo Templat',
   'Delete this Desk from all Workflows' => 'Apagar esta Área de TODOS os Workflows',
   'Delete this Element' => 'Apagar este Elemento',
   'Delete this Profile' => 'Apagar',
   'Delete' => 'Apagar',
   'Deploy' => 'Entregar',
   'Download' => 'Download (Ficheiro Actual)',
   'Edit' => 'Editar',
   'Expire' => 'Expirar',
   'Find Media' => 'Pesquisar Multimedia',
   'Find Stories' => 'Pesquisar Artigo',
   'Find Templates' => 'Pesquisar Template',
   'Manage' => 'Gerir',
   'Move Assets' => 'Mover Materiais',
   'Move to' => 'Mover para',
   'New Media ' => 'Novo Multimedia ',
   'New Media' => 'Novo Multimedia',
   'New Story' => 'Novo Artigo',
   'New Template' => 'Novo Template',
   'Preview in' => 'Prever em',
   'Publish' => 'Publicar',
   'Relate' => 'Relacionar',
   'Remove' => 'Remover',
   'Repeat new password' => 'Repetir nova password',
   'SEARCH' => 'PESQUISAR',
   'SUBMIT' => 'OK',
   'Scheduler' => 'Planear',
   'Select Desk' => 'Seleccionar Área',
   'Select Role' => 'Seleccionar Função',
   'Select an Event Type' => 'Seleccionar Tipo de Evento',
   'Select' => 'Seleccionar',
   'Sort By' => 'Ordenar Por',
   'Submit' => 'Ok',
   'Switch Roles' => 'Mudar Funções',
   'Template Profile' => 'Características do Template',
   'Template Code' => 'Template Code',
   'Un-Associate' => 'Desassociar',
   'Upload a file' => 'Adicionar ficheiro',
   'User Override' => 'User Overide',
   'View' => 'Ver',
   'Workflow Profile' => 'Características do Workflow',
   'Grant "[_1]" members permission to access assets in these categories.' =>
     'Conceder permissões aos membros do grupo [_1] para aceder aos materiais destas categorias.',
   'Grant "[_1]" members permission to access assets in these workflows.' =>
     'Conceder permissões aos membros do grupo [_1] para aceder aos materiais destes workflows.',
   'Grant "[_1]" members permission to access assets on these desks.' =>
     'Conceder acesso aos membros do grupo [_1]  aos materiais nestas áreas.',
   'Grant "[_1]" members permission to access the members of these groups.' =>
     'Conceder permissões aos membros do grupo [_1] para aceder aos membros destes grupos.',
   'Grant the members of the following groups permission to access the members of the "[_1]" group.' =>
     'Conceder permissão aos membros dos seguintes grupos para aceder aos membros do grupo [_1].',


# System reply messages
  '"[_1]" Elements saved.' => '"[_1]" Elementos gravados.',
  '%n Found' => '%n Resultados',
  '404 NOT FOUND' => '404 - página não encontrada',
  'A site with the [_1] "[_2]" already exists' => 'O site [_1] "[_2]" já existe',
  'Action profile "[_1]" deleted.' => 'A acção "[_1]" foi apagada.',
  'Action profile "[_1]" saved.' => 'A acção "[_1]" foi guardada.',
  'Add a New Action' => 'Adicionar Acção',
  'Add a New Server' => 'Adicionar Servidor',
  'Alert Type profile "[_1]" deleted.' => 'Tipo de Alerta "[_1]" apagado.',
  'Alert Type profile "[_1]" saved.' => 'Tipo de Alerta "[_1]" gravado.',
  'Alias in Category' => 'Referências nesta Categoria',
  'Alias to "[_1]" created and saved.' => 'Referência para "[_1]" guardada.',
  'All Types' => 'Todos os Tipos',
  'The "[_1]" field type already exists. Please try another key name.' => 'Já existe um atributo com essa designação ("[_1]"). Por favor tente outro nome.',
  'An active template already exists for the selected output channel, category, element and burner you selected.  You must delete the existing template before you can add a new one.' => 'Já existe um template activo para o canal de distribuição/categoria/elemento e burner que assinalou. Tem de apagar o template existente antes de poder adicionar um novo.',
  'An error occurred while processing your request:' => 'Surgiu um erro ao processar o seu pedido:',
  'An error occurred.' => 'Ocorreu um erro.',
  'At least one extension is required.' => 'Tem de indicar pelo menos uma extensão.',
  'Bad element name "[_1]". Did you mean "[_2]"?' => 'O nome "[_1]" não pode ser utilizado. Queria dizer "[_2]"?',
  'Cannot auto-publish related media "[_1]" because it is checked out.' => 'Não é possível fazer publicação automática dos elementos multimedia porque este se encontram reservados.',
  'Cannot auto-publish related story "[_1]" because it is checked out.' => 'O artigo "[_1]" não pode ser publicado enquanto estiver reservado.',
  'Cannot both delete and make primary a single output channel.' => 'Não é possível apagar e ao mesmo tempo tornar primário um Canal de Distribuição, por favor execute cada uma das acções de forma independente',
  'Cannot cancel "[_1]" because it is currently executing.' => 'Não é possível cancelar "[_1]" porque está neste momento a ser executado.',
  'Cannot create an alias to a media in the same site.' => 'Não é possível criar uma referência a um multimedia dentro do mesmo site.',
  'Cannot create an alias to a story in the same site.' => 'Não é possível criar uma referência a um artigo dentro do mesmo site.',
  'Cannot move [_1] asset "[_2]" while it is checked out' => 'Não é possível mover [_1], uma vez que o mesmo se encontra reservado.',
  'Cannot preview asset "[_1]" because there are no Preview Destinations associated with its output channels.' => 'Não é possível prever o objecto "[_1]" porque não há destinos de pré-visualização associados aos respectivos Canais de Distribuição',
  'Cannot publish asset "[_1]" to "[_2]" because there are no Destinations associated with this output channel.' =>  'Não é possível publicar "[_1]" em "[_2]" porque o respectivo Canal de Distribuição não tem ainda nenhum destinos associado.',
  'Cannot publish checked-out media "[_1]"' => 'Não é possível publicar o elemento multimedia que se encontre reservado "[_1]"',
  'Cannot publish checked-out story "[_1]"' => 'Não é possível publicar o artigo que se encontra reservado "[_1]"',
  'Cannot publish media "[_1]" because it is checked out.' => 'Não é possível publicar um elemento multimedia ("[_1]") porque se encontra reservado.',
  'Cannot publish story "[_1]" because it is checked out.' => 'Não é possível publicar o artigo "[_1]" porque o mesmo se encontra reservado.',
  'Cascade into Subcategories' => 'Propagar às Sub-Categorias',
  'Category "[_1]" added.' => 'Categoria "[_1]" guardada.',
  'Category "[_1]" cannot be deleted.' => 'A categoria "[_1]" não pode ser apagada.',
  'Category "[_1]" disassociated.' => 'Categoria "[_1]" desassociada.',
  'Category Permissions' => 'Permissões para a Categoria',
  'Category URI' => 'Endereço URI da Categoria',
  'Category profile "[_1]" and all its categories deleted.' => 'A categoria "[1]" e respectivas subcategorias foram apagadas.',
  'Category profile "[_1]" deleted.' => 'A categoria "[_1]" foi apagada.',
  'Category profile "[_1]" saved.' => 'Categoria "[_1]" guardada.',
  'Changes not saved: permission denied.' => 'Não foi possível guardar as suas alterações: permissão inválida.',
  'Check In to [_1]' => 'Libertar para [_1]',
  'Choose a Related Story' => 'Escolher Artigo Relacionado',
  'Contributor "[_1]" disassociated.' => 'Colaborador "[_1]" desassociado.',
  'Contributor Type Manager' => 'Gestão de Tipos de Colaborador',
  'Contributor profile "[_1]" deleted.' => 'Colaborador "[_1]" apagado.',
  'Contributor profile "[_1]" saved.' => 'Colaborador "[_1]" gravado.',
  'Contributors disassociated.' => 'Colaboradores desassociados.',
  'Copy Resources' => 'Copiar Objectos',
  'Cover Date incomplete.' => 'Data de Destaque incompleta.',
  'Delete this Category and All its Subcategories' => 'Apagar esta Categoria e TODAS as suas Subcategorias',
  'Deployed Version' => 'Versão em produção',
  'Desk profile "[_1]" deleted from all workflows.' => 'Área "[_1]" apagada em todos os workflows.',
  'Destination' => 'Destino',
  'Destination Profile' => 'Caracteriticas do Destino',
  'Destination not specified' => 'Destino não especificado',
  'Destination profile "[_1]" deleted.' => 'Destino "[_1]" apagado.',
  'Destination profile "[_1]" saved.' => 'Destino "[_1]" gravado.',
  'Directory name "[_1]" contains invalid characters. Please try a different directory name.' => 'O nome de directório "[_1]" contém caracteres inválidos. por favor tente um nome de directório diferente.',
  'Distributing files.' => 'A distribuir ficheiros.',
  'Document Root' => 'Raíz dos documentos',
  'Element "[_1]" deleted.' => 'Elemento "[_1]" apagado.',
  'Element "[_1]" saved.' => 'Elemento "[_1]" gravado.',
  'Element Type profile "[_1]" deleted.' => 'Tipo de Elemento "[_1]" apagado.',
  'Element Type profile "[_1]" saved.' => 'Tipo de Elemento "[_1]" gravado.',
  'Expire Date incomplete.' => 'Data de Expiração incompleta.',
  'Extension "[_1]" ignored.' => 'Extensão "[_1]" ignorada.',
  'Extension "[_1]" is already used by media type "[_2]".' => 'A Extensão "[_1]" já está a ser utilizada pelo Tipo de Media "[_2]".',
  'FTP' => 'FTP',
  'Field "[_1]" appears more than once but it is not a repeatable element.  Please remove all but one.' => 'O campo "[_1]" não é repetível, no entanto surge mais que uma vez. Por favor remova os campos em excesso.',
  'Field profile "[_1]" deleted.' => 'Campo "[_1]" apagado.',
  'Field profile "[_2]" saved.' => 'Campo "[_1]" gravado.',
  'File System' => 'Sistema de Ficheiros',
  'Find Media To Alias' => 'Encontrar Multimedia para referenciar',
  'Find Story To Alias' => 'Encontrar Artigo para referenciar',
  'Find a media to alias' => 'Encontrar um multimedia para referenciar',
  'Find a story to alias' => 'Encontrar um artigo para referenciar',
  'From' => 'Desde',
  'Group Label' => 'Designação do Grupo',
  'Group Memberships' => 'Membros do Grupo',
  'Group cannot be deleted.' => 'O grupo não pode ser apagado.',
  'Group profile "[_1]" deleted.' => 'Grupo "[_1]" apagado.',
  'Group profile "[_1]" saved.' => 'Grupo "[_1]" gravado.',
  'Hi [_1]!' => 'Olá [_1]!',
  'Host Name' => 'Nome do servidor',
  'Invalid date value for "[_1]" field.' => 'Data inválida no campo "[_1]".',
  'Invalid page request' => 'Pedido de página inválido',
  'Invalid password. Please try again.' => 'Password inválida! Por favor tente de novo.',
  'Invalid username or password. Please try again.' => 'Nome de utilizador ou palavra-passe inválidos! Por favor volte a tentar.',
  'Job profile "[_1]" deleted.' => 'Tarefa "[_1]" apagado.',
  'Job profile "[_1]" saved.' => 'Tarefa "[_1]" gravado.',
  'Keyword' => 'Palavra-chave',
  'Keyword Manager' => 'Gestão de Palavras-chave',
  'Keyword Profile' => 'Caraterísticas da palavras-chave',
  'Keywords' => 'Palavras-chave',
  'Keywords saved.' => 'Palavras-chave guardadas.',
  'Login "[_1]" contains invalid characters.' => 'O login "[_1]" contém caracteres inválidos.',
  'Login "[_1]" is already in use. Please try again.' => 'O login "[_1]" já está a ser utilizado. Por favor tente de novo.',
  'Login cannot be blank. Please enter a login.' => 'O nome de utilizador (login) não pode estar em branco. Por favor insira de novo.',
  'Login must be at least [_1] characters.' => 'O login tem de ter pelo menos [_1] caracteres.',
  'MEDIA FOUND' => 'MULTIMEDIA ENCONTRADOS',
  'Media "[_1]" check out canceled.' => 'Reserva de "[_1]" cancelada.',
  'Media "[_1]" created and saved.' => 'Multimedia "[_1]" gravado.',
  'Media "[_1]" deleted.' => 'Multimedia "[_1]" apagado.',
  'Media "[_1]" published.' => 'Multimedia "[_1]" publicado.',
  'Media "[_1]" reverted to V.[_2]' => 'Multimedia "[_1]" revertido para versão [_2]',
  'Media "[_1]" saved and checked in to "[_2]".' => 'Multimedia "[_1]" gravado e libertado para "[_2]".',
  'Media "[_1]" saved and moved to "[_2]".' => 'Multimedia "[_1]" gravado e movido para "[_2]".',
  'Media "[_1]" saved and shelved.' => 'Multimedia "[_1] gravado e arquivado.',
  'Media "[_1]" saved.' => 'Multimedia "[_1]" gravado.',
  'Media Type profile "[_1]" deleted.' => 'Tipo de Multimedia "[_1]" apagado.',
  'Media Type profile "[_1]" saved.' => 'Tipo de Multimedia "[_1]" gravado.',
  'Move Method' => 'Mover utilizando',
  'Move to Desk' => 'Mover para a Área',
  'Name is required.' => 'O nome é obrigatório.',
  'Needs to be Deployed' => 'Precisa de ser lançado',
  'Needs to be Published' => 'Precisa de ser publicado',
  'New Alias' => 'Nova Referência',
  'New passwords do not match. Please try again.' => 'As palavras-chave introduzidas são diferentes. Por favor tente de novo.',
  'No Alias' => 'Não existem referências',
  'No alert types were found' => 'Não foram encontrados tipos de alerta',
  'No categories were found' => 'Não foram encontradas categorias',
  'No contributor types were found' => 'Não foram encontrados tipos de colaborador',
  'No contributors defined' => 'Não existem colaboradores definidos',
  'No contributors defined.' => 'Não existem colaboradores definidos',
  'No destinations were found' => 'Não foram encontrados destinos',
  'No element types were found' => 'Não foram encontrados tipos de elementos',
  'No elements are present.' => 'Não existem elementos.',
  'No elements have been added.' => 'Não foram adicionados elementos.',
  'No elements were found' => 'Não foram encontrados elementos',
  'No existing notes.' => 'Não existem notas.',
  'No file associated with media "[_1]". Skipping.' => 'Não existe ficheiro multimedia para "[_1]" - Ignorar',
  'No file has been uploaded' => 'Não foi feito upload de nenhum ficheiro',
  'No groups were found' => 'Não foram encontrados grupos',
  'No jobs were found' => 'Não foram encontradas tarefas',
  'No keywords defined.' => 'Não existem palavras-chave definidas.',
  'No media file is associated with asset "[_1]", so none will be distributed.' => 'Não haverá distribuição porque ao objecto "[_1]" não existe relacionado nenhum ficheiros multimedia associado.',
  'No media types were found' => 'Não foram encontrados tipos de multimedia',
  'No media were found' => 'Não foram encontrados elementos multimedia',
  'No output channels were found' => 'Não foram encontrados canais de distribuição',
  'No output to preview.' => 'Nada escrito para prever',
  'No related Stories' => 'Não há artigos relacionados',
  'No servers were found' => 'Não foram encontrados servidores',
  'No sources were found' => 'Não foram encontradas fontes',
  'No stories were found' => 'Não foram encontrados artigos',
  'No templates were found' => 'Não foram encontrados modelos',
  'No users were found' => 'Não foram encontrados utilizadores',
  'No workflows were found' => 'Não foram encontrados workflows',
  'Note: Container element "[_1]" removed in bulk edit but will not be deleted.' => 'Nota: o elemento "[_1]" foi removido na edição em bloco, no entanto não será apagado.',
  'Note: Field element "[_1]" is required and cannot be completely removed.  Will delete all but one.' => 'Nota: O campo "[_1]" é obrigatório e não pode ser completamente removido, pelo que o sistema irá manter um deles.',
  'Object Group Permissions' => 'Permissões para Tipos de Objectos',
  'Or Pick a Type' => 'Ou Escolha por Tipo',
  'Output Channel profile "[_1]" deleted.' => 'Canal de Distribuição "[_1]" apagado.',
  'Output Channel profile "[_1]" saved.' => 'Canal de Distribuição "[_1]" gravado.',
  'PENDING JOBS' => 'TAREFAS PENDENTES',
  'Parent cannot choose itself or its child as its parent. Try a different parent.' => 'Uma categoria não pode ser mãe dela própria, nem ter como mãe uma das suas filhas. Por favor escolha outra categoria.',
  'Password contains illegal preceding or trailing spaces. Please try again.' => 'A password não pode conter espaços no início ou seu meio. Por favor insira uma nova password.',
  'Passwords cannot have spaces at the beginning!' => 'As passwords não podem ter espaços no início!',
  'Passwords cannot have spaces at the end!' => 'As passwords não podem ter espaços no final!',
  'Passwords do not match!  Please re-enter.' => 'As passwords introduzidas não são iguais. Por favor tente de novo.',
  'Passwords must be at least [_1] characters!' => 'As passwords têm de ter pelo menos [_1] caracteres!',
  'Passwords must match!' => 'As passwords introduzidas são diferentes!',
  'Permission Denied' => 'Acesso não autorizado',
  'Permission to checkout "[_1]" denied.' => 'Reservar de "[_1]" não autorizada.',
  'Permission to delete "[_1]" denied.' => 'Não está autorizado a apagar "[_1]".',
  'Permissions saved.' => 'Permissões guardadas',
  'Please check the URL and try again. If you feel you have reached this page as a result of a server error or other bug, please notify the server administrator. Be sure to include as much detail as possible, including the type of browser, operating system, and the steps leading up to your arrival here.' => 'Por favor verifique o URL e volte a tentar. Caso pense que chegou a esta página em resultado de um erro de servidor ou outra falha, por favor notifique o administrador do sistema. Inclua o máximo de informação possível, incluindo o tipo de browser, sistema operativo, e os passos que percorreu até chegar aqui.',
  'Please click [_1]here[_2] to start.' => 'Por favor clique [_1]aqui[_2] para iniciar.',
  'Please log in:' => 'Por favor, introduza o seu Nome de Utilizador e respectiva Password',
  'Please select a primary category.' => 'Por favor seleccione uma categoria primária.',
  'Please select a primary output channel.' => 'Por favor seleccione um canal de distribuição primário.',
  'Please select a story type.' => 'Por favor seleccione um tipo de artigo.',
  'Preference "[_1]" updated.' => 'Preferência "[_1]" actualizada.',
  'Problem adding "[_1]"' => 'Problemas ao criar "[_1]".',
  'Problem deleting "[_1]"' => 'Problemas ao apagar "[_1]".',
  'Published Version' => 'Versão publicada',
  'Redirecting to preview.' => 'A redireccionar para previsualização.',
  'Related Media to Alias' => 'Multimedia a Referenciar',
  'Related Story to Alias' => 'Artigo a Referenciar',
  'STORY INFORMATION' => 'INFORMAÇÃO SOBRE O ARTIGO',
  'Scheduled Time' => 'Data agendada',
  'Select Alias' => 'Criar Referência',
  'Select Categories' => 'Seleccionar Categorias',
  'Separator Changed.' => 'Separador Alterado.',
  'Server profile "[_1]" deleted.' => 'Servidor "[_1]" apagado.',
  'Server profile "[_1]" saved.' => 'Servidor "[_1]" gravado.',
  'Servers' => 'Servidores',
  'Site "[_1]" requires a primary output channel.' => 'O Site "[_1]" precisa dum canal de distribuição primário',
  'Site profile "[_1]" deleted.' => 'Site "[_1]" apagado.',
  'Site profile "[_1]" saved.' => 'Site "[_1]" gravado.',
  'Slug must conform to URI character rules.' => 'O identificador do URL deve seguir as regras de caracteres dos URIs.',
  'Sort Name' => 'Nome da ordenação',
  'Source profile "[_1]" deleted.' => 'Fonte "[_1]" apagada.',
  'Source profile "[_1]" saved.' => 'Fonte "[_1]" guardada.',
  'Status' => 'Estado',
  'Stories' => 'Artigos',
  'Stories in this category' => 'Artigos desta categoria',
  'Story "[_1]" check out canceled.' => 'Reserva do artigo "[_1]" cancelada.',
  'Story "[_1]" created and saved.' => 'Artigo "[_1]" gravado.',
  'Story "[_1]" deleted.' => 'Artigo "[_1]" apagado.',
  'Story "[_1]" published.' => 'Artigo "[_1]" publicado.',
  'Story "[_1]" reverted to V.[_2].' => 'Artigo "[_1]" revertido para a versão [_2].',
  'Story "[_1]" saved and checked in to "[_2]".' => 'Artigo "[_1]" gravado e libertado para "[_2]".',
  'Story "[_1]" saved and moved to "[_2]".' => 'Artigo "[_1]" gravado e movido para "[_2]"',
  'Story "[_1]" saved and shelved.' => 'Artigo "[_1]" gravado e arquivado.',
  'Story "[_1]" saved.' => 'Artigo "[_1]" gravado.',
  'Template "[_1]" check out canceled.' => 'Reserva do Template "[_1]" cancelada.',
  'Template "[_1]" deleted.' => 'Template "[_1]" apagado.',
  'Template "[_1]" saved and checked in to "[_2]".' => 'Template "[_1]" libertado para a área "[_2]".',
  'Template "[_1]" saved and moved to "[_2]".' => 'Template "[_1]" gravado e movido para "[_2]".',
  'Template "[_1]" saved and shelved.' => 'Template "[_1]" gravado e arquivado.',
  'Template "[_1]" saved.' => 'Template "[_1]" gravado.',
  'Template Includes' => 'Template a incluir',
  'Template compile failed: [_1]' => 'Compilação do Template falhou: [_1]',
  'Template deployed.' => 'Template passado a produção',
  'Templates' => 'Templates',
  'Templates Found' => 'Templates Encontrados',
  'Text to search' => 'Texto a pesquisar',
  'The URI "[_1]" is not unique. Please change the cover date, output channels, category, or file name as necessary to make the URIs unique.' => 'O URI "[_1]" não é único. Para corrigir este problema sugere-se as seguintes alterações possíveis: mudar a Categoria, o nome do ficheiro, os canais de distribuição ou a data da página de destaques.',
  'The URL you requested, <b>[_1]</b>, was not found on this server' => 'O URL pedido, <b>[_1]</b>, não foi encontrado neste servidor',
  'The name "[_1]" is already used by another Alert Type.' => 'O nome "[_1]" já está a ser utilizado por outro Tipo de Alerta.',
  'The name "[_1]" is already used by another Desk.' => 'O nome "[_1]" já está a ser utilizado noutra Área.',
  'The name "[_1]" is already used by another Destination.' => 'O nome "[_1]" já está a ser utilizado por outro Destino',
  'The name "[_1]" is already used by another Element Type.' => 'O nome "[_1]" já está a ser usado por outro Tipo de Elemento.',
  'The name "[_1]" is already used by another Media Type.' => 'O nome "[_1]" já está a ser utilizado por outro Tipo de Multimedia.',
  'The name "[_1]" is already used by another Output Channel.' => 'O nome "[_1]" já está a ser usado por outro Canal de Distribuição.',
  'The name "[_1]" is already used by another Server in this Destination.' => 'O nome "[_1]" já está a ser utilizado por outro Servidor neste Destino',
  'The name "[_1]" is already used by another Source.' => 'O nome "[_1]" já está a ser usada por outra Fonte',
  'The name "[_1]" is already used by another Workflow.' => 'O nome "[_1]" já está a ser usado por outro Workflow.',
  'The slug can only contain alphanumeric characters (A-Z, 0-9, - or _)!' => 'O identificador no URL só pode conter caracteres alfanuméricos (A-Z, 0-9, - ou _)!',
  'The slug, category and cover date you selected would have caused this story to have a URI conflicting with that of story [_1].' => 'O URL, categoria e data de publicação que seleccionou iram causar um conflito entre este artigo e o artigo [_1].',
  'This day does not exist! Your day is changed to the' => 'A data introduzida não existe, pelo que foi alterada para ',
  'This story has not been assigned to a category.' => 'Este artigo não possui categoria.',
  'To' => 'Até',
  'URI "[_1]" is already in use. Please try a different directory name or parent category.' => 'O URI "[_1]" já está a ser usado. Por favor tente um nome de categoria ou outra categoria \'mãe\' diferente.',
  'Un-relate' => 'Anular relação',
  'User profile "[_1]" deleted.' => 'Utilizador "[_1]" apagado.',
  'User profile "[_1]" saved.' => 'Utilizador "[_1]" gravado',
  'Usernames must be at least 6 characters!' => 'Os nomes de utilizador têm de ter pelo menos 6 caracteres!',
  'Using Bricolage without JavaScript can result in corrupt data and system instability. Please activate JavaScript in your browser before continuing.' => 'Utilizar o Bricolage sem JavaScript pode levar à corrupção de informação e tornar o sistema incoerente. por favor active o JavaScript no seu browser antes de continuar.',
  'V.' => 'V.',
  'Value of [_1] cannot be empty' => 'O valor de [_1] tem que ser preenchido',
  'Warning! Bricolage is designed to run with JavaScript enabled.' => 'ATENÇÃO! O Bricolage foi concebido para ser utilizado com JavaScript activado.',
  'Warning! State inconsistent: Please use the buttons provided by the application rather than the \'Back\'/\'Forward\' buttons.' =>  'ATENÇÃO: Acção inválida - Por favor utilize os botões disponíveis na aplicação e não os botões \'Back\'/\'Forward\' (\'Avançar\'/\'Retroceder\') do browser.',
  'Warning:  Use of element\'s \'name\' field is deprecated for use with element method \'get_container\'.  Please use the element\'s \'key_name\' field instead.' => 'ATENÇÃO:  A utilização do \'nome\' do elemento com o método \'get_container\' foi abandonada. Deve-se utilizar o \'key_name\'.',
  'Warning:  Use of element\'s \'name\' field is deprecated for use with element method \'get_value\'.  Please use the element\'s \'key_name\' field instead.' => 'ATENÇÃO:  A utilização do \'nome\' do elemento com o método \'get_value\' foi abandonada. Deve-se utilizar o \'key_name\'.',
  'Warning: object "[_1]" had no associated desk.  It has been assigned to the "[_2]" desk.' => 'ATENÇÃO: o objecto "[_1]" não tem área associada. Foi atribuído à secretária "[_2]".',
  'Warning: object "[_1]" had no associated workflow.  It has been assigned to the "[_2]" workflow.' => 'ATENÇÃO: o objecto "[_1]" não estava associado a um Workflow. Foi-lhe designado o workflow "[_2]"',
  'Warning: object "[_1]" had no associated workflow.  It has been assigned to the "[_2]" workflow. This change also required that this object be moved to the "[_3]" desk.' => 'ATENÇÃO: o objecto "[_1]" não estava associado a um Workflow. Foi-lhe designado o workflow "[_2]" e a Área "[_3]"',
  'Welcome to [_1]' => 'Bem-vindo ao [_1]',
  'Workflow profile "[_1]" deleted.' => 'Workflow "[_1]" apagado.',
  'Writing files to "[_1]" Output Channel.' => 'A escrever ficheiros para "[_1]".',
  'You are about to permanently delete items! Do you wish to continue?' => 'Irá apagar definitivamente estes elementos! Quer continuar?',
  'You cannot remove all Sites.' => 'Não é possível remover todos os Sites.',
  'You have not been granted <b>[_1]</b> access to the <b>[_2]</b> [_3]' => 'Não tem acesso de <b>[_1]</b> a <b>[_3]</b> [_2]',
  'You must be an administrator to use this function.' => 'Esta função é reservada aos administrador deste sistema.',
  'You must select an Element or check the &quot;Generic&quot; check box.' => 'Tem de seleccionar um Elemento ou assinalar a check box &quot;Genérico&quot;.',
  'You must select an Element.' => 'É necessário escolher um Elemento',
  'You must supply a unique name for this role!' => 'Tem de atribuir um nome único a esta função!',
  'You must supply a value for ' => 'Tem de indicar um valor para ',
  '[_1] recipients changed.' => '[_1] destinatários alterados.',
  '[quant,$quant,Contributors] [_1] [quant,$quant,disassociated].' => 'Colaboradore(s) [_1] desassociado(s).',
  '[quant,_1,Alert] acknowledged.' => '[quant,_1,Alerta,Alertas] lidos.',
  '[quant,_1,Contributor] "[_2]" associated.' => '[quant,_1,Associado Colaborador, Associado Colaboradores] "[_2]".',
  '[quant,_1,Template] deployed.' => '[quant,_1,Template,Templates] lançad[quant,_1,o,os].',
  '[quant,_1,media,media] published.' => '[quant,_1,Multimedia publicado,Multimedia publicados]',
  '[quant,_1,story,stories] published.' => '[quant,_1,Artigo publicado,Artigos publicados]',
  'contains illegal characters!' => ' contém caracteres inválidos!',
  'Element must be associated with at least one site and one output channel.' => 'O elemento deve estar associado a pelo menos um Site e um Canal de Distribuição',
  'Permission to manage "[_1]" group membership denied' => 'Não possui permissões para gerir o grupo "[_1]"',
  'Permission to grant permission "[_1]" to group "[_2]" denied' => 'Não possui permissões para conceber privilégios a "[_1]" no grupo "[_2]"',
  'This job has failed' => 'Esta tarefa falhou',
  'First Published' => 'Primeira publicação',
  'You do not have permission to add "[_1]" objects' => 'Não possui permissões para adicionar os elementos "[_1]"',
  'Remaining' => 'Restantes',
  'The error message is available below. No further execution attempts will be made on this job unless you check the "Reset this Job" checkbox below.' => 'A messagem de erro encontram em baixo, no entanto não serão realizadas novas tentativas de realizar esta tarefa a menos que seleccione a checkbox "Reset this Job" em baixo.',
  'Not defined.' => 'Não existe.',
  'Milliseconds' => 'Mili-segundos',
  'Microseconds' => 'Micro-segundos',
  'Precision' => 'Precisão',
  'Object Groups' => 'Grupos de Objectos',
  'You do not have permission to override user "[_1]"' => 'Não possui permissões para se ligar como o utilizador "[_1]"',
  'You do not have sufficient permission to create a media document for this site' =>  'Não possui suficientes permissões para creat um elemento multimedia neste site.',
  '[_1] Site Categories' => 'Categorias do site [_1]',
  '[_1] Site [_2] Permissions' => 'Permissões de [_1] [_2]', # Site Category Permissions
  'The primary category cannot be deleted.' => 'A categoria principal não pode ser apagada.',
  'Reactivate' => 'Re-activar',
  'All Subelements' => 'Todos os Sub-Elementos',
  'Code' => 'Código',
  'Code Select' => 'Seleccionar Código',
  'Include deleted' => 'Incluir apagados',
  'Job "[_1]" has been reset.' => 'A tarefa "[_1]" foi re-inicializada.',
  'Cannot make a dissociated category the primary category.' => 'Não é possível tornar uma categoria não relacionada como primária.',
  'Name "[_1]" is not a valid media name. The name must be of the form "type/subtype".' => 'O nome "[_1]" não é um nome válido. O nome deve ser na forma "tipo/subtipo".',
  '[quant,_1,media,media] expired.' => '[quant,_1,multimedia expirado, multimedia expirados].',
  '[quant,_1,story,stories] expired.' => '[quant,_1,artigo expirado,artigos expirados].',
  'No context for content beginning at line [_1].' => 'O conteúdo que começa na linha [_1] não possui contexto.',
  'Unknown tag "[_1]" at line [_2].' => 'Etiqueta desconhecida ("[_1]") na linha [_2].',
  'No such site "[_1]" at line [_2].'=> 'Não existe o site "[_1]" na linha [_2].',
  'No such URI "[_1]" in site "[_2]" at line [_3].' => 'Não existe o URI "[_1]" no site "[_2]" na linha [_3].',
  'D (for Deployed)'  => 'L (de Lançado)',
  'P (for Published)' => 'P (de Publicado)',
  'No story document found for UUID "[_1]" at line [_2].' => 'Não foi encontrado nenhum artigo com o UUID "[_1]" na linha [_2].',
  'No media document found for UUID "[_1]" at line [_2].' => 'Não foi encontrado nenhum multimedia com o UUID "[_1]" na linha [_2].',
  'No story document found for ID "[_1]" at line [_2].' => 'Não foi encontrado nenhum artigo com o ID "[_1]" na linha [_2].',
  'No media document found for ID "[_1]" at line [_2].' => 'Não foi encontrado nenhum multimedia com o ID "[_1]" na linha [_2].',
  'No story document found for URI "[_1]" at line [_2].' => 'Não foi encontrado nenhum artigo com o URI "[_1]" na linha [_2].',
  'No media document found for URI "[_1]" at line [_2].' => 'Não foi encontrado nenhum multimedia com o URI "[_1]" na linha [_2].',
  'Non-repeatable field "[_1]" appears more than once beginning at line [_2]. Please remove all but one.' => 'O campo "[_1]" é não repetível, no entanto surge mais do que uma vez na linha [_2]. Por favor apagar os restantes em excesso.',
  'No such subelement "[_1]" at line [_2]. Did you mean "[_3]"?' => 'Não existe o subelemento "[_1]" na linha [_2]. Queria dizer "[_3]"?',
  'No such field "[_1]" at line [_2]. Did you mean "[_3]"?' => 'Não existe o campo "[_1]" na linha [_2]. Queria dizer "[_3]"?',
  'Invalid codeselect code (didnt return an array ref of even size)' => 'Invalid codeselect code (didnt return an array ref of even size)',
  'Related [_1] "[_2]" is not activate. Please relate another [_1].' => 'A relação [_1] "[_2]" não está activa. Por favor relacione outro [_1].',
  'The URI "[_1]" is not unique. Please change the cover date, output channels, slug, or categories as necessary to make the URIs unique.' => 'O URI "[_1]" não é único. Por favor altere a data de publicação, o canal de distribuição, identificador ou categorias conforme necessário para tornar o URI unico.',
  'Cannot auto-publish related $rel_disp_name "[_1]" because it is not on a publish desk.' => 'Não é possível publicar automáticamente $rel_disp_name "[_1]" por não se encontrar numa área de publicação.',
  '_AUTO' => 1,
);

=begin comment

To translate:

   'Shelve'
   'and Shelve'
   'and'
	'EXISTING NOTES' => 'NOTAS EXISTENTES',
	'Primary URI' => 'Endereço URI', 
	'Story Trail' => 'Histórico do Artigo',
	'Triggered ' => 'Activado por',
	'Attributes' => 'Atributos',
	'Logged in as' => 'Ligado como',
	'Clone' => 'Clonar',
	'Last Published' => 'Última Publicação',

=end comment

=cut

1;

__END__

=head1 AUTHOR

ClE<aacute>udio Valente <cvalente@co.sapo.pt>,
Joao Pedro Goncalves <joaop@co.sapo.pt>
Pedro Custódio <pecus@co.sapo.pt>

=head1 SEE ALSO

NONE

=cut
