/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;

public final class FacetedProjectFramework {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.project.facet.core";
    private static ProjectFacetsManagerImpl impl = null;

    private FacetedProjectFramework() {
    }

    public static boolean hasProjectFacet(IProject project, String fid) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet(project, fid, null);
    }

    public static boolean hasProjectFacet(IProject project, String fid, String vexpr) throws CoreException {
        if (project.isAccessible() && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
            FacetedProjectFramework.initialize();
            IFacetedProject fproj = ProjectFacetsManager.create(project);
            if (fproj != null && ProjectFacetsManager.isProjectFacetDefined(fid)) {
                IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                if (vexpr == null) {
                    return fproj.hasProjectFacet(f);
                }
                IProjectFacetVersion fv = fproj.getInstalledVersion(f);
                if (fv != null) {
                    return f.getVersions(vexpr).contains(fv);
                }
            }
        }
        return false;
    }

    private static synchronized void initialize() {
        if (impl == null) {
            impl = new ProjectFacetsManagerImpl();
        }
    }

    static ProjectFacetsManagerImpl getProjectFacetsManagerImpl() {
        FacetedProjectFramework.initialize();
        return impl;
    }
}

